unit list;
interface
uses item;
type
  tlist = object
    first, last: ptitem;
    constructor init;
    destructor done;
    procedure append(x: ttype);
    function empty: boolean;
    procedure print;
    procedure remove_item(p: ptitem);
  private
    last_read: ptitem;
  end;
implementation
constructor tlist.init;
  begin
    first := nil; last := nil;
    new(last_read)
  end;
destructor tlist.done;
  var p, T: ptitem;
  begin
    p := first;
    while assigned(p) do
      begin
        T := p;
        p := p^.next;
        dispose(T, done)
      end;
  end;
function tlist.empty: boolean;
  begin
    empty := not assigned(first)
  end;
procedure tlist.append(x: ttype);
  var p: ptitem;
  begin
    new(p, init(x, nil));
    if empty then first := p
    else last^.next := p;
    last := p
  end;
procedure tlist.print;
  var p: ptitem;
  begin
    p := first;
    write('᮪ : ');
    while assigned(p) do
      begin
        write(p^.info, ' ');
        p := p^.next
      end;
    writeln;
  end;
procedure tlist.remove_item(p: ptitem);
  var r: ptitem;
  begin
    r := p^.next;
    p^ := r^;
    dispose(r, done);
    r := nil
  end;
end.