unit rounds;
interface
Uses Graph,Crt;
procedure zastavka;
const MaxShar=10;
type shar = object
  x,y:integer;
  r:word;
  color:byte;
  dx,dy:shortint;
  hits:set of byte;
  constructor initShar(x0,y0:integer; r0:word; color0:byte; dx0,dy0:shortint);
  procedure Move;
  procedure Show;
  procedure Hide;
  procedure CheckBorder;
  procedure CheckHit(k:byte);
  procedure revertXDirection;
  procedure revertYDirection;
  procedure TurnAfterHit(k:byte);
  function Value:real;
  end;
var bgColor,i:byte;
    x,y,dx,dy,ErrCode:integer;
    r:word;
    shars: array[1..MaxShar] of shar;
    sh:shar;
    f:text;
implementation
Procedure shar.Move;
  begin
    x:=x+dx;
    y:=y+dy;
  end;
Procedure shar.Show;
  begin
    setColor(color);
    circle(x, y, r);
  end;
Procedure shar.Hide;
  begin
    setColor(bgColor);
    circle(x, y, r);
  end;
procedure shar.revertXDirection;
  begin
    dx:=-dx;
    x:=x+dx;
  end;
procedure shar.revertYDirection;
  begin
    dy:=-dy;
    y:=y+dy;
  end;
Constructor shar.initShar(x0, y0 :integer; r0 :word; color0 :byte; dx0, dy0 :shortint);
  begin
    x:=x0;
    y:=y0;
    r:=r0;
    color:=color0;
    dx:=dx0;
    dy:=dy0;
    hits:=[];
  end;
procedure shar.CheckBorder;
  begin
    if (r+x>=GetMaxX-1) or (x-r<=1) then revertXDirection;
    if (y+r>=GetMaxY-1) or (y-r<=1) then revertYDirection
  end;
procedure shar.TurnAfterHit(k:byte);
var m1, m2 :real;
    vx10,vy10,vx20,vy20:integer;
  begin
    m1 := Value;
    m2 := shars[k].Value;
    vx10 := dx;
    vy10 := dy;
    vx20 := shars[k].dx;
    vy20 := shars[k].dy;
    dx := round((2*m2*vx20 + (m1-m2)*vx10)/(m1+m2));
    dy := round((2*m2*vy20 + (m1-m2)*vy10)/(m1+m2));
    shars[k].dx := round((2*m1*vx10 + (m2-m1)*vx20)/(m1+m2));
    shars[k].dy := round((2*m1*vy10 + (m2-m1)*vy20)/(m1+m2));
  end;
function shar.Value:real;
  begin
    Value:=4*Pi*r*r*r/3;
  end;
procedure shar.CheckHit(k:byte);
var i1:byte;
    dist:longint;
  begin
    for i1:=1 to MaxShar do if ((i1<>k) and not(k in hits)) then
      begin
        shars[i1].hits:=shars[i1].hits+[k];
        dist:=round(sqrt(sqr(1.0*x-shars[i1].x)+sqr(1.0*y-shars[i1].y)));
        if (dist<r+shars[i1].r) then
          begin
            TurnAfterHit(i1);
            CheckBorder;
            Move;
            shars[i1].CheckBorder;
            shars[i1].Move;
            dist:=round(sqrt(sqr(1.0*x-shars[i1].x)+sqr(1.0*y-shars[i1].y)));
            while (dist<r+shars[i1].r) do
              begin
                CheckBorder;
                Move;
                shars[i1].CheckBorder;
                shars[i1].Move;
                dist:=round(sqrt(sqr(1.0*x-shars[i1].x)+sqr(1.0*y-shars[i1].y)));
              end;
          end;
      end;
  end;
function initializeGraph:integer;
var grDriver : Integer;
     grMode  : Integer;
  begin
    grDriver:=Detect;
    InitGraph(grDriver, grMode, '');
    initializeGraph:=GraphResult;
  end;

procedure zastavka;
begin
  ErrCode:=initializeGraph;
  if ErrCode <> grOk then
    WriteLn('Error', GraphErrorMsg(ErrCode))
  else
    begin
      assign(f,'log.txt');
      rewrite(f);
      bgColor:=0;
      rectangle(1,1,GetMaxX-1,GetMaxY-1);
      for i:=1 to MaxShar do
        begin
          r:=20+random(10);
          shars[i].initShar(1+r+random(GetMaxX-2*r),
          1+r+random(GetMaxY-2*r),r,1+random(GetMaxColor-1),
          random(15)-7,random(12)-6);
        end;
      repeat
        for i:=1 to MaxShar do
          shars[i].Show;
        Delay(580);
        for i:=1 to MaxShar do
          shars[i].Hide;
        for i:=1 to MaxShar do
          begin
            shars[i].Move;
            shars[i].CheckBorder;
            shars[i].CheckHit(i);
          end;
        for i:=1 to MaxShar do
          shars[i].hits:=[];
      until keyPressed;
      CloseGraph;
      close(f);
    end
end;
end.
