Unit ThrdAPI;

{
********************************************************************
*                    EDI Threads Pascal Interface                  *
*                                                                  *
********************************************************************
*       Copyright 1992 Robert Salesas, All Rights Reserved         *
********************************************************************
*      Version: 1.00             Author:  Robert Salesas           *
*      Date:    22-May-1992      Changes: Original                 *
*                                                                  *
********************************************************************
}


Interface


Uses WinTypes;



Type
  PThreadRec = Pointer;

  PThreadFunc = ^TThreadFunc;
  TThreadFunc = Procedure(Thread : PThreadRec;  Wnd : HWnd;  wParam : Word;  lParam : LongInt);


Const
  tm_User     = $0100;                { Starting user message to pass to a thread }
  tm_Quit     = $0001;                { Thread has ended or must end }
  tm_Continue = $0002;                { Thread can continue or is continuing }
  tm_Paused   = $0003;								{ Thread is currently paused }

  ts_DefTimeSlice = 50;               { Default time slice }
  ts_DefPriority  = 100;              { Default thread priority }


  Function GetThrdUtlsVersion : Word;
  { Returns major revision in high byte, minor revision in low byte. }

  Function GetNumThreads : Word;

  Procedure SetThrdUtlsTimeSlice(ATimeSlice : Word);


  Function CreateThread(ThreadFunc : PThreadFunc;  StackSize : Word;
                        Wnd : HWnd;  wParam : Word;  lParam : LongInt) : PThreadRec;

  Procedure DisposeThread(Var Thread : PThreadRec);

  Function ExecThread(Thread : PThreadRec) : Word;

  Function YieldThread : Word;

  Procedure ExitThread;

  Procedure TerminateThread(Thread : PThreadRec);

  Procedure SetThreadPriority(Thread : PThreadRec;  Priority : Word);

  Procedure SetThreadPause(Thread : PThreadRec;  Paused : Bool);

  Function IsThreadPaused(Thread : PThreadRec) : Bool;

  Function IsThreadFinished(Thread : PThreadRec) : Bool;

  
  Function AddThread(Thread : PThreadRec) : Bool;

  Procedure RemoveThread(Thread : PThreadRec);

  Function StartThread(ThreadFunc : PThreadFunc;  StackSize : Word;
                       Wnd : HWnd;  wParam : Word;  lParam : LongInt) : PThreadRec;

  Procedure EndThread(Var Thread : PThreadRec);

  Procedure ExecTaskThreads(Task : THandle);

  Procedure EndTaskThreads(Task : THandle);




Implementation


  Function GetThrdUtlsVersion;  External 'THRDUTLS' Index 100;

  Function GetNumThreads;  External 'THRDUTLS' Index 110;

  Procedure SetThrdUtlsTimeSlice;  External 'THRDUTLS' Index 120;


  Function CreateThread;  External 'THRDUTLS' Index 200;

  Procedure DisposeThread;  External 'THRDUTLS' Index 210;

  Function ExecThread;  External 'THRDUTLS' Index 220;

  Function YieldThread;  External 'THRDUTLS' Index 230;

  Procedure ExitThread;  External 'THRDUTLS' Index 240;

  Procedure TerminateThread;  External 'THRDUTLS' Index 250;

  Procedure SetThreadPriority;  External 'THRDUTLS' Index 260;

  Procedure SetThreadPause;  External 'THRDUTLS' Index 270;

  Function IsThreadPaused;  External 'THRDUTLS' Index 280;

  Function IsThreadFinished;  External 'THRDUTLS' Index 290;


  Function AddThread;  External 'THRDUTLS' Index 300;

  Procedure RemoveThread;  External 'THRDUTLS' Index 310;

  Function StartThread;  External 'THRDUTLS' Index 320;

  Procedure EndThread;  External 'THRDUTLS' Index 330;

  Procedure ExecTaskThreads;  External 'THRDUTLS' Index 340;

  Procedure EndTaskThreads;  External 'THRDUTLS' Index 350;


End. {ThrdAPI}