Unit
  Arc_kbd;

INTERFACE

uses
  Dos;

const
  kSYSREQ=$54;
  kCAPSLOCK=$3A;
  kNUMLOCK=$45;
  kSCROLLLOCK=$46;
  kLEFTCTRL=$1D;
  kLEFTALT=$38;
  kLEFTSHIFT=$2A;
  kRIGHTCTRL=$9D;
  kRIGHTALT=$B8;
  kRIGHTSHIFT=$36;
  kESC=$01;
  kBACKSPACE=$0E;
  kENTER=$1C;
  kSPACE=$39;
  kTAB=$0F;
  kF1=$3B;
  kF2=$3C;
  kF3=$3D;
  kF4=$3E;
  kF5=$3F;
  kF6=$40;
  kF7=$41;
  kF8=$42;
  kF9=$43;
  kF10=$44;
  kF11=$57;
  kF12=$58;
  kA=$1E;
  kB=$30;
  kC=$2E;
  kD=$20;
  kE=$12;
  kF=$21;
  kG=$22;
  kH=$23;
  kJ=$24;
  kK=$25;
  kL=$26;
  kM=$32;
  kN=$31;
  kO=$18;
  kP=$19;
  kQ=$10;
  kR=$13;
  kS=$1F;
  kT=$14;
  kU=$16;
  kV=$2F;
  kW=$11;
  kX=$2D;
  kY=$15;
  kZ=$2C;
  k1=$02;
  k2=$03;
  k3=$04;
  k4=$05;
  k5=$06;
  k6=$07;
  k7=$08;
  k8=$09;
  k9=$0A;
  k0=$0B;
  kMINUS=$0C;
  kEQUAL=$0D;
  kLBRACKET=$1A;
  kRBRACKET=$1B;
  kSEMICOLON=$27;
  kTICK=$28;
  kAPOSTROPHE=$29;
  kBACKSLASH=$2B;
  kCOMMA=$33;
  kPERIOD=$34;
  kSLASH=$35;
  kINS=$D2;
  kDEL=$D3;
  kHOME=$C7;
  kEND=$CF;
  kPGUP=$C9;
  kLARROW=$CB;
  kRARROW=$CD;
  kUARROW=$C8;
  kDARROW=$D0;
  kKEYPAD0=$52;
  kKEYPAD1=$4F;
  kKEYPAD2=$50;
  kKEYPAD3=$51;
  kKEYPAD4=$4B;
  kKEYPAD5=$4C;
  kKEYPAD6=$4D;
  kKEYPAD7=$47;
  kKEYPAD8=$48;
  kKEYPAD9=$49;
  kKEYPADDEL=$53;
  kKEYPADSTAR=$37;
  kKEYPADMINUS=$4A;
  kKEYPADPLUS=$4E;
  kKEYPADENTER=$9C;
  kCNTRLPRTSC=$B7;
  kSHIFTPRTSC=$B7;
  kKEYPADSLASH=$B5;

type
  keyboardObj=object
    constructor Init;
    destructor Done;
    function Down(b: byte): boolean;
  end;

var
  OldInt9: pointer;                { saves location of old OldInt9 vector }
  Keys: array [0..255] of boolean; { array that holds key values }
  e0Flag: byte;

IMPLEMENTATION

{$F+}
procedure NewInt9; interrupt; assembler;
asm
  cli
  in      al, $60                       { get scan code from keyboard port }
  cmp     al, $E0                       { al = $E0 key ? }
  jne     @@SetScanCode
  mov     [e0Flag], 128
  mov     al, 20h                       { Send 'generic' EOI to PIC }
  out     20h, al
  jmp     @@exit
@@SetScanCode:
  mov     bl, al                        { Save scancode in BL }
  and     bl, 01111111b
  add     bl, [e0Flag]
  xor     bh, bh
  and     al, 10000000b                 { keep break bit, if set }
  xor     al, 10000000b                 { flip bit, 1 means pressed, 0 no }
  rol     al, 1                         { move breakbit to bit 0 }
  mov     [offset keys + bx], al
  mov     [e0Flag], 0
  mov     al, 20h                       { send EOI to PIC }
  out     20h, al
@@exit:
  sti
end;
{$F-}

procedure SetNewInt9;
begin
  GetIntVec($09, OldInt9);         { save old location of INT 09 handler }
  SetIntVec($09, Addr(NewInt9));   { point to new routine }
end;

procedure SetOldInt9;
begin
  SetIntVec($09, OldInt9);         { point back to original routine }
end;

constructor keyboardObj.Init;
begin
  SetNewInt9;                      { point to new keyboard routine }
  FillChar(Keys, 256, 0);          { clear the keys array }
end;

destructor keyboardObj.Done;
begin
  SetOldInt9;                      { point back to original keyboard routine }
end;

function keyboardObj.Down(b: byte): boolean;
begin
  if keys[b] then
    Down:=true
  else
    Down:=false;
end;

END.
