Program Arc_Demo;

Uses
  crt;

Const
  VGA = $a000;

Type
  Virt = array [1..64000] of byte;
  VirtPtr = ^Virt;

Var
  VirtScr : VirtPtr;
  Vaddr : word;

Procedure SetMCGA;
Begin
  asm
    mov ax,0013h
    int 10h
  end;
End;

Procedure CLS(col : byte; where : word);
Begin
  FillChar(Mem[where:0], 64000, col)
End;

Procedure WaitRetrace; Assembler;
Label
  l1, l2;
Asm
  mov dx,3DAh
l1:
  in al,dx
  and al,08h
  jnz l1
l2:
  in al,dx
  and al,08h
  jnz l2
End;

Procedure SetUpVirtScr;
Begin
  GetMem(VirtScr, 64000);
  Vaddr := Seg(VirtScr^);
End;

Procedure DestroyVirtScr;
Begin
  FreeMem(VirtScr, 64000);
End;

Procedure PutPixel(x, y : integer; col : byte; where : word);
Begin
  Mem[where:X+(Y*320)] := col;
End;

Procedure Flip;
Begin
  Move(VirtScr, Mem[VGA:0], 64000);
End;

Procedure Pal(ColorNo : byte; R, G, B : byte);
Begin
  Port[$3c8] := ColorNo;
  Port[$3c9] := R;
  Port[$3c9] := G;
  Port[$3c9] := B;
End;

{}

var
  x, y, old_x, old_y, sp_x, sp_y : integer;
  Dev : integer;
  Key : char;
  Ran, Ex : boolean;

Begin
  Randomize;
  SetMCGA;
  SetUpVirtScr;
  CLS(0, Vaddr);
  sp_x := 160;
  sp_y := 100;
  Dev := 10;
  Ex := false;
  Ran := false;

  Repeat
    If KeyPressed then Key := ReadKey;
    If UpCase(Key) = 'R' then Ran := NOT Ran;
    If Key = #27 then Ex := true;
    If (Key = '-') and (Dev > 1) then Dec(Dev);
    If (Key = '+') and (Dev < 100) then Inc(Dev);
    If Upcase(Key) = 'B' then
      Begin
        sp_x := 160;
        sp_y := 100;
      End;
    Key := #0;

    x := Random(320);
    y := Random(200);
    If Random((Abs(x - sp_x) + Abs(y - sp_y)) div Dev) = 0 then
      PutPixel(x, y, Random(256), VGA)
    Else
      PutPixel(x, y, 0, VGA);
    If Ran and (Random(10000) = 0) then
      Begin
        old_x := sp_x;
        old_y := sp_y;
        Inc(sp_x, Random(11) - 5);
        Inc(sp_y, Random(11) - 5);
        If (sp_x > 300) or (sp_x < 20) or (sp_y > 180) or (sp_y < 20) then
          Begin
            sp_x := old_x;
            sp_y := old_y;
          End;
      End;
  Until Ex;
End.