Program Arc_Demo;

Uses
  crt;

Const
  VGA = $a000;
  paus = 5000;

Type
  Virt = array [1..64000] of byte;
  VirtPtr = ^Virt;

Var
  VirtScr : VirtPtr;
  Vaddr : word;

Procedure SetMCGA;
Begin
  asm
    mov ax,0013h
    int 10h
  end;
End;

Procedure CLS(col : byte; where : word);
Begin
  FillChar(Mem[where:0], 64000, col)
End;

Procedure WaitRetrace; Assembler;
Label
  l1, l2;
Asm
  mov dx,3DAh
l1:
  in al,dx
  and al,08h
  jnz l1
l2:
  in al,dx
  and al,08h
  jnz l2
End;

Procedure SetUpVirtScr;
Begin
  GetMem(VirtScr, 64000);
  Vaddr := Seg(VirtScr^);
End;

Procedure DestroyVirtScr;
Begin
  FreeMem(VirtScr, 64000);
End;

Procedure PutPixel(x, y : integer; col : byte; where : word);
Begin
  Mem[where:X+(Y*320)] := col;
End;

Procedure Flip;
Begin
  Move(VirtScr, Mem[VGA:0], 64000);
End;

Procedure Pal(ColorNo : byte; R, G, B : byte);
Begin
  Port[$3c8] := ColorNo;
  Port[$3c9] := R;
  Port[$3c9] := G;
  Port[$3c9] := B;
End;

Procedure Funny_line(a,b,c,d:integer;where:word);
  function sgn(a:real):integer;
  begin
    if a>0 then sgn:=+1;
    if a<0 then sgn:=-1;
    if a=0 then sgn:=0;
  end;
var
  i,s,d1x,d1y,d2x,d2y,u,v,m,n:integer;
  count:integer;
begin
  count:=50;
  u:= c - a;
  v:= d - b;
  d1x:= SGN(u);
  d1y:= SGN(v);
  d2x:= SGN(u);
  d2y:= 0;
  m:= ABS(u);
  n := ABS(v);
  IF NOT (M>N) then
  BEGIN
    d2x := 0 ;
    d2y := SGN(v);
    m := ABS(v);
    n := ABS(u);
  END;
  s := m shr 1;
  FOR i := 0 TO m DO
  BEGIN
    putpixel(a,b,count,where);
    inc (count);
    if count=101 then count:=50;
    s := s + n;
    IF not (s<m) THEN
    BEGIN
      s := s - m;
      a:= a + d1x;
      b := b + d1y;
    END
    ELSE
    BEGIN
      a := a + d2x;
      b := b + d2y;
    END;
  end;
END;


{}

var
  dx, dy, x, y, sp_x, sp_y, s_x, s_y : integer;
  a_x, a_y, b_x, b_y, c_x, c_y, d_x, d_y : integer;
  pause, t : integer;
  Key : char;
  Ex : boolean;

Begin
  Randomize;
  SetMCGA;
  SetUpVirtScr;
  CLS(0, Vaddr);

  sp_x := 160;
  sp_y := 100;
  Ex := false;
  dx := 1;
  dy := 1;
  t := 1;
  s_x := sp_x;
  s_y := sp_y;

  Repeat
    If KeyPressed then Key := ReadKey;
    If Key = #27 then Ex := true;
    Key := #0;

    x := Random(320);
    y := Random(200);

    If Random((Abs(x - sp_x) + Abs(y - sp_y)) div (Random(100)+30)) = 0 then
      PutPixel(x, y, 0, VGA)
    Else
      PutPixel(x, y, Random(256), VGA);

    Inc(pause);
    If Pause > Paus then
      begin
        If Random(10) = 0 then
          Funny_line(Random(320),Random(200),Random(320),Random(200),VGA);
        Pause := 0;
        Inc(sp_x, dx);
        Inc(sp_y, dy);
        If (sp_y >= 200) or (sp_y <= 0) then dy := -1 * dy;
        If (sp_x >= 320) or (sp_x <= 0) then dx := -1 * dx;
        Inc(t,5);
        If t > 30 then
          begin
            t := 1;
            s_x := sp_x;
            s_y := sp_y;
          end;
        a_x := s_x - t;
        If a_x < 0 then a_x := 0;
        a_y := s_y - t;
        If a_y < 0 then a_y := 0;
        b_x := s_x + t;
        If b_x > 319 then b_x := 319;
        b_y := s_y - t;
        If b_y < 0 then b_y := 0;
        c_x := s_x + t;
        If c_x > 319 then c_x := 319;
        c_y := s_y + t;
        If c_y > 199 then c_y := 199;
        d_x := s_x - t;
        If d_x < 0 then d_x := 0;
        d_y := s_y + t;
        If d_y > 199 then d_y := 199;
        Funny_line(a_x, a_y, b_x, b_y, VGA);
        Funny_line(b_x, b_y, c_x, c_y, VGA);
        Funny_line(c_x, c_y, d_x, d_y, VGA);
        Funny_line(d_x, d_y, a_x, a_y, VGA);
      end;
  Until Ex;
End.