Program Arc_Demo;

Uses
  crt;

Const
  VGA = $a000;
  alphabet : array [1..39,1..49] of byte
           = ((0,0,1,1,1,0,0,
               0,1,1,0,1,1,0,
               1,1,0,0,0,1,1,
               1,1,1,1,1,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1),

              (1,1,1,1,1,1,0,
               0,1,1,0,0,1,1,
               0,1,1,0,0,1,1,
               0,1,1,1,1,1,0,
               0,1,1,0,0,1,1,
               0,1,1,0,0,1,1,
               1,1,1,1,1,1,0),

              (0,0,1,1,1,1,0,
               0,1,1,0,0,1,1,
               1,1,0,0,0,0,0,
               1,1,0,0,0,0,0,
               1,1,0,0,0,0,0,
               0,1,1,0,0,1,1,
               0,0,1,1,1,1,0),

              (1,1,1,1,1,0,0,
               0,1,1,0,1,1,0,
               0,1,1,0,0,1,1,
               0,1,1,0,0,1,1,
               0,1,1,0,0,1,1,
               0,1,1,0,1,1,0,
               1,1,1,1,1,0,0),

              (1,1,1,1,1,1,1,
               0,1,1,0,0,0,1,
               0,1,1,0,1,0,0,
               0,1,1,1,1,0,0,
               0,1,1,0,1,0,0,
               0,1,1,0,0,0,1,
               1,1,1,1,1,1,1),

              (1,1,1,1,1,1,1,
               0,1,1,0,0,0,1,
               0,1,1,0,1,0,0,
               0,1,1,1,1,0,0,
               0,1,1,0,1,0,0,
               0,1,1,0,0,0,0,
               1,1,1,1,0,0,0),

              (0,0,1,1,1,1,0,
               0,1,1,0,0,1,1,
               1,1,0,0,0,0,0,
               1,1,0,0,0,0,0,
               1,1,0,0,1,1,1,
               0,1,1,0,0,1,1,
               0,0,1,1,1,0,1),

              (1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,1,1,1,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1),

              (0,1,1,1,1,0,0,
               0,0,1,1,0,0,0,
               0,0,1,1,0,0,0,
               0,0,1,1,0,0,0,
               0,0,1,1,0,0,0,
               0,0,1,1,0,0,0,
               0,1,1,1,1,0,0),

              (0,0,0,1,1,1,1,
               0,0,0,0,1,1,0,
               0,0,0,0,1,1,0,
               0,0,0,0,1,1,0,
               1,1,0,0,1,1,0,
               1,1,0,0,1,1,0,
               0,1,1,1,1,0,0),

              (1,1,1,0,0,1,1,
               0,1,1,0,0,1,1,
               0,1,1,0,1,1,0,
               0,1,1,1,1,0,0,
               0,1,1,0,1,1,0,
               0,1,1,0,0,1,1,
               1,1,1,0,0,1,1),

              (1,1,1,1,0,0,0,
               0,1,1,0,0,0,0,
               0,1,1,0,0,0,0,
               0,1,1,0,0,0,0,
               0,1,1,0,0,0,1,
               0,1,1,0,0,1,1,
               1,1,1,1,1,1,1),

              (1,1,0,0,0,1,1,
               1,1,1,0,1,1,1,
               1,1,1,1,1,1,1,
               1,1,1,1,1,1,1,
               1,1,0,1,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1),

              (1,1,0,0,0,1,1,
               1,1,1,0,0,1,1,
               1,1,1,1,0,1,1,
               1,1,0,1,1,1,1,
               1,1,0,0,1,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1),

              (0,1,1,1,1,1,0,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               0,1,1,1,1,1,0),

              (1,1,1,1,1,1,0,
               0,1,1,0,0,1,1,
               0,1,1,0,0,1,1,
               0,1,1,1,1,1,0,
               0,1,1,0,0,0,0,
               0,1,1,0,0,0,0,
               1,1,1,1,0,0,0),

              (0,1,1,1,1,1,0,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,1,1,1,
               0,1,1,1,1,1,0,
               0,0,0,0,0,1,1),

              (1,1,1,1,1,1,0,
               0,1,1,0,0,1,1,
               0,1,1,0,0,1,1,
               0,1,1,1,1,1,0,
               0,1,1,0,1,1,0,
               0,1,1,0,0,1,1,
               1,1,1,0,0,1,1),

              (0,1,1,1,1,1,0,
               1,1,0,0,0,1,1,
               0,1,1,0,0,0,0,
               0,0,1,1,1,0,0,
               0,0,0,0,1,1,0,
               1,1,0,0,0,1,1,
               0,1,1,1,1,1,0),

              (0,1,1,1,1,1,1,
               0,1,1,1,1,1,1,
               0,1,0,1,1,0,1,
               0,0,0,1,1,0,0,
               0,0,0,1,1,0,0,
               0,0,0,1,1,0,0,
               0,0,1,1,1,1,0),

              (1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               0,1,1,1,1,1,0),

              (1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               0,1,1,0,1,1,0,
               0,0,1,1,1,0,0),

              (1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               1,1,0,1,0,1,1,
               1,1,0,1,0,1,1,
               1,1,1,1,1,1,1,
               0,1,1,0,1,1,0),

              (1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               0,1,1,0,1,1,0,
               0,0,1,1,1,0,0,
               0,1,1,0,1,1,0,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1),

              (0,1,1,0,0,1,1,
               0,1,1,0,0,1,1,
               0,1,1,0,0,1,1,
               0,0,1,1,1,1,0,
               0,0,0,1,1,0,0,
               0,0,0,1,1,0,0,
               0,0,1,1,1,1,0),

              (1,1,1,1,1,1,1,
               1,1,0,0,0,1,1,
               1,0,0,0,1,1,0,
               0,0,0,1,1,0,0,
               0,0,1,1,0,0,1,
               0,1,1,0,0,1,1,
               1,1,1,1,1,1,1),

              (0,0,0,0,0,0,0,
               0,0,0,1,1,0,0,
               0,0,0,1,1,0,0,
               0,0,0,0,0,0,0,
               0,0,0,0,0,0,0,
               0,0,0,1,1,0,0,
               0,0,0,1,1,0,0),

              (0,0,0,0,0,0,0,
               0,0,0,0,0,0,0,
               0,0,0,0,0,0,0,
               0,0,0,0,0,0,0,
               0,0,0,0,0,0,0,
               0,0,0,1,1,0,0,
               0,0,0,1,1,0,0),

              (0,1,1,1,1,1,0,
               1,1,0,0,0,1,1,
               1,1,0,0,1,1,1,
               1,1,0,1,0,1,1,
               1,1,1,0,0,1,1,
               1,1,0,0,0,1,1,
               0,1,1,1,1,1,0),

              (0,0,0,1,1,0,0,
               0,0,1,1,1,0,0,
               0,0,0,1,1,0,0,
               0,0,0,1,1,0,0,
               0,0,0,1,1,0,0,
               0,0,0,1,1,0,0,
               0,1,1,1,1,1,1),

              (0,1,1,1,1,1,0,
               1,1,0,0,0,1,1,
               0,0,0,0,0,1,1,
               0,0,0,1,1,1,0,
               0,0,1,1,0,0,0,
               0,1,1,0,0,1,1,
               1,1,1,1,1,1,1),

              (0,1,1,1,1,1,0,
               1,1,0,0,0,1,1,
               0,0,0,0,0,1,1,
               0,0,1,1,1,1,0,
               0,0,0,0,0,1,1,
               1,1,0,0,0,1,1,
               0,1,1,1,1,1,0),

              (0,0,0,1,1,1,0,
               0,0,1,1,1,1,0,
               0,1,1,0,1,1,0,
               1,1,0,0,1,1,0,
               1,1,1,1,1,1,1,
               0,0,0,0,1,1,0,
               0,0,0,1,1,1,1),

              (1,1,1,1,1,1,1,
               1,1,0,0,0,0,0,
               1,1,0,0,0,0,0,
               1,1,1,1,1,1,0,
               0,0,0,0,0,1,1,
               1,1,0,0,0,1,1,
               0,1,1,1,1,1,0),

              (0,0,1,1,1,0,0,
               0,1,1,0,0,0,0,
               1,1,0,0,0,0,0,
               1,1,1,1,1,1,0,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               0,1,1,1,1,1,0),

              (1,1,1,1,1,1,1,
               1,1,0,0,0,1,1,
               0,0,0,0,1,1,0,
               0,0,0,1,1,0,0,
               0,0,1,1,0,0,0,
               0,0,1,1,0,0,0,
               0,0,1,1,0,0,0),

              (0,1,1,1,1,1,0,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               0,1,1,1,1,1,0,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               0,1,1,1,1,1,0),

              (0,1,1,1,1,1,0,
               1,1,0,0,0,1,1,
               1,1,0,0,0,1,1,
               0,1,1,1,1,1,1,
               0,0,0,0,0,1,1,
               0,0,0,0,1,1,0,
               0,1,1,1,1,0,0),

              (0,0,0,0,0,0,0,
               0,0,0,0,0,0,0,
               0,0,0,0,0,0,0,
               0,0,0,0,0,0,0,
               0,0,0,0,0,0,0,
               0,0,0,0,0,0,0,
               0,0,0,0,0,0,0));

                        {012345A6AAB589.ABC:DEFGHIJKLMNOPQRSTUVWXYZ}
Type
  Virt = array [1..64000] of byte;
  VirtPtr = ^Virt;

Var
  VirtScr : VirtPtr;
  Vaddr : word;
  pause : longint;

Procedure SetMCGA;
Begin
  asm
    mov ax,0013h
    int 10h
  end;
End;

Procedure CLS(col : byte; where : word);
Begin
  FillChar(Mem[where:0], 64000, col)
End;

Procedure WaitRetrace; Assembler;
Label
  l1, l2;
Asm
  mov dx,3DAh
l1:
  in al,dx
  and al,08h
  jnz l1
l2:
  in al,dx
  and al,08h
  jnz l2
End;

Procedure SetUpVirtScr;
Begin
  GetMem(VirtScr, 64000);
  Vaddr := Seg(VirtScr^);
End;

Procedure DestroyVirtScr;
Begin
  FreeMem(VirtScr, 64000);
End;

Procedure PutPixel(x, y : integer; col : byte; where : word);
Begin
  Mem[where:X+(Y*320)] := col;
End;

Procedure Flip(Source, Dest : word);
Begin
  asm
    push    ds
    mov     ax, [Dest]
    mov     es, ax
    mov     ax, [Source]
    mov     ds, ax
    xor     si, si
    xor     di, di
    mov     cx, 32000
    rep     movsw
    pop     ds
  end;
End;

Procedure Pal(ColorNo : byte; R, G, B : byte);
Begin
  Port[$3c8] := ColorNo;
  Port[$3c9] := R;
  Port[$3c9] := G;
  Port[$3c9] := B;
End;

Procedure line(a,b,c,d : integer;col : integer; where : word);
  function sgn(a:real):integer;
  begin
    if a>0 then sgn:=+1;
    if a<0 then sgn:=-1;
    if a=0 then sgn:=0;
  end;
var
  i,s,d1x,d1y,d2x,d2y,u,v,m,n:integer;
  count:integer;
begin
  count:=50;
  u:= c - a;
  v:= d - b;
  d1x:= SGN(u);
  d1y:= SGN(v);
  d2x:= SGN(u);
  d2y:= 0;
  m:= ABS(u);
  n := ABS(v);
  IF NOT (M>N) then
  BEGIN
    d2x := 0 ;
    d2y := SGN(v);
    m := ABS(v);
    n := ABS(u);
  END;
  s := m shr 1;
  FOR i := 0 TO m DO
  BEGIN
    if col = -2 then
      putpixel(a,b,count,where)
    else if col = -1 then
      putpixel(a,b,Random(256),where)
    else
      putpixel(a,b,col,where);
    inc (count);
    if count=101 then count:=50;
    s := s + n;
    IF not (s<m) THEN
    BEGIN
      s := s - m;
      a:= a + d1x;
      b := b + d1y;
    END
    ELSE
    BEGIN
      a := a + d2x;
      b := b + d2y;
    END;
  end;
END;

Procedure DrawString(x,y : integer; Str : string; col : integer; where : word);
var
  i, x1, y1, num : integer;
  cl : byte;
begin
  For i := 1 to length(str) do
  begin
    num := Ord(UpCase(Str[i])) - 64;
    If Str[i] = ':' then num := 27;
    If Str[i] = '.' then num := 28;
    If Str[i] = '0' then num := 29;
    If Str[i] = '1' then num := 30;
    If Str[i] = '2' then num := 31;
    If Str[i] = '3' then num := 32;
    If Str[i] = '4' then num := 33;
    If Str[i] = '5' then num := 34;
    If Str[i] = '6' then num := 35;
    If Str[i] = '7' then num := 36;
    If Str[i] = '8' then num := 37;
    If Str[i] = '9' then num := 38;
    If Str[i] = ' ' then num := 39;
    For x1 := 1 to 7 do
      For y1 := 1 to 7 do
      begin
        If col = -1 then cl := Random(256)
        Else
          If col = -2 then cl := (i * 8 + x1) mod 51 + 50
          Else
            cl := col;
        If Alphabet[num, x1 + (y1 - 1) * 7] <> 0 then
          PutPixel(8 * (i - 1) + x1 + x, y1 + y, cl, where);
      end;
  end;
end;

Procedure DrawSqr(x,y : integer; Str : string; col : integer; where : word);
var
  i, x1, y1 : integer;
  cl : byte;
begin
  For i := 1 to length(str) do
  begin
    For x1 := 1 to 4 do
      For y1 := 1 to 10 do
      begin
        If col = -1 then cl := Random(256)
        Else
          If col = -2 then cl := (i * 4 + x1) mod 51 + 50
          Else
            cl := col;
        If Str[i] <> ' ' then
          PutPixel(4 * (i - 1) + x1 + x, y1 + y, cl, where);
      end;
  end;
end;

Procedure FullSnow(h : integer; where : word);
var
  x, y : integer;
begin
  For y := 0 to h do
    For x := 0 to 319 do
      PutPixel(x, y, Random(256), where);
end;

function Clock : longint; assembler;
asm
  mov   es,[seg0040]
  mov   ax,es:[6Ch]
  mov   dx,es:[6Eh]
end;

Procedure SincronisePause;
var
  i, Time1 : longint;
begin
  DrawString(80,96,'Calibrating timer...',-2,VGA);
  i :=0;
  Time1 := Clock;
  Repeat
    Inc(i);
  Until Clock >= Time1 + 200;
  CLS(0, VGA);
  Pause := i div 100000;
end;


{}

var
  Key : char;
  Ex : boolean;
  i, j, k : integer;
  tmr : longint;
  dx, dy, x, y, sp_x, sp_y, s_x, s_y : integer;
  a_x, a_y, b_x, b_y, c_x, c_y, d_x, d_y : integer;
  t : integer;
  booms : array [1..1000, 1..4] of real;
  a_r, b_r : real;
  lines : array [1..20] of integer;

Begin
  Randomize;
  SetMCGA;
  SetUpVirtScr;
  CLS(0, Vaddr);
  SincronisePause;

  Ex := false;
  tmr := 0;
  sp_x := 160;
  sp_y := 100;
  Ex := false;
  dx := 1;
  dy := 1;
  t := 1;
  s_x := sp_x;
  s_y := sp_y;


  Repeat
    Inc(tmr);
    if (tmr <= 830) or (tmr > 5500000) then CLS(0, Vaddr);

    if (tmr = 1) then
    begin
      DrawString(35,96,'Press any key to start demo...', -2, VGA);
      While KeyPressed do ReadKey;
      ReadKey;
    end;

    if (tmr <= 200) then
      FullSnow(tmr - 1, Vaddr);

    if (tmr > 200) and (tmr <= 250) then
      FullSnow(199, Vaddr);

    if (tmr > 250) and (tmr <= 280) then
      FullSnow(199 + 250 - tmr, Vaddr);

    if (tmr > 280) and (tmr <= 800) then
      FullSnow(169, Vaddr);

    if (tmr > 800) and (tmr <= 830) then
      FullSnow(169 + tmr - 800, Vaddr);

    if (tmr <= 830) then
    begin
      DrawSqr(17,20,'oooo    o   o   o ooo    ooo  o   o o oooooo   o   ooooo o  ooo  o   o',0,Vaddr);
      DrawSqr(17,30,'o   o  o o  o   o o  o  o   o o   o o      o  o o    o   o o   o o   o',0,Vaddr);
      DrawSqr(17,40,'o   o o   o oo  o o   o o   o oo oo o     o  o   o   o   o o   o oo  o',0,Vaddr);
      DrawSqr(17,50,'o   o o   o o o o o   o o   o o o o o    o   o   o   o   o o   o o o o',0,Vaddr);
      DrawSqr(17,60,'oooo  ooooo o  oo o   o o   o o   o o   o    ooooo   o   o o   o o  oo',0,Vaddr);
      DrawSqr(17,70,'o o   o   o o   o o   o o   o o   o o  o     o   o   o   o o   o o   o',0,Vaddr);
      DrawSqr(17,80,'o  o  o   o o   o o  o  o   o o   o o o      o   o   o   o o   o o   o',0,Vaddr);
      DrawSqr(17,90,'o   o o   o o   o ooo    ooo  o   o o oooooo o   o   o   o  ooo  o   o',0,Vaddr);
      DrawSqr(117,110,'oo  ooo o   o  oo ',0,Vaddr);
      DrawSqr(117,120,'o o o   oo oo o  o',0,Vaddr);
      DrawSqr(117,130,'o o oo  o o o o  o',0,Vaddr);
      DrawSqr(117,140,'o o o   o   o o  o',0,Vaddr);
      DrawSqr(117,150,'oo  ooo o   o  oo ',0,Vaddr);
    end;

    if (tmr > 250) and (tmr <= 830) then
    begin
      DrawString(1,170,'Coder     :  Anton Maximov aka Archon',-1,Vaddr);
      DrawString(1,180,'Compiler  :  Turbo Pascal 7.01',-1,Vaddr);
      DrawString(1,190,'Work Mode :  Seriously Drunken',-1,Vaddr);
    end;


    if (tmr > 830) and (tmr <= 5500000) then
    begin
      x := Random(320);
      y := Random(200);
      If Random((Abs(x - sp_x) + Abs(y - sp_y)) div (Random(100)+30)) = 0 then
        PutPixel(x, y, 0, VGA)
      Else
        PutPixel(x, y, Random(256), VGA);
      Inc(i);
      If i > Pause then
      begin
        If Random(15) = 0 then
          line(Random(320),Random(200),Random(320),Random(200),-2,VGA);
        i := 0;
        Inc(sp_x, dx);
        Inc(sp_y, dy);
        If (sp_y >= 200) or (sp_y <= 0) then dy := -1 * dy;
        If (sp_x >= 320) or (sp_x <= 0) then dx := -1 * dx;
        Inc(t,5);
        If t > 30 then
        begin
          t := 1;
          s_x := sp_x;
          s_y := sp_y;
        end;
        a_x := s_x - t;
        If a_x < 0 then a_x := 0;
        a_y := s_y - t;
        If a_y < 0 then a_y := 0;
        b_x := s_x + t;
        If b_x > 319 then b_x := 319;
        b_y := s_y - t;
        If b_y < 0 then b_y := 0;
        c_x := s_x + t;
        If c_x > 319 then c_x := 319;
        c_y := s_y + t;
        If c_y > 199 then c_y := 199;
        d_x := s_x - t;
        If d_x < 0 then d_x := 0;
        d_y := s_y + t;
        If d_y > 199 then d_y := 199;
        line(a_x, a_y, b_x, b_y, -2, VGA);
        line(b_x, b_y, c_x, c_y, -2, VGA);
        line(c_x, c_y, d_x, d_y, -2, VGA);
        line(d_x, d_y, a_x, a_y, -2, VGA);
      end;
    end;

    if (tmr > 5000000) and (tmr <= 5500000) then
    begin
      if tmr mod 200 = 0 then
        Pal(Random(256),0,0,0);
    end;

    if (tmr = 5500001) or (tmr = 5500621) or (tmr = 5501241) then
    begin
      CLS(0, Vaddr);
      CLS(0, VGA);
      if (tmr = 5500001) then
        For i := 0 to 255 do
          Pal(i,i,0,0);
      if (tmr = 5500621) then
        For i := 0 to 255 do
          Pal(i,0,i,0);
      if (tmr = 5501241) then
        For i := 0 to 255 do
          Pal(i,0,0,i);
      For i := 1 to 1000 do
        begin
          booms[i,1] := 160;
          booms[i,2] := 100;
          repeat
            booms[i,3] := Random(2001) / 1000 - 1;
            booms[i,4] := Random(2001) / 1000 - 1;
          until sqr(booms[i,3]) + sqr(booms[i,4]) <= 1;
        end;
      j := 63;
    end;

    if (tmr > 5500000) and (tmr <= 5501860) then
    begin
      For i := 1 to 1000 do
      begin
        if j < 0 then j := 0;
        a_r := booms[i,1] + booms[i,3];
        b_r := booms[i,2] + booms[i,4];
        booms[i,1] := a_r;
        booms[i,2] := b_r;
        if not ((a_r < 0) or (a_r > 319) or (b_r < 0) or (b_r > 199)) then
          PutPixel(trunc(a_r), trunc(b_r), j, Vaddr);
      end;
      if (tmr mod 10 = 0) and (j <> 10) then Dec(j);
    end;

    if (tmr = 5501861) then
    begin
      For i := 0 to 49 do
        Pal(i,i,0,0);
      For i := 50 to 100 do
        Pal(i,0,0,i-37);
      For i := 101 to 150 do
        Pal(i,i-87,0,0);
    end;

    if (tmr > 5501861) and (tmr <= 5502200) then
    begin
      For i := 0 to 2000 do
      begin
        PutPixel(Random(320), Random(i div 20), Random(50), Vaddr);
        PutPixel(Random(320), 199 - Random(i div 20), Random(50), Vaddr);
      end;
      For i := 1 to Random(4)+2 do
      begin
        if Random(5) = 0 then
          lines[i] := Random(320);
        if not (Random(5) = 0) then
          For s_y := 0 to 199 do
            putpixel(lines[i],s_y,Random(50)+101, Vaddr);
      end;
      a_x := Random(80);
      b_x := Random(a_x);
      c_x := Random(b_x + 1) - b_x div 2 + 100;
      For j := 1 to 4 do
      begin
        sp_x := 0;
        sp_y := 100;
        For i := 0 to 32 do
        begin
          x := i * 10 + Random(11) - 5;
          If x > 319 then x := 319;
          If x < 0 then x := 0;
          y := c_x + (Random(j * 10 + 1) - j * 5);
          line(sp_x, sp_y, x, y, -2, Vaddr);
          sp_x := x;
          sp_y := y;
        end;
      end;
      Delay(pause);
    end;

    if (tmr > 5501861) and (tmr <= 5501911) then
    begin
      For i := 0 to 319 do
        for j := 0 to 5501911 - tmr do
        begin
          PutPixel(i,j*2,0,Vaddr);
          PutPixel(i,j*2+1,0,Vaddr);
          PutPixel(i,199-(j*2),0,Vaddr);
          PutPixel(i,199-(j*2)+1,0,Vaddr);
        end;
    end;

    if (tmr > 5502150) and (tmr <= 5502200) then
    begin
      For i := 0 to 319 do
        for j := 0 to tmr - 5502151 do
        begin
          PutPixel(i,j*2,0,Vaddr);
          PutPixel(i,j*2+1,0,Vaddr);
          PutPixel(i,199-(j*2),0,Vaddr);
          PutPixel(i,199-(j*2)+1,0,Vaddr);
        end;
    end;

    if (tmr = 5502200) then
    begin
      For i := 0 to 255 do
        Pal(i, 0, 0, 0);
      k := 0;
    end;

    if (tmr > 5502200)and(tmr <= 5502456) then
    begin
      if k <= 63 then
        for i := k to 255 do
          Pal(i, k, 0, 0);
      if (k > 63)and(k <= 127) then
        for i := k to 255 do
          Pal(i, 63-(k mod 64), k mod 64, 0);
      if (k > 127)and(k <= 191) then
        for i := k to 255 do
          Pal(i, 0, 63-(k mod 64), k mod 64);
      if (k > 191)and(k <= 255) then
        for i := k to 255 do
          Pal(i, k mod 64, 0, 63-(k mod 64));
      Inc(k);
    end;

    if (tmr > 5502600) and (tmr <= 5502856) then
    begin
      Pal(tmr - 5502701, 0, 0, 0);
    end;

    if (tmr > 5502200)and(tmr <= 5502856) then
    begin
      For x := 0 to 319 do
      for y := 0 to 199 do
        PutPixel(x,y,trunc(sqr(x) + x*y + sqr(y) + a_r*x + b_r*y),Vaddr);
      a_r := a_r - 0.1;
      b_r := b_r - 0.1;
    end;

    if (tmr <= 830) or (tmr > 5500000) then
    begin
      WaitRetrace;
      Flip(Vaddr, VGA);
    end;

    if tmr = 5502856 then
      Ex := true;

    If KeyPressed then Key := ReadKey;
    If Key = #27 then Ex := true;
    Key := #0;

  Until Ex;
End.