Program Arc_Demo;

Uses
  crt;

Const
  VGA = $a000;
  n = 10;
  m = 5;

Type
  Virt = array [1..64000] of byte;
  VirtPtr = ^Virt;
  vector = array[1..3] of Real;
  projection = array[1..2] of vector;

Var
  VirtScr : VirtPtr;
  Vaddr : word;
  P : projection;
  absX, absY : integer;

Procedure SetMCGA;
Begin
  asm
    mov ax,0013h
    int 10h
  end;
End;

Procedure CLS(col : byte; where : word);
Begin
  asm
    push es
    mov cx, 32000;
    mov es,[where]
    xor di,di
    mov al,[col]
    mov ah,al
    rep stosw
    pop es
  End;
End;

Procedure WaitRetrace; Assembler;
Label
  l1, l2;
Asm
  mov dx,3DAh
l1:
  in al,dx
  and al,08h
  jnz l1
l2:
  in al,dx
  and al,08h
  jnz l2
End;

Procedure SetUpVirtScr;
Begin
  GetMem(VirtScr, 64000);
  Vaddr := Seg(VirtScr^);
End;

Procedure DestroyVirtScr;
Begin
  FreeMem(VirtScr, 64000);
End;

Procedure PutPixel(x, y : integer; col : byte; where : word);
Begin
  Asm
    mov   ax,[where]
    mov   es,ax
    mov   bx,[X]
    mov   dx,[Y]
    mov   di,bx
    mov   bx, dx
    shl   dx, 8
    shl   bx, 6
    add   dx, bx
    add   di, dx
    mov   al, [Col]
    stosb
  End;
End;

Procedure Flip(source,dest:word);
Begin
  asm
    push  ds
    mov   ax, [Dest]
    mov   es, ax
    mov   ax, [Source]
    mov   ds, ax
    xor   si, si
    xor   di, di
    mov   cx, 32000
    rep   movsw
    pop   ds
  end;
  Move(VirtScr^, Mem[VGA:0], 64000);
End;

Procedure Pal(ColorNo : byte; R, G, B : byte);
Begin
  Port[$3c8] := ColorNo;
  Port[$3c9] := R;
  Port[$3c9] := G;
  Port[$3c9] := B;
End;


Procedure line(a,b,c,d : integer;col : integer; where : word);
  function sgn(a:real):integer;
  begin
    if a>0 then sgn:=+1;
    if a<0 then sgn:=-1;
    if a=0 then sgn:=0;
  end;
var
  i,s,d1x,d1y,d2x,d2y,u,v,m,n:integer;
  count:integer;
begin
  count:=50;
  u:= c - a;
  v:= d - b;
  d1x:= SGN(u);
  d1y:= SGN(v);
  d2x:= SGN(u);
  d2y:= 0;
  m:= ABS(u);
  n := ABS(v);
  IF NOT (M>N) then
  BEGIN
    d2x := 0 ;
    d2y := SGN(v);
    m := ABS(v);
    n := ABS(u);
  END;
  s := m shr 1;
  FOR i := 0 TO m DO
  BEGIN
    if col = -2 then
      putpixel(a,b,count,where)
    else if col = -1 then
      putpixel(a,b,Random(256),where)
    else
      putpixel(a,b,col,where);
    inc (count);
    if count=101 then count:=50;
    s := s + n;
    IF not (s<m) THEN
    BEGIN
      s := s - m;
      a:= a + d1x;
      b := b + d1y;
    END
    ELSE
    BEGIN
      a := a + d2x;
      b := b + d2y;
    END;
  end;
END;

Procedure E012(x, y, col : integer);
Begin
  if Mem[Vaddr:(X-1)+(Y*320)] < col then PutPixel(x-1, y, col, Vaddr);
  if Mem[Vaddr:(X+1)+(Y*320)] < col then PutPixel(x+1, y, col, Vaddr);
  if Mem[Vaddr:X+((Y-1)*320)] < col then PutPixel(x, y-1, col, Vaddr);
  if Mem[Vaddr:X+((Y+1)*320)] < col then PutPixel(x, y+1, col, Vaddr);
End;

Procedure Waaah(x1,y1,x2,y2 : integer);
var i,x,y : integer;
Begin
  For i := 30 downto 15 do
    For x := x1 to x2 do
      For y := y1 to y2 do
        if Mem[Vaddr:X+(Y*320)] > i then E012(x, y, i);
End;

Procedure Change(var a, b : integer);
var c : integer;
begin
  if a > b then
  begin
    c := a;
    a := b;
    b := c;
  end;
end;
{}

Type
  ln = record
    x1,x2,y1,y2 : integer;
    dx1,dx2,dy1,dy2 : integer;
  end;
  wn = record
    x1,x2,y1,y2 : integer;
  end;

var
  lines : array[1..n] of ln;
  windows : array[1..m] of wn;
  i, j, c, x, y : integer;
  Z : boolean;

Begin
  Randomize;
  SetMCGA;
  SetUpVirtScr;
  For i := 1 to n do
    with lines[i] do
    Begin
      x1 := Random(320);
      x2 := Random(320);
      y1 := Random(200);
      y2 := Random(200);
      dx1 := Random(2) * 2 - 1;
      dx2 := Random(2) * 2 - 1;
      dy1 := Random(2) * 2 - 1;
      dy2 := Random(2) * 2 - 1;
    End;

  For i := 1 to m do
    with windows[i] do
    Begin
      x1 := Random(316)+2;
      y1 := Random(196)+2;
      x2 := Random(316)+2;
      y2 := Random(196)+2;
      Change(x1, x2);
      Change(y1, y2);
    End;

  Repeat

    CLS(0, Vaddr);

    For i := 1 to n do
      With lines[i] do
      Begin
        line(x1, y1, x2, y2, 31, Vaddr);
        Inc(x1, dx1);
        if x1 <= 0 then dx1 := 1;
        if x1 >= 319 then dx1 := -1;
        Inc(x2, dx2);
        if x2 <= 0 then dx2 := 1;
        if x2 >= 319 then dx2 := -1;
        Inc(y1, dy1);
        if y1 <= 0 then dy1 := 1;
        if y1 >= 199 then dy1 := -1;
        Inc(y2, dy2);
        if y2 <= 0 then dy2 := 1;
        if y2 >= 199 then dy2 := -1;
      End;

      For i := 1 to m do
        with windows[i] do
        Begin
          Waaah(x1,y1,x2,y2);
        End;
      For i := 1 to m do
        with windows[i] do
        Begin
          Line(x1-2,y1-2,x2+2,y1-2,4,Vaddr);
          Line(x1-2,y2+2,x2+2,y2+2,4,Vaddr);
          Line(x1-2,y1-2,x1-2,y2+2,4,Vaddr);
          Line(x2+2,y1-2,x2+2,y2+2,4,Vaddr);
        End;

    Flip(Vaddr, VGA);

  Until KeyPressed;

  ReadKey;
End.