Program Arc_Demo;

Uses
  crt;

Const
  VGA = $a000;
  n = 1000;

Type
  Virt = array [1..64000] of byte;
  VirtPtr = ^Virt;
  vector = array[1..3] of Real;
  projection = array[1..2] of vector;

Var
  VirtScr : VirtPtr;
  Vaddr : word;
  P : projection;
  absX, absY : integer;

Procedure SetMCGA;
Begin
  asm
    mov ax,0013h
    int 10h
  end;
End;

Procedure CLS(col : byte; where : word);
Begin
  FillChar(Mem[where:0], 64000, col)
End;

Procedure WaitRetrace; Assembler;
Label
  l1, l2;
Asm
  mov dx,3DAh
l1:
  in al,dx
  and al,08h
  jnz l1
l2:
  in al,dx
  and al,08h
  jnz l2
End;

Procedure SetUpVirtScr;
Begin
  GetMem(VirtScr, 64000);
  Vaddr := Seg(VirtScr^);
End;

Procedure DestroyVirtScr;
Begin
  FreeMem(VirtScr, 64000);
End;

Procedure PutPixel(x, y : integer; col : byte; where : word);
Begin
  Asm
    mov   ax,[where]
    mov   es,ax
    mov   bx,[X]
    mov   dx,[Y]
    mov   di,bx
    mov   bx, dx
    shl   dx, 8
    shl   bx, 6
    add   dx, bx
    add   di, dx
    mov   al, [Col]
    stosb
  End;
End;

Procedure Flip(source,dest:word);
Begin
  asm
    push  ds
    mov   ax, [Dest]
    mov   es, ax
    mov   ax, [Source]
    mov   ds, ax
    xor   si, si
    xor   di, di
    mov   cx, 32000
    rep   movsw
    pop   ds
  end;
  Move(VirtScr^, Mem[VGA:0], 64000);
End;

Procedure Pal(ColorNo : byte; R, G, B : byte);
Begin
  Port[$3c8] := ColorNo;
  Port[$3c9] := R;
  Port[$3c9] := G;
  Port[$3c9] := B;
End;

{}
Type
  pnt = record
    x,y : integer;
    col : byte;
  end;

Var
  points : array[1..n] of pnt;
  i : integer;

Begin
  Randomize;
  SetMCGA;
  SetUpVirtScr;
  For i := 1 to n do
    with points[i] do
    begin
      x := 160;
      y := 199;
      col := Random(256);
    end;

  Repeat

    CLS(0, Vaddr);

    For i := 1 to n do
      with points[i] do
        PutPixel(x,y,col,Vaddr);

    For i := 1 to n do
      with points[i] do
      begin
        Inc(x,Random(3)-1);
        Dec(y,Random(2));
        If y < 0 then
        begin
          x := 160;
          y := 199;
          Col := Random(200);
        end;
      end;

    Flip(Vaddr, VGA);

  Until KeyPressed;

  ReadKey;
End.