Program Arc_Demo;

Uses
  crt;

Const
  VGA = $a000;
  n = 50;

Type
  Virt = array [1..64000] of byte;
  VirtPtr = ^Virt;
  vector = array[1..3] of Real;
  projection = array[1..2] of vector;

Var
  VirtScr : VirtPtr;
  Vaddr : word;
  P : projection;
  absX, absY : integer;

Procedure SetMCGA;
Begin
  asm
    mov ax,0013h
    int 10h
  end;
End;

Procedure CLS(col : byte; where : word);
Begin
  FillChar(Mem[where:0], 64000, col)
End;

Procedure WaitRetrace; Assembler;
Label
  l1, l2;
Asm
  mov dx,3DAh
l1:
  in al,dx
  and al,08h
  jnz l1
l2:
  in al,dx
  and al,08h
  jnz l2
End;

Procedure SetUpVirtScr;
Begin
  GetMem(VirtScr, 64000);
  Vaddr := Seg(VirtScr^);
End;

Procedure DestroyVirtScr;
Begin
  FreeMem(VirtScr, 64000);
End;

Procedure PutPixel(x, y : integer; col : byte; where : word);
Begin
  Asm
    mov   ax,[where]
    mov   es,ax
    mov   bx,[X]
    mov   dx,[Y]
    mov   di,bx
    mov   bx, dx
    shl   dx, 8
    shl   bx, 6
    add   dx, bx
    add   di, dx
    mov   al, [Col]
    stosb
  End;
End;

Procedure Flip(source,dest:word);
Begin
  asm
    push  ds
    mov   ax, [Dest]
    mov   es, ax
    mov   ax, [Source]
    mov   ds, ax
    xor   si, si
    xor   di, di
    mov   cx, 32000
    rep   movsw
    pop   ds
  end;
  Move(VirtScr^, Mem[VGA:0], 64000);
End;

Procedure Pal(ColorNo : byte; R, G, B : byte);
Begin
  Port[$3c8] := ColorNo;
  Port[$3c9] := R;
  Port[$3c9] := G;
  Port[$3c9] := B;
End;

{}
Type
  pnt = record
    x : integer;
    y,eld : byte;
  end;

Var
  points : array[0..319,1..n] of pnt;
  k,i, j : integer;

Begin
  Randomize;
  SetMCGA;
  SetUpVirtScr;
  For i := 1 to n do
    For j := 0 to 319 do
      with points[j,i] do
      begin
        x := j;
        y := 199-Random(128);
        eld := 199-y;
      end;
  For i := 0 to 63 do
    Pal(i,i,0,0);
  For i := 64 to 127 do
    Pal(i,63,i,0);

  Repeat

    CLS(0, Vaddr);

    For j := 0 to 319 do
      For i := 1 to n do
        with points[j,i] do
          if y<200 then PutPixel(x,y,127-eld,Vaddr);

    For j := 0 to 319 do
      For i := 1 to n do
        with points[j,i] do
        begin
          Inc(Eld, Random(2));
          Inc(x,Random(3)-1);
          Dec(y,Random(4)-1);
          If Eld>127 then
          begin
            eld := 0;
            x := j;
            y := 199;
          end;
        end;

    Flip(Vaddr, VGA);

  Until KeyPressed;

  ReadKey;
End.