Program Arc_Demo;

Uses
  crt;

Const
  VGA = $a000;

Type
  Virt = array [1..64000] of byte;
  VirtPtr = ^Virt;

Var
  VirtScr : VirtPtr;
  Vaddr : word;

Procedure SetMCGA;
Begin
  asm
    mov ax,0013h
    int 10h
  end;
End;

Procedure CLS(col : byte; where : word);
Begin
  FillChar(Mem[where:0], 64000, col)
End;

Procedure WaitRetrace; Assembler;
Label
  l1, l2;
Asm
  mov dx,3DAh
l1:
  in al,dx
  and al,08h
  jnz l1
l2:
  in al,dx
  and al,08h
  jnz l2
End;

Procedure SetUpVirtScr;
Begin
  GetMem(VirtScr, 64000);
  Vaddr := Seg(VirtScr^);
End;

Procedure DestroyVirtScr;
Begin
  FreeMem(VirtScr, 64000);
End;

Procedure PutPixel(x, y : integer; col : byte; where : word);
Begin
  Mem[where:X+(Y*320)] := col;
End;

Procedure Flip;
Begin
  Move(VirtScr^, Mem[VGA:0], 64000);
End;

Procedure Pal(ColorNo : byte; R, G, B : byte);
Begin
  Port[$3c8] := ColorNo;
  Port[$3c9] := R;
  Port[$3c9] := G;
  Port[$3c9] := B;
End;

Procedure Funny_line(a,b,c,d:integer;where:word);
  function sgn(a:real):integer;
  begin
    if a>0 then sgn:=+1;
    if a<0 then sgn:=-1;
    if a=0 then sgn:=0;
  end;
var
  i,s,d1x,d1y,d2x,d2y,u,v,m,n:integer;
  count:integer;
begin
  count:=50;
  u:= c - a;
  v:= d - b;
  d1x:= SGN(u);
  d1y:= SGN(v);
  d2x:= SGN(u);
  d2y:= 0;
  m:= ABS(u);
  n := ABS(v);
  IF NOT (M>N) then
  BEGIN
    d2x := 0 ;
    d2y := SGN(v);
    m := ABS(v);
    n := ABS(u);
  END;
  s := m shr 1;
  FOR i := 0 TO m DO
  BEGIN
    putpixel(a,b,count,where);
    inc (count);
    if count=101 then count:=50;
    s := s + n;
    IF not (s<m) THEN
    BEGIN
      s := s - m;
      a:= a + d1x;
      b := b + d1y;
    END
    ELSE
    BEGIN
      a := a + d2x;
      b := b + d2y;
    END;
  end;
END;

Function SM : integer;
Begin
  SM := Random(21) - 10;
End;

{}

var
  i, j : integer;
  k4,k5,k3 : integer;
  Key : char;
  Ex : boolean;
  cosX: array [0..1000] of byte;

Begin
  Randomize;
  SetMCGA;
  SetUpVirtScr;
  For i := 0 to 1000 do
    cosX[i] := trunc((cos(i/16)+1)*31.5);

  FOr i := 0 to 127 do
    Pal(i,63-(i div 2),i div 2,0);
  FOr i := 128 to 255 do
    Pal(i,(i div 2)-128,63-(i div 2 - 128),0);
  k4 := 0;
  k5 := 0;
  Repeat
    For i := 0 to 319 do
      for j := 0 to 199 do
        PutPixel(i,j,cosX[(i+k4+(cosX[cosX[k4]]+cosX[cosX[k4]])div 2)] + (cosX[j+i+k4+cosX[k4]]+cosX[319-i+k4+cosX[k4]+
        cosX[k4]])div 2+cosX[199-j+(cosX[cosX[cosX[k4]+j]+i+k4])div 2]+cosX[k4]+k5,Vaddr);


    Inc(k3);
    if k3 > trunc(Pi*64) then k3 := 0;
    k4 := k3 div 2;
    Inc(k5);
    if k5 = 256 then k5 := 0;
    WaitRetrace;
    Flip;

    If KeyPressed then Key := ReadKey;
    If Key = #27 then Ex := true;
    Key := #0;
  Until Ex;

End.