with Ada.Strings.UTF_Encoding; use Ada.Strings.UTF_Encoding;
with System.Address_To_Access_Conversions;

with Win32;

package Windows_Support is

   use Ada;

   package WCHAR_A2A is new System.Address_To_Access_Conversions (Win32.WCHAR);

   Windows_Error : exception;

   -- System error messages
   function Sys_Error_Message (Error_Code : Win32.DWORD) return UTF_8_String;

   -- Raise_Last_OS_Error calls GetLastError to retrieve the code for
   -- the last occuring error in a call to an OS or system library function.
   -- If GetLastError returns an error code, Raise_Last_OS_Error raises
   -- a Windows_Error exception with the error code and a system-provided
   -- message associated with with error.
   procedure Raise_Last_OS_Error with No_Return;

   -- Raise_Last_OS_Error calls GetLastError to retrieve the code for
   -- the last occuring error in a call to an OS or system library function.
   -- If GetLastError returns an error code, Raise_Last_OS_Error raises
   -- a Windows_Error exception with the error code and a system-provided
   -- message associated with with error.
   procedure Raise_Last_OS_Error (Last_Error : Win32.DWORD) with No_Return;

   -- Raise_Last_OS_Error calls GetLastError to retrieve the code for
   -- the last occuring error in a call to an OS or system library function.
   -- If GetLastError returns an error code, Raise_Last_OS_Error raises
   -- a Windows_Error exception with the error code and a system-provided
   -- message associated with with error.
   procedure Check_OS_Error (Last_Error : Win32.DWORD) with Inline;

   -- Check_OS_Error is used to check the return value of a Win32 API function
   -- which returns a BOOL to indicate success. If the Win32 API function
   -- returns False (indicating failure), Check_OS_Error calls
   -- Raise_Last_OS_Error to raise an exception.
   procedure Check_OS_Error (Ret_Val : Win32.BOOL);

end Windows_Support;
