{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

UNIT gxvidmem;

INTERFACE

USES gxtype;

TYPE PSpecSurface=^TSpecSurface;
     TSpecSurface=RECORD
       base:pointer;
       size:dword;
       flags:dword;
     END;

FUNCTION CreateSpecSurface(w,h,bpl:longint;flags:dword;var sp:pointer;var ss:TSpecSurface):boolean;
FUNCTION DestroySpecSurface(var ss:TSpecSurface):boolean;

PROCEDURE InitVideoMem(vms,oms:dword);
{FUNCTION getvideomem(var mem,data:pointer;size:dword):boolean;
FUNCTION getoffscreenmem(var mem,data:pointer;size:dword):boolean;
FUNCTION getsysmem(var mem,data:pointer;size:dword):boolean;
FUNCTION freevideomem(var mem,data:pointer;size:dword):boolean;
FUNCTION freeoffscreenmem(var mem,data:pointer;size:dword):boolean;
FUNCTION freesysmem(var mem,data:pointer;size:dword):boolean;}

IMPLEMENTATION

USES gxsup;

TYPE PMemblock=^TMemBlock;
     TMemblock=RECORD
       base,size:dword;
       used:boolean;
       nextvideomem,nextoffscreenmem:PMemBlock;
     END;

VAR videomemlist,offscreenmemlist:PMemBlock;
{    videomembase,offscreenmembase:dword; }
    videomemsize,offscreenmemsize:dword;

PROCEDURE defraglist;
VAR h,n,d:PMemBlock;
BEGIN
  h:=videomemlist;
  WHILE (h<>nil) DO
    BEGIN
      IF NOT h^.used THEN
        BEGIN
          n:=h^.nextvideomem;
          WHILE (n<>nil) AND NOT n^.used DO
            BEGIN
              h^.size:=h^.size+n^.size;
              d:=n;
              n:=n^.nextvideomem;
              h^.nextvideomem:=n;
              dispose(d);
            END;
          IF (n<>nil) THEN n^.nextoffscreenmem:=h;
        END;
      h:=h^.nextvideomem;
    END;


{  DBG('videomemlist');
  h:=videomemlist;
  WHILE (h<>nil) DO
    BEGIN
      IF h^.used THEN
        DBG('used '+hexlong(h^.base)+'/'+hexlong(h^.size))
      ELSE
        DBG('free '+hexlong(h^.base)+'/'+hexlong(h^.size));
      h:=h^.nextvideomem;
    END; }
END;

PROCEDURE deletelist;
VAR h,d:PMemBlock;
BEGIN
  h:=videomemlist;
  WHILE (h<>nil) DO
    BEGIN
      d:=h;
      h:=h^.nextvideomem;
      dispose(d);
    END;
END;

PROCEDURE initvideomem(vms,oms:dword);
VAR n:PMemBlock;
BEGIN
{  videomembase:=vmb; }
  videomemsize:=vms;
{  offscreenmembase:=omb; }
  offscreenmemsize:=oms;

  deletelist;
  new(n);
  n^.base:=0;
  n^.size:=videomemsize+offscreenmemsize;
  n^.used:=FALSE;
  n^.nextvideomem:=nil;
  n^.nextoffscreenmem:=nil;
  videomemlist:=n;
  offscreenmemlist:=n;
END;

FUNCTION getvideomem(var base:pointer;size:dword):boolean;
VAR h,n:PMemBlock;
BEGIN
  getvideomem:=FALSE;
  h:=videomemlist;
  WHILE (h<>nil) DO
    BEGIN
      IF NOT h^.used AND (h^.size>=size) THEN
        BEGIN
          IF (h^.size>size) THEN
            BEGIN
              new(n);
              n^.base:=h^.base+size;
              n^.size:=h^.size-size;
              n^.used:=FALSE;
              n^.nextvideomem:=h^.nextvideomem;
              n^.nextoffscreenmem:=h;
              h^.base:=h^.base;
              h^.size:=size;
              h^.nextvideomem:=n;
            END;
          dword(base):=h^.base;
          h^.used:=TRUE;
          getvideomem:=TRUE;
          break;
        END;
      h:=h^.nextvideomem;
    END;
END;

FUNCTION getoffscreenmem(var base:pointer;size:dword):boolean;
VAR h,n:PMemBlock;
BEGIN
{DBG('getoffscreenmem');}
  getoffscreenmem:=FALSE;
  h:=offscreenmemlist;
  WHILE (h<>nil) DO
    BEGIN
      IF NOT h^.used AND (h^.size>=size) THEN
        BEGIN
          IF (h^.size>size) THEN
            BEGIN
              new(n);
              n^.base:=h^.base;
              n^.size:=h^.size-size;
              n^.used:=FALSE;
              n^.nextvideomem:=h;
              n^.nextoffscreenmem:=h^.nextoffscreenmem;
              h^.base:=h^.base+h^.size-size;
              h^.size:=size;
              h^.nextoffscreenmem:=n;
            END;
          dword(base):=h^.base;
          h^.used:=TRUE;
          getoffscreenmem:=TRUE;
          break;
        END;
      h:=h^.nextoffscreenmem;
    END;
{DBG(hexlong(longint(data)));}
END;

FUNCTION getsysmem(var base:pointer;size:dword):boolean;
BEGIN
{DBG('getsysmem');}
  getsysmem:=FALSE;
  getmem(base,size);
  IF (base<>nil) THEN getsysmem:=TRUE;
END;

FUNCTION freevideomem(var base:pointer;size:dword):boolean;
VAR h:PMemBlock;
BEGIN
{DBG('freevideomem');}
  freevideomem:=FALSE;
  h:=videomemlist;
  WHILE (h<>nil) DO
    BEGIN
      IF (h^.base=dword(base)) THEN
        BEGIN
          h^.used:=FALSE;
          freevideomem:=TRUE;
          break;
        END;
      h:=h^.nextvideomem;
    END;
  defraglist;
  base:=nil;
END;

FUNCTION freeoffscreenmem(var base:pointer;size:dword):boolean;
VAR h:PMemBlock;
BEGIN
{DBG('freeoffscreenmem');}
  freeoffscreenmem:=FALSE;
  h:=offscreenmemlist;
  WHILE (h<>nil) DO
    BEGIN
      IF (h^.base=dword(base)) THEN
        BEGIN
          h^.used:=FALSE;
          freeoffscreenmem:=TRUE;
          break;
        END;
      h:=h^.nextoffscreenmem;
    END;
  defraglist;
  base:=nil;
END;

FUNCTION freesysmem(var base:pointer;size:dword):boolean;
BEGIN
{DBG('freesysmem');}
  freemem(base,size);
  base:=nil;
{  data:=nil; }
  freesysmem:=TRUE;
END;

{--------------------------------------------------------------------------}

FUNCTION CreateSpecSurface(w,h,bpl:longint;flags:dword;var sp:pointer;var ss:TSpecSurface):boolean;
VAR ok:boolean;
BEGIN
  ss.flags:=flags;
  ss.size:=h*bpl;
  CASE (flags AND mgxsf_memloction) OF
  gxsf_videomem:ok:=getvideomem(ss.base,ss.size);
  gxsf_offscreenmem:ok:=getoffscreenmem(ss.base,ss.size);
  gxsf_sysmem:ok:=getsysmem(ss.base,ss.size);
  END;
  sp:=ss.base;
  CreateSpecSurface:=ok;
END;

FUNCTION DestroySpecSurface(var ss:TSpecSurface):boolean;
BEGIN
  CASE (ss.flags AND mgxsf_memloction) OF
  gxsf_videomem:freevideomem(ss.base,ss.size);
  gxsf_offscreenmem:freeoffscreenmem(ss.base,ss.size);
  gxsf_sysmem:freesysmem(ss.base,ss.size);
  END;
  DestroySpecSurface:=TRUE;
END;

{==========================================================================}

VAR OldExitProc:pointer;

PROCEDURE NewExitProc;
BEGIN
  ExitProc:=OldExitProc;
  deletelist;
END;

BEGIN
  OldExitProc:=ExitProc;
  ExitProc:=@NewExitProc;
  videomemlist:=nil;
  offscreenmemlist:=nil;
END.