{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

USES gxcrt,graphix,gxmouse,gx3d,gx3dtype,gxtext;

{
 short discription:

   wait until the map is created then
   press Enter to display it in isometric 3D
   every other key generates a new landscape
   press ESC to quit the pogram

   the size of the landscape can be definied
   in line 410: 'CreateWorld';

   Move through the landscape by pressing
   the right mouse button and moving it

}

TYPE TLoc=RECORD
       typ:longint;
       height,light:longint;
       col:longint;
     END;

{
  bit 0-2: gelnde
  bit 3-4: gewchse
  bit 5-6: rohstoffe
}

CONST lt_gras=$01;
      lt_sand=$02;
      lt_wasser=$03;
      lt_fels=$04;
      lt_schnee=$05;

VAR world:pointer;
    wxd,wyd:longint;
    cwpx,cwpy:longint;

CONST wpx=-32;
      wpy=-32;

PROCEDURE ReadLoc(var loc:Tloc;x,y:longint);
BEGIN
  move((world+(y*wxd+x)*sizeof(Tloc))^,loc,sizeof(Tloc));
END;

PROCEDURE WriteLoc(var loc:Tloc;x,y:longint);
BEGIN
  move(loc,(world+(y*wxd+x)*sizeof(Tloc))^,sizeof(Tloc));
END;

FUNCTION blend(r,g,b,alpha:byte):longint;
BEGIN
  blend:=rgbcolor((r*alpha) SHR 8,(g*alpha) SHR 8,(b*alpha) SHR 8);
END;

FUNCTION getloccol(typ,alpha:byte):longint;
VAR b:byte;
BEGIN
  b:=random(20);
  CASE typ OF
    1:getloccol:=blend(0,120+b,0,alpha);
    2:getloccol:=blend(180+b,120+b,0,alpha);
    3:getloccol:=blend(50+b,50+b,200+random(20),alpha);
    4:getloccol:=blend(120+b,120+b,120+b,alpha);
    5:getloccol:=blend(220+b,220+b,220+b,alpha);
  END;
END;

PROCEDURE CreateWorld(xsiz,ysiz:longint);
BEGIN
  wxd:=xsiz;
  wyd:=ysiz;
  getmem(world,wxd*wyd*sizeof(Tloc));
  cwpx:=0;
  cwpy:=0;
END;

PROCEDURE ClearWorld;
VAR x,y:longint;
    loc:Tloc;
BEGIN
  FOR x:=1 TO wxd DO
    FOR y:=1 TO wyd DO
      BEGIN
        Loc.typ:=lt_wasser;
        Loc.height:=0;
        Loc.light:=255;
        loc.col:=rgbcolor(0,0,191);
        writeloc(loc,x-1,y-1);
      END;
END;

PROCEDURE RandomWorld;
CONST z=20;
      n=16;

  PROCEDURE wloc(var loc:tloc;x,y:longint);
  VAR col:longint;
  BEGIN
    CASE loc.height OF
    -32768..-1:loc.typ:=lt_wasser;
      0..29:loc.typ:=lt_sand;
      30..149:loc.typ:=lt_gras;
      150..249:loc.typ:=lt_fels;
      250..32767:loc.typ:=lt_schnee;
    END;
    CASE loc.typ OF
      lt_gras:col:=rgbcolor(0,120,0);
      lt_sand:col:=rgbcolor(180,120,0);
      lt_wasser:col:=rgbcolor(0,0,200);
      lt_fels:col:=rgbcolor(120,120,120);
      lt_schnee:col:=rgbcolor(220,220,220);
    END;
    putpixel(x,y,col);
    writeloc(loc,x-1,y-1);
  END;

  PROCEDURE hline(x1,x2,y:longint);
  VAR x,xd:longint;
      h:longint;
      Loc1,Loc2:TLoc;
  BEGIN
    if x2-x1<2 then exit;
    x:=(x1+x2+1) SHR 1;
    readloc(loc1,x1-1,y-1);
    readloc(loc2,x2-1,y-1);
    xd:=(x2-x1);
    h:=(loc1.height+loc2.height) DIV 2-random(xd)+random((xd*z) DIV n);
    loc1.height:=h;
    wloc(loc1,x,y);
    hline(x1,x,y);
    hline(x,x2,y);
  END;

  procedure vline(y1,y2,x: longint);
  var y,yd : longint;
      h : longint;
      Loc1,Loc2:TLoc;
  begin { proc vline }
    if y2-y1<2 then exit;
    y:=(y1+y2+1) SHR 1;
    readloc(loc1,x-1,y1-1);
    readloc(loc2,x-1,y2-1);
    yd:=(y2-y1);
    h:=(loc1.height+loc2.height) DIV 2-random(yd)+random((yd*z) DIV n);
    loc1.height:=h;
    wloc(loc1,x,y);
    vline(y1,y,x);
    vline(y,y2,x);
  end; { proc vline }

  procedure subdivide(x1,y1,x2,y2: longint);
  var x,y : longint;
  begin { proc subdivide }
{    if keypressed then exit; }
    if (x2-x1<2) or (y2-y1<2) then exit;
    if x2-x1>y2-y1 then
      begin
        x:=(x1+x2+1) SHR 1;
        vline(y1,y2,x);
        subdivide(x1,y1,x,y2);
        subdivide(x,y1,x2,y2);
      end
    else
      begin
        y:=(y1+y2+1) SHR 1;
        hline(x1,x2,y);
        subdivide(x1,y1,x2,y);
        subdivide(x1,y,x2,y2);
      end;
  end; { proc subdivide }

begin
  ClearWorld;
  Randomize;
  subdivide(10,10,wxd-10,wyd-10);
end;

PROCEDURE ShadowWorld;
TYPE float=single;
CONST nx=3;
      ny=3;
VAR x,y:longint;
    loc1,loc2,locm:tloc;
    xx,yy,zz,vx,vy,vz:float;

  PROCEDURE EinheitsVektor(var x,y,z:float);
  VAR l:float;
  BEGIN
    l:=sqrt(x*x+y*y+z*z);
    x:=x/l;
    y:=y/l;
    z:=z/l;
  END;

  FUNCTION VektorWinkel(x1,y1,z1,x2,y2,z2:float):float;
  VAR l1,l2:float;
  BEGIN
    l1:=sqrt(x1*x1+y1*y1+z1*z1);
    l2:=sqrt(x2*x2+y2*y2+z2*z2);
    VektorWinkel:=(x1*x2+y1*y2+z1*z2)/(l1*l2+0.1);
  END;

  PROCEDURE NormalVektor(var x,y,z:float;x1,y1,z1,x2,y2,z2:float);
  BEGIN
    x:=(y1*z2-z1*y2);
    y:=(x1*z2-z1*x2);
    z:=(x1*y2-y1*x2);
  END;

  PROCEDURE EinheitsNormalVektor(var x,y,z:float;x1,y1,z1,x2,y2,z2:float);
  VAR l:float;
  BEGIN
    x:=(y1*z2-z1*y2);
    y:=(x1*z2-z1*x2);
    z:=(x1*y2-y1*x2);
    l:=sqrt(x*x+y*y+z*z);
    x:=x/l;
    y:=y/l;
    z:=z/l;
  END;

BEGIN
  FOR y:=1 TO wyd-2 DO
    FOR x:=1 TO wxd-2 DO
      BEGIN
        readloc(locm,x,y);

        vx:=0;
        vy:=0;
        vz:=0;

        readloc(loc1,x-1,y-1);
        readloc(loc2,x,y-1);
        EinheitsNormalVektor(xx,yy,zz,-nx,-ny,loc1.height-locm.height, 0,-ny,loc2.height-locm.height);
        vx:=vx+xx;vy:=vy+yy;vz:=vz+zz;

        loc1:=loc2;
        readloc(loc2,x+1,y);
        EinheitsNormalVektor(xx,yy,zz, 0,-ny,loc1.height-locm.height, +nx, 0,loc2.height-locm.height);
        vx:=vx+xx;vy:=vy+yy;vz:=vz+zz;

        loc1:=loc2;
        readloc(loc2,x+1,y+1);
        EinheitsNormalVektor(xx,yy,zz, +nx, 0,loc1.height-locm.height, +nx,+ny,loc2.height-locm.height);
        vx:=vx+xx;vy:=vy+yy;vz:=vz+zz;

        loc1:=loc2;
        readloc(loc2,x,y+1);
        EinheitsNormalVektor(xx,yy,zz, +nx, +ny,loc1.height-locm.height, 0,+ny,loc2.height-locm.height);
        vx:=vx+xx;vy:=vy+yy;vz:=vz+zz;

        loc1:=loc2;
        readloc(loc2,x-1,y);
        EinheitsNormalVektor(xx,yy,zz, 0, +ny,loc1.height-locm.height, -nx, 0,loc2.height-locm.height);
        vx:=vx+xx;vy:=vy+yy;vz:=vz+zz;

        loc1:=loc2;
        readloc(loc2,x-1,y-1);
        EinheitsNormalVektor(xx,yy,zz, -nx, 0,loc1.height-locm.height, -nx, -ny,loc2.height-locm.height);
        vx:=vx+xx;vy:=vy+yy;vz:=vz+zz;

        locm.light:=128+trunc(VektorWinkel(-vx,-vy,-vz,-1,+1,-1)*127);
        locm.col:=getloccol(locm.typ,locm.light);
        writeloc(locm,x,y);

        putpixel(x,y,locm.col);
      END;
END;

PROCEDURE WorldWaterLevel(h:longint);
VAR Loc:TLoc;
    x,y:longint;
BEGIN
  FOR x:=1 TO wxd DO
    FOR y:=1 TO wyd DO
      BEGIN
        readloc(loc,x-1,y-1);
        IF (loc.height<h) THEN
          BEGIN
            Loc.typ:=lt_wasser;
            Loc.height:=h;
          END;
        writeloc(loc,x-1,y-1);
      END;
END;

PROCEDURE WorldLevel(h:longint);
VAR Loc:TLoc;
    x,y:longint;
BEGIN
  FOR x:=1 TO wxd DO
    FOR y:=1 TO wyd DO
      BEGIN
        readloc(loc,x-1,y-1);
        inc(Loc.height,h);
        CASE loc.height OF
         -32768..-1:loc.typ:=lt_wasser;
          0..29:loc.typ:=lt_sand;
         30..149:loc.typ:=lt_gras;
         150..249:loc.typ:=lt_fels;
         250..32767:loc.typ:=lt_schnee;
        END;
        IF (loc.height<0) THEN loc.height:=0;
        writeloc(loc,x-1,y-1);
      END;
END;

PROCEDURE DisplayWorld(xp,yp,xd,yd,xs,ys:longint);
VAR x,y:longint;
    loc11,loc21,loc12,loc22:tloc;
    rend:prender;
    xm,ym,x1,y1:longint;
BEGIN
  new(rend);
  xp:=xp+yp DIV 2;

  xm:=-xp MOD xs+((yp DIV 2) MOD xs);
  ym:=-yp MOD ys;
  xp:=xp DIV xs;
  yp:=yp DIV ys;
  y:=0;
  REPEAT
{  FOR y:=0 TO yd-1 DO }
    y1:=y+1;
    FOR x:=(y DIV 2) TO (y DIV 2)+xd-1 DO
      IF (xp+x>=0) AND (xp+x<wxd-1) AND (yp+y>=0) AND (yp+y<wyd-1) THEN
      BEGIN
        x1:=x+1;
        ReadLoc(loc11,xp+x,yp+y);
        ReadLoc(loc21,xp+x1,yp+y);
        ReadLoc(loc12,xp+x,yp+y1);
        ReadLoc(loc22,xp+x1,yp+y1);
        rend^.points[0].x:=xm+x*xs+wpx-(y*xs) DIV 2;
        rend^.points[0].y:=ym-loc11.height+y*ys+wpy;
        rend^.points[1].x:=xm+x*xs+wpx-(y1*xs) DIV 2;
        rend^.points[1].y:=ym-loc12.height+y1*ys+wpy;
        rend^.points[2].x:=xm+x1*xs+wpx-(y1*xs) DIV 2;
        rend^.points[2].y:=ym-loc22.height+y1*ys+wpy;
        rend^.colors[0]:=loc11.col;
        rend^.colors[1]:=loc12.col;
        rend^.colors[2]:=loc22.col;
        triangle_gouraud(rend);

        rend^.points[0].x:=xm+x*xs+wpx-(y*xs) DIV 2;
        rend^.points[0].y:=ym-loc11.height+y*ys+wpy;
        rend^.points[1].x:=xm+x1*xs+wpx-(y*xs) DIV 2;
        rend^.points[1].y:=ym-loc21.height+y*ys+wpy;
        rend^.points[2].x:=xm+x1*xs+wpx-(y1*xs) DIV 2;
        rend^.points[2].y:=ym-loc22.height+y1*ys+wpy;
        rend^.colors[0]:=loc11.col;
        rend^.colors[1]:=loc21.col;
        rend^.colors[2]:=loc22.col;
        triangle_gouraud(rend);
      END;
    inc(y);
  UNTIL (yp+y>=wyd) OR (-255+ym+y*ys+wpy>getmaxY);
  dispose(rend);
END;

PROCEDURE DestroyWorld;
BEGIN
  freemem(world,wxd*wyd*sizeof(Tloc));
END;

PROCEDURE DrawScreen;
BEGIN
  bar(0,0,getmaxX,getmaxY,rgbcolor(0,0,80));
  DisplayWorld(cwpx,cwpy,getmaxX DIV 16+6,getmaxY,16,8);
  FlipSurface(TRUE);
END;

PROCEDURE MoveWorld;
VAR ax,ay,mx,my:longint;
BEGIN
  IF (MouseButton=2) THEN
    BEGIN
      SetMousePosition(getmaxX DIV 2,getmaxY DIV 2);
      MouseCoords(ax,ay);
      MouseOff;
      WHILE (MouseButton=2) DO
        BEGIN
          MouseCoords(mx,my);
          IF (mx<>ax) OR (my<>ay) THEN
            BEGIN
              inc(cwpx,(mx-ax)*2);
              inc(cwpy,(my-ay)*2);
              DrawScreen;
              SetMousePosition(getmaxX DIV 2,getmaxY DIV 2);
              MouseCoords(ax,ay);
            END;
        END;
      MouseOn;
    END;
END;

PROCEDURE Message(s:string);
VAR f:TFontVGA;
BEGIN
  f.LoadFont;
  f.outtext(10,getmaxY-20,s,-1);
  f.RemoveFont;
END;

VAR sf:PSurface;

BEGIN
  InitGraphiX(ig_vesa,ig_lfb);
  SetModeGraphiX(640,480,ig_col16);
  InitMouse;
  MouseOff;
  CreateWorld(640,480);
{  ClearWorld; }
  REPEAT
    RandomWorld;
    WorldLevel(-20);
    ShadowWorld;
    Message('press ENTER to see landscape in isometric 3d else generate a new landscape');
  UNTIL (readkey=#13);
  DrawScreen;
  EnableSurfaceFlipping(sf,gxsf_sysmem);
  REPEAT
    MoveWorld;
  UNTIL keypressed;
  readkey;
  DisableSurfaceFlipping(sf);
  DestroyWorld;
END.
