{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

UNIT gxdemo4;

INTERFACE

PROCEDURE GraphixDemo4(background:pointer);

IMPLEMENTATION

USES graphix,gxtext,gximg,gximeff,gxmouse;

VAR FontVGA:PFontVGA;

PROCEDURE Demo_Rotate(bg:pointer);
VAR p:pointer;
    i,mx,my:longint;
BEGIN
  mx:=getmaxX DIV 2;
  my:=getmaxY DIV 2;
  p:=CloneImage(bg);
  FOR i:=0 TO 128 DO
    putimage(0,0,rotateimage(copyimage(p,bg),bg,mx,my,mx,my,getimagewidth(bg),getimageheight(bg),i SHL 9));
  DestroyImage(p);
END;

PROCEDURE Demo_Lens(bg:pointer);
VAR x,y,rx,ry,i:longint;
    d1,m1,s1,s2:pointer;
BEGIN
  putimage(0,0,bg);
  LoadImageFile(itJPG,'gxmask2.jpg',m1,0);
  blendimageALPHA(m1,m1,224);
  d1:=CloneImage(m1);
  s2:=CloneImage(m1);
  s1:=CreateImageWH(128,128);
  x:=getmaxX DIV 2;
  y:=getmaxY DIV 2;
  rx:=-1-random(3);
  ry:=-1-random(3);
  FOR i:=1 TO 500 DO
    BEGIN
      composeimage(s1,bg,-x+64,-y+64);
      composeimage(s2,bg,-x+128,-y+128);
      scaleimage(d1,s1);
      blendimageMASKimage(d1,d1,m1,s2);
      waitforretraceend;
      putimage(x-128,y-128,d1);
      waitforretracestart;
      IF (x<vx1) THEN rx:=+1+random(3);
      IF (x>vx2) THEN rx:=-1-random(3);
      IF (y<vy1) THEN ry:=+1+random(3);
      IF (y>vy2) THEN ry:=-1-random(3);
      inc(x,rx);
      inc(y,ry);
    END;
  FOR i:=1 TO 32 DO putimage(x-rx-128,y-ry-128,blendimageALPHAimage(m1,s2,i*8-1,d1));
  putimage(x-rx-128,y-ry-128,s2);
  DestroyImage(d1);
  DestroyImage(m1);
  DestroyImage(s1);
  DestroyImage(s2);
END;

PROCEDURE Demo_Filter_Mosaic(bg:pointer);
CONST filter1:array[1..3,1..3] of byte=
              ((0,1,0),
               (1,4,1),
               (0,1,0));
VAR p,q,r:pointer;
    i,mx,my:longint;
BEGIN
  mx:=getmaxX DIV 2;
  my:=getmaxY DIV 2;
  p:=cloneimage(bg);
  q:=cloneimage(bg);
  r:=cloneimage(bg);
  FOR i:=1 TO 8 DO putimage(0,0,filterimage(p,copyimage(q,p),filter1,1,1,3,3,0));
  mosaicimage(q,bg,mx,my,64,64);
  averageimage(r,q,4,4,8,8);
  FOR i:=0 TO 32 DO putimage(0,0,blendimageALPHAimage(q,r,i SHL 3,p));
  mosaicimage(p,bg,mx,my,64,64);
  FOR i:=0 TO 32 DO putimage(0,0,blendimageALPHAimage(r,p,i SHL 3,q));
  i:=64;
  REPEAT
    mosaicimage(p,bg,mx,my,i,i);
    putimage(0,0,p);
    dec(i);
  UNTIL (i<=0);
{  putimage(0,0,bg); }
  DestroyImage(p);
  DestroyImage(q);
  DestroyImage(r);
END;

PROCEDURE GraphixDemo4(background:pointer);
BEGIN
  new(FontVGA,LoadFont);
  Demo_Rotate(background);
  Demo_Lens(background);
  Demo_Filter_Mosaic(background);
  dispose(FontVGA,RemoveFont);
END;

END.
