{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

UNIT gxdemo6;

INTERFACE

PROCEDURE GraphixDemo6;

IMPLEMENTATION

USES gxcrt,dos,gxcrtext,graphix,gxmouse,gx3d,gxtype,gx3dtype,gximg,gxdemot,gxtext{,dbgherc};

{$IFDEF LINUX}
CONST sep='/';
{$ELSE}
CONST sep='\';
{$ENDIF}

VAR {curstate:string;}
    curpath:string;
    ft:PFont;

PROCEDURE shadedbar(x1,y1,x2,y2,col1,col2,col3,col4:longint);
VAR rend:trender;
BEGIN
  IF LFBenabled OR MFBused THEN
    BEGIN
      rend.points[0].x:=x1;
      rend.points[0].y:=y1;
      rend.points[1].x:=x2;
      rend.points[1].y:=y1;
      rend.points[2].x:=x1;
      rend.points[2].y:=y2;
      rend.colors[0]:=col1;
      rend.colors[1]:=col2;
      rend.colors[2]:=col3;
      triangle_gouraud(prender(addr(rend)));
      rend.points[0].x:=x2;
      rend.points[0].y:=y1;
      rend.points[1].x:=x1;
      rend.points[1].y:=y2;
      rend.points[2].x:=x2;
      rend.points[2].y:=y2;
      rend.colors[0]:=col2;
      rend.colors[1]:=col3;
      rend.colors[2]:=col4;
      triangle_gouraud(Prender(addr(rend)));
    END;
END;

PROCEDURE BaseScreen;
VAR gxlogo:pointer;
BEGIN
  MouseOff;
  StartDraw;
  LoadImageFile(itGIF,'gxlogo.gif',gxlogo,0);
  bar(0,0,getmaxX,getmaxY,rgbcolorRGB(0,0,80));
  shadedbar(0,100,getmaxX,getmaxY,rgbcolorRGB(0,0,80),rgbcolorRGB(0,0,80),rgbcolorRGB(192,192,192),rgbcolorRGB(192,192,192));
  shadedbar(10,10,getmaxX-10,60,rgbcolorRGB(192,192,192),rgbcolorRGB(96,96,136),rgbcolorRGB(96,96,136),rgbcolorRGB(0,0,80));
  ft2^.outtext(335,20,'Image-Loader-Demo',rgbcolor($00FFFFFF));
  ft3^.outtext(335,45,vergraphix,rgbcolor($00FFFFFF));
  zoomimage(15,15,315,55,gxlogo);
  shadedbar(10,65,getmaxX-10,getmaxY-55,rgbcolorRGB(192,192,192),rgbcolorRGB(96,96,136),rgbcolorRGB(96,96,136),rgbcolorRGB(0,0,80));
  shadedbar(10,getmaxY-50,getmaxX-10,getmaxY-10,rgbcolorRGB(192,192,192),rgbcolorRGB(96,96,136),rgbcolorRGB(96,96,136),rgbcolorRGB(0,0,80));
  DestroyImage(gxlogo);
  EndDraw;
  MouseOn;
END;

FUNCTION MouseArea(x1,y1,x2,y2:longint):boolean;
BEGIN
  MouseArea:=FALSE;
  IF (IsMouseInArea(x1,y1,x2,y2)=129) THEN
    BEGIN
      MouseOff;
      barXOR(x1,y1,x2,y2,$FFFFFF);
      MouseOn;
      WaitButtonReleased;
      MouseOff;
      barXOR(x1,y1,x2,y2,$FFFFFF);
      MouseOn;
      IF (IsMouseInArea(x1,y1,x2,y2)=128) THEN MouseArea:=TRUE;
    END;
END;

PROCEDURE Status(s:string);
BEGIN
  MouseOff;
{  curstate:=s; }
  bar(15,getmaxY-80,getmaxX-15,getmaxY-60,rgbcolorRGB(0,0,80));
  ft1^.outtext(20,getmaxY-78,'Status: '+s,rgbcolor($00FFFFFF));
  MouseOn;
END;

PROCEDURE ProgressIndicator(x,max:longint);
VAR xx,p:longint;
BEGIN
  xx:=(getmaxX-367) DIV 2;
  p:=(x*298) DIV max;
  bar(xx+35,getmaxY-38,xx+35+p,getmaxY-21,rgbcolor($00000080));
  IF (p+1<298) THEN
    bar(xx+35+p+1,getmaxY-38,xx+334,getmaxY-21,rgbcolor($00BFBFBF));
END;

PROCEDURE DisplayImage(x,y:longint;img:pimage);
BEGIN
  MouseOff;
  graphwin(10+5,65+5,getmaxX-10-5,getmaxY-80-5);
  putimage(15+x,70+y,img);
  maxgraphwin;
  MouseOn;
END;

FUNCTION upstr(s:string):string;
VAR i:byte;
BEGIN
  FOR i:=1 TO length(s) DO s[i]:=upcase(s[i]);
  upstr:=s;
END;

VAR liststart:longint;

TYPE Pfilelist=^Tfilelist;
     Tfilelist=RECORD
       name:string;
       size:longint;
       desc:string;
       attr:byte;
       next:Pfilelist;
     END;

CONST drive=$80;

VAR drivelist:boolean;
    firstdrive,lastdrive:Pfilelist;

PROCEDURE GetDriveList(var f,l:PFileList;var len:longint);
VAR i:byte;
    h:PFileList;
    s:string;
BEGIN
  IF drivelist THEN exit;
  drivelist:=TRUE;
  f:=nil;
  l:=nil;
  len:=0;
  FOR i:=1 TO 26 DO
    BEGIN
      s:='';
      DiskSize($FF);
      IF (DiskSize(i)<>-1) THEN
        BEGIN
          new(h);
          h^.name:=chr(65+i-1)+':\';
          h^.size:=0;
          h^.desc:='[DRIVE]';
          h^.attr:=drive;
          h^.next:=nil;
          IF (f=nil) THEN f:=h;
          IF (l<>nil) THEN l^.next:=h;
          l:=h;
          inc(len);
        END;
    END;
END;

PROCEDURE DestroyDriveList(var f,l:PFileList);
VAR i:byte;
    h:PFileList;
    s:string;
BEGIN
  l^.next:=nil;
  WHILE (f<>nil) DO
    BEGIN
      h:=f;
      f:=f^.next;
      dispose(h);
    END;
END;

PROCEDURE GetDirectoryList(var f,l:PFileList;var len:longint);
VAR n,h,p:PFileList;
    DirInfo:SearchRec;
    cn:string;
BEGIN
  f:=nil;
  l:=nil;
  len:=0;
  FindFirst(curpath+'*.*', directory, DirInfo);
  WHILE (DosError=0) DO
    BEGIN
      IF (DirInfo.attr AND directory=directory) THEN
        BEGIN
          new(n);
          n^.name:=DirInfo.name;
          n^.size:=DirInfo.size;
          n^.desc:='[DIRECTORY]';
          n^.attr:=DirInfo.attr AND NOT drive;
          n^.next:=nil;
          cn:=upstr(n^.name);
          h:=f;
          p:=nil;
          WHILE (h<>nil) DO
            BEGIN
              IF (upstr(h^.name)>cn) THEN break;
              p:=h;
              h:=h^.next;
            END;
          IF (p=nil) THEN
            BEGIN
              n^.next:=f;
              f:=n;
              IF (l<>nil) THEN l:=n;
            END
          ELSE
            BEGIN
              n^.next:=p^.next;
              p^.next:=n;
              IF (n^.next=nil) THEN l:=n;
            END;



       {   IF (f=nil) THEN f:=h;
          IF (l<>nil) THEN l^.next:=h;
          l:=h; }
          inc(len);
        END;
      FindNext(DirInfo);
    END;
  FindClose(DirInfo);
END;

PROCEDURE GetFileList(var f,l:PFileList;var len:longint);
VAR n,p,h:PFileList;
    DirInfo:SearchRec;
    cn,desc:string;
    imagetype:Timagetype;
BEGIN
  f:=nil;
  l:=nil;
  len:=0;
  FindFirst(curpath+'*.*', anyfile AND NOT directory, DirInfo);
  WHILE (DosError=0) DO
    BEGIN
{DBG(Dirinfo.name);
desc:='FILE';}
      IF NOT(DirInfo.attr AND directory=directory) THEN
        BEGIN
          imagetype:=whatisimagefile(curpath+DirInfo.Name);
      {    imagetype:=itBMP; }
          CASE imagetype OF
            itBMP:desc:='MS Windows Bitmap';
            itGIF:desc:='Graphics Interchange Format';
            itCUR:desc:='MS Windows Cursor';
            itICO:desc:='MS Windows Icon';
            itJPG:desc:='JPEG Interchange Format';
            itPCX:desc:='Zsoft Image Format';
            itPxM:desc:='Portable Bitmap/Graymap/Pixelmap';
            itPNG:desc:='Portable Network Graphics';
            itTGA:desc:='Targa Graphics';
            itTIF:desc:='Tagged Image Format';
            itunknown:desc:='unknown file format';
          END;
          IF (imagetype<>itunknown) THEN
            BEGIN
              new(n);
              n^.name:=DirInfo.name;
              n^.size:=DirInfo.size;
              n^.desc:=desc;
              n^.attr:=DirInfo.attr AND NOT drive;
              n^.next:=nil;
              cn:=upstr(n^.name);
              h:=f;
              p:=nil;
              WHILE (h<>nil) DO
                BEGIN
                  IF (upstr(h^.name)>cn) THEN break;
                  p:=h;
                  h:=h^.next;
                END;
              IF (p=nil) THEN
                BEGIN
                  n^.next:=f;
                  f:=n;
                  IF (l<>nil) THEN l:=n;
                END
              ELSE
                BEGIN
                  n^.next:=p^.next;
                  p^.next:=n;
                  IF (n^.next=nil) THEN l:=n;
                END;

            {  IF (f=nil) THEN f:=h;
              IF (l<>nil) THEN l^.next:=h;
              l:=h; }
              inc(len);
            END;
        END;
      FindNext(DirInfo);
    END;
  FindClose(DirInfo);
END;

FUNCTION GetFile:string;
VAR h,list:Pfilelist;
    firstdir,lastdir:Pfilelist;
    firstfile,lastfile:Pfilelist;
    listlen,drivelistlen,dirlistlen,filelistlen:longint;
    ch:char;
    directoryselected:boolean;
    fileselected:boolean;

  PROCEDURE DrawList;
  VAR lp:longint;
      h:Pfilelist;
      x,y:longint;
  BEGIN
    Status('current directory: '+curpath);
    MouseOff;
    graphwin(10+5,65+5,getmaxX-10-5,getmaxY-80-5);
    bar(10+5,65+5,getmaxX-10-5,getmaxY-80-5,-1);
    rectangle(10+5,65+5,getmaxX-10-5,getmaxY-80-5,0);
    lp:=0;
    h:=list;
    WHILE (lp<liststart) DO
      BEGIN
        IF (h<>nil) THEN h:=h^.next;
        inc(lp);
      END;
    x:=10+5+5;
    y:=65+5+1;
    WHILE (y<getmaxY-80-5-5) AND (h<>nil) DO
      BEGIN
        ft^.outtext(x,y,h^.name,0);
        ft^.outtext(x+300,y,long2str(h^.size),0);
        ft^.outtext(x+400,y,h^.desc,0);
        inc(y,ft^.fontheight);
        inc(lp);
        h:=h^.next;
      END;
    maxgraphwin;
    MouseOn;
  END;

  FUNCTION SelectElement:Pfilelist;
  VAR x,y,element,cnt:longint;
      h:Pfilelist;
  BEGIN
   SelectElement:=nil;
   IF (ismouseinarea(10+5+1,65+5+1,10+5+300,getmaxY-80-5)=129) THEN
     BEGIN
       MouseCoords(x,y);
       element:=((y-(65+5+1)) DIV ft^.fontheight);
       h:=list;
       cnt:=liststart+element;
       WHILE (h<>nil) AND (cnt>0) DO
         BEGIN
           dec(cnt);
           h:=h^.next;
         END;
       IF (h<>nil) THEN
         BEGIN
           IF mousearea(10+5+1,65+5+1+element*ft^.fontheight,10+5+300,65+5+1+(element+1)*ft^.fontheight) THEN
             BEGIN
               SelectElement:=h;
             END;
         END;
       WaitButtonReleased;
     END;
  END;

BEGIN
  GetFile:='';
  GetDriveList(firstdrive,lastdrive,drivelistlen);
  REPEAT
    GetDirectoryList(firstdir,lastdir,dirlistlen);
    GetFileList(firstfile,lastfile,filelistlen);
    list:=firstdrive;
    lastdrive^.next:=firstdir;
    lastdir^.next:=firstfile;
    listlen:=drivelistlen+dirlistlen+filelistlen;
    DrawList;
    ch:=#0;
    fileselected:=FALSE;
    directoryselected:=FALSE;
    REPEAT
      IF keypressed THEN
        BEGIN
          ch:=readkey;
          CASE ch OF
          #0:CASE readkey OF
             'H':IF (liststart>0) THEN dec(liststart);
             'P':IF (liststart<listlen-1) THEN inc(liststart);
             END;
          END;
          DrawList;
        END;
      MouseMove;
      IF (mousebutton=1) THEN
        BEGIN
          h:=SelectElement;
          IF (h<>nil) THEN
            BEGIN
              IF (h^.attr AND drive=drive) THEN
                BEGIN
                  curpath:=h^.name;
                  directoryselected:=TRUE;
                  liststart:=0;
                END
              ELSE IF (h^.attr AND directory=directory) THEN
                BEGIN
                  IF (h^.name='.') THEN
                    BEGIN
                    END
                  ELSE IF (h^.name='..') THEN
                    BEGIN
                      REPEAT
                        dec(curpath[0]);
                      UNTIL (curpath[length(curpath)]=sep);
                    END
                  ELSE
                    BEGIN
                      curpath:=curpath+h^.name+sep;
                    END;
                  directoryselected:=TRUE;
                  liststart:=0;
                END
              ELSE
                BEGIN
                  fileselected:=TRUE;
                  GetFile:=curpath+h^.name;
                END;
            END;
        END;
    UNTIL (ch=#27) OR directoryselected OR fileselected;
    list:=firstdir;
    WHILE (list<>nil) DO
      BEGIN
        h:=list;
        list:=list^.next;
        dispose(h);
      END;
    lastdrive^.next:=nil;
  UNTIL (ch=#27) OR fileselected;
{  list:=firstdrive;
  WHILE (list<>nil) DO
    BEGIN
      h:=list;
      list:=list^.next;
      dispose(h);
    END; }
  MouseOff;
  shadedbar(10,65,getmaxX-10,getmaxY-55,rgbcolorRGB(192,192,192),rgbcolorRGB(96,96,136),rgbcolorRGB(96,96,136),rgbcolorRGB(0,0,80));
  MouseOn;
END;

PROCEDURE MainMenu;
CONST dk=8;
      dm=2;
      md=20;
VAR ch:char;
    x,y,xx,mx,my:longint;
    cb:pointer;
    imagename:string;
    imageopen:boolean;
    imageptr:pimage;
BEGIN
  xx:=(getmaxX-367) DIV 2;
  x:=0;
  y:=0;
  ch:=#0;
  imageopen:=FALSE;
  imagename:='';
  imageptr:=nil;

  LoadImageFile(itGIF,'gximgcb.gif',cb,0);
  putimageC(xx,getmaxY-44,cb);
  Status('no file opened');

  SetProgressMonitor(@ProgressIndicator);
  REPEAT
    IF keypressed THEN
      BEGIN
        ch:=readkey;
        IF (ch=#0) AND (imageptr<>nil) THEN
          BEGIN
            CASE readkey OF
            'H':inc(y,dk);
            'K':inc(x,dk);
            'M':dec(x,dk);
            'P':dec(y,dk);
            END;
            IF (x+imageptr^.width<getmaxX-30+1) THEN x:=(getmaxX-30+1)-imageptr^.width;
            IF (y+imageptr^.height<getmaxY-155+1) THEN y:=(getmaxY-155+1)-imageptr^.height;
            IF (x>0) THEN x:=0;
            IF (y>0) THEN y:=0;
            displayimage(x,y,imageptr);
          END;
      END;
    IF (MouseButton>0) THEN
      BEGIN
        IF imageopen THEN
          BEGIN
            IF (IsMouseInArea(10+5,65+5,getmaxX-10-5,getmaxY-80-5)>128) THEN
              BEGIN
                MouseCoords(mx,my);
                IF (mx>15) AND (mx<15+md) THEN inc(x,dm);
                IF (my>70) AND (my<70+md) THEN inc(y,dm);
                IF (mx>getmaxX-15-md) AND (mx<getmaxX-15) THEN dec(x,dm);
                IF (my>getmaxY-85-md) AND (my<getmaxY-85) THEN dec(y,dm);
                IF (x+imageptr^.width<getmaxX-30+1) THEN x:=(getmaxX-30+1)-imageptr^.width;
                IF (y+imageptr^.height<getmaxY-155+1) THEN y:=(getmaxY-155+1)-imageptr^.height;
                IF (x>0) THEN x:=0;
                IF (y>0) THEN y:=0;
                displayimage(x,y,imageptr);
              END;
          END;
        IF MouseArea(xx+5,getmaxY-40,xx+26,getmaxY-18) THEN
          BEGIN
         {   imagename:=GetFile;
            IF (imagename<>'') THEN }
            IF EditText(ft1,xx+37,getmaxY-37,295,rgbcolorRGB(0,0,128),rgbcolorRGB(91,191,191),imagename,80) THEN
              BEGIN
                MouseOff;
                IF imageopen THEN DestroyImage(imageptr);
                IF (LoadImageFile(itdetect,imagename,imageptr,0)=0) THEN
                  BEGIN
                    imageopen:=TRUE;
                    Status('['+imagename+'] opened');
                    x:=0;
                    y:=0;
                  END
                ELSE
                  BEGIN
                    Status('cannot open ['+imagename+']');
                  END;
                MouseOn;
              END;
            IF imageopen THEN displayimage(0,0,imageptr);
          END;
      END;
  UNTIL (ch=#27) OR MouseArea(xx+341,getmaxY-40,xx+362,getmaxY-18);
  IF imageopen THEN DestroyImage(imageptr);
  ClearProgressMonitor;
  DestroyImage(cb);
END;

PROCEDURE GraphixDemo6;
BEGIN
  drivelist:=FALSE;
  ft:=ftf;
  getdir(0,curpath);
  liststart:=0;
  IF (curpath[length(curpath)]<>sep) THEN curpath:=curpath+sep;
  BaseScreen;
  MainMenu;
  IF drivelist THEN DestroyDriveList(firstdrive,lastdrive);
END;

END.
