{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{============================================================================}
{ Tseng ET4000AX, ET4000W32, ET6000                                          }
{============================================================================}
{$I gxglobal.cfg}
UNIT gxhw_tsg;

INTERFACE

USES gxbase,gxsup;
{$I gxlocal.cfg}

PROCEDURE setprocs_base_tseng;
PROCEDURE setprocs_hwac_tseng;
PROCEDURE setreslist_tseng4000(var modelist:PModeEntry);
PROCEDURE setreslist_tseng6000(var modelist:PModeEntry);

PROCEDURE initmode_tseng4000(mode:word);
PROCEDURE initmode_tseng6000(mode:word);
PROCEDURE enableregs_tseng;
PROCEDURE disableregs_tseng;
PROCEDURE setcolormode_tseng6000(col:longint);
PROCEDURE scanline_tseng(linewidth:word);
PROCEDURE displaystart_tseng(offs:dword);
PROCEDURE bankswitch_tseng;

PROCEDURE enableLFB_tseng4000(physaddr:dword);
PROCEDURE disableLFB_tseng4000;
PROCEDURE enableLFB_tseng6000(physaddr:dword);
PROCEDURE disableLFB_tseng6000;
PROCEDURE enableMMIO_tseng6000(physaddr:dword);
PROCEDURE disableMMIO_tseng6000;

FUNCTION detect_tseng:longint;
FUNCTION detectmem_tseng4000:word;
FUNCTION detectmem_tseng4000W32:word;
FUNCTION detectmem_tseng6000:word;

IMPLEMENTATION

USES graphix;

{----------------------------------------------------------------------------}
{----------------------------------------------------------------------------}

PROCEDURE get_tseng_iocsba;assembler;
ASM
  PUSH BX
  MOV DX,03D4h
  MOV AL,21h
  OUT DX,AL
  INC DX
  IN AL,DX
  DEC DX
  MOV BH,AL
  MOV AL,22h
  OUT DX,AL
  INC DX
  IN AL,DX
  MOV BL,AL
  MOV DX,BX
  POP BX
END;

PROCEDURE initmode_tseng4000(mode:word);assembler;
ASM
  MOV AX,10F0h
  MOV BX,mode
  OR BH,BH
  JNZ @tseng_not0
  MOV AX,BX
@tseng_not0:
  INT 10h
  MOV BX,mode
  CMP BL,0FFh
  JE @tseng4_nohicolor
  OR BH,BH
  JZ @tseng4_nohicolor
  MOV AX,10F2h
  MOV BL,BH
  MOV BH,0
  INT 10h
@tseng4_nohicolor:
  MOV DX,03BFh
  MOV AL,03h
  OUT DX,AL
  MOV DX,03D8h
  MOV AL,0A0h
  OUT DX,AL
END;

PROCEDURE initmode_tseng6000(mode:word);assembler;
ASM
  MOV AX,10F0h
  MOV BX,mode
  OR BH,BH
  JNZ @tseng_not0
  MOV AX,BX
  XOR AH,AH
@tseng_not0:
  INT 10h
END;

PROCEDURE enableregs_tseng;assembler;
ASM
{unlock extensions}
{  MOV DX,03BFh
  MOV AL,03h
  OUT DX,AL }
  MOV DX,03D8h
  MOV AL,0A0h
  OUT DX,AL
END;

PROCEDURE disableregs_tseng;
BEGIN
END;

PROCEDURE setcolormode_tseng6000(col:longint);assembler;
ASM
  MOV BX,0
  CMP col,ig_col8
  JNE @scm_w1
  MOV BX,0001h
  JMP @scm_w5
@scm_w1:
  CMP col,ig_col15
  JNE @scm_w2
  MOV BX,1000h
  JMP @scm_w5
@scm_w2:
  CMP col,ig_col16
  JNE @scm_w3
  MOV BX,1002h
  JMP @scm_w5
@scm_w3:
  CMP col,ig_col24
  JNE @scm_w4
  MOV BX,2000h
  JMP @scm_w5
@scm_w4:
  CMP col,ig_col32
  JNE @scm_w5
  MOV BX,3000h
  JMP @scm_w5
@scm_w5:

  MOV DX,03DAh  { set 8, 15/16, 24 or 32bit mode }
  IN AL,DX
  MOV DX,03C0h
  MOV AL,16h
  OUT DX,AL
  INC DX
  IN AL,DX
  DEC DX
  AND AL,0CFh
  OR AL,BH
  OUT DX,AL

  MOV DX,03DAh
  IN AL,DX
  MOV DX,03C0h
  MOV AL,20h
  OUT DX,AL

  CALL get_tseng_iocsba
  ADD DX,0058h
  IN AL,DX
  AND AL,0FCh
  OR AL,BL
  OUT DX,AL
END;

PROCEDURE scanline_tseng(linewidth:word);assembler;
ASM
{bit 0-7}
  MOV DX,03D4h
  MOV AH,BYTE PTR linewidth
  MOV AL,13h
  OUT DX,AX
{bit 8}
  MOV AX,linewidth
  SHL AH,7
  AND AH,80h
  MOV AL,3Fh
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,07Fh
  OR AL,AH
  OUT DX,AL
  DEC DX
{bit 9}
  MOV AX,linewidth
  SHL AH,5
  AND AH,40h
  MOV AL,3Fh
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0BFh
  OR AL,AH
  OUT DX,AL
END;

PROCEDURE displaystart_tseng(offs:dword);assembler;
ASM
  MOV EBX,offs
{bit 0-7}
  SHR EBX,2
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Dh
  OUT DX,AX
{bit 8-15}
  SHR EBX,8
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Ch
  OUT DX,AX
{bit 16-19}
  SHR EBX,8
  AND BL,0Fh
  MOV AL,33h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0F0h
  OR AL,BL
  OUT DX,AL
END;

PROCEDURE bankswitch_tseng;assembler;
ASM
  MOV AL,DL
  AND AL,0Fh
  MOV AH,AL
  SHL AH,4
  OR AL,AH
  MOV AH,DL
  MOV DX,03CDh
  OUT DX,AL

  AND AH,030h
  MOV AL,AH
  SHR AL,4
  OR AL,AH
  MOV DX,03CBh
  OUT DX,AL
END;

{FUNCTION detectmem_tseng:word;assembler;
ASM
  MOV DX,03DEh
  MOV AL,03h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AX,000Ch
END;}

{----------------------------------------------------------------------------}

PROCEDURE enableLFB_tseng4000(physaddr:dword);assembler;
ASM
  MOV DX,03D4h {disable LFB}
  MOV AL,36h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0EFh
  OUT DX,AL
  DEC DX

  MOV EBX,physaddr {Set LFB addr}
  SHR EBX,22
  MOV AH,BL
  MOV AL,30h
  OUT DX,AX

  MOV DX,03D4h {enable LFB}
  MOV AL,36h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0EFh
  OR AL,10h
  OUT DX,AL
END;

PROCEDURE disableLFB_tseng4000;assembler;
ASM
  MOV DX,03D4h {disable LFB}
  MOV AL,36h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0EFh
  OUT DX,AL
END;

PROCEDURE enableLFB_tseng6000(physaddr:dword);assembler;
ASM
  CALL get_tseng_iocsba
  ADD DX,0040h
  MOV AL,09h
  OUT DX,AL
END;

PROCEDURE disableLFB_tseng6000;assembler;
ASM
  CALL get_tseng_iocsba
  ADD DX,0040h
  MOV AL,00h
  OUT DX,AL
END;

PROCEDURE enableMMIO_tseng6000(physaddr:dword);assembler;
ASM
  CALL get_tseng_iocsba
  ADD DX,0040h
  IN AL,DX
  OR AL,02h
  OUT DX,AL
END;

PROCEDURE disableMMIO_tseng6000;assembler;
ASM
  CALL get_tseng_iocsba
  ADD DX,0040h
  IN AL,DX
  AND AL,0Dh
  OUT DX,AL
END;

{----------------------------------------------------------------------------}

FUNCTION detect_tseng:longint;assembler;
ASM
  MOV DX,03BFh {enable Tseng-extensions}
  MOV AL,3
  OUT DX,AL
  MOV DX,03D8h
  MOV AL,0A0h
  OUT DX,AL

  MOV DX,03CDh
  IN AL,DX
  XOR AL,3Fh
  OUT DX,AL
  IN AL,DX
  XOR AL,3Fh
  JNZ @tseng_not_detected

  MOV BX,0300h {ID fr ET3000}

  MOV DX,03D4h
  MOV AL,33h
  OUT DX,AL
  INC DX
  IN AL,DX
  XOR AL,0Fh
  OUT DX,AL
  IN AL,DX
  XOR AL,0Fh
  JNZ @tseng_detected_ET3000

  MOV BX,0400h {ID fr ET4000}

  MOV DX,03CBh
  IN AL,DX
  XOR AL,33h
  OUT DX,AL
  IN AL,DX
  XOR AL,33h
  JNZ @tseng_detected_ET4000

  MOV BX,0401h {ID fr ET4000W32x (W32, W32i, W32p)}

  MOV DX,217Ah
  MOV AL,0ECh
  OUT DX,AL
  INC DX
  IN AL,DX
  DEC DX
  AND AL,0F0h
  OR BL,AL   {BX: W32=0401h, W32i=0431h, W32p=0421h}
  MOV AX,BX
  JMP @ende

@tseng_detected_ET4000:
  MOV AX,BX
  JMP @ende

@tseng_detected_ET3000:
  MOV AX,BX
  XOR DX,DX
  JMP @ende

@tseng_not_detected:
  XOR AX,AX
  XOR DX,DX
@ende:
  MOVZX EAX,AX
END;

FUNCTION detectmem_tseng4000:word;assembler;
ASM
  MOV DX,03BFh {enable Tseng-extensions}
  MOV AL,3
  OUT DX,AL
  MOV DX,03D8h
  MOV AL,0A0h
  OUT DX,AL

  MOV DX,03D4h { detect mem-size (ET4000)}
  MOV AL,37h
  OUT DX,AL
  INC DX
  IN AL,DX

  MOV DX,256
  TEST AL,08h
  JZ @tseng_w2
  MOV DX,64
@tseng_w2:
  MOV CL,AL
  AND CL,03h
  DEC CL
  SHL DX,CL
  MOV AX,DX
END;

FUNCTION detectmem_tseng4000W32:word;assembler;
ASM
  MOV DX,03BFh {enable Tseng-extensions}
  MOV AL,3
  OUT DX,AL
  MOV DX,03D8h
  MOV AL,0A0h
  OUT DX,AL

  MOV DX,03D4h { detect mem-size (ET4000W32x)}
  MOV AL,37h
  OUT DX,AL
  INC DX
  IN AL,DX

  MOV DX,1024
  TEST AL,08h
  JZ @tseng_w1
  MOV DX,256
@tseng_w1:
  MOV CL,AL
  AND CL,01h
  INC CL
  SHL DX,CL

  MOV AX,DX
END;

FUNCTION detectmem_tseng6000:word;assembler;
ASM
  CALL get_tseng_iocsba
  ADD DX,0045h
  IN AL,DX

  MOV BX,1024
  MOV CL,AL
  AND CL,03h
  SHL BX,CL

  MOV CL,AL
  SHR CL,2
  AND CL,01h
  SHL BX,CL

  MOV AX,BX
END;

{------------------------------- Hardware-Acceleration ----------------------}

{============================================================================}

PROCEDURE setprocs_base_tseng;
BEGIN
END;

PROCEDURE setprocs_hwac_tseng;
BEGIN
END;

PROCEDURE setreslist_tseng4000(var modelist:PModeEntry);
BEGIN
  AddModeToList(modelist,$0013,  320, 200,1,  320, $28,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$0113,  320, 200,2,  640, $50,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$0213,  320, 200,2,  640, $50,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$002D,  640, 350,1,  640, $50,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$012D,  640, 350,2, 1280, $A0,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$022D,  640, 350,2, 1280, $A0,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$2DFF,  640, 350,3, 1920, $F0,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col24);
  AddModeToList(modelist,$002F,  640, 400,1,  640, $50,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$012F,  640, 400,2, 1280, $A0,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$022F,  640, 400,2, 1280, $A0,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$2FFF,  640, 400,3, 1920, $F0,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col24);
  AddModeToList(modelist,$002E,  640, 480,1,  640, $50,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$012E,  640, 480,2, 1280, $A0,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$022E,  640, 480,2, 1280, $A0,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$2EFF,  640, 480,3, 1920, $F0,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col24);
  AddModeToList(modelist,$0030,  800, 600,1,  800, $64,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$0130,  800, 600,2, 1600, $C8,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$0230,  800, 600,2, 1600, $C8,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$30FF,  800, 600,3, 2400,$12C,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col24);
  AddModeToList(modelist,$0038, 1024, 768,1, 1024, $80,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$0138, 1024, 768,2, 2048,$100,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$0238, 1024, 768,2, 2048,$100,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$38FF, 1024, 768,3, 3072,$180,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col24);
END;

PROCEDURE setreslist_tseng6000(var modelist:PModeEntry);
BEGIN
  AddModeToList(modelist,$0013,  320, 200,1,  320, $28,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$0313,  320, 200,2,  640, $50,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$0413,  320, 200,2,  640, $50,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$0213,  320, 200,3,  960, $78,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col24);
  AddModeToList(modelist,$0213,  320, 200,4, 1280, $A0,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col32);
  AddModeToList(modelist,$001E,  320, 240,1,  320, $28,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$031E,  320, 240,2,  640, $50,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$041E,  320, 240,2,  640, $50,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$021E,  320, 240,3,  960, $78,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col24);
  AddModeToList(modelist,$021E,  320, 240,4, 1280, $A0,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col32);
  AddModeToList(modelist,$001F,  512, 384,1,  512, $40,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$031F,  512, 384,2, 1024, $80,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$041F,  512, 384,2, 1024, $80,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$021F,  512, 384,3, 1536, $C0,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col24);
  AddModeToList(modelist,$021F,  512, 384,4, 2048,$100,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col32);
  AddModeToList(modelist,$002F,  640, 400,1,  640, $50,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$032F,  640, 400,2, 1280, $A0,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$042F,  640, 400,2, 1280, $A0,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$022F,  640, 400,3, 1920, $F0,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col24);
  AddModeToList(modelist,$022F,  640, 400,4, 2560,$140,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col32);
  AddModeToList(modelist,$002E,  640, 480,1,  640, $50,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$032E,  640, 480,2, 1280, $A0,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$042E,  640, 480,2, 1280, $A0,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$022E,  640, 480,3, 1920, $F0,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col24);
  AddModeToList(modelist,$022E,  640, 480,4, 2560,$140,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col32);
  AddModeToList(modelist,$0030,  800, 600,1,  800, $64,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$0330,  800, 600,2, 1600, $C8,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$0430,  800, 600,2, 1600, $C8,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$0230,  800, 600,3, 2400,$12C,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col24);
  AddModeToList(modelist,$0230,  800, 600,4, 3200,$190,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col32);
  AddModeToList(modelist,$0038, 1024, 768,1, 1024, $80,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$0338, 1024, 768,2, 2048,$100,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$0438, 1024, 768,2, 2048,$100,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$0238, 1024, 768,3, 3072,$180,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col24);
  AddModeToList(modelist,$0238, 1024, 768,4, 4096,$200,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb+ig_col32);
  AddModeToList(modelist,$003B, 1152, 864,1, 1152, $90,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$033B, 1152, 864,2, 2304,$120,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$043B, 1152, 864,2, 2304,$120,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$003F, 1280,1024,1, 1280, $A0,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
  AddModeToList(modelist,$033F, 1280,1024,2, 2560,$140,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb+ig_col15);
  AddModeToList(modelist,$043F, 1280,1024,2, 2560,$140,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb+ig_col16);
  AddModeToList(modelist,$0041, 1600,1200,1, 1600, $C8,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb+ig_col8);
END;

{============================================================================}

END.
