{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{============================================================================}
{ 3Dfx Voodoo Banshee, Avenger                                               }
{============================================================================}

{$I gxglobal.cfg}
UNIT gxhw_vdo;

INTERFACE

USES gxtype,gxbase,gxpci,gx3dtype,gxsup,gxmem;
{$I gxlocal.cfg}

PROCEDURE sethwaprocs_voodoo3(col:longint);
PROCEDURE setupdevice_voodoo(baseaddr:dword;var pcidev:TPCIdevice);
PROCEDURE adjustaddresses_voodoo(old_ds_base,new_ds_base:dword);
PROCEDURE setreslist_voodoo3(var modelist:PModeEntry);
FUNCTION detectmem_voodoo3:longint;
PROCEDURE enableregs_voodoo3;
PROCEDURE disableregs_voodoo3;
PROCEDURE initmode_voodoo2(mode:word);
PROCEDURE donemode_voodoo2;
PROCEDURE scanline_voodoo3(linewidth:word);
PROCEDURE displaystart_voodoo3(offs:dword);
PROCEDURE bankswitch_voodoo3;
PROCEDURE enableHWA_voodoo3(col,init,bpl,bpp,pix:longint);
PROCEDURE disableHWA_voodoo3;

IMPLEMENTATION

USES graphix;

CONST
  {=== Voodoo 2 Registers ===}
  fbzMode=$110;
  lfbMode=$114;

  fbiInit4=$200;
  backPorch=$208;
  videoDimensions=$20C;
  fbiInit0=$210;
  fbiInit1=$214;
  fbiInit2=$218;
  fbiInit3=$21C;
  hSync=$220;
  vSync=$224;
  clutData=$228;
  dacData=$22C;
  hBorder=$234;
  vBorder=$238;
  borderColor=$23C;

  fbiInit5=$244;
  fbiInit6=$248;
  fbiInit7=$24C;

  {=== Voodoo 3 Registers ===}
  status=$000;         {0x0 31:0 R Avenger status register}
  intCtrl=$004;        {0x1 31:0 R/W Interrupt control and status}
  clip0Min=$008;       {0x2 28:0 R/W Min X & Y clip values when clip select is 0}
  clip0Max=$00c;       {0x3 28:0 R/W Max X & Y clip values when clip select is 0}
  dstBaseAddr=$010;    {0x4 23:0 R/W Destination base address}
  dstFormat=$014;      {0x5 17:0 R/W Destination stride and bits per pixel}
  srcColorkeyMin=$018; {0x6 23:0 R/W Source Colorkey range (min)}
  srcColorkeyMax=$01c; {0x7 23:0 R/W Source Colorkey range (max)}
  dstColorkeyMin=$020; {0x8 23:0 R/W Destination Colorkey range (min)}
  dstColorkeyMax=$024; {0x9 23:0 R/W Destination Colorkey range (max)}
  bresError0=$028;     {0xA 31:0 R/W Initial error for lines, right edges & stretch blt x}
  bresError1=$02c;     {0xB 31:0 R/W Initial error for left poly edges & stretch blt y}
  rop=$030;            {0xC 31:0 R/W 4 Ternary Raster operations}
  srcBaseAddr=$034;    {0xD 23:0 R/W Source base address}
  commandExtra=$038;   {0xE 31:0 R/W Extra control bits}
  lineStipple=$03c;    {0xF 31:0 R/W Monochrome pattern for lines}
  lineStyle=$040;      {0x10 28:0 R/W Style register for lines}
  pattern0Alias=$044;  {0x11 31:0 R/W Alias to colorPattern(0)}
  pattern1Alias=$048;  {0x12 31:0 R/W Alias to colorPattern(1)}
  clip1Min=$04c;       {0x13 28:0 R/W Min X & Y clip values when clip select is 1}
  clip1Max=$050;       {0x14 28:0 R/W Max X & Y clip values when clip select is 1}
  srcFormat=$054;      {0x15 18:0 R/W Source stride and bits per pixel}
  srcSize=$058;        {0x16 28:0 R/W Height and width of source for stretch blts}
  srcXY=$05c;          {0x17 28:0 R/W Starting pixel of blt source data, Starting position for lines, Top-most point for a polygon fill}
  colorBack=$060;      {0x18 31:0 R/W Background color}
  colorFore=$064;      {0x19 31:0 R/W Foreground color}
  dstSize=$068;        {0x1A 28:0 R/W Destination width and height for blts and rectangle fills}
  dstXY=$06c;          {0x1B 28:0 R/W Starting X and Y of destination for blts, End point for lines}
  command=$070;        {0x1C 31:0 R/W 2D command mode & control bits}
  launcharea=$80;

VAR initregs:word;
    mmiomap0:tmmiomap;
    mmiomap1:tmmiomap;
    reg_io:dword;
    reg_mc:dword;
    reg_2d:dword;
    reg_3d:dword;
    mem_tmu0:dword;
    mem_tmu1:dword;
    mem_yuv:dword;
    mem_3dlfb:dword;
    reg_graph:dword;
{    lfboffs:dword; }
    mem_tex:dword;

PROCEDURE setupdevice_voodoo(baseaddr:dword;var pcidev:TPCIdevice);
BEGIN
  CASE pcidev.device OF
  $0001,$0002:
    BEGIN
      mapresource(mmiomap0,pcidev.base0 AND $FF000000,getpcibasesize(baseaddr,0));
      reg_graph:=mmiomap0.offs+$00000000;
      lfbbase:=mmiomap0.offs+$00400000;
      mem_tex:=mmiomap0.offs+$00800000;
    END;
  $0003,$0004,$0005:
    BEGIN
      mapresource(mmiomap0,pcidev.base0 AND $FE000000,getpcibasesize(baseaddr,0));
      mapresource(mmiomap1,pcidev.base1 AND $FE000000,getpcibasesize(baseaddr,1));
      reg_io:=   mmiomap0.offs+$00000000;
      reg_mc:=   mmiomap0.offs+$00080000;
      reg_2d:=   mmiomap0.offs+$00100000;
      reg_3d:=   mmiomap0.offs+$00200000;
      mem_tmu0:= mmiomap0.offs+$00600000;
      mem_tmu1:= mmiomap0.offs+$00800000;
      mem_yuv:=  mmiomap0.offs+$00C00000;
      mem_3dlfb:=mmiomap0.offs+$01000000;
      lfbbase:=mmiomap1.offs;
      initregs:=pcidev.base2 AND $0000FFF0;
    END;
  END;
END;

PROCEDURE adjustaddresses_voodoo(old_ds_base,new_ds_base:dword);
BEGIN
  adjustaddress(reg_graph,old_ds_base,new_ds_base);
  adjustaddress(mem_tex,old_ds_base,new_ds_base);
  adjustaddress(reg_io,old_ds_base,new_ds_base);
  adjustaddress(reg_mc,old_ds_base,new_ds_base);
  adjustaddress(reg_2d,old_ds_base,new_ds_base);
  adjustaddress(reg_3d,old_ds_base,new_ds_base);
  adjustaddress(mem_tmu0,old_ds_base,new_ds_base);
  adjustaddress(mem_tmu1,old_ds_base,new_ds_base);
  adjustaddress(mem_yuv,old_ds_base,new_ds_base);
  adjustaddress(mem_3dlfb,old_ds_base,new_ds_base);
  adjustaddress(lfbbase,old_ds_base,new_ds_base);
END;

{----------------------------------------------------------------------------}

FUNCTION detectmem_voodoo3:longint;assembler;
ASM
  MOV AX,4096
END;

{----------------------------------------------------------------------------}

PROCEDURE enableregs_voodoo3;assembler;
ASM
  MOV DX,initregs
  ADD DX,0028h
  IN EAX,DX
  AND EAX,0FFFFFFBFh
  OR EAX,000000040h
  OUT DX,EAX
END;

PROCEDURE disableregs_voodoo3;
BEGIN
END;

PROCEDURE initmode_voodoo2(mode:word);
CONST w=640;
      h=480;
      b=5;
      p=5;
      hsoff=2*p+2*b+w;
      vsoff=2*p+2*b+h;
      hson=40;
      vson=40;
BEGIN
  dword(pointer(reg_graph+hSync)^):=(hsoff SHL 16)+hson;
  dword(pointer(reg_graph+vSync)^):=(vsoff SHL 16)+vson;
  dword(pointer(reg_graph+hBorder)^):=(b SHL 16)+b;
  dword(pointer(reg_graph+vBorder)^):=(b SHL 16)+b;
  dword(pointer(reg_graph+backPorch)^):=(p SHL 16)+p;
  dword(pointer(reg_graph+videoDimensions)^):=(h SHL 16)+w;

  dword(pointer(reg_graph+fbiInit0)^):=1;
END;

PROCEDURE donemode_voodoo2;
BEGIN
  dword(pointer(reg_graph+fbiInit0)^):=0;
END;

PROCEDURE scanline_voodoo3(linewidth:word);assembler;
ASM
END;

PROCEDURE displaystart_voodoo3(offs:dword);assembler;
ASM
END;

PROCEDURE bankswitch_voodoo3;assembler;
ASM
  MOV EBX,EDX
  MOV DX,initregs
  ADD DX,0028h
  IN EAX,DX
  SHL EBX,14
  AND EAX,0FFC03FFFh
  AND EBX,0003FC000h
  OR EAX,EBX
  OUT DX,EAX
END;

{------------------------------- Hardware-Acceleration ----------------------}

VAR srcFormatReg,dstFormatReg:longint;

PROCEDURE enableHWA_voodoo3(col,init,bpl,bpp,pix:longint);
BEGIN
  CASE col OF
  ig_col8:srcFormatReg:=$00010000;
  ig_col15:srcFormatReg:=$00020000;
  ig_col16:srcFormatReg:=$00030000;
  ig_col24:srcFormatReg:=$00040000;
  ig_col32:srcFormatReg:=$00050000;
  END;
  CASE col OF
  ig_col8:dstFormatReg:=$00010000;
  ig_col15:dstFormatReg:=$00020000;
  ig_col16:dstFormatReg:=$00030000;
  ig_col24:dstFormatReg:=$00040000;
  ig_col32:dstFormatReg:=$00050000;
  END;
  ASM
    MOV EDI,reg_2d
    MOV EAX,0
    MOV [EDI+commandExtra],EAX
    MOV EAX,bytperline
    OR EAX,dstformatReg
    MOV [EDI+dstFormat],EAX
  END;
END;

PROCEDURE disableHWA_voodoo3;
BEGIN
END;

PROCEDURE graphwinhw_voodoo3(x1,y1,x2,y2:longint);assembler;
ASM
  MOV EDI,reg_2d
  MOV AX,WORD PTR y1
  MOV BX,WORD PTR y2
  INC BX
  SHL EAX,16
  SHL EBX,16
  MOV AX,WORD PTR x1
  MOV BX,WORD PTR x2
  INC BX
  MOV [EDI+clip0Min],EAX
  MOV [EDI+clip0Max],EBX
  MOV EAX,frontdrawoffset
  MOV [EDI+srcBaseAddr],EAX
  MOV [EDI+dstBaseAddr],EAX
END;

PROCEDURE setpatternHW_voodoo3(pattern:ppattern);assembler;
ASM
  MOV EDI,reg_2d
  MOV EBX,pattern
  MOV EAX,[EBX]
  MOV [EDI+pattern0Alias],EAX
  MOV EAX,[EBX+4]
  MOV [EDI+pattern1Alias],EAX
END;

{----------------------------- line ---------------------------------------}

PROCEDURE line_voodoo3(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EAX,x1
  MOV EBX,y1
  MOV ECX,x2
  MOV EDX,y2
  MOV EDI,reg_2d
  SHL EBX,16
  SHL EDX,16
  MOV BX,AX
  MOV DX,CX
  MOV [EDI+srcXY],EBX
  MOV [EDI+dstXY],EDX
  MOV EAX,bytperline
  OR EAX,dstformatReg
  MOV [EDI+dstFormat],EAX
  MOV EAX,f
  MOV [EDI+colorFore],EAX
  MOV EAX,0CC000106h
  MOV [EDI+command],EAX
@busy:
  TEST DWORD PTR [EDI+status],00000400h
  JNZ @busy
END;

{-------------------------------- lineH -------------------------------------}

PROCEDURE lineH_voodoo3(x1,x2,y,f:longint);assembler;
ASM
  MOV EAX,x1
  MOV EBX,y
  MOV ECX,x2
  CMP EAX,ECX
  JLE @lh_vdo_w1
  XCHG EAX,ECX
@lh_vdo_w1:
  MOV EDI,reg_2d
  SUB ECX,EAX
  MOV EDX,00010000h
  INC ECX
  SHL EBX,16
  MOV BX,AX
  MOV DX,CX
  MOV [EDI+dstXY],EBX
  MOV [EDI+dstSize],EDX
  MOV EAX,bytperline
  OR EAX,dstformatReg
  MOV [EDI+dstFormat],EAX
  MOV EAX,f
  MOV [EDI+colorFore],EAX
  MOV EAX,0FFFFFFFFh
  MOV [EDI+pattern0Alias],EAX
  MOV [EDI+pattern1Alias],EAX
  MOV EAX,0CC002105h
  MOV [EDI+command],EAX
{@busy:
  TEST DWORD PTR [EDI+status],00000400h
  JNZ @busy }
END;

{-------------------------------- lineH_pattern -----------------------------}

PROCEDURE lineH_pattern_voodoo3(x1,x2,y,f:longint);assembler;
ASM
{   CALL setpattern_voodoo3}
  MOV EAX,x1
  MOV EBX,y
  MOV ECX,x2
  CMP EAX,ECX
  JLE @lh_vdo_w1
  XCHG EAX,ECX
@lh_vdo_w1:
  MOV EDI,reg_2d
  SUB ECX,EAX
  MOV EDX,00010000h
  INC ECX
  SHL EBX,16
  MOV BX,AX
  MOV DX,CX
  MOV [EDI+dstXY],EBX
  MOV [EDI+dstSize],EDX
  MOV EAX,bytperline
  OR EAX,dstformatReg
  MOV [EDI+dstFormat],EAX
  MOV EAX,f
  MOV [EDI+colorFore],EAX
  MOV EAX,0CC012105h
  MOV [EDI+command],EAX
{@busy:
  TEST DWORD PTR [EDI+status],00000400h
  JNZ @busy }
END;

{-------------------------------- bar -------------------------------------}

PROCEDURE bar_voodoo3(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EAX,x1
  MOV EBX,y1
  MOV ECX,x2
  MOV EDX,y2
  CMP EAX,ECX
  JLE @br_vdo_w1
  XCHG EAX,ECX
@br_vdo_w1:
  CMP EBX,EDX
  JLE @br_vdo_w2
  XCHG EBX,EDX
@br_vdo_w2:
  MOV EDI,reg_2d
  SUB ECX,EAX
  SUB EDX,EBX
  INC ECX
  INC EDX
  SHL EBX,16
  SHL EDX,16
  MOV BX,AX
  MOV DX,CX
  MOV [EDI+dstXY],EBX
  MOV [EDI+dstSize],EDX
  MOV EAX,bytperline
  OR EAX,dstformatReg
  MOV [EDI+dstFormat],EAX
  MOV EAX,f
  MOV [EDI+colorFore],EAX
  MOV EAX,0FFFFFFFFh
  MOV [EDI+pattern0Alias],EAX
  MOV [EDI+pattern1Alias],EAX
  MOV EAX,0CC002105h
  MOV [EDI+command],EAX
@busy:
  TEST DWORD PTR [EDI+status],00000400h
  JNZ @busy
END;

{-------------------------------- bar_pattern -------------------------------}

PROCEDURE bar_pattern_voodoo3(x1,y1,x2,y2,f:longint);assembler;
ASM
{  CALL setpattern_voodoo3 }
  MOV EAX,x1
  MOV EBX,y1
  MOV ECX,x2
  MOV EDX,y2
  CMP EAX,ECX
  JLE @br_vdo_w1
  XCHG EAX,ECX
@br_vdo_w1:
  CMP EBX,EDX
  JLE @br_vdo_w2
  XCHG EBX,EDX
@br_vdo_w2:
  MOV EDI,reg_2d
  SUB ECX,EAX
  SUB EDX,EBX
  INC ECX
  INC EDX
  SHL EBX,16
  SHL EDX,16
  MOV BX,AX
  MOV DX,CX
  MOV [EDI+dstXY],EBX
  MOV [EDI+dstSize],EDX
  MOV EAX,bytperline
  OR EAX,dstformatReg
  MOV [EDI+dstFormat],EAX
  MOV EAX,f
  MOV [EDI+colorFore],EAX
  MOV EAX,0CC012105h
  MOV [EDI+command],EAX
@busy:
  TEST DWORD PTR [EDI+status],00000400h
  JNZ @busy
END;

{-------------------------------- barXOR ----------------------------------}

PROCEDURE barXOR_voodoo3(x1,y1,x2,y2,f:longint);assembler;
ASM
  MOV EAX,x1
  MOV EBX,y1
  MOV ECX,x2
  MOV EDX,y2
  CMP EAX,ECX
  JLE @br_vdo_w1
  XCHG EAX,ECX
@br_vdo_w1:
  CMP EBX,EDX
  JLE @br_vdo_w2
  XCHG EBX,EDX
@br_vdo_w2:
  MOV EDI,reg_2d
  SUB ECX,EAX
  SUB EDX,EBX
  INC ECX
  INC EDX
  SHL EBX,16
  SHL EDX,16
  MOV BX,AX
  MOV DX,CX
  MOV [EDI+dstXY],EBX
  MOV [EDI+dstSize],EDX
  MOV EAX,bytperline
  OR EAX,dstformatReg
  MOV [EDI+dstFormat],EAX
  MOV EAX,f
  MOV [EDI+colorFore],EAX
  MOV EAX,0FFFFFFFFh
  MOV [EDI+pattern0Alias],EAX
  MOV [EDI+pattern1Alias],EAX
  MOV EAX,066002105h
  MOV [EDI+command],EAX
@busy:
  TEST DWORD PTR [EDI+status],00000400h
  JNZ @busy
END;

{-------------------------------- barXOR_pattern ----------------------------}

PROCEDURE barXOR_pattern_voodoo3(x1,y1,x2,y2,f:longint);assembler;
ASM
{  CALL setpattern_voodoo3 }
  MOV EAX,x1
  MOV EBX,y1
  MOV ECX,x2
  MOV EDX,y2
  CMP EAX,ECX
  JLE @br_vdo_w1
  XCHG EAX,ECX
@br_vdo_w1:
  CMP EBX,EDX
  JLE @br_vdo_w2
  XCHG EBX,EDX
@br_vdo_w2:
  MOV EDI,reg_2d
  SUB ECX,EAX
  SUB EDX,EBX
  INC ECX
  INC EDX
  SHL EBX,16
  SHL EDX,16
  MOV BX,AX
  MOV DX,CX
  MOV [EDI+dstXY],EBX
  MOV [EDI+dstSize],EDX
  MOV EAX,bytperline
  OR EAX,dstformatReg
  MOV [EDI+dstFormat],EAX
  MOV EAX,f
  MOV [EDI+colorFore],EAX
  MOV EAX,066012105h
  MOV [EDI+command],EAX
@busy:
  TEST DWORD PTR [EDI+status],00000400h
  JNZ @busy
END;

{------------------------- moverect ---------------------------------------}

PROCEDURE moverect_voodoo3(x1,y1,x2,y2,x,y:longint);assembler;
VAR dstX,dstY,srcX,srcY,sgn,scl,stpo:longint;
ASM
  MOV EAX,x
  MOV EBX,y
  MOV ECX,x1
  MOV EDX,y1
  MOV EDI,x2
  MOV ESI,y2
{---}
  CMP ECX,EDI
  JLE @mr_vdo_w1
  XCHG ECX,EDI
@mr_vdo_w1:
  CMP EDX,ESI
  JLE @mr_vdo_w2
  XCHG EDX,ESI
@mr_vdo_w2:
{---}
  SUB EDI,ECX
  SUB ESI,EDX
  MOV stpo,0
{---}
  CMP EAX,ECX
  JLE @mr_vdo_w3
  OR stpo,00004000h
  ADD EAX,EDI
  ADD ECX,EDI
@mr_vdo_w3:
  CMP EBX,EDX
  JLE @mr_vdo_w4
  OR stpo,00008000h
  ADD EBX,ESI
  ADD EDX,ESI
@mr_vdo_w4:
{---}
  INC ESI
  INC EDI
{---}
  SHL ESI,16
  MOV SI,DI
  SHL EBX,16
  MOV BX,AX
  SHL EDX,16
  MOV DX,CX
{---}
  MOV EDI,reg_2d
  MOV [EDI+dstSize],ESI
  MOV [EDI+srcXY],EDX
  MOV [EDI+dstXY],EBX
  MOV EAX,bytperline
  OR EAX,srcFormatReg
  MOV [EDI+srcFormat],EAX
  MOV EAX,bytperline
  OR EAX,dstFormatReg
  MOV [EDI+dstFormat],EAX
  MOV EAX,0CC000101h
  OR EAX,stpo
  MOV [EDI+command],EAX
@busy:
  TEST DWORD PTR [EDI+status],00000400h
  JNZ @busy
END;

{=== 3D-Funktionen ==========================================================}
{ ... none ...}
{============================================================================}

PROCEDURE setreslist_voodoo3(var modelist:PModeEntry);
BEGIN
END;

{============================================================================}

PROCEDURE sethwaprocs_voodoo3(col:longint);
BEGIN
  graphwinHW:=@graphwinHW_voodoo3;
  setpatternHW:=@setpatternHW_voodoo3;
  line:=@line_voodoo3;
  lineH:=@lineH_voodoo3;
  lineH_solid:=@lineH_voodoo3;
  lineH_pattern:=@lineH_pattern_voodoo3;
  bar:=@bar_voodoo3;
  bar_solid:=@bar_voodoo3;
  bar_pattern:=@bar_pattern_voodoo3;
  barXOR:=@barXOR_voodoo3;
  barXOR_solid:=@barXOR_voodoo3;
  barXOR_pattern:=@barXOR_pattern_voodoo3;
  moverect:=@moverect_voodoo3;
END;

END.
