{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{
                       --------------------------
                        G r a p h i X   V E S A
                       --------------------------
                                 v1.00
                       --------------------------
}

{$I gxglobal.cfg}
UNIT gxvbe;

INTERFACE

USES graphix,go32,gxcrtext,gxbase,gxsup{,dbgherc};
{$I gxlocal.cfg}

TYPE PVBEInfo=^TVBEInfo;
     TVBEInfo=RECORD
       Signature:array[0..3] of char;
       Version:word;
       ptr2OEMname:longint;
       capabilities:longint;
       ptr2VBEnOEMmodes:longint;
       memory:word;
       OEMversion:word;
       ptr2vendorname:longint;
       ptr2productname:longint;
       ptr2productrevstring:longint;
       AccelVbeVersion:word;
       AccelVideoModePtr:longint;
       reserved:array[$2A..$FF] of byte;
       oemdata:array[$00..$FF] of byte
     END;

     TSupVBEInfo=RECORD
       signature:array[0..6] of char;
       Version:word;
       capabilities1:longint;
       capabilities2:longint;
       oemsoftwarerev:word;
       ptr2vendorname:longint;
       ptr2productname:longint;
       ptr2productrevstring:longint;
       ptr2string:longint;
       reserved:array[$25..$FF] of byte;
     END;

     TVBEModeInfo=RECORD
       modeattr:word;
       winAattr:byte;
       winBattr:byte;
       wingran:word;
       winsize:word;
       startA:word;
       startB:word;
       winposptr:pointer;
       bytperscanline:word;
       {--- VBE 1.2 ---}
       width:word;
       height:word;
       cellwidth:byte;
       cellheight:byte;
       memplanes:byte;
       bitsperpix:byte;
       banks:byte;
       memmodel:byte;
       banksize:byte;
       pages:byte;
       reserved1:byte;
       {--- Direct Color Fields ---}
       redmasksize:byte;
       redmaskpos:byte;
       greenmasksize:byte;
       greenmaskpos:byte;
       bluemasksize:byte;
       bluemaskpos:byte;
       resmasksize:byte;
       resmaskpos:byte;
       directscrnmodeinfo:byte;
       {--- VBE 2.0 ---}
       lfbaddr:longint;
       reserved2:longint;
       reserved3:word;
       {--- VBE 3.0 ---}
       Linbytperscanline:word;
       BnkNumPages:byte;
       LinNumPages:byte;
       LinRedmasksize:byte;
       LinRedmaskpos:byte;
       LinGreenmasksize:byte;
       LinGreenmaskpos:byte;
       LinBluemasksize:byte;
       LinBluemaskpos:byte;
       LinResmasksize:byte;
       LinResmaskpos:byte;
       MaxPixelClock:longint;
       reserved4:array[$42..$FF] of byte;
     END;

VAR vbepmod32_code,vbepmod32_bankswitch,vbepmod32_displaystart:pointer;
    vbepmod32_mmiosel,vbepmod32_mmiosize,vbepmod32_codesize:word;
    vbepmod32_mmiophys,vbepmod32_mmiolinear:longint;
    vbepmod32_used:boolean;

    vbepmep_codesel:word;
    vbepmep_codeentry:longint;
    vbepmep_stacksel:word;
    vbepmep_stackbuf:pointer;
    vbepmep_used:boolean;

PROCEDURE initmode_vesa(mode:word);
PROCEDURE setrgbcolor_vesa(i,r,g,b:byte);
PROCEDURE scanline_vesa12(linewidth:word);
PROCEDURE scanline_vesa20(linewidth:word);
PROCEDURE displaystart_vesa12(offs:dword);
PROCEDURE displaystart_vesa20(offs:dword);
PROCEDURE displaystart_vbepmod32(offs:dword);
PROCEDURE bankswitch_vesa;
PROCEDURE bankswitch_vbepmod32;

FUNCTION Get_VBE_Info(var VBEInfo:TVBEInfo):boolean;
FUNCTION Get_SupVBE_Info(var SupVBEInfo:TSupVBEInfo;func:word):boolean;
FUNCTION Get_VBE_OEM_String:string;
FUNCTION Get_VBE_Mode_Info(var VBEModeInfo:TVBEModeInfo;nr:word):boolean;
PROCEDURE Scan_VBE_Modes(var modelist:PModeEntry;overrideflags:dword);
PROCEDURE Setup_VBEPMod32_Interface;
PROCEDURE Cleanup_VBEPMod32_interface;
PROCEDURE Setup_VBEAF_Interface;
PROCEDURE Cleanup_VBEAF_interface;
PROCEDURE Setup_VBEPMEP_Interface;
PROCEDURE Cleanup_VBEPMEP_interface;

IMPLEMENTATION

procedure dosalloc(var selector:word; var segment:word;size:longint);
var res:longint;
begin
  res:=global_dos_alloc(size);
  selector:=word(res);
  segment:=word(res shr 16);
end;

procedure dosfree(selector:word);
begin
  global_dos_free(selector);
end;

FUNCTION create_ldt_selector(base,limit:longint):word;
VAR sel:word;
BEGIN
  sel:=allocate_ldt_descriptors(1);
  Set_Segment_Base_Address(sel,base);
  Set_Segment_Limit(sel,limit-1);
  create_ldt_selector:=sel;
END;

{----------------------------------------------------------------------------}

PROCEDURE initmode_vesa(mode:word);assembler;
ASM
  MOV AX,4F02h
  MOV BX,mode
  XOR CX,CX
  XOR DX,DX
  INT 10h
END;

PROCEDURE setrgbcolor_vesa(i,r,g,b:byte);
VAR RealRegs:TRealRegs;
    segment,selector:word;
    col:dword;
    sh:byte;
BEGIN
  ASM
    MOV AX,4F08h
    MOV BL,01h
    INT 10h
    MOV AL,8
    SUB AL,BH
    MOV sh,AL
  END;
  col:=((dword(r) SHR sh) SHL 16)+((dword(g) SHR sh) SHL 8)+(dword(b) SHR sh);
  dosalloc(selector,segment,4);
  dosmemput(segment,0,col,4);
  fillchar(RealRegs,sizeof(TRealRegs),0);
  RealRegs.AX:=$4F09;
  RealRegs.BX:=0;
  RealRegs.CX:=1;
  RealRegs.DX:=i;
  RealRegs.ES:=segment;
  RealRegs.DI:=0;
  realintr($10,RealRegs);
  dosfree(selector);
END;

PROCEDURE scanline_vesa12(linewidth:word);assembler;
ASM
  MOV AX,4F06h
  MOV BL,00h
  MOV CX,linewidth
  INT 10h
END;

PROCEDURE scanline_vesa20(linewidth:word);assembler;
ASM
  MOV AX,4F06h
  MOV BL,02h
  MOV CX,linewidth
  INT 10h
END;

PROCEDURE displaystart_vesa12(offs:dword);assembler;
ASM
  MOV AX,4F07h
  MOV BX,0000h
  MOV CX,0000h
{  MOV DX,WORD PTR frontdrawoffsety }
  MOV DX,WORD PTR offs
  INT 10h
END;

PROCEDURE displaystart_vesa20(offs:dword);assembler;
ASM
  MOV AX,WORD PTR [offs+0]
  MOV DX,WORD PTR [offs+2]
  DIV WORD PTR bytperline
  MOV CX,AX
  MOV AX,DX
  MOV DX,0
  DIV WORD PTR bytperpix
  MOV DX,CX
  MOV CX,AX
  MOV AX,4F07h
  MOV BX,0000h
  INT 10h
END;

PROCEDURE displaystart_vbepmod32(offs:dword);assembler;
ASM
  PUSH ES
  MOV AX,4F07h
  MOV BX,0000h
  SHR offs,2
  MOV CX,WORD PTR [offs+0]
  MOV DX,WORD PTR [offs+2]
  MOV ES,vbepmod32_mmiosel
  CALL vbepmod32_displaystart
  POP ES
END;

PROCEDURE bankswitch_vesa;assembler;
ASM
  MOV AX,4F05h
  MOV BX,0
  PUSH CX
  MOV CL,BYTE PTR bankgran
  SHL DX,CL
  POP CX
  INT 10h
END;

PROCEDURE bankswitch_vbepmod32;assembler;
ASM
  PUSH ES
  PUSH CX
  MOV AX,4F05h
  MOV BX,0000h
  MOV CL,BYTE PTR bankgran
  SHL DX,CL
  MOV ES,vbepmod32_mmiosel
  CALL vbepmod32_bankswitch
  POP CX
  POP ES
END;

{----------------------------------------------------------------------------}

FUNCTION Get_VBE_Info(var VBEInfo:TVBEInfo):boolean;
VAR RealRegs:TRealRegs;
    segment,selector:word;
BEGIN
  dosalloc(selector,segment,512);
  fillchar(VBEinfo,sizeof(VBEinfo),0);
  VBEInfo.Signature:='VBE2';
  dosmemput(segment,0,VBEInfo,sizeof(TVBEInfo));
  fillchar(RealRegs,sizeof(TRealRegs),0);
  RealRegs.AX:=$4F00;
  RealRegs.ES:=segment;
  RealRegs.DI:=0;
  realintr($10,RealRegs);
  dosmemget(segment,0,VBEInfo,sizeof(TVBEInfo));
  IF (VBEInfo.signature<>'VESA') THEN
    BEGIN
      fillchar(VBEinfo,sizeof(VBEinfo),0);
      VBEInfo.Signature:='VESA';
      dosmemput(segment,0,VBEInfo,sizeof(TVBEInfo));
      fillchar(RealRegs,sizeof(TRealRegs),0);
      RealRegs.EAX:=$4F00;
      RealRegs.ES:=segment;
      RealRegs.DI:=0;
      realintr($10,RealRegs);
      dosmemget(segment,0,VBEInfo,sizeof(TVBEInfo));
      IF (VBEInfo.signature<>'VESA') THEN halt;
    END;
  Get_VBE_Info:=(RealRegs.AX=$004F);
  dosfree(selector);
END;

FUNCTION Get_SupVBE_Info(var SupVBEInfo:TSupVBEInfo;func:word):boolean;
VAR RealRegs:TRealRegs;
    segment,selector:word;
BEGIN
  dosalloc(selector,segment,256);
  dosmemput(segment,0,SupVBEInfo,sizeof(TSupVBEInfo));
  fillchar(RealRegs,sizeof(TRealRegs),0);
  RealRegs.AX:=func;
  RealRegs.BX:=0;
  RealRegs.ES:=segment;
  RealRegs.DI:=0;
  realintr($10,RealRegs);
  Get_SupVBE_Info:=(RealRegs.AX=$004F);
  dosmemget(segment,0,SupVBEInfo,sizeof(TSupVBEInfo));
  dosfree(selector);
END;

FUNCTION Get_VBE_OEM_String:string;
VAR RealRegs:TRealRegs;
    segment,selector:word;
    s:string;
    VBEInfo:TVBEInfo;
    i:byte;
BEGIN
  dosalloc(selector,segment,512);
  fillchar(VBEinfo,sizeof(VBEinfo),0);
  VBEInfo.Signature:='VBE2';
  dosmemput(segment,0,VBEInfo,sizeof(TVBEInfo));
  fillchar(RealRegs,sizeof(TRealRegs),0);
  RealRegs.EAX:=$4F00;
  RealRegs.ES:=segment;
  RealRegs.EDI:=0;
  realintr($10,RealRegs);
  dosmemget(segment,0,VBEInfo,sizeof(TVBEInfo));
  IF (VBEInfo.signature<>'VESA') THEN
    BEGIN
      fillchar(VBEinfo,sizeof(VBEinfo),0);
      VBEInfo.Signature:='VESA';
      dosmemput(segment,0,VBEInfo,sizeof(TVBEInfo));
      fillchar(RealRegs,sizeof(TRealRegs),0);
      RealRegs.EAX:=$4F00;
      RealRegs.ES:=segment;
      RealRegs.EDI:=0;
      realintr($10,RealRegs);
      dosmemget(segment,0,VBEInfo,sizeof(TVBEInfo));
      IF (VBEInfo.signature<>'VESA') THEN halt;
    END;
{  dosmemget(word((VBEInfo.ptr2OEMname SHR 16) AND $FFFF),word(VBEInfo.ptr2OEMname AND $FFFF),s[1],255); }
  dosmemget(hi(VBEInfo.ptr2OEMname),lo(VBEInfo.ptr2OEMname),s[1],255);
  i:=1;
  WHILE (s[i]<>#0) DO inc(i);
  s[0]:=chr(i-1);
  Get_VBE_OEM_String:=s;
  dosfree(selector);
END;

FUNCTION Get_VBE_Mode_Info(var VBEModeInfo:TVBEModeInfo;nr:word):boolean;
VAR RealRegs:TRealRegs;
    segment,selector:word;
BEGIN
  dosalloc(selector,segment,256);
  fillchar(RealRegs,sizeof(TRealRegs),0);
  RealRegs.EAX:=$4F01;
  RealRegs.ECX:=nr;
  RealRegs.ES:=segment;
  RealRegs.EDI:=0;
  realintr($10,RealRegs);
  dosmemget(segment,0,VBEModeInfo,sizeof(TVBEModeInfo));
  dosfree(selector);
  Get_VBE_Mode_Info:=(RealRegs.AX=$004F);
END;

PROCEDURE Scan_VBE_Modes(var modelist:PModeEntry;overrideflags:dword);
VAR VBEInfo:TVBEInfo;
    VBEModeInfo:TVBEModeInfo;
    RealRegs:TRealRegs;
    ModeNrSeg,ModeNrOfs,ModeNr,NumModes:word;
    ModeNrList,ModeNrPtr:^word;
    segment,selector:word;
    scanline:word;
    flags:longint;
BEGIN
  dosalloc(selector,segment,512);
  VBEInfo.Signature:='VBE2';
  dosmemput(segment,0,VBEInfo,sizeof(TVBEInfo));
  fillchar(RealRegs,sizeof(TRealRegs),0);
  RealRegs.EAX:=$4F00;
  RealRegs.ES:=segment;
  RealRegs.EDI:=0;
  realintr($10,RealRegs);
  dosmemget(segment,0,VBEInfo,sizeof(TVBEInfo));
  IF (VBEInfo.signature<>'VESA') THEN
    BEGIN
      fillchar(VBEinfo,sizeof(VBEinfo),0);
      VBEInfo.Signature:='VESA';
      dosmemput(segment,0,VBEInfo,sizeof(TVBEInfo));
      fillchar(RealRegs,sizeof(TRealRegs),0);
      RealRegs.EAX:=$4F00;
      RealRegs.ES:=segment;
      RealRegs.EDI:=0;
      realintr($10,RealRegs);
      dosmemget(segment,0,VBEInfo,sizeof(TVBEInfo));
      IF (VBEInfo.signature<>'VESA') THEN halt;
    END;
  ModeNrSeg:=hi(VBEInfo.Ptr2VBEnOEMmodes);
  ModeNrOfs:=lo(VBEInfo.Ptr2VBEnOEMmodes);

  NumModes:=0;
  REPEAT
    dosmemget(ModeNrSeg,ModeNrOfs+NumModes*2,ModeNr,2);
    inc(NumModes);
  UNTIL (ModeNr=$FFFF);
  getmem(ModeNrList,NumModes*2);
  dosmemget(ModeNrSeg,ModeNrOfs,ModeNrList^,NumModes*2);
  ModeNrPtr:=ModeNrList;
  REPEAT
    ModeNr:=ModeNrPtr^;
    inc(ModeNrPtr);
    IF (ModeNr<>$FFFF) THEN
      BEGIN
        IF Get_VBE_Mode_Info(VBEModeInfo,ModeNr) THEN
          IF (VBEModeInfo.modeattr AND $10=$10) AND (VBEmodeInfo.bitsperpix>=8) THEN
            BEGIN
              WITH VBEModeInfo DO
                BEGIN
                  flags:=overrideflags;
                  CASE bitsperpix OF
                   8:BEGIN
                       flags:=flags OR ig_col8;
                       redmaskpos:=5;
                       redmasksize:=3;
                       greenmaskpos:=2;
                       greenmasksize:=3;
                       bluemaskpos:=0;
                       bluemasksize:=2;
                     END;
                  15,16:
                     CASE greenmasksize OF
                       5:flags:=flags OR ig_col15;
                       6:flags:=flags OR ig_col16;
                     END;
                  24:flags:=flags OR ig_col24;
                  32:flags:=flags OR ig_col32;
                  END;
                  IF (modeattr AND $40=$40) THEN flags:=flags OR ig_bank;
                  IF (modeattr AND $80=$80) THEN flags:=flags OR ig_lfb;
                  CASE VBEInfo.Version OF
                  $0102:scanline:=width;
                  $0200:scanline:=bytperscanline;
                  $0300:scanline:=bytperscanline;
                  END;
                  AddModeToList(modelist,ModeNr,width,height,
                               (bitsperpix+7) SHR 3,bytperscanline,scanline,0,0,
                               redmaskpos,redmasksize,
                               greenmaskpos,greenmasksize,
                               bluemaskpos,bluemasksize,
                               flags);
                END;
            END;
        END;
  UNTIL (ModeNr=$FFFF);
  freemem(ModeNrList,NumModes*sizeof(word));
  dosfree(selector);
END;

{--- VBE/PM -----------------------------------------------------------------}

PROCEDURE Setup_VBEPMod32_Interface;
VAR RealRegs:TRealRegs;
    listptr:pointer;
BEGIN
  vbepmod32_used:=FALSE;
  RealRegs.AX:=$4F0A;
  RealRegs.BX:=0;
  realintr($10,RealRegs);
  IF (RealRegs.AX=$004F) THEN
    BEGIN
      vbepmod32_codesize:=RealRegs.CX;
      getmem(vbepmod32_code,vbepmod32_codesize);
      dosmemget(RealRegs.ES,RealRegs.DI,vbepmod32_code^,vbepmod32_codesize);

      vbepmod32_bankswitch:=pointer(vbepmod32_code+word((vbepmod32_code+0)^));
      vbepmod32_displaystart:=pointer(vbepmod32_code+word((vbepmod32_code+2)^));
      listptr:=pointer(vbepmod32_code+word((vbepmod32_code+6)^));

      WHILE (word(listptr^)<>$FFFF) DO inc(listptr,2);
      inc(listptr,2);
      IF (word(listptr^)<>$FFFF) THEN
        BEGIN
          vbepmod32_mmiophys:=longint(listptr^);
          vbepmod32_mmiosize:=word((listptr+4)^);
          vbepmod32_mmiolinear:=get_linear_addr(vbepmod32_mmiophys,vbepmod32_mmiosize);
          vbepmod32_mmiosel:=allocate_ldt_descriptors(1);
          Set_Segment_Base_Address(vbepmod32_mmiosel,vbepmod32_mmiolinear);
          Set_Segment_Limit(vbepmod32_mmiosel,vbepmod32_mmiosize-1);
          lock_linear_region(vbepmod32_mmiolinear,vbepmod32_mmiosize);
        END;
      vbepmod32_used:=TRUE;
    END;
END;

PROCEDURE Cleanup_VBEPMod32_interface;
BEGIN
  IF vbepmod32_used THEN
    BEGIN
      IF (vbepmod32_mmiosel<>0) THEN
        BEGIN
          unlock_linear_region(vbepmod32_mmiolinear,vbepmod32_mmiosize);
          Free_ldt_Descriptor(vbepmod32_mmiosel);
        END;
      freemem(vbepmod32_code,vbepmod32_codesize);
    END;
  vbepmod32_used:=FALSE;
END;

{--- VBE/AF -----------------------------------------------------------------}

PROCEDURE Setup_VBEAF_Interface;
{VAR RealRegs:TRealRegs;
    listptr:pointer; }
BEGIN
END;

PROCEDURE Cleanup_VBEAF_interface;
BEGIN
END;

{--- VBE 3.0 Protected Mode Entry Point -----------------------------------}

TYPE PPMInfoBlock=^TPMInfoBlock;
     TPMInfoBlock=RECORD
       signature:array[0..3] of char;
       entrypoint:word;
       pminitialize:word;
       biosdatasel:word;
       A0000sel:word;
       B0000sel:word;
       B8000sel:word;
       codesegsel:word;
       inprotectedmode:byte;
       checksum:byte;
     END;

VAR PMInfoBlock:PPMInfoBlock;
    vbepmep_biosimage:pointer;
    vbepmep_biosdata:pointer;

PROCEDURE Setup_VBEPMEP_Interface; {NOT TESTED !!!!}
VAR i:longint;
    checksum:byte;
    thestacksel:word;
    thestackptr:longint;
    codeinit:longint;
BEGIN
  vbepmep_used:=FALSE;
{step 1}
  getmem(vbepmep_biosimage,32768);
{step 2}
  dosmemget($C000,0,vbepmep_biosimage^,32768);
{step 3}
  PMInfoBlock:=vbepmep_biosimage;
  WHILE (PMInfoBlock^.signature<>'PMID')
    AND (PMInfoBlock<=vbepmep_biosimage+32768-sizeof(TPMInfoBlock))
     DO inc(PMInfoBlock);
  IF (PMInfoBlock^.signature='PMID') THEN
    BEGIN
      checksum:=0;
      FOR i:=0 TO sizeof(TPMInfoBlock)-1 DO
        checksum:=checksum+byte((pointer(PMInfoBlock)+i)^);
      IF (checksum=0) THEN
        BEGIN
{step 4}
          getmem(vbepmep_biosdata,$600);
          fillchar(vbepmep_biosdata^,$600,0);
          PMInfoBlock^.biosdatasel:=create_ldt_selector(get_segment_base_address(get_ds)+vbepmep_biosdata,$600);
{step 5}
          PMInfoBlock^.A0000sel:=create_ldt_selector(get_linear_addr($000A0000,65536),65536);
          PMInfoBlock^.B0000sel:=create_ldt_selector(get_linear_addr($000B0000,65536),65536);
          PMInfoBlock^.B8000sel:=create_ldt_selector(get_linear_addr($000B8000,32768),32768);
{step 6}
          PMInfoBlock^.codesegsel:=create_ldt_selector(longint(vbepmep_biosimage),32768);
{step 7}
          PMInfoBlock^.inprotectedmode:=1;
{step 8}
          vbepmep_codesel:=create_code_segment_alias_descriptor(PMInfoBlock^.codesegsel);
          set_descriptor_access_right(vbepmep_codesel,get_descriptor_access_right(vbepmep_codesel) AND $BFFF);
{step 9}
          getmem(vbepmep_stackbuf,1024);
          vbepmep_stacksel:=create_ldt_selector(longint(vbepmep_stackbuf),1024);
          set_descriptor_access_right(vbepmep_stacksel,get_descriptor_access_right(vbepmep_stacksel) AND $BFFF);
{step 10}
          vbepmep_codeentry:=PMInfoBlock^.entrypoint;
          vbepmep_used:=TRUE;

          codeinit:=PMInfoBlock^.pminitialize;
          ASM
            MOV thestacksel,SS
            MOV thestackptr,ESP

            MOV SS,vbepmep_stacksel
            MOV SP,0

            PUSH CS
            CALL codeinit

            MOV ESP,thestackptr
            MOV SS,thestacksel
          END;
        END;
    END;
   IF NOT vbepmep_used THEN freemem(vbepmep_biosimage,32768);
END;

PROCEDURE Cleanup_VBEPMEP_interface;
BEGIN
  IF vbepmep_used THEN
    BEGIN
{step 9}
      free_ldt_descriptor(vbepmep_stacksel);
      freemem(vbepmep_stackbuf,1024);
{step 8}
      free_ldt_descriptor(vbepmep_codesel);
{step 6}
      free_ldt_descriptor(PMInfoBlock^.codesegsel);
{step 5}
      free_ldt_descriptor(PMInfoBlock^.A0000sel);
      free_ldt_descriptor(PMInfoBlock^.B0000sel);
      free_ldt_descriptor(PMInfoBlock^.B8000sel);
{step 4}
      free_ldt_descriptor(PMInfoBlock^.biosdatasel);
      freemem(vbepmep_biosdata,$600);
{step 1}
      freemem(vbepmep_biosimage,32768);
    END;
END;

{----------------------------------------------------------------------------}

BEGIN
  vbepmod32_used:=FALSE;
END.
