{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{$I gxglobal.cfg}
UNIT gx3dtype;

INTERFACE

USES gxtype;
{$I gxlocal.cfg}

TYPE PPoint2D=^TPoint2D;
     TPoint2D=RECORD
       x,y:longint;
     END;

     PPoint3D=^TPoint3D;
     TPoint3D=RECORD
       x,y,z:longint;
     END;

     PRGB=^TRGB;
     TRGB=PACKED RECORD
       b,g,r,a:byte;
     END;

     RenderPtr=^RenderRec;
     RenderRec=RECORD
       flags:dword;
       num:longint;
       color:TRGB;
       points:PPoint3D;
    {   normals:PPoint3D; }
       colors:PRGB;
     END;

     TPoint3Darray=array[0..0] of TPoint3D;

     PRender=^TRender;
     TRender=RECORD
       points:array[0..2] of TPoint3D;
       colors:array[0..2] of longint; {alpha (31-24) red (23-16), green (15-8), blue (7-0)}
       texture:pimage;
       texturesize:word;
       rendertype:word;
       texcoords:array[0..2] of TPoint2D;
     END;

     PPolyRender=^TPolyRender;
     TPolyRender=RECORD
       numpts:longint;
       pts:^TPoint3Darray;
       color:longint;
     END;

     triangle_renderproc=procedure(rend:prender);
     polygon_renderproc=procedure(rend:ppolyrender);

CONST polygon3d_type=$0000000F;
      polygon3d_flat=$00000001;
      polygon3d_gouraud=$00000002;
      polygon3d_phong=$00000003;

IMPLEMENTATION

END.