{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

UNIT gxdemo2;

INTERFACE

PROCEDURE GraphixDemo2(background:pointer);

IMPLEMENTATION

USES gxcrt,graphix,gxtext,gximg,gx2d,gxmouse,gxtype;

VAR dx1,dy1,dx2,dy2:longint;
    bg:pointer;
    pat:array[1..5] of PPattern;
    ft:pfontfnt;

PROCEDURE Rahmen(pat:boolean);
BEGIN
  graphwin(0,0,getmaxX,getmaxY);
  putimage(0,0,bg);
  dx1:=10;
  CASE gxcurres OF
  $03200200..$05120480:dy1:=10;
  $06400350..$16001200:dy1:=100;
  END;
  dx2:=getmaxX-10;
  dy2:=getmaxY-15;
  rectangle(dx1-1,dy1-1,dx2+1,dy2+1,rgbcolorRGB(255,255,255));
  bar(dx1,dy1,dx2,dy2,rgbcolorRGB(0,0,90));
  IF pat THEN
    ft^.outtext(dx1,dy2+2,'[Continue <ENTER/Mouse-Button>] [select pattern <0>,<1>,<2>,<3>,<4>,<5>]',rgbcolorRGB(0,0,80))
  ELSE
    ft^.outtext(dx1,dy2+2,'[Continue <ENTER/Mouse-Button>]',rgbcolorRGB(0,0,80));
  graphwin(dx1,dy1,dx2,dy2);
END;

PROCEDURE selectpattern(ch:char);
BEGIN
  CASE ch OF
  '0':setfillstyle(fs_solid);
  '1':setfillpattern(fs_pattern,pat[1]);
  '2':setfillpattern(fs_pattern,pat[2]);
  '3':setfillpattern(fs_pattern,pat[3]);
  '4':setfillpattern(fs_pattern,pat[4]);
  '5':setfillpattern(fs_pattern,pat[5]);
  END;
END;

TYPE TPoint=RECORD
       x,y,rx,ry:longint;
     END;

CONST ecken=7;

VAR linexy:array[1..2] of TPoint;
    rectanglexy:array[1..2] of TPoint;
    barxy:array[1..2] of TPoint;
    linexyR:array[1..ecken] of TPoint;
    linexyP:array[1..ecken] of TPoint2d;
    
PROCEDURE Demo_line;
VAR xx,yy,r,g,b,rr,rg,rb:longint;
    i:byte;
    ch:char;
BEGIN
  Rahmen(FALSE);
  WITH linexy[1] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=-1-random(3);
      ry:=-1-random(3);
    END;
  WITH linexy[2] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=+1+random(3);
      ry:=+1+random(3);
    END;
  r:=random(256);
  g:=random(256);
  b:=random(256);
  rr:=1;
  rg:=1;
  rb:=1;
  REPEAT
    FOR xx:=-1 TO +1 DO
      FOR yy:=-1 TO +1 DO
        BEGIN
          line(linexy[1].x+xx,linexy[1].y+yy,
               linexy[2].x+xx,linexy[2].y+yy,rgbcolorRGB(r,g,b));
        END;
    FOR i:=1 TO 2 DO
      WITH linexy[i] DO
        BEGIN
          IF (x<vx1) THEN
            rx:=+1+random(2);
          IF (x>vx2) THEN
            rx:=-1-random(2);
          IF (y<vy1) THEN
            ry:=+1+random(2);
          IF (y>vy2) THEN
            ry:=-1-random(2);
          inc(x,rx);
          inc(y,ry);
        END;
    inc(r,rr);
    inc(g,rg);
    inc(b,rb);
    IF (r>255) THEN
      BEGIN
        r:=255;
        rr:=-1-random(3);
      END;
    IF (r<0) THEN
      BEGIN
        r:=0;
        rr:=+1+random(3);
      END;
    IF (g>255) THEN
      BEGIN
        g:=255;
        rg:=-1-random(3);
      END;
    IF (g<0) THEN
      BEGIN
        g:=0;
        rg:=+1+random(3);
      END;
    IF (b>255) THEN
      BEGIN
        b:=255;
        rb:=-1-random(3);
      END;
    IF (b<0) THEN
      BEGIN
        b:=0;
        rb:=+1+random(3);
      END;
    ch:=#0;
    IF keypressed THEN
      BEGIN
        ch:=readkey;
        selectpattern(ch);
      END;
  UNTIL (ch=#13) OR (MouseButton>0);
  IF (MouseButton>0) THEN WaitButtonReleased;
  setfillstyle(fs_solid);
END;

PROCEDURE Demo_linexor;
CONST ol=1000;
VAR r,g,b,rr,rg,rb:longint;
    i:byte;
    ch:char;
    oldlinexy:array[1..ol,1..2] of TPoint;
    oldcolor:array[1..ol] of dword;
    cp:dword;
BEGIN
  Rahmen(FALSE);
  WITH linexy[1] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=-1-random(3);
      ry:=-1-random(3);
    END;
  WITH linexy[2] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=+1+random(3);
      ry:=+1+random(3);
    END;
  r:=random(256);
  g:=random(256);
  b:=random(256);
  rr:=1;
  rg:=1;
  rb:=1;

  FOR cp:=1 TO ol DO
    BEGIN
      linexor(linexy[1].x,linexy[1].y,linexy[2].x,linexy[2].y,rgbcolorRGB(r,g,b));
      oldlinexy[cp,1]:=linexy[1];
      oldlinexy[cp,2]:=linexy[2];
      oldcolor[cp]:=rgbcolorRGB(r,g,b);
      FOR i:=1 TO 2 DO
        WITH linexy[i] DO
          BEGIN
            IF (x<vx1) THEN
              rx:=+1+random(2);
            IF (x>vx2) THEN
              rx:=-1-random(2);
            IF (y<vy1) THEN
            ry:=+1+random(2);
            IF (y>vy2) THEN
              ry:=-1-random(2);
            inc(x,rx);
            inc(y,ry);
          END;
      inc(r,rr);
      inc(g,rg);
      inc(b,rb);
      IF (r>255) THEN
        BEGIN
          r:=255;
          rr:=-1-random(3);
        END;
      IF (r<0) THEN
        BEGIN
          r:=0;
          rr:=+1+random(3);
        END;
      IF (g>255) THEN
        BEGIN
          g:=255;
          rg:=-1-random(3);
        END;
      IF (g<0) THEN
        BEGIN
          g:=0;
          rg:=+1+random(3);
        END;
      IF (b>255) THEN
        BEGIN
          b:=255;
          rb:=-1-random(3);
        END;
      IF (b<0) THEN
        BEGIN
          b:=0;
          rb:=+1+random(3);
        END;
    END;
  cp:=1;
  REPEAT
    linexor(oldlinexy[cp,1].x,oldlinexy[cp,1].y,oldlinexy[cp,2].x,oldlinexy[cp,2].y,oldcolor[cp]);
    linexor(linexy[1].x,linexy[1].y,linexy[2].x,linexy[2].y,rgbcolorRGB(r,g,b));
    oldlinexy[cp,1]:=linexy[1];
    oldlinexy[cp,2]:=linexy[2];
    oldcolor[cp]:=rgbcolorRGB(r,g,b);
    inc(cp);
    IF (cp>ol) THEN cp:=1;
    FOR i:=1 TO 2 DO
      WITH linexy[i] DO
        BEGIN
          IF (x<vx1) THEN
            rx:=+1+random(2);
          IF (x>vx2) THEN
            rx:=-1-random(2);
          IF (y<vy1) THEN
            ry:=+1+random(2);
          IF (y>vy2) THEN
            ry:=-1-random(2);
          inc(x,rx);
          inc(y,ry);
        END;
    inc(r,rr);
    inc(g,rg);
    inc(b,rb);
    IF (r>255) THEN
      BEGIN
        r:=255;
        rr:=-1-random(3);
      END;
    IF (r<0) THEN
      BEGIN
        r:=0;
        rr:=+1+random(3);
      END;
    IF (g>255) THEN
      BEGIN
        g:=255;
        rg:=-1-random(3);
      END;
    IF (g<0) THEN
      BEGIN
        g:=0;
        rg:=+1+random(3);
      END;
    IF (b>255) THEN
      BEGIN
        b:=255;
        rb:=-1-random(3);
      END;
    IF (b<0) THEN
      BEGIN
        b:=0;
        rb:=+1+random(3);
      END;
    ch:=#0;
    IF keypressed THEN
      BEGIN
        ch:=readkey;
        selectpattern(ch);
      END;
  UNTIL (ch=#13) OR (MouseButton>0);
  IF (MouseButton>0) THEN WaitButtonReleased;
  setfillstyle(fs_solid);
END;

PROCEDURE Demo_rectangle;
VAR r,g,b,rr,rg,rb:longint;
    i:byte;
    ch:char;
BEGIN
  Rahmen(TRUE);
  WITH rectanglexy[1] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=-1-random(3);
      ry:=-1-random(3);
    END;
  WITH rectanglexy[2] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=+1+random(3);
      ry:=+1+random(3);
    END;
  r:=random(256);
  g:=random(256);
  b:=random(256);
  rr:=1;
  rg:=1;
  rb:=1;
  REPEAT
    rectangle(rectanglexy[1].x-1,rectanglexy[1].y-1,rectanglexy[2].x+1,rectanglexy[2].y+1,rgbcolorRGB(r,g,b));
    rectangle(rectanglexy[1].x,rectanglexy[1].y,rectanglexy[2].x,rectanglexy[2].y,rgbcolorRGB(r,g,b));
    rectangle(rectanglexy[1].x+1,rectanglexy[1].y+1,rectanglexy[2].x-1,rectanglexy[2].y-1,rgbcolorRGB(r,g,b));
    FOR i:=1 TO 2 DO
      WITH rectanglexy[i] DO
        BEGIN
          IF (x<vx1) THEN
            rx:=+1+random(2);
          IF (x>vx2) THEN
            rx:=-1-random(2);
          IF (y<vy1) THEN
            ry:=+1+random(2);
          IF (y>vy2) THEN
            ry:=-1-random(2);
          inc(x,rx);
          inc(y,ry);
        END;
    inc(r,rr);
    inc(g,rg);
    inc(b,rb);
    IF (r>255) THEN
      BEGIN
        r:=255;
        rr:=-1-random(3);
      END;
    IF (r<0) THEN
      BEGIN
        r:=0;
        rr:=+1+random(3);
      END;
    IF (g>255) THEN
      BEGIN
        g:=255;
        rg:=-1-random(3);
      END;
    IF (g<0) THEN
      BEGIN
        g:=0;
        rg:=+1+random(3);
      END;
    IF (b>255) THEN
      BEGIN
        b:=255;
        rb:=-1-random(3);
      END;
    IF (b<0) THEN
      BEGIN
        b:=0;
        rb:=+1+random(3);
      END;
    ch:=#0;
    IF keypressed THEN
      BEGIN
        ch:=readkey;
        selectpattern(ch);
      END;
  UNTIL (ch=#13) OR (MouseButton>0);
  IF (MouseButton>0) THEN WaitButtonReleased;
  setfillstyle(fs_solid);
END;

PROCEDURE Demo_bar;
VAR r,g,b,rr,rg,rb:longint;
    i:byte;
    ch:char;
BEGIN
  Rahmen(TRUE);
  WITH barxy[1] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=-1-random(3);
      ry:=-1-random(3);
    END;
  WITH barxy[2] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=+1+random(3);
      ry:=+1+random(3);
    END;
  r:=random(256);
  g:=random(256);
  b:=random(256);
  rr:=1;
  rg:=1;
  rb:=1;
  REPEAT
    bar(barxy[1].x,barxy[1].y,barxy[2].x,barxy[2].y,rgbcolorRGB(r,g,b));
    FOR i:=1 TO 2 DO
      WITH barxy[i] DO
        BEGIN
          IF (x<vx1) THEN
            rx:=+1+random(3);
          IF (x>vx2) THEN
            rx:=-1-random(3);
          IF (y<vy1) THEN
            ry:=+1+random(3);
          IF (y>vy2) THEN
            ry:=-1-random(3);
          inc(x,rx);
          inc(y,ry);
        END;
    inc(r,rr);
    inc(g,rg);
    inc(b,rb);
    IF (r>255) THEN
      BEGIN
        r:=255;
        rr:=-1-random(3);
      END;
    IF (r<0) THEN
      BEGIN
        r:=0;
        rr:=+1+random(3);
      END;
    IF (g>255) THEN
      BEGIN
        g:=255;
        rg:=-1-random(3);
      END;
    IF (g<0) THEN
      BEGIN
        g:=0;
        rg:=+1+random(3);
      END;
    IF (b>255) THEN
      BEGIN
        b:=255;
        rb:=-1-random(3);
      END;
    IF (b<0) THEN
      BEGIN
        b:=0;
        rb:=+1+random(3);
      END;
    ch:=#0;
    IF keypressed THEN
      BEGIN
        ch:=readkey;
        selectpattern(ch);
      END;
  UNTIL (ch=#13) OR (MouseButton>0);
  IF (MouseButton>0) THEN WaitButtonReleased;
  setfillstyle(fs_solid);
END;

PROCEDURE Demo_barXOR;
VAR r,g,b,rr,rg,rb:longint;
    i:byte;
    ch:char;
BEGIN
  Rahmen(TRUE);
  WITH barxy[1] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=-1-random(3);
      ry:=-1-random(3);
    END;
  WITH barxy[2] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=+1+random(3);
      ry:=+1+random(3);
    END;
  r:=random(256);
  g:=random(256);
  b:=random(256);
  rr:=1;
  rg:=1;
  rb:=1;
  REPEAT
    barXOR(barxy[1].x,barxy[1].y,barxy[2].x,barxy[2].y,rgbcolorRGB(r,g,b));
    FOR i:=1 TO 2 DO
      WITH barxy[i] DO
        BEGIN
          IF (x<vx1) THEN
            rx:=+1+random(3);
          IF (x>vx2) THEN
            rx:=-1-random(3);
          IF (y<vy1) THEN
            ry:=+1+random(3);
          IF (y>vy2) THEN
            ry:=-1-random(3);
          inc(x,rx);
          inc(y,ry);
        END;
    inc(r,rr);
    inc(g,rg);
    inc(b,rb);
    IF (r>255) THEN
      BEGIN
        r:=255;
        rr:=-1-random(3);
      END;
    IF (r<0) THEN
      BEGIN
        r:=0;
        rr:=+1+random(3);
      END;
    IF (g>255) THEN
      BEGIN
        g:=255;
        rg:=-1-random(3);
      END;
    IF (g<0) THEN
      BEGIN
        g:=0;
        rg:=+1+random(3);
      END;
    IF (b>255) THEN
      BEGIN
        b:=255;
        rb:=-1-random(3);
      END;
    IF (b<0) THEN
      BEGIN
        b:=0;
        rb:=+1+random(3);
      END;
    ch:=#0;
    IF keypressed THEN
      BEGIN
        ch:=readkey;
        selectpattern(ch);
      END;
  UNTIL (ch=#13) OR (MouseButton>0);
  IF (MouseButton>0) THEN WaitButtonReleased;
  setfillstyle(fs_solid);
END;

PROCEDURE Demo_font;
VAR Font1,Font2,Font3,Font4,Font5:pfontfnt;
    ch:char;
BEGIN
  new(Font1,LoadFont('font1.fnt'));
  new(Font2,LoadFont('font2.fnt'));
  new(Font3,LoadFont('font3.fnt'));
  new(Font4,LoadFont('font4.fnt'));
  new(Font5,LoadFont('font5.fnt'));
  Rahmen(FALSE);
  REPEAT
    CASE random(5) OF
    0:font1^.outtext(random(getmaxX),random(getmaxY),'Text',rgbcolorRGB(random(255),random(255),random(255)));
    1:font2^.outtext(random(getmaxX),random(getmaxY),'Text',rgbcolorRGB(random(255),random(255),random(255)));
    2:font3^.outtext(random(getmaxX),random(getmaxY),'Text',rgbcolorRGB(random(255),random(255),random(255)));
    3:font4^.outtext(random(getmaxX),random(getmaxY),'Text',rgbcolorRGB(random(255),random(255),random(255)));
    4:font5^.outtext(random(getmaxX),random(getmaxY),'Text',rgbcolorRGB(random(255),random(255),random(255)));
    END;
    ch:=#0;
    IF keypressed THEN
      BEGIN
        ch:=readkey;
        selectpattern(ch);
      END;
  UNTIL (ch=#13) OR (MouseButton>0);
  IF (MouseButton>0) THEN WaitButtonReleased;
  dispose(Font1,RemoveFont);
  dispose(Font2,RemoveFont);
  dispose(Font3,RemoveFont);
  dispose(Font4,RemoveFont);
  dispose(Font5,RemoveFont);
  setfillstyle(fs_solid);
END;

PROCEDURE Demo_scrolling;
VAR Font1:pfontfnt;
    c:longint;
    r,g,b,rr,rg,rb,mx:longint;
    s:string;
BEGIN
  new(Font1,LoadFont('font6.fnt'));
  Rahmen(FALSE);
  c:=0;
  r:=0;
  g:=0;
  b:=0;
  rr:=1;
  rg:=1;
  rb:=1;
  s:='THIS IS A SCROLLING TEXT';
  mx:=(getmaxX-font1^.textlength(s)) DIV 2;
  REPEAT
    waitforretrace;
    moverect(dx1,dy1+2,dx2,dy2,dx1,dy1);
    Font1^.outtext(mx+trunc(sin(real(c)/50)*100)-1,dy2-font1^.fontheight-1,s,0);
    Font1^.outtext(mx+trunc(sin(real(c)/50)*100),dy2-font1^.fontheight,s,rgbcolorRGB(r,g,b));
    inc(c);
    inc(r,rr);
    inc(g,rg);
    inc(b,rb);
    IF (r>255) THEN
      BEGIN
        r:=255;
        rr:=-1-random(3);
      END;
    IF (r<0) THEN
      BEGIN
        r:=0;
        rr:=+1+random(3);
      END;
    IF (g>255) THEN
      BEGIN
        g:=255;
        rg:=-1-random(3);
      END;
    IF (g<0) THEN
      BEGIN
        g:=0;
        rg:=+1+random(3);
      END;
    IF (b>255) THEN
      BEGIN
        b:=255;
        rb:=-1-random(3);
      END;
    IF (b<0) THEN
      BEGIN
        b:=0;
        rb:=+1+random(3);
      END;
  UNTIL keypressed OR (MouseButton>0);
  IF keypressed THEN readkey;
  IF (MouseButton>0) THEN WaitButtonReleased;
  dispose(Font1,RemoveFont);
  setfillstyle(fs_solid);
END;

PROCEDURE Demo_putimage;
VAR p:pointer;
BEGIN
  LoadImageFile(itJPG,'graphix2.jpg',p,0);
  Rahmen(FALSE);
  REPEAT
    putimage(random(getmaxX+100)-100,random(getmaxY+100)-100,p);
  UNTIL keypressed OR (MouseButton>0);
  IF keypressed THEN readkey;
  IF (MouseButton>0) THEN WaitButtonReleased;
  Destroyimage(p);
END;

PROCEDURE Demo_putimageC;
VAR p:pointer;
BEGIN
  LoadImageFile(itGIF,'graphix1.gif',p,0);
  Rahmen(FALSE);
  REPEAT
    putimageC(random(getmaxX+100)-100,random(getmaxY+100)-100,p);
  UNTIL keypressed OR (MouseButton>0);
  IF keypressed THEN readkey;
  IF (MouseButton>0) THEN WaitButtonReleased;
  Destroyimage(p);
  setfillstyle(fs_solid);
END;

PROCEDURE Demo_zoomimage;
VAR i:byte;
    p:pointer;
BEGIN
  LoadImageFile(itJPG,'graphix2.jpg',p,0);
  Rahmen(FALSE);
  WITH linexy[1] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=-1-random(3);
      ry:=-1-random(3);
    END;
  WITH linexy[2] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=+1+random(3);
      ry:=+1+random(3);
    END;
  REPEAT
    zoomimage(linexy[1].x,linexy[1].y,linexy[2].x,linexy[2].y,p);
    FOR i:=1 TO 2 DO
      WITH linexy[i] DO
        BEGIN
          inc(x,rx);
          inc(y,ry);
          IF (x<vx1) THEN
            BEGIN
              rx:=+1+random(5);
              x:=vx1;
            END;
          IF (x>vx2) THEN
            BEGIN
              rx:=-1-random(5);
              x:=vx2;
            END;
          IF (y<vy1) THEN
            BEGIN
              ry:=+1+random(5);
              y:=vy1;
            END;
          IF (y>vy2-1) THEN
            BEGIN
              ry:=-1-random(5);
              y:=vy2-1;
            END;
        END;
  UNTIL keypressed OR (MouseButton>0);
  IF keypressed THEN readkey;
  IF (MouseButton>0) THEN WaitButtonReleased;
  Destroyimage(p);
  setfillstyle(fs_solid);
END;

PROCEDURE Demo_zoomimageC;
VAR i:byte;
    p:pointer;
BEGIN
  LoadImageFile(itGIF,'graphix1.gif',p,0);
  Rahmen(FALSE);
  WITH linexy[1] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=-1-random(3);
      ry:=-1-random(3);
    END;
  WITH linexy[2] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=+1+random(3);
      ry:=+1+random(3);
    END;
  REPEAT
    zoomimageC(linexy[1].x,linexy[1].y,linexy[2].x,linexy[2].y,p);
    FOR i:=1 TO 2 DO
      WITH linexy[i] DO
        BEGIN
          inc(x,rx);
          inc(y,ry);
          IF (x<vx1) THEN
            BEGIN
              rx:=+1+random(5);
              x:=vx1;
            END;
          IF (x>vx2) THEN
            BEGIN
              rx:=-1-random(5);
              x:=vx2;
            END;
          IF (y<vy1) THEN
            BEGIN
              ry:=+1+random(5);
              y:=vy1;
            END;
          IF (y>vy2-1) THEN
            BEGIN
              ry:=-1-random(5);
              y:=vy2-1;
            END;
        END;
  UNTIL keypressed OR (MouseButton>0);
  IF keypressed THEN readkey;
  IF (MouseButton>0) THEN WaitButtonReleased;
  Destroyimage(p);
  setfillstyle(fs_solid);
END;

PROCEDURE Demo_moverect;
CONST d:longint=4;
VAR p:pointer;
    ch:char;
BEGIN
  Rahmen(FALSE);
  LoadImageFile(itJPG,'graphix2.jpg',p,0);
  zoomimage(vx1,vy1,vx2,vy2-1,p);
  Destroyimage(p);
  p:=createimage(vx2-d,vy1,vx2,vy2);
  ch:='+';
  REPEAT
{    captureimage(vx2-d,vy1,vx2,vy2,p); }
    getimage(vx2-d,vy1{,vx2,vy2},p);
    moverect(vx1,vy1,vx2-d,vy2,vx1+d,vy1);
    putimage(vx1,vy1,p);
    IF keypressed THEN
      BEGIN
        ch:=readkey;
        CASE ch OF
        '-':BEGIN
              Destroyimage(p);
              dec(d);
              IF (d<1) THEN d:=1;
              p:=createimage(vx2-d,vy1,vx2,vy2);
            END;
        '+':BEGIN
              Destroyimage(p);
              inc(d);
              IF (d>32) THEN d:=32;
              p:=createimage(vx2-d,vy1,vx2,vy2);
            END;
       END;
     END;
  UNTIL ((ch<>'-') AND (ch<>'+')) OR (MouseButton>0);
  IF (MouseButton>0) THEN WaitButtonReleased;
  Destroyimage(p);
  setfillstyle(fs_solid);
END;

PROCEDURE Demo_polygon;
VAR r,g,b,rr,rg,rb:longint;
    i:byte;
    ch:char;
BEGIN
  Rahmen(TRUE);
  FOR i:=1 TO ecken DO
    WITH linexyR[i] DO
      BEGIN
        x:=getmaxX DIV 2;
        y:=getmaxY DIV 2;
        rx:=1+random(4);
        ry:=1+random(4);
      END;
  r:=random(256);
  g:=random(256);
  b:=random(256);
  rr:=1;
  rg:=1;
  rb:=1;
  REPEAT
    FOR i:=1 TO ecken DO
      BEGIN
        linexyP[i].x:=linexyR[i].x;
        linexyP[i].y:=linexyR[i].y;
      END;
    polygon(linexyP,ecken,rgbcolorRGB(r,g,b));
    FOR i:=1 TO ecken DO
      WITH linexyR[i] DO
        BEGIN
          IF (x<vx1) THEN
            rx:=+1+random(2);
          IF (x>vx2) THEN
            rx:=-1-random(2);
          IF (y<vy1) THEN
            ry:=+1+random(2);
          IF (y>vy2) THEN
            ry:=-1-random(2);
          inc(x,rx);
          inc(y,ry);
        END;
    inc(r,rr);
    inc(g,rg);
    inc(b,rb);
    IF (r>255) THEN
      BEGIN
        r:=255;
        rr:=-1-random(3);
      END;
    IF (r<0) THEN
      BEGIN
        r:=0;
        rr:=+1+random(3);
      END;
    IF (g>255) THEN
      BEGIN
        g:=255;
        rg:=-1-random(3);
      END;
    IF (g<0) THEN
      BEGIN
        g:=0;
        rg:=+1+random(3);
      END;
    IF (b>255) THEN
      BEGIN
        b:=255;
        rb:=-1-random(3);
      END;
    IF (b<0) THEN
      BEGIN
        b:=0;
        rb:=+1+random(3);
      END;
    ch:=#0;
    IF keypressed THEN
      BEGIN
        ch:=readkey;
        selectpattern(ch);
      END;
  UNTIL (ch=#13) OR (MouseButton>0);
  IF keypressed THEN readkey;
  setfillstyle(fs_solid);
END;

PROCEDURE Demo_circle;
VAR r,g,b,rr,rg,rb:longint;
    i:byte;
BEGIN
  Rahmen(FALSE);
  WITH linexy[1] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=-1-random(3);
      ry:=-1-random(3);
    END;
  WITH linexy[2] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=+1+random(3);
      ry:=+1+random(3);
    END;
  r:=random(256);
  g:=random(256);
  b:=random(256);
  rr:=1;
  rg:=1;
  rb:=1;
  REPEAT
    circle(linexy[1].x,linexy[1].y,trunc(sqrt(sqr(linexy[2].x-linexy[1].x)+
                                              sqr(linexy[2].y-linexy[1].y)+1)) DIV 4,rgbcolorRGB(r,g,b));
    FOR i:=1 TO 2 DO
      WITH linexy[i] DO
        BEGIN
          IF (x<vx1) THEN
            rx:=+1+random(2);
          IF (x>vx2) THEN
            rx:=-1-random(2);
          IF (y<vy1) THEN
            ry:=+1+random(2);
          IF (y>vy2) THEN
            ry:=-1-random(2);
          inc(x,rx);
          inc(y,ry);
        END;
    inc(r,rr);
    inc(g,rg);
    inc(b,rb);
    IF (r>255) THEN
      BEGIN
        r:=255;
        rr:=-1-random(3);
      END;
    IF (r<0) THEN
      BEGIN
        r:=0;
        rr:=+1+random(3);
      END;
    IF (g>255) THEN
      BEGIN
        g:=255;
        rg:=-1-random(3);
      END;
    IF (g<0) THEN
      BEGIN
        g:=0;
        rg:=+1+random(3);
      END;
    IF (b>255) THEN
      BEGIN
        b:=255;
        rb:=-1-random(3);
      END;
    IF (b<0) THEN
      BEGIN
        b:=0;
        rb:=+1+random(3);
      END;
  UNTIL keypressed OR (MouseButton>0);
  IF (MouseButton>0) THEN WaitButtonReleased;
  IF keypressed THEN readkey;
  setfillstyle(fs_solid);
END;

PROCEDURE Demo_circlefill;
VAR r,g,b,rr,rg,rb:longint;
    i:byte;
    ch:char;
BEGIN
  Rahmen(TRUE);
  WITH linexy[1] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=-1-random(3);
      ry:=-1-random(3);
    END;
  WITH linexy[2] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=+1+random(3);
      ry:=+1+random(3);
    END;
  r:=random(256);
  g:=random(256);
  b:=random(256);
  rr:=1;
  rg:=1;
  rb:=1;
  REPEAT
    circlefill(linexy[1].x,linexy[1].y,trunc(sqrt(sqr(linexy[2].x-linexy[1].x)+
                                                  sqr(linexy[2].y-linexy[1].y)+1)) DIV 4,rgbcolorRGB(r,g,b));
    FOR i:=1 TO 2 DO
      WITH linexy[i] DO
        BEGIN
          IF (x<vx1) THEN
            rx:=+1+random(2);
          IF (x>vx2) THEN
            rx:=-1-random(2);
          IF (y<vy1) THEN
            ry:=+1+random(2);
          IF (y>vy2) THEN
            ry:=-1-random(2);
          inc(x,rx);
          inc(y,ry);
        END;
    inc(r,rr);
    inc(g,rg);
    inc(b,rb);
    IF (r>255) THEN
      BEGIN
        r:=255;
        rr:=-1-random(3);
      END;
    IF (r<0) THEN
      BEGIN
        r:=0;
        rr:=+1+random(3);
      END;
    IF (g>255) THEN
      BEGIN
        g:=255;
        rg:=-1-random(3);
      END;
    IF (g<0) THEN
      BEGIN
        g:=0;
        rg:=+1+random(3);
      END;
    IF (b>255) THEN
      BEGIN
        b:=255;
        rb:=-1-random(3);
      END;
    IF (b<0) THEN
      BEGIN
        b:=0;
        rb:=+1+random(3);
      END;
    ch:=#0;
    IF keypressed THEN
      BEGIN
        ch:=readkey;
        selectpattern(ch);
      END;
  UNTIL (ch=#13) OR (MouseButton>0);
  IF (MouseButton>0) THEN WaitButtonReleased;
  setfillstyle(fs_solid);
END;

PROCEDURE Demo_ellipsefill;
VAR r,g,b,rr,rg,rb,mx,my:longint;
    i:byte;
    ch:char;
BEGIN
  Rahmen(TRUE);
  WITH linexy[1] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=-1-random(3);
      ry:=-1-random(3);
    END;
  WITH linexy[2] DO
    BEGIN
      x:=getmaxX DIV 2;
      y:=getmaxY DIV 2;
      rx:=+1+random(3);
      ry:=+1+random(3);
    END;
  r:=random(256);
  g:=random(256);
  b:=random(256);
  rr:=1;
  rg:=1;
  rb:=1;
  mx:=getmaxX DIV 2;
  my:=getmaxY DIV 2;
  REPEAT
    ellipsefill(mx,my,abs(linexy[2].x-mx),abs(linexy[2].y-my),rgbcolorRGB(r,g,b));
    FOR i:=1 TO 2 DO
      WITH linexy[i] DO
        BEGIN
          IF (x<vx1) THEN
            rx:=+1+random(2);
          IF (x>vx2) THEN
            rx:=-1-random(2);
          IF (y<vy1) THEN
            ry:=+1+random(2);
          IF (y>vy2) THEN
            ry:=-1-random(2);
          inc(x,rx);
          inc(y,ry);
        END;
    inc(r,rr);
    inc(g,rg);
    inc(b,rb);
    IF (r>255) THEN
      BEGIN
        r:=255;
        rr:=-1-random(3);
      END;
    IF (r<0) THEN
      BEGIN
        r:=0;
        rr:=+1+random(3);
      END;
    IF (g>255) THEN
      BEGIN
        g:=255;
        rg:=-1-random(3);
      END;
    IF (g<0) THEN
      BEGIN
        g:=0;
        rg:=+1+random(3);
      END;
    IF (b>255) THEN
      BEGIN
        b:=255;
        rb:=-1-random(3);
      END;
    IF (b<0) THEN
      BEGIN
        b:=0;
        rb:=+1+random(3);
      END;
    ch:=#0;
    IF keypressed THEN
      BEGIN
        ch:=readkey;
        selectpattern(ch);
      END;
  UNTIL (ch=#13) OR (MouseButton>0);
  IF (MouseButton>0) THEN WaitButtonReleased;
  setfillstyle(fs_solid);
END;

PROCEDURE GraphixDemo2(background:pointer);
BEGIN
  MouseOff;
  bg:=background;
  new(ft,LoadFont('fontega.fnt'));
  pat[1]:=CreatePattern('+','++     +',
                            '+++  +  ',
                            ' +  +++ ',
                            '   +++  ',
                            '  +++   ',
                            ' +++  + ',
                            '  +  +++',
                            '+     ++');

  pat[2]:=CreatePattern('+','   ++   ',
                            '  +  +  ',
                            ' +    + ',
                            '+      +',
                            '+      +',
                            ' +    + ',
                            '  +  +  ',
                            '   ++   ');

  pat[3]:=CreatePattern('+','++++    ',
                            '++++    ',
                            '++++    ',
                            '++++    ',
                            '    ++++',
                            '    ++++',
                            '    ++++',
                            '    ++++');
  pat[4]:=CreatePattern('+','++++    ',
                            '+  + ++ ',
                            '+  + ++ ',
                            '++++    ',
                            '    ++++',
                            ' ++ +  +',
                            ' ++ +  +',
                            '    ++++');

  pat[5]:=CreatePattern('+','++++++++',
                            '+      +',
                            '+     + ',
                            '+    +  ',
                            '+   +   ',
                            '+  + +  ',
                            '+ +   + ',
                            '++     +');
  Demo_line;
  Demo_linexor;
  Demo_rectangle;
  Demo_bar;
  Demo_barXOR;
  Demo_font;
  Demo_putimage;
  Demo_putimageC;
  Demo_zoomimage;
  Demo_zoomimageC;
  Demo_moverect;
  Demo_scrolling;
  Demo_polygon;
  Demo_circle;
  Demo_circlefill;
  Demo_ellipsefill;
  Destroypattern(pat[1]);
  Destroypattern(pat[2]);
  Destroypattern(pat[3]);
  Destroypattern(pat[4]);
  Destroypattern(pat[5]);
  setfillstyle(fs_solid);
  dispose(ft,RemoveFont);
  maxgraphwin;
  MouseOn;
END;

END.
