{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{============================================================================}
{ ATI mach8, mach32, mach64                                                  }
{============================================================================}
{$I gxglobal.cfg}
UNIT gxhw_ati;

INTERFACE

USES gxbase,gxpci,gx3dtype,gxsup,gxmem;
{$I gxlocal.cfg}

{PROCEDURE sethwaprocs_ati(col:longint);}
PROCEDURE setupdevice_ati(baseaddr:dword;var pcidev:TPCIdevice);
PROCEDURE adjustaddresses_ati(old_ds_base,new_ds_base:dword);
PROCEDURE setreslist_ati_mach64(var modelist:PModeEntry);
FUNCTION detectchip_ati(var chipid:dword;var name:string):longint;
FUNCTION detectmem_ati(devid:longint):longint;
PROCEDURE enableregs_ati_mach8;
PROCEDURE disableregs_ati_mach8;
PROCEDURE enableregs_ati_mach32;
PROCEDURE disableregs_ati_mach32;
PROCEDURE enableregs_ati_mach64;
PROCEDURE disableregs_ati_mach64;
PROCEDURE initmode_ati_mach64(mode:word);
{PROCEDURE setcolormode_ati(col:longint);}
PROCEDURE setrgbcolor_ati(nr,R,G,B:byte);
PROCEDURE scanline_ati(linewidth:word);
PROCEDURE scanline_ati_mach64(linewidth:word);
PROCEDURE displaystart_ati(offs:dword);
PROCEDURE displaystart_ati_mach64(offs:dword);
PROCEDURE bankswitch_ati_mach8;
PROCEDURE bankswitch_ati_mach32;
PROCEDURE bankswitch_ati_mach64;
PROCEDURE enableLFB_ati_mach8(physaddr:dword);
PROCEDURE enableLFB_ati_mach32(physaddr:dword);
PROCEDURE enableLFB_ati_mach32_pci(physaddr:dword);
PROCEDURE enableLFB_ati_mach64(physaddr:dword);
PROCEDURE enableLFB_ati_mach64_pci(physaddr:dword);
PROCEDURE disableLFB_ati_mach8;
PROCEDURE disableLFB_ati_mach32;
PROCEDURE disableLFB_ati_mach64;

IMPLEMENTATION

USES gxcrtext,graphix,go32;

VAR mmiomap0:tmmiomap;
    devid:dword;
{    reg_mca:dword; }

PROCEDURE setupdevice_ati(baseaddr:dword;var pcidev:TPCIdevice);
BEGIN
  devid:=0;
  CASE pcidev.device OF
  $4158: {mach 32}
    BEGIN
      devid:=pcidev.device;
    END;
  $4354..$4C54,$5354..$5656: {mach64}
    BEGIN
      mapresource(mmiomap0,pcidev.base0 AND $FF800000,getpcibasesize(baseaddr,0));
      lfbbase:=mmiomap0.offs;
      devid:=pcidev.device;
    END;
  $5041..$5348: {rage128}
    BEGIN
      devid:=pcidev.device;
    END;
  END;
END;

PROCEDURE adjustaddresses_ati(old_ds_base,new_ds_base:dword);
BEGIN
  adjustaddress(lfbbase,old_ds_base,new_ds_base);
END;

{----------------------------------------------------------------------------}

FUNCTION detectchip_ati(var chipid:dword;var name:string):longint;
VAR chip:dword;
    typ:byte;
BEGIN
  dosmemget($C000,$43,typ,1);
  CASE typ OF
  $31..$36:
    ASM
      MOV EAX,08000000h
      MOV DX,1CEh
      MOV AL,0AAh
      OUT DX,AL
      INC DX
      IN AL,DX
      AND AL,0Fh
      MOV chip,EAX
    END;
  $61..$63:
    ASM
    {mach32}
      MOV EAX,32000000h
      MOV DX,0FAEEh
      IN AX,DX
      AND AX,03FFh
      MOV chip,EAX
    END;
  $20..$30,$37..$4F:
    ASM
    {mach64}
      MOV DX,6EECh
      IN EAX,DX
      AND EAX,0000FFFFh
      OR EAX,64000000h
      MOV chip,EAX
    END;
  END;
  CASE chip OF
    $00000000:;
    $08000005:name:='ATI 28800-5';
    $08000006:name:='ATI 28800-6';
    $32000017:name:='ATI 68800-AX';
    $32000177:name:='ATI 68800-LX';
    $320002F7:name:='ATI 68800-6';
    $64000057:name:='ATI mach64 CX';
    $640000D7:name:='ATI mach64 GX';
    $64004354:name:='ATI mach64 CT';
    $64004554:name:='ATI mach64 ET';
    $64005654:name:='ATI mach64 GT/VT';
    $64004755:name:='ATI mach64 GT2';
    $64005655:name:='ATI mach64 VT2';
    $64004744,
    $64004749,
    $64004750:name:='ATI mach64 GTP';
    ELSE name:='ATI - unknown - ID '+hexbyte(chip);
  END;
  chipid:=chip;
  detectchip_ati:=chip;
END;

FUNCTION detectmem_ati(devid:longint):longint;
VAR w:word;
    mem:longint;
BEGIN
  mem:=2048;
  CASE devid OF
  $08000000..$0800FFFF:
    BEGIN
      ASM
        MOV DX,01CEh
        MOV AL,0B0h
        OUT DX,AL
        INC DX
        IN AL,DX
        AND AX,0018h
        MOV w,AX
      END;
      CASE w OF
      $0000:mem:=256;
      $0010:mem:=512;
      $0008:mem:=1024;
      $0018:mem:=1024;
      END;
    END;
  $4158,$32000000..$3200FFFF: {mach 32}
    BEGIN
      ASM
        MOV DX,36EEh
        IN AX,DX
        MOV CX,AX
        AND CX,000Ch
        SHR CX,2
        MOV AX,0200h
        SHL AX,CL
        MOV mem,EAX
      END;
    END;
  $4354..$4C54,$5354..$5656,$64000000..$6400FFFF: {mach64}
    BEGIN
      ASM
        MOV DX,52ECh
        IN EAX,DX
        AND AX,0007h
        MOV w,AX
      END;
      CASE w OF
      $0000:mem:=512;
      $0001:mem:=1024;
      $0002:mem:=2048;
      $0003:mem:=4096;
      $0004:mem:=6144;
      $0005:mem:=8192;
      ELSE mem:=4096;
      END;
    END;
  $5041..$5348: {rage128}
    BEGIN
    END;
  END;
  detectmem_ati:=mem;
END;


{----------------------------------------------------------------------------}

PROCEDURE enableregs_ati_mach8;assembler;
ASM
END;

PROCEDURE disableregs_ati_mach8;
BEGIN
END;

PROCEDURE enableregs_ati_mach32;assembler;
ASM
  MOV DX,42EEh
  MOV AX,0000h
  OUT DX,AX
  MOV DX,5EEEh
  IN AX,DX
  AND AX,0FFF0h
  OUT DX,AX
END;

PROCEDURE disableregs_ati_mach32;
BEGIN
END;

PROCEDURE enableregs_ati_mach64;assembler;
ASM
END;

PROCEDURE disableregs_ati_mach64;
BEGIN
END;

PROCEDURE initmode_ati_mach64(mode:word);assembler;
ASM
  MOV AX,mode
  OR AH,AH
  JZ @vgamode
  MOV CX,AX
  MOV AX,0A000h
  INT 10h
  MOV AX,0A001h
  MOV CL,81h
@vgamode:
  INT 10h
END;

PROCEDURE setrgbcolor_ati(nr,R,G,B:byte);assembler;
ASM
  MOV DX,03C8h
  MOV AL,nr
  OUT DX,AL
  INC DX
  MOV AL,r
  OUT DX,AL
  MOV AL,g
  OUT DX,AL
  MOV AL,b
  OUT DX,AL
END;

PROCEDURE scanline_ati(linewidth:word);assembler;
ASM
{bit 0-7}
  MOV DX,03D4h
  MOV AH,BYTE PTR linewidth
  MOV AL,13h
  OUT DX,AX
END;

PROCEDURE scanline_ati_mach64(linewidth:word);assembler;
ASM
  MOV DX,16ECh
  IN EAX,DX
  AND EAX,003FFFFFh
  MOV BX,linewidth
  SHL EBX,22
  OR EAX,EBX
  OUT DX,EAX
END;

PROCEDURE displaystart_ati(offs:dword);assembler;
ASM
  MOV EBX,offs
{bit 0-7}
  SHR EBX,2
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Dh
  OUT DX,AX
{bit 8-15}
  SHR EBX,8
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Ch
  OUT DX,AX
{bit 16}
  MOV DX,01CEh
  SHR EBX,1
  SHR BL,1
  AND BL,40h
  MOV AL,0B0h
  OUT DX,AL
  INC DX
  IN AL,DX
  DEC DX
  AND AL,0BFh
  MOV AH,AL
  MOV AL,0B0h
  OUT DX,AL
  MOV AL,AH
  OR AL,BL
  INC DX
  OUT DX,AL
  DEC DX
{bit 17}
  SHR EBX,1
  SHR BL,3
  AND BL,10h
  MOV AL,0A3h
  OUT DX,AL
  INC DX
  IN AL,DX
  DEC DX
  AND AL,0EFh
  MOV AH,AL
  MOV AL,0A3h
  OUT DX,AL
  MOV AL,AH
  OR AL,BL
  INC DX
  OUT DX,AL
  DEC DX
{bit 18-19}
  SHR EBX,2
  SHR BL,4
  AND BL,0Ch
  MOV AL,0ADh
  OUT DX,AL
  INC DX
  IN AL,DX
  DEC DX
  AND AL,0F3h
  MOV AH,AL
  MOV AL,0ADh
  OUT DX,AL
  MOV AL,AH
  OR AL,BL
  INC DX
  OUT DX,AL
  DEC DX
END;

PROCEDURE displaystart_ati_mach64(offs:dword);assembler;
ASM
  MOV DX,16ECh
  IN EAX,DX
  AND EAX,0FFF00000h
  MOV EBX,offs
  SHR EBX,3
  AND EBX,000FFFFFh
  OR EAX,EBX
  OUT DX,EAX
END;

PROCEDURE bankswitch_ati_mach8;assembler;
ASM
  MOV AH,DL
  MOV DX,01CEh
  MOV AL,0B2h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0E1h
  SHL AH,1
  AND AH,1Eh
  OR AH,AL
  DEC DX
  MOV AL,0B2h
  OUT DX,AL
  INC DX
  MOV AL,AH
  OUT DX,AL
END;

PROCEDURE bankswitch_ati_mach32;assembler;
ASM
  MOV BL,DL
  MOV DX,01CEh
  MOV AL,0AEh
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0F0h
  MOV AH,BL
  SHL AH,4
  AND AH,3
  OR AH,AL
  DEC DX
  MOV AL,0AEh
  OUT DX,AL
  INC DX
  MOV AL,AH
  OUT DX,AL
  DEC DX
  MOV AL,0B2h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0E1h
  MOV AH,BL
  SHL AH,1
  AND AH,1Eh
  OR AH,AL
  DEC DX
  MOV AL,0B2h
  OUT DX,AL
  INC DX
  MOV AL,AH
  OUT DX,AL
END;

PROCEDURE bankswitch_ati_mach64;assembler;
ASM
  XOR EAX,EAX
  SHL DL,1
  MOV AL,DL
  INC AL
  SHL EAX,16
  MOV AL,DL
  MOV DX,56ECh
  OUT DX,EAX
  MOV DX,5AECh
  OUT DX,EAX
END;
{
PROCEDURE enableLFB_ati(physaddr:dword);assembler;
ASM
  MOV DX,03C4h
  MOV AL,10h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0EFh
  OUT DX,AL

  MOV DX,03C4h
  MOV AL,12h
  OUT DX,AL
  INC DX
  IN AL,DX
  AND AL,0FCh
  OR AL,02h
  OUT DX,AL

  MOV EBX,physaddr
  SHR EBX,16
  MOV DX,03C4h
  MOV AL,13h
  MOV AH,BL
  OUT DX,AX
  MOV AL,14h
  MOV AH,BH
  OUT DX,AX

  MOV DX,03C4h
  MOV AL,10h
  OUT DX,AL
  INC DX
  IN AL,DX
  OR AL,1Ch
  OUT DX,AL
END;
}
PROCEDURE enableLFB_ati_mach8(physaddr:dword);assembler;
ASM
  MOV DX,01CEh
  MOV AL,0ACh
  OUT DX,AL
  INC DX
  IN AX,DX
  OR AL,01h
  MOV AH,AL
  DEC DX
  MOV AL,0ACh
  OUT DX,AL
  INC DX
  MOV AL,AH
  OUT DX,AL
END;

PROCEDURE disableLFB_ati_mach8;assembler;
ASM
  MOV DX,01CEh
  MOV AL,0ACh
  OUT DX,AL
  INC DX
  IN AX,DX
  AND AL,0FEh
  MOV AH,AL
  DEC DX
  MOV AL,0ACh
  OUT DX,AL
  INC DX
  MOV AL,AH
  OUT DX,AL
END;

PROCEDURE enableLFB_ati_mach32(physaddr:dword);assembler;
ASM
  MOV DX,5EEEh
  IN AX,DX
  AND AX,0FFF0h
  OR AX,0002h
  MOV EBX,physaddr
  SHR EBX,12
  AND BX,0FF00h
  OR AX,BX
  OUT DX,AX
END;

PROCEDURE enableLFB_ati_mach32_pci(physaddr:dword);assembler;
ASM
  MOV DX,5EEEh
  IN AX,DX
  AND AX,0FFF0h
  OR AX,0002h
  OUT DX,AX
END;

PROCEDURE disableLFB_ati_mach32;assembler;
ASM
  MOV DX,5EEEh
  IN AX,DX
  AND AX,0FFF0h
  OUT DX,AX
END;

PROCEDURE enableLFB_ati_mach64(physaddr:dword);assembler;
ASM
  MOV DX,6AECh
  IN EAX,DX
  AND EAX,0FFFFFFF0h
  OR EAX,00000002h
  MOV EBX,physaddr
  SHR EBX,18
  AND EBX,000001FE0h
  OR EAX,EBX
  OUT DX,EAX
END;

PROCEDURE enableLFB_ati_mach64_pci(physaddr:dword);assembler;
ASM
  MOV DX,6AECh
  IN EAX,DX
  AND EAX,0FFFFFFF0h
  OR EAX,00000002h
  OUT DX,EAX
END;

PROCEDURE disableLFB_ati_mach64;assembler;
ASM
  MOV DX,6AECh
  IN EAX,DX
  AND EAX,0FFFFFFF0h
  OR EAX,00000004h
  OUT DX,EAX
END;


{============================================================================}

procedure dosalloc(var selector:word; var segment:word;size:longint);
var res:longint;
begin
  res:=global_dos_alloc(size);
  selector:=word(res);
  segment:=word(res shr 16);
end;

procedure dosfree(selector:word);
begin
  global_dos_free(selector);
end;

PROCEDURE setreslist_ati_mach64(var modelist:PModeEntry);
TYPE TQuery=PACKED RECORD
       size:word;
       revision:byte;
       modtabnum:byte;
       modtabofs:word;
       modtabsize:byte;
       vgatype:byte;
       asicrevision:word;
       vgaboundary:byte;
       memorysize:byte;
       dactype:byte;
       memorytype:byte;
       bustype:byte;
       syncenable:byte;
       apertureaddr:word;
       apertureconf:byte;
       colordepth:byte;
       ramdac:byte;
       res0:byte;
       curmodtab:word;
       iobase:word;
       res1,res2,res3,res4,res5,res6:byte;
     END;

     TModeTable=PACKED RECORD
       hres:word;
       vres:word;
       maxcolordepth:byte;
       modenum:byte;
       eepromofs:word;
       scan:word;
       crtc_H_total:byte;
       crtc_H_disp:byte;
       crtc_H_syncstart:byte;
       crtc_H_syncwid:byte;
       crtc_V_total:word;
       crtc_V_disp:word;
       crtc_V_syncstart:word;
       crtc_V_syncwid:byte;
       clock_cntl:byte;
       copdotclock:word;
       ovr:byte;
       crtc_H_xxx_dly:byte;
       ovr_wid_top:byte;
       ovr_wid_bottom:byte;
       ovr_clr_b:byte;
       ovr_clr_8:byte;
       ovr_clr_g:byte;
       ovr_clr_r:byte;
     END;

VAR RealRegs:TRealRegs;
    segment,selector:word;
    size,i,j:word;
    queryptr,modtabptr:pointer;
BEGIN
  RealRegs.AX:=$A008;
  RealRegs.CL:=$01;
  realintr($10,RealRegs);
  size:=RealRegs.CX;
  dosalloc(selector,segment,size);
  RealRegs.AX:=$A009;
  RealRegs.CL:=$01;
  RealRegs.DX:=segment;
  RealRegs.BX:=0;
  realintr($10,RealRegs);
  getmem(queryptr,size);
  dosmemget(segment,0,queryptr^,size);
  dosfree(selector);
  modtabptr:=queryptr+TQuery(queryptr^).modtabofs;
  FOR i:=1 TO TQuery(queryptr^).modtabnum DO
    BEGIN
      WITH TModeTable(modtabptr^) DO
        BEGIN
          write(i,' - ');
          write(hexbyte(modenum),', ');
          write(hres,', ');
          write(vres,', ');
          writeln(maxcolordepth);
          FOR j:=2 TO maxcolordepth DO
            CASE j OF
              2:AddModeToList(modelist,(modenum SHL 8) OR $92,hres,vres,1,hres*1,hres SHR 3,0,0,  5,3,2,3,0,2, ig_bank+ig_lfb{+ig_hwa}+ig_col8);
              3:AddModeToList(modelist,(modenum SHL 8) OR $93,hres,vres,2,hres*2,hres SHR 3,0,0, 10,5,5,5,0,5, ig_bank+ig_lfb{+ig_hwa}+ig_col15);
              4:AddModeToList(modelist,(modenum SHL 8) OR $94,hres,vres,2,hres*2,hres SHR 3,0,0, 11,5,5,6,0,5, ig_bank+ig_lfb{+ig_hwa}+ig_col16);
              5:AddModeToList(modelist,(modenum SHL 8) OR $95,hres,vres,3,hres*3,hres SHR 3,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb{+ig_hwa}+ig_col24);
              6:AddModeToList(modelist,(modenum SHL 8) OR $96,hres,vres,4,hres*4,hres SHR 3,0,0, 16,8,8,8,0,8, ig_bank+ig_lfb{+ig_hwa}+ig_col32);
            END;
        END;
      inc(modtabptr,TQuery(queryptr^).modtabsize);
    END;
  freemem(queryptr,size);
END;

{============================================================================}

END.
