{
    This file is a part of the graphics library GraphiX
    Copyright (C) 2001 Michael Knapp

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
}

{$I gxglobal.cfg}
UNIT gxvga;

INTERFACE

{$I gxlocal.cfg}

PROCEDURE initmode_vga(mode:word);
PROCEDURE scanline_vga(linewidth:word);
PROCEDURE displaystart_vga(offs:dword);
PROCEDURE retrace_vga;
PROCEDURE retraceend_vga;
PROCEDURE retracestart_vga;
PROCEDURE setrgbcolor_vga(nr,R,G,B:byte);

IMPLEMENTATION

PROCEDURE initmode_vga(mode:word);assembler;
ASM
  MOV AX,mode
  XOR AH,AH
  INT 10h
END;

PROCEDURE scanline_vga(linewidth:word);assembler;
ASM
{bit 0-7}
  MOV DX,03D4h
  MOV AH,BYTE PTR linewidth
  MOV AL,13h
  OUT DX,AX
END;

PROCEDURE displaystart_vga(offs:dword);assembler;
ASM
  MOV EBX,offs
{bit 0-7}
  SHR EBX,2
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Dh
  OUT DX,AX
{bit 8-15}
  SHR EBX,8
  MOV DX,03D4h
  MOV AH,BL
  MOV AL,0Ch
  OUT DX,AX
END;

PROCEDURE retrace_vga;assembler;
ASM
  MOV DX,03DAh
@rl1:
  IN AL,DX
  TEST AL,08h
  JNZ @rl1
@rl2:
  IN AL,DX
  TEST AL,08h
  JZ @rl2
END;

PROCEDURE retraceend_vga;assembler;
ASM
  MOV DX,03DAh
@r2:
  IN AL,DX
  TEST AL,08h
  JZ @r2
END;

PROCEDURE retracestart_vga;assembler;
ASM
  MOV DX,03DAh
@r1:
  IN AL,DX
  TEST AL,08h
  JNZ @r1
END;

PROCEDURE setrgbcolor_vga(nr,R,G,B:byte);assembler;
ASM
  MOV DX,03C8h
  MOV AL,nr
  OUT DX,AL
  INC DX
  MOV AL,r
  SHR AL,2
  OUT DX,AL
  MOV AL,g
  SHR AL,2
  OUT DX,AL
  MOV AL,b
  SHR AL,2
  OUT DX,AL
END;

END.



