unit DirectSoundFPC;

{$I SWITCHES.INC}

interface

uses
	windows, DirectDraw, DirectSound, ole2;


// IDirectSound interface methods

function IDirectSound_CreateSoundBuffer(idd : IDirectSound; const lpDSBufferDesc : TDSBufferDesc; var lpIDirectSoundBuffer : IDirectSoundBuffer; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirectSound_GetCaps(idd : IDirectSound; var lpDSCaps : TDSCaps) : HResult; stdcall;
function IDirectSound_DuplicateSoundBuffer(idd : IDirectSound; lpDsbOriginal : IDirectSoundBuffer; var lpDsbDuplicate : IDirectSoundBuffer) : HResult; stdcall;
function IDirectSound_SetCooperativeLevel(idd : IDirectSound; hwnd : HWND; dwLevel : DWORD) : HResult; stdcall;
function IDirectSound_Compact(idd : IDirectSound) : HResult; stdcall;
function IDirectSound_GetSpeakerConfig(idd : IDirectSound; var lpdwSpeakerConfig : DWORD) : HResult; stdcall;
function IDirectSound_SetSpeakerConfig(idd : IDirectSound; dwSpeakerConfig : DWORD) : HResult; stdcall;
function IDirectSound_Initialize(idd : IDirectSound; lpGuid : PGUID) : HResult; stdcall;

// IDirectSoundBuffer interface methods

function IDirectSoundBuffer_GetCaps(idd : IDirectSoundBuffer; var lpDSCaps : TDSBCaps) : HResult; stdcall;
function IDirectSoundBuffer_GetCurrentPosition(idd : IDirectSoundBuffer; lpdwCapturePosition , lpdwReadPosition : PDWORD) : HResult; stdcall;
function IDirectSoundBuffer_GetFormat(idd : IDirectSoundBuffer; lpwfxFormat : PWaveFormatEx; dwSizeAllocated : DWORD; lpdwSizeWritten : PWORD) : HResult; stdcall;
function IDirectSoundBuffer_GetVolume(idd : IDirectSoundBuffer; var lplVolume : integer) : HResult; stdcall;
function IDirectSoundBuffer_GetPan(idd : IDirectSoundBuffer; var lplPan : integer) : HResult; stdcall;
function IDirectSoundBuffer_GetFrequency(idd : IDirectSoundBuffer; var lpdwFrequency : DWORD) : HResult; stdcall;
function IDirectSoundBuffer_GetStatus(idd : IDirectSoundBuffer; var lpdwStatus : DWORD) : HResult; stdcall;
function IDirectSoundBuffer_Initialize(idd : IDirectSoundBuffer; lpDirectSound : IDirectSound; const lpcDSBufferDesc : TDSBufferDesc) : HResult; stdcall;
function IDirectSoundBuffer_Lock(idd : IDirectSoundBuffer; dwWriteCursor , dwWriteBytes : DWORD; var lplpvAudioPtr1 : Pointer; var lpdwAudioBytes1 : DWORD; var lplpvAudioPtr2 : Pointer; var lpdwAudioBytes2 : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectSoundBuffer_Play(idd : IDirectSoundBuffer; dwReserved1 , dwReserved2 , dwFlags : DWORD) : HResult; stdcall;
function IDirectSoundBuffer_SetCurrentPosition(idd : IDirectSoundBuffer; dwPosition : DWORD) : HResult; stdcall;
function IDirectSoundBuffer_SetFormat(idd : IDirectSoundBuffer; const lpcfxFormat : TWaveFormatEx) : HResult; stdcall;
function IDirectSoundBuffer_SetVolume(idd : IDirectSoundBuffer; lVolume : integer) : HResult; stdcall;
function IDirectSoundBuffer_SetPan(idd : IDirectSoundBuffer; lPan : integer) : HResult; stdcall;
function IDirectSoundBuffer_SetFrequency(idd : IDirectSoundBuffer; dwFrequency : DWORD) : HResult; stdcall;
function IDirectSoundBuffer_Stop(idd : IDirectSoundBuffer) : HResult; stdcall;
function IDirectSoundBuffer_Unlock(idd : IDirectSoundBuffer; lpvAudioPtr1 : Pointer; dwAudioBytes1 : DWORD; lpvAudioPtr2 : Pointer; dwAudioBytes2 : DWORD) : HResult; stdcall;
function IDirectSoundBuffer_Restore(idd : IDirectSoundBuffer) : HResult; stdcall;

// IDirectSound3DListener interface methods

function IDirectSound3DListener_GetAllParameters(idd : IDirectSound3DListener; var lpListener : TDS3DListener) : HResult; stdcall;
function IDirectSound3DListener_GetDistanceFactor(idd : IDirectSound3DListener; var lpflDistanceFactor : TD3DValue) : HResult; stdcall;
function IDirectSound3DListener_GetDopplerFactor(idd : IDirectSound3DListener; var lpflDopplerFactor : TD3DValue) : HResult; stdcall;
function IDirectSound3DListener_GetOrientation(idd : IDirectSound3DListener; var lpvOrientFront , lpvOrientTop : TD3DVector) : HResult; stdcall;
function IDirectSound3DListener_GetPosition(idd : IDirectSound3DListener; var lpvPosition : TD3DVector) : HResult; stdcall;
function IDirectSound3DListener_GetRolloffFactor(idd : IDirectSound3DListener; var lpflRolloffFactor : TD3DValue) : HResult; stdcall;
function IDirectSound3DListener_GetVelocity(idd : IDirectSound3DListener; var lpvVelocity : TD3DVector) : HResult; stdcall;
function IDirectSound3DListener_SetAllParameters(idd : IDirectSound3DListener; const lpcListener : TDS3DListener; dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DListener_SetDistanceFactor(idd : IDirectSound3DListener; flDistanceFactor : TD3DValue; dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DListener_SetDopplerFactor(idd : IDirectSound3DListener; flDopplerFactor : TD3DValue; dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DListener_SetOrientation(idd : IDirectSound3DListener; xFront , yFront , zFront , xTop , yTop , zTop : TD3DValue; dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DListener_SetPosition(idd : IDirectSound3DListener; x , y , z : TD3DValue; dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DListener_SetRolloffFactor(idd : IDirectSound3DListener; flRolloffFactor : TD3DValue; dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DListener_SetVelocity(idd : IDirectSound3DListener; x , y , z : TD3DValue; dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DListener_CommitDeferredSettings(idd : IDirectSound3DListener) : HResult; stdcall;

// IDirectSound3DBuffer interface methods

function IDirectSound3DBuffer_GetAllParameters(idd : IDirectSound3DBuffer; var lpDs3dBuffer : TDS3DBuffer) : HResult; stdcall;
function IDirectSound3DBuffer_GetConeAngles(idd : IDirectSound3DBuffer; var lpdwInsideConeAngle , lpdwOutsideConeAngle : DWORD) : HResult; stdcall;
function IDirectSound3DBuffer_GetConeOrientation(idd : IDirectSound3DBuffer; var lpvOrientation : TD3DVector) : HResult; stdcall;
function IDirectSound3DBuffer_GetConeOutsideVolume(idd : IDirectSound3DBuffer; var lplConeOutsideVolume : integer) : HResult; stdcall;
function IDirectSound3DBuffer_GetMaxDistance(idd : IDirectSound3DBuffer; var lpflMaxDistance : TD3DValue) : HResult; stdcall;
function IDirectSound3DBuffer_GetMinDistance(idd : IDirectSound3DBuffer; var lpflMinDistance : TD3DValue) : HResult; stdcall;
function IDirectSound3DBuffer_GetMode(idd : IDirectSound3DBuffer; var lpdwMode : DWORD) : HResult; stdcall;
function IDirectSound3DBuffer_GetPosition(idd : IDirectSound3DBuffer; var lpvPosition : TD3DVector) : HResult; stdcall;
function IDirectSound3DBuffer_GetVelocity(idd : IDirectSound3DBuffer; var lpvVelocity : TD3DVector) : HResult; stdcall;
function IDirectSound3DBuffer_SetAllParameters(idd : IDirectSound3DBuffer; const lpcDs3dBuffer : TDS3DBuffer; dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DBuffer_SetConeAngles(idd : IDirectSound3DBuffer; dwInsideConeAngle , dwOutsideConeAngle , dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DBuffer_SetConeOrientation(idd : IDirectSound3DBuffer; x , y , z : TD3DValue; dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DBuffer_SetConeOutsideVolume(idd : IDirectSound3DBuffer; lConeOutsideVolume : LongInt; dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DBuffer_SetMaxDistance(idd : IDirectSound3DBuffer; flMaxDistance : TD3DValue; dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DBuffer_SetMinDistance(idd : IDirectSound3DBuffer; flMinDistance : TD3DValue; dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DBuffer_SetMode(idd : IDirectSound3DBuffer; dwMode : DWORD; dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DBuffer_SetPosition(idd : IDirectSound3DBuffer; x , y , z : TD3DValue; dwApply : DWORD) : HResult; stdcall;
function IDirectSound3DBuffer_SetVelocity(idd : IDirectSound3DBuffer; x , y , z : TD3DValue; dwApply : DWORD) : HResult; stdcall;

// IDirectSoundCapture interface methods

function IDirectSoundCapture_CreateCaptureBuffer(idd : IDirectSoundCapture; const lpDSCBufferDesc : TDSCBufferDesc; var lplpDirectSoundCaptureBuffer : IDirectSoundCaptureBuffer; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirectSoundCapture_GetCaps(idd : IDirectSoundCapture; var lpdwCaps : TDSCCaps) : HResult; stdcall;
function IDirectSoundCapture_Initialize(idd : IDirectSoundCapture; lpGuid : PGUID) : HResult; stdcall;

// IDirectSoundCaptureBuffer interface methods

function IDirectSoundCaptureBuffer_GetCaps(idd : IDirectSoundCaptureBuffer; var lpdwCaps : TDSCBCaps) : HResult; stdcall;
function IDirectSoundCaptureBuffer_GetCurrentPosition(idd : IDirectSoundCaptureBuffer; lpdwCapturePosition , lpdwReadPosition : PDWORD) : HResult; stdcall;
function IDirectSoundCaptureBuffer_GetFormat(idd : IDirectSoundCaptureBuffer; lpwfxFormat : PWaveFormatEx; dwSizeAllocated : DWORD; lpdwSizeWritten : PDWORD) : HResult; stdcall;
function IDirectSoundCaptureBuffer_GetStatus(idd : IDirectSoundCaptureBuffer; var lpdwStatus : DWORD) : HResult; stdcall;
function IDirectSoundCaptureBuffer_Initialize(idd : IDirectSoundCaptureBuffer; lpDirectSoundCapture : IDirectSoundCapture; const lpcDSBufferDesc : TDSCBufferDesc) : HResult; stdcall;
function IDirectSoundCaptureBuffer_Lock(idd : IDirectSoundCaptureBuffer; dwReadCursor , dwReadBytes : DWORD; var lplpvAudioPtr1 : Pointer; var lpdwAudioBytes1 : DWORD; var lplpvAudioPtr2 : Pointer; var lpdwAudioBytes2 : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectSoundCaptureBuffer_Start(idd : IDirectSoundCaptureBuffer; dwFlags : DWORD) : HResult; stdcall;
function IDirectSoundCaptureBuffer_Stop(idd : IDirectSoundCaptureBuffer) : HResult; stdcall;
function IDirectSoundCaptureBuffer_Unlock(idd : IDirectSoundCaptureBuffer; lpvAudioPtr1 : Pointer; dwAudioBytes1 : DWORD; lpvAudioPtr2 : Pointer; dwAudioBytes2 : DWORD) : HResult; stdcall;

// IDirectSoundNotify interface methods

function IDirectSoundNotify_SetNotificationPositions(idd : IDirectSoundNotify; cPositionNotifies : DWORD; const lpcPositionNotifies : TDSBPositionNotify) : HResult; stdcall;

// IKsPropertySet interface methods

function IKsPropertySet_Get(idd : IKsPropertySet; const rguidPropSet : TGUID; ulId : DWORD; var pInstanceData; ulInstanceLength : DWORD; var pPropertyData; ulDataLength : DWORD; var pulBytesReturned : DWORD) : HResult; stdcall;
function IKsPropertySet_SetProperty(idd : IKsPropertySet; const rguidPropSet : TGUID; ulId : DWORD; var pInstanceData; ulInstanceLength : DWORD; var pPropertyData; pulDataLength : DWORD) : HResult; stdcall;
function IKsPropertySet_QuerySupport(idd : IKsPropertySet; const rguidPropSet : TGUID; ulId : DWORD; var pulTypeSupport : DWORD) : HResult; stdcall;

implementation


// IDirectSound interface methods

function IDirectSound_CreateSoundBuffer(idd : IDirectSound; const lpDSBufferDesc : TDSBufferDesc; var lpIDirectSoundBuffer : IDirectSoundBuffer; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateSoundBuffer(idd, lpDSBufferDesc, lpIDirectSoundBuffer, pUnkOuter);
end;

function IDirectSound_GetCaps(idd : IDirectSound; var lpDSCaps : TDSCaps) : HResult; stdcall;
begin
	result := idd^^.GetCaps(idd, lpDSCaps);
end;

function IDirectSound_DuplicateSoundBuffer(idd : IDirectSound; lpDsbOriginal : IDirectSoundBuffer; var lpDsbDuplicate : IDirectSoundBuffer) : HResult; stdcall;
begin
	result := idd^^.DuplicateSoundBuffer(idd, lpDsbOriginal, lpDsbDuplicate);
end;

function IDirectSound_SetCooperativeLevel(idd : IDirectSound; hwnd : HWND; dwLevel : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetCooperativeLevel(idd, hwnd, dwLevel);
end;

function IDirectSound_Compact(idd : IDirectSound) : HResult; stdcall;
begin
	result := idd^^.Compact(idd);
end;

function IDirectSound_GetSpeakerConfig(idd : IDirectSound; var lpdwSpeakerConfig : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetSpeakerConfig(idd, lpdwSpeakerConfig);
end;

function IDirectSound_SetSpeakerConfig(idd : IDirectSound; dwSpeakerConfig : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetSpeakerConfig(idd, dwSpeakerConfig);
end;

function IDirectSound_Initialize(idd : IDirectSound; lpGuid : PGUID) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpGuid);
end;


// IDirectSoundBuffer interface methods

function IDirectSoundBuffer_GetCaps(idd : IDirectSoundBuffer; var lpDSCaps : TDSBCaps) : HResult; stdcall;
begin
	result := idd^^.GetCaps(idd, lpDSCaps);
end;

function IDirectSoundBuffer_GetCurrentPosition(idd : IDirectSoundBuffer; lpdwCapturePosition , lpdwReadPosition : PDWORD) : HResult; stdcall;
begin
	result := idd^^.GetCurrentPosition(idd, lpdwCapturePosition, lpdwReadPosition);
end;

function IDirectSoundBuffer_GetFormat(idd : IDirectSoundBuffer; lpwfxFormat : PWaveFormatEx; dwSizeAllocated : DWORD; lpdwSizeWritten : PWORD) : HResult; stdcall;
begin
	result := idd^^.GetFormat(idd, lpwfxFormat, dwSizeAllocated, lpdwSizeWritten);
end;

function IDirectSoundBuffer_GetVolume(idd : IDirectSoundBuffer; var lplVolume : integer) : HResult; stdcall;
begin
	result := idd^^.GetVolume(idd, lplVolume);
end;

function IDirectSoundBuffer_GetPan(idd : IDirectSoundBuffer; var lplPan : integer) : HResult; stdcall;
begin
	result := idd^^.GetPan(idd, lplPan);
end;

function IDirectSoundBuffer_GetFrequency(idd : IDirectSoundBuffer; var lpdwFrequency : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetFrequency(idd, lpdwFrequency);
end;

function IDirectSoundBuffer_GetStatus(idd : IDirectSoundBuffer; var lpdwStatus : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetStatus(idd, lpdwStatus);
end;

function IDirectSoundBuffer_Initialize(idd : IDirectSoundBuffer; lpDirectSound : IDirectSound; const lpcDSBufferDesc : TDSBufferDesc) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpDirectSound, lpcDSBufferDesc);
end;

function IDirectSoundBuffer_Lock(idd : IDirectSoundBuffer; dwWriteCursor , dwWriteBytes : DWORD; var lplpvAudioPtr1 : Pointer; var lpdwAudioBytes1 : DWORD; var lplpvAudioPtr2 : Pointer; var lpdwAudioBytes2 : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Lock(idd, dwWriteCursor, dwWriteBytes, lplpvAudioPtr1, lpdwAudioBytes1, lplpvAudioPtr2, lpdwAudioBytes2, dwFlags);
end;

function IDirectSoundBuffer_Play(idd : IDirectSoundBuffer; dwReserved1 , dwReserved2 , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Play(idd, dwReserved1, dwReserved2, dwFlags);
end;

function IDirectSoundBuffer_SetCurrentPosition(idd : IDirectSoundBuffer; dwPosition : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetCurrentPosition(idd, dwPosition);
end;

function IDirectSoundBuffer_SetFormat(idd : IDirectSoundBuffer; const lpcfxFormat : TWaveFormatEx) : HResult; stdcall;
begin
	result := idd^^.SetFormat(idd, lpcfxFormat);
end;

function IDirectSoundBuffer_SetVolume(idd : IDirectSoundBuffer; lVolume : integer) : HResult; stdcall;
begin
	result := idd^^.SetVolume(idd, lVolume);
end;

function IDirectSoundBuffer_SetPan(idd : IDirectSoundBuffer; lPan : integer) : HResult; stdcall;
begin
	result := idd^^.SetPan(idd, lPan);
end;

function IDirectSoundBuffer_SetFrequency(idd : IDirectSoundBuffer; dwFrequency : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetFrequency(idd, dwFrequency);
end;

function IDirectSoundBuffer_Stop(idd : IDirectSoundBuffer) : HResult; stdcall;
begin
	result := idd^^.Stop(idd);
end;

function IDirectSoundBuffer_Unlock(idd : IDirectSoundBuffer; lpvAudioPtr1 : Pointer; dwAudioBytes1 : DWORD; lpvAudioPtr2 : Pointer; dwAudioBytes2 : DWORD) : HResult; stdcall;
begin
	result := idd^^.Unlock(idd, lpvAudioPtr1, dwAudioBytes1, lpvAudioPtr2, dwAudioBytes2);
end;

function IDirectSoundBuffer_Restore(idd : IDirectSoundBuffer) : HResult; stdcall;
begin
	result := idd^^.Restore(idd);
end;


// IDirectSound3DListener interface methods

function IDirectSound3DListener_GetAllParameters(idd : IDirectSound3DListener; var lpListener : TDS3DListener) : HResult; stdcall;
begin
	result := idd^^.GetAllParameters(idd, lpListener);
end;

function IDirectSound3DListener_GetDistanceFactor(idd : IDirectSound3DListener; var lpflDistanceFactor : TD3DValue) : HResult; stdcall;
begin
	result := idd^^.GetDistanceFactor(idd, lpflDistanceFactor);
end;

function IDirectSound3DListener_GetDopplerFactor(idd : IDirectSound3DListener; var lpflDopplerFactor : TD3DValue) : HResult; stdcall;
begin
	result := idd^^.GetDopplerFactor(idd, lpflDopplerFactor);
end;

function IDirectSound3DListener_GetOrientation(idd : IDirectSound3DListener; var lpvOrientFront , lpvOrientTop : TD3DVector) : HResult; stdcall;
begin
	result := idd^^.GetOrientation(idd, lpvOrientFront, lpvOrientTop);
end;

function IDirectSound3DListener_GetPosition(idd : IDirectSound3DListener; var lpvPosition : TD3DVector) : HResult; stdcall;
begin
	result := idd^^.GetPosition(idd, lpvPosition);
end;

function IDirectSound3DListener_GetRolloffFactor(idd : IDirectSound3DListener; var lpflRolloffFactor : TD3DValue) : HResult; stdcall;
begin
	result := idd^^.GetRolloffFactor(idd, lpflRolloffFactor);
end;

function IDirectSound3DListener_GetVelocity(idd : IDirectSound3DListener; var lpvVelocity : TD3DVector) : HResult; stdcall;
begin
	result := idd^^.GetVelocity(idd, lpvVelocity);
end;

function IDirectSound3DListener_SetAllParameters(idd : IDirectSound3DListener; const lpcListener : TDS3DListener; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetAllParameters(idd, lpcListener, dwApply);
end;

function IDirectSound3DListener_SetDistanceFactor(idd : IDirectSound3DListener; flDistanceFactor : TD3DValue; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetDistanceFactor(idd, flDistanceFactor, dwApply);
end;

function IDirectSound3DListener_SetDopplerFactor(idd : IDirectSound3DListener; flDopplerFactor : TD3DValue; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetDopplerFactor(idd, flDopplerFactor, dwApply);
end;

function IDirectSound3DListener_SetOrientation(idd : IDirectSound3DListener; xFront , yFront , zFront , xTop , yTop , zTop : TD3DValue; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetOrientation(idd, xFront, yFront, zFront, xTop, yTop, zTop, dwApply);
end;

function IDirectSound3DListener_SetPosition(idd : IDirectSound3DListener; x , y , z : TD3DValue; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetPosition(idd, x, y, z, dwApply);
end;

function IDirectSound3DListener_SetRolloffFactor(idd : IDirectSound3DListener; flRolloffFactor : TD3DValue; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetRolloffFactor(idd, flRolloffFactor, dwApply);
end;

function IDirectSound3DListener_SetVelocity(idd : IDirectSound3DListener; x , y , z : TD3DValue; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetVelocity(idd, x, y, z, dwApply);
end;

function IDirectSound3DListener_CommitDeferredSettings(idd : IDirectSound3DListener) : HResult; stdcall;
begin
	result := idd^^.CommitDeferredSettings(idd);
end;


// IDirectSound3DBuffer interface methods

function IDirectSound3DBuffer_GetAllParameters(idd : IDirectSound3DBuffer; var lpDs3dBuffer : TDS3DBuffer) : HResult; stdcall;
begin
	result := idd^^.GetAllParameters(idd, lpDs3dBuffer);
end;

function IDirectSound3DBuffer_GetConeAngles(idd : IDirectSound3DBuffer; var lpdwInsideConeAngle , lpdwOutsideConeAngle : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetConeAngles(idd, lpdwInsideConeAngle, lpdwOutsideConeAngle);
end;

function IDirectSound3DBuffer_GetConeOrientation(idd : IDirectSound3DBuffer; var lpvOrientation : TD3DVector) : HResult; stdcall;
begin
	result := idd^^.GetConeOrientation(idd, lpvOrientation);
end;

function IDirectSound3DBuffer_GetConeOutsideVolume(idd : IDirectSound3DBuffer; var lplConeOutsideVolume : integer) : HResult; stdcall;
begin
	result := idd^^.GetConeOutsideVolume(idd, lplConeOutsideVolume);
end;

function IDirectSound3DBuffer_GetMaxDistance(idd : IDirectSound3DBuffer; var lpflMaxDistance : TD3DValue) : HResult; stdcall;
begin
	result := idd^^.GetMaxDistance(idd, lpflMaxDistance);
end;

function IDirectSound3DBuffer_GetMinDistance(idd : IDirectSound3DBuffer; var lpflMinDistance : TD3DValue) : HResult; stdcall;
begin
	result := idd^^.GetMinDistance(idd, lpflMinDistance);
end;

function IDirectSound3DBuffer_GetMode(idd : IDirectSound3DBuffer; var lpdwMode : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetMode(idd, lpdwMode);
end;

function IDirectSound3DBuffer_GetPosition(idd : IDirectSound3DBuffer; var lpvPosition : TD3DVector) : HResult; stdcall;
begin
	result := idd^^.GetPosition(idd, lpvPosition);
end;

function IDirectSound3DBuffer_GetVelocity(idd : IDirectSound3DBuffer; var lpvVelocity : TD3DVector) : HResult; stdcall;
begin
	result := idd^^.GetVelocity(idd, lpvVelocity);
end;

function IDirectSound3DBuffer_SetAllParameters(idd : IDirectSound3DBuffer; const lpcDs3dBuffer : TDS3DBuffer; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetAllParameters(idd, lpcDs3dBuffer, dwApply);
end;

function IDirectSound3DBuffer_SetConeAngles(idd : IDirectSound3DBuffer; dwInsideConeAngle , dwOutsideConeAngle , dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetConeAngles(idd, dwInsideConeAngle, dwOutsideConeAngle, dwApply);
end;

function IDirectSound3DBuffer_SetConeOrientation(idd : IDirectSound3DBuffer; x , y , z : TD3DValue; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetConeOrientation(idd, x, y, z, dwApply);
end;

function IDirectSound3DBuffer_SetConeOutsideVolume(idd : IDirectSound3DBuffer; lConeOutsideVolume : LongInt; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetConeOutsideVolume(idd, lConeOutsideVolume, dwApply);
end;

function IDirectSound3DBuffer_SetMaxDistance(idd : IDirectSound3DBuffer; flMaxDistance : TD3DValue; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetMaxDistance(idd, flMaxDistance, dwApply);
end;

function IDirectSound3DBuffer_SetMinDistance(idd : IDirectSound3DBuffer; flMinDistance : TD3DValue; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetMinDistance(idd, flMinDistance, dwApply);
end;

function IDirectSound3DBuffer_SetMode(idd : IDirectSound3DBuffer; dwMode : DWORD; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetMode(idd, dwMode, dwApply);
end;

function IDirectSound3DBuffer_SetPosition(idd : IDirectSound3DBuffer; x , y , z : TD3DValue; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetPosition(idd, x, y, z, dwApply);
end;

function IDirectSound3DBuffer_SetVelocity(idd : IDirectSound3DBuffer; x , y , z : TD3DValue; dwApply : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetVelocity(idd, x, y, z, dwApply);
end;


// IDirectSoundCapture interface methods

function IDirectSoundCapture_CreateCaptureBuffer(idd : IDirectSoundCapture; const lpDSCBufferDesc : TDSCBufferDesc; var lplpDirectSoundCaptureBuffer : IDirectSoundCaptureBuffer; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateCaptureBuffer(idd, lpDSCBufferDesc, lplpDirectSoundCaptureBuffer, pUnkOuter);
end;

function IDirectSoundCapture_GetCaps(idd : IDirectSoundCapture; var lpdwCaps : TDSCCaps) : HResult; stdcall;
begin
	result := idd^^.GetCaps(idd, lpdwCaps);
end;

function IDirectSoundCapture_Initialize(idd : IDirectSoundCapture; lpGuid : PGUID) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpGuid);
end;


// IDirectSoundCaptureBuffer interface methods

function IDirectSoundCaptureBuffer_GetCaps(idd : IDirectSoundCaptureBuffer; var lpdwCaps : TDSCBCaps) : HResult; stdcall;
begin
	result := idd^^.GetCaps(idd, lpdwCaps);
end;

function IDirectSoundCaptureBuffer_GetCurrentPosition(idd : IDirectSoundCaptureBuffer; lpdwCapturePosition , lpdwReadPosition : PDWORD) : HResult; stdcall;
begin
	result := idd^^.GetCurrentPosition(idd, lpdwCapturePosition, lpdwReadPosition);
end;

function IDirectSoundCaptureBuffer_GetFormat(idd : IDirectSoundCaptureBuffer; lpwfxFormat : PWaveFormatEx; dwSizeAllocated : DWORD; lpdwSizeWritten : PDWORD) : HResult; stdcall;
begin
	result := idd^^.GetFormat(idd, lpwfxFormat, dwSizeAllocated, lpdwSizeWritten);
end;

function IDirectSoundCaptureBuffer_GetStatus(idd : IDirectSoundCaptureBuffer; var lpdwStatus : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetStatus(idd, lpdwStatus);
end;

function IDirectSoundCaptureBuffer_Initialize(idd : IDirectSoundCaptureBuffer; lpDirectSoundCapture : IDirectSoundCapture; const lpcDSBufferDesc : TDSCBufferDesc) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpDirectSoundCapture, lpcDSBufferDesc);
end;

function IDirectSoundCaptureBuffer_Lock(idd : IDirectSoundCaptureBuffer; dwReadCursor , dwReadBytes : DWORD; var lplpvAudioPtr1 : Pointer; var lpdwAudioBytes1 : DWORD; var lplpvAudioPtr2 : Pointer; var lpdwAudioBytes2 : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Lock(idd, dwReadCursor, dwReadBytes, lplpvAudioPtr1, lpdwAudioBytes1, lplpvAudioPtr2, lpdwAudioBytes2, dwFlags);
end;

function IDirectSoundCaptureBuffer_Start(idd : IDirectSoundCaptureBuffer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Start(idd, dwFlags);
end;

function IDirectSoundCaptureBuffer_Stop(idd : IDirectSoundCaptureBuffer) : HResult; stdcall;
begin
	result := idd^^.Stop(idd);
end;

function IDirectSoundCaptureBuffer_Unlock(idd : IDirectSoundCaptureBuffer; lpvAudioPtr1 : Pointer; dwAudioBytes1 : DWORD; lpvAudioPtr2 : Pointer; dwAudioBytes2 : DWORD) : HResult; stdcall;
begin
	result := idd^^.Unlock(idd, lpvAudioPtr1, dwAudioBytes1, lpvAudioPtr2, dwAudioBytes2);
end;


// IDirectSoundNotify interface methods

function IDirectSoundNotify_SetNotificationPositions(idd : IDirectSoundNotify; cPositionNotifies : DWORD; const lpcPositionNotifies : TDSBPositionNotify) : HResult; stdcall;
begin
	result := idd^^.SetNotificationPositions(idd, cPositionNotifies, lpcPositionNotifies);
end;


// IKsPropertySet interface methods

function IKsPropertySet_Get(idd : IKsPropertySet; const rguidPropSet : TGUID; ulId : DWORD; var pInstanceData; ulInstanceLength : DWORD; var pPropertyData; ulDataLength : DWORD; var pulBytesReturned : DWORD) : HResult; stdcall;
begin
	result := idd^^.Get(idd, rguidPropSet, ulId, pInstanceData, ulInstanceLength, pPropertyData, ulDataLength, pulBytesReturned);
end;

function IKsPropertySet_SetProperty(idd : IKsPropertySet; const rguidPropSet : TGUID; ulId : DWORD; var pInstanceData; ulInstanceLength : DWORD; var pPropertyData; pulDataLength : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetProperty(idd, rguidPropSet, ulId, pInstanceData, ulInstanceLength, pPropertyData, pulDataLength);
end;

function IKsPropertySet_QuerySupport(idd : IKsPropertySet; const rguidPropSet : TGUID; ulId : DWORD; var pulTypeSupport : DWORD) : HResult; stdcall;
begin
	result := idd^^.QuerySupport(idd, rguidPropSet, ulId, pulTypeSupport);
end;


begin
end.
