unit Direct3DFPC;

{$I SWITCHES.INC}

interface

uses
	windows, DirectDraw, Direct3D, ole2;


// IDirect3D interface methods

function IDirect3D_QueryInterface(idd : IDirect3D; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3D_AddRef(idd : IDirect3D) : Longint; stdcall;
function IDirect3D_Release(idd : IDirect3D) : Longint; stdcall;
function IDirect3D_Initialize(idd : IDirect3D; lpREFIID : {REFIID} PGUID) : HResult; stdcall;
function IDirect3D_EnumDevices(idd : IDirect3D; lpEnumDevicesCallback : TD3DEnumDevicesCallback; lpUserArg : Pointer) : HResult; stdcall;
function IDirect3D_CreateLight(idd : IDirect3D; var lplpDirect3Dlight : IDirect3DLight; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirect3D_CreateMaterial(idd : IDirect3D; var lplpDirect3DMaterial : IDirect3DMaterial; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirect3D_CreateViewport(idd : IDirect3D; var lplpD3DViewport : IDirect3DViewport; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirect3D_FindDevice(idd : IDirect3D; var lpD3DFDS : TD3DFindDeviceSearch; var lpD3DFDR : TD3DFindDeviceResult) : HResult; stdcall;

// IDirect3D2 interface methods

function IDirect3D2_QueryInterface(idd : IDirect3D2; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3D2_AddRef(idd : IDirect3D2) : Longint; stdcall;
function IDirect3D2_Release(idd : IDirect3D2) : Longint; stdcall;
function IDirect3D2_EnumDevices(idd : IDirect3D2; lpEnumDevicesCallback : TD3DEnumDevicesCallback; lpUserArg : pointer) : HResult; stdcall;
function IDirect3D2_CreateLight(idd : IDirect3D2; var lplpDirect3Dlight : IDirect3DLight; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirect3D2_CreateMaterial(idd : IDirect3D2; var lplpDirect3DMaterial2 : IDirect3DMaterial2; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirect3D2_CreateViewport(idd : IDirect3D2; var lplpD3DViewport2 : IDirect3DViewport2; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirect3D2_FindDevice(idd : IDirect3D2; var lpD3DFDS : TD3DFindDeviceSearch; var lpD3DFDR : TD3DFindDeviceResult) : HResult; stdcall;
function IDirect3D2_CreateDevice(idd : IDirect3D2; const rclsid : TRefClsID; lpDDS : IDirectDrawSurface; var lplpD3DDevice2 : IDirect3DDevice2) : HResult; stdcall;

// IDirect3D3 interface methods

function IDirect3D3_QueryInterface(idd : IDirect3D3; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3D3_AddRef(idd : IDirect3D3) : Longint; stdcall;
function IDirect3D3_Release(idd : IDirect3D3) : Longint; stdcall;
function IDirect3D3_EnumDevices(idd : IDirect3D3; lpEnumDevicesCallback : TD3DEnumDevicesCallback; lpUserArg : pointer) : HResult; stdcall;
function IDirect3D3_CreateLight(idd : IDirect3D3; var lplpDirect3Dlight : IDirect3DLight; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirect3D3_CreateMaterial(idd : IDirect3D3; var lplpDirect3DMaterial3 : IDirect3DMaterial3; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirect3D3_CreateViewport(idd : IDirect3D3; var lplpD3DViewport3 : IDirect3DViewport3; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirect3D3_FindDevice(idd : IDirect3D3; var lpD3DFDS : TD3DFindDeviceSearch; var lpD3DFDR : TD3DFindDeviceResult) : HResult; stdcall;
function IDirect3D3_CreateDevice(idd : IDirect3D3; const rclsid : TRefClsID; lpDDS : IDirectDrawSurface4; var lplpD3DDevice : IDirect3DDevice3; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirect3D3_CreateVertexBuffer(idd : IDirect3D3; var lpVBDesc : TD3DVertexBufferDesc; var lpD3DVertexBuffer : IDirect3DVertexBuffer; dwFlags : DWORD; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirect3D3_EnumZBufferFormats(idd : IDirect3D3; const riidDevice : TRefClsID; lpEnumCallback : TD3DEnumPixelFormatsCallback; lpContext : pointer) : HResult; stdcall;
function IDirect3D3_EvictManagedTextures(idd : IDirect3D3) : HResult; stdcall;

// IDirect3D7 interface methods

function IDirect3D7_QueryInterface(idd : IDirect3D7; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3D7_AddRef(idd : IDirect3D7) : Longint; stdcall;
function IDirect3D7_Release(idd : IDirect3D7) : Longint; stdcall;
function IDirect3D7_EnumDevices(idd : IDirect3D7; lpEnumDevicesCallback : TD3DEnumDevicesCallback7; lpUserArg : pointer) : HResult; stdcall;
function IDirect3D7_CreateDevice(idd : IDirect3D7; const rclsid : TGUID; lpDDS : IDirectDrawSurface7; var lplpD3DDevice : IDirect3DDevice7) : HResult; stdcall;
function IDirect3D7_CreateVertexBuffer(idd : IDirect3D7; const lpVBDesc : TD3DVertexBufferDesc; var lplpD3DVertexBuffer : IDirect3DVertexBuffer7; dwFlags : DWORD) : HResult; stdcall;
function IDirect3D7_EnumZBufferFormats(idd : IDirect3D7; const riidDevice : TGUID; lpEnumCallback : TD3DEnumPixelFormatsCallback; lpContext : pointer) : HResult; stdcall;
function IDirect3D7_EvictManagedTextures(idd : IDirect3D7) : HResult; stdcall;

// IDirect3DDevice interface methods

function IDirect3DDevice_QueryInterface(idd : IDirect3DDevice; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DDevice_AddRef(idd : IDirect3DDevice) : Longint; stdcall;
function IDirect3DDevice_Release(idd : IDirect3DDevice) : Longint; stdcall;
function IDirect3DDevice_Initialize(idd : IDirect3DDevice; lpd3d : IDirect3D; lpGUID : PGUID; var lpd3ddvdesc : TD3DDeviceDesc) : HResult; stdcall;
function IDirect3DDevice_GetCaps(idd : IDirect3DDevice; var lpD3DHWDevDesc : TD3DDeviceDesc; var lpD3DHELDevDesc : TD3DDeviceDesc) : HResult; stdcall;
function IDirect3DDevice_SwapTextureHandles(idd : IDirect3DDevice; lpD3DTex1 : IDirect3DTexture; lpD3DTex2 : IDirect3DTexture) : HResult; stdcall;
function IDirect3DDevice_CreateExecuteBuffer(idd : IDirect3DDevice; var lpDesc : TD3DExecuteBufferDesc; var lplpDirect3DExecuteBuffer : IDirect3DExecuteBuffer; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirect3DDevice_GetStats(idd : IDirect3DDevice; var lpD3DStats : TD3DStats) : HResult; stdcall;
function IDirect3DDevice_Execute(idd : IDirect3DDevice; lpDirect3DExecuteBuffer : IDirect3DExecuteBuffer; lpDirect3DViewport : IDirect3DViewport; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice_AddViewport(idd : IDirect3DDevice; lpDirect3DViewport : IDirect3DViewport) : HResult; stdcall;
function IDirect3DDevice_DeleteViewport(idd : IDirect3DDevice; lpDirect3DViewport : IDirect3DViewport) : HResult; stdcall;
function IDirect3DDevice_NextViewport(idd : IDirect3DDevice; lpDirect3DViewport : IDirect3DViewport; var lplpDirect3DViewport : IDirect3DViewport; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice_Pick(idd : IDirect3DDevice; lpDirect3DExecuteBuffer : IDirect3DExecuteBuffer; lpDirect3DViewport : IDirect3DViewport; dwFlags : DWORD; var lpRect : TD3DRect) : HResult; stdcall;
function IDirect3DDevice_GetPickRecords(idd : IDirect3DDevice; var lpCount : DWORD; var lpD3DPickRec : TD3DPickRecord) : HResult; stdcall;
function IDirect3DDevice_EnumTextureFormats(idd : IDirect3DDevice; lpd3dEnumTextureProc : TD3DEnumTextureFormatsCallback; lpArg : Pointer) : HResult; stdcall;
function IDirect3DDevice_CreateMatrix(idd : IDirect3DDevice; var lpD3DMatHandle : TD3DMatrixHandle) : HResult; stdcall;
function IDirect3DDevice_SetMatrix(idd : IDirect3DDevice; d3dMatHandle : TD3DMatrixHandle; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
function IDirect3DDevice_GetMatrix(idd : IDirect3DDevice; var lpD3DMatHandle : TD3DMatrixHandle; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
function IDirect3DDevice_DeleteMatrix(idd : IDirect3DDevice; d3dMatHandle : TD3DMatrixHandle) : HResult; stdcall;
function IDirect3DDevice_BeginScene(idd : IDirect3DDevice) : HResult; stdcall;
function IDirect3DDevice_EndScene(idd : IDirect3DDevice) : HResult; stdcall;
function IDirect3DDevice_GetDirect3D(idd : IDirect3DDevice; var lpD3D : IDirect3D) : HResult; stdcall;

// IDirect3DDevice2 interface methods

function IDirect3DDevice2_QueryInterface(idd : IDirect3DDevice2; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DDevice2_AddRef(idd : IDirect3DDevice2) : Longint; stdcall;
function IDirect3DDevice2_Release(idd : IDirect3DDevice2) : Longint; stdcall;
function IDirect3DDevice2_GetCaps(idd : IDirect3DDevice2; var lpD3DHWDevDesc : TD3DDeviceDesc; var lpD3DHELDevDesc : TD3DDeviceDesc) : HResult; stdcall;
function IDirect3DDevice2_SwapTextureHandles(idd : IDirect3DDevice2; lpD3DTex1 : IDirect3DTexture2; lpD3DTex2 : IDirect3DTexture2) : HResult; stdcall;
function IDirect3DDevice2_GetStats(idd : IDirect3DDevice2; var lpD3DStats : TD3DStats) : HResult; stdcall;
function IDirect3DDevice2_AddViewport(idd : IDirect3DDevice2; lpDirect3DViewport2 : IDirect3DViewport2) : HResult; stdcall;
function IDirect3DDevice2_DeleteViewport(idd : IDirect3DDevice2; lpDirect3DViewport : IDirect3DViewport2) : HResult; stdcall;
function IDirect3DDevice2_NextViewport(idd : IDirect3DDevice2; lpDirect3DViewport : IDirect3DViewport2; var lplpDirect3DViewport : IDirect3DViewport2; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice2_EnumTextureFormats(idd : IDirect3DDevice2; lpd3dEnumTextureProc : TD3DEnumTextureFormatsCallback; lpArg : Pointer) : HResult; stdcall;
function IDirect3DDevice2_BeginScene(idd : IDirect3DDevice2) : HResult; stdcall;
function IDirect3DDevice2_EndScene(idd : IDirect3DDevice2) : HResult; stdcall;
function IDirect3DDevice2_GetDirect3D(idd : IDirect3DDevice2; var lpD3D : IDirect3D2) : HResult; stdcall;
function IDirect3DDevice2_SetCurrentViewport(idd : IDirect3DDevice2; lpd3dViewport2 : IDirect3DViewport2) : HResult; stdcall;
function IDirect3DDevice2_GetCurrentViewport(idd : IDirect3DDevice2; var lplpd3dViewport2 : IDirect3DViewport2) : HResult; stdcall;
function IDirect3DDevice2_SetRenderTarget(idd : IDirect3DDevice2; lpNewRenderTarget : IDirectDrawSurface) : HResult; stdcall;
function IDirect3DDevice2_GetRenderTarget(idd : IDirect3DDevice2; var lplpNewRenderTarget : IDirectDrawSurface) : HResult; stdcall;
function IDirect3DDevice2_Begin_(idd : IDirect3DDevice2; d3dpt : TD3DPrimitiveType; d3dvt : TD3DVertexType; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice2_BeginIndexed(idd : IDirect3DDevice2; dptPrimitiveType : TD3DPrimitiveType; dvtVertexType : TD3DVertexType; lpvVertices : pointer; dwNumVertices : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice2_Vertex(idd : IDirect3DDevice2; lpVertexType : pointer) : HResult; stdcall;
function IDirect3DDevice2_Index(idd : IDirect3DDevice2; wVertexIndex : WORD) : HResult; stdcall;
function IDirect3DDevice2_End_(idd : IDirect3DDevice2; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice2_GetRenderState(idd : IDirect3DDevice2; dwRenderStateType : TD3DRenderStateType; var lpdwRenderState) : HResult; stdcall;
function IDirect3DDevice2_SetRenderState(idd : IDirect3DDevice2; dwRenderStateType : TD3DRenderStateType; dwRenderState : DWORD) : HResult; stdcall;
function IDirect3DDevice2_GetLightState(idd : IDirect3DDevice2; dwLightStateType : TD3DLightStateType; var lpdwLightState) : HResult; stdcall;
function IDirect3DDevice2_SetLightState(idd : IDirect3DDevice2; dwLightStateType : TD3DLightStateType; dwLightState : DWORD) : HResult; stdcall;
function IDirect3DDevice2_SetTransform(idd : IDirect3DDevice2; dtstTransformStateType : TD3DTransformStateType; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
function IDirect3DDevice2_GetTransform(idd : IDirect3DDevice2; dtstTransformStateType : TD3DTransformStateType; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
function IDirect3DDevice2_MultiplyTransform(idd : IDirect3DDevice2; dtstTransformStateType : TD3DTransformStateType; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
function IDirect3DDevice2_DrawPrimitive(idd : IDirect3DDevice2; dptPrimitiveType : TD3DPrimitiveType; dvtVertexType : TD3DVertexType; var lpvVertices; dwVertexCount , dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice2_DrawIndexedPrimitive(idd : IDirect3DDevice2; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; lpvVertices : pointer; dwVertexCount : DWORD; var lpwIndices : WORD; dwIndexCount , dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice2_SetClipStatus(idd : IDirect3DDevice2; var lpD3DClipStatus : TD3DClipStatus) : HResult; stdcall;
function IDirect3DDevice2_GetClipStatus(idd : IDirect3DDevice2; var lpD3DClipStatus : TD3DClipStatus) : HResult; stdcall;

// IDirect3DDevice3 interface methods

function IDirect3DDevice3_QueryInterface(idd : IDirect3DDevice3; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DDevice3_AddRef(idd : IDirect3DDevice3) : Longint; stdcall;
function IDirect3DDevice3_Release(idd : IDirect3DDevice3) : Longint; stdcall;
function IDirect3DDevice3_GetCaps(idd : IDirect3DDevice3; var lpD3DHWDevDesc : TD3DDeviceDesc; var lpD3DHELDevDesc : TD3DDeviceDesc) : HResult; stdcall;
function IDirect3DDevice3_GetStats(idd : IDirect3DDevice3; var lpD3DStats : TD3DStats) : HResult; stdcall;
function IDirect3DDevice3_AddViewport(idd : IDirect3DDevice3; lpDirect3DViewport : IDirect3DViewport3) : HResult; stdcall;
function IDirect3DDevice3_DeleteViewport(idd : IDirect3DDevice3; lpDirect3DViewport : IDirect3DViewport3) : HResult; stdcall;
function IDirect3DDevice3_NextViewport(idd : IDirect3DDevice3; lpDirect3DViewport : IDirect3DViewport3; var lplpAnotherViewport : IDirect3DViewport3; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice3_EnumTextureFormats(idd : IDirect3DDevice3; lpd3dEnumPixelProc : TD3DEnumPixelFormatsCallback; lpArg : Pointer) : HResult; stdcall;
function IDirect3DDevice3_BeginScene(idd : IDirect3DDevice3) : HResult; stdcall;
function IDirect3DDevice3_EndScene(idd : IDirect3DDevice3) : HResult; stdcall;
function IDirect3DDevice3_GetDirect3D(idd : IDirect3DDevice3; var lpD3D : IDirect3D3) : HResult; stdcall;
function IDirect3DDevice3_SetCurrentViewport(idd : IDirect3DDevice3; lpd3dViewport : IDirect3DViewport3) : HResult; stdcall;
function IDirect3DDevice3_GetCurrentViewport(idd : IDirect3DDevice3; var lplpd3dViewport : IDirect3DViewport3) : HResult; stdcall;
function IDirect3DDevice3_SetRenderTarget(idd : IDirect3DDevice3; lpNewRenderTarget : IDirectDrawSurface4) : HResult; stdcall;
function IDirect3DDevice3_GetRenderTarget(idd : IDirect3DDevice3; var lplpNewRenderTarget : IDirectDrawSurface4) : HResult; stdcall;
function IDirect3DDevice3_Begin_(idd : IDirect3DDevice3; d3dpt : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice3_BeginIndexed(idd : IDirect3DDevice3; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; lpvVertices : pointer; dwNumVertices : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice3_Vertex(idd : IDirect3DDevice3; lpVertex : pointer) : HResult; stdcall;
function IDirect3DDevice3_Index(idd : IDirect3DDevice3; wVertexIndex : WORD) : HResult; stdcall;
function IDirect3DDevice3_End_(idd : IDirect3DDevice3; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice3_GetRenderState(idd : IDirect3DDevice3; dwRenderStateType : TD3DRenderStateType; var lpdwRenderState) : HResult; stdcall;
function IDirect3DDevice3_SetRenderState(idd : IDirect3DDevice3; dwRenderStateType : TD3DRenderStateType; dwRenderState : DWORD) : HResult; stdcall;
function IDirect3DDevice3_GetLightState(idd : IDirect3DDevice3; dwLightStateType : TD3DLightStateType; var lpdwLightState) : HResult; stdcall;
function IDirect3DDevice3_SetLightState(idd : IDirect3DDevice3; dwLightStateType : TD3DLightStateType; dwLightState : DWORD) : HResult; stdcall;
function IDirect3DDevice3_SetTransform(idd : IDirect3DDevice3; dtstTransformStateType : TD3DTransformStateType; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
function IDirect3DDevice3_GetTransform(idd : IDirect3DDevice3; dtstTransformStateType : TD3DTransformStateType; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
function IDirect3DDevice3_MultiplyTransform(idd : IDirect3DDevice3; dtstTransformStateType : TD3DTransformStateType; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
function IDirect3DDevice3_DrawPrimitive(idd : IDirect3DDevice3; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; const lpvVertices; dwVertexCount , dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice3_DrawIndexedPrimitive(idd : IDirect3DDevice3; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; const lpvVertices; dwVertexCount : DWORD; var lpwIndices : WORD; dwIndexCount , dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice3_SetClipStatus(idd : IDirect3DDevice3; var lpD3DClipStatus : TD3DClipStatus) : HResult; stdcall;
function IDirect3DDevice3_GetClipStatus(idd : IDirect3DDevice3; var lpD3DClipStatus : TD3DClipStatus) : HResult; stdcall;
function IDirect3DDevice3_DrawPrimitiveStrided(idd : IDirect3DDevice3; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; var lpVertexArray : TD3DDrawPrimitiveStridedData; dwVertexCount , dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice3_DrawIndexedPrimitiveStrided(idd : IDirect3DDevice3; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; var lpVertexArray : TD3DDrawPrimitiveStridedData; dwVertexCount : DWORD; var lpwIndices : WORD; dwIndexCount , dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice3_DrawPrimitiveVB(idd : IDirect3DDevice3; dptPrimitiveType : TD3DPrimitiveType; lpd3dVertexBuffer : IDirect3DVertexBuffer; dwStartVertex , dwNumVertices , dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice3_DrawIndexedPrimitiveVB(idd : IDirect3DDevice3; dptPrimitiveType : TD3DPrimitiveType; lpd3dVertexBuffer : IDirect3DVertexBuffer; var lpwIndices : WORD; dwIndexCount , dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice3_ComputeSphereVisibility(idd : IDirect3DDevice3; var lpCenters : TD3DVector; var lpRadii : TD3DValue; dwNumSpheres , dwFlags : DWORD; var lpdwReturnValues : DWORD) : HResult; stdcall;
function IDirect3DDevice3_GetTexture(idd : IDirect3DDevice3; dwStage : DWORD; var lplpTexture : IDirect3DTexture2) : HResult; stdcall;
function IDirect3DDevice3_SetTexture(idd : IDirect3DDevice3; dwStage : DWORD; lplpTexture : IDirect3DTexture2) : HResult; stdcall;
function IDirect3DDevice3_GetTextureStageState(idd : IDirect3DDevice3; dwStage : DWORD; dwState : TD3DTextureStageStateType; var lpdwValue : DWORD) : HResult; stdcall;
function IDirect3DDevice3_SetTextureStageState(idd : IDirect3DDevice3; dwStage : DWORD; dwState : TD3DTextureStageStateType; lpdwValue : DWORD) : HResult; stdcall;
function IDirect3DDevice3_ValidateDevice(idd : IDirect3DDevice3; var lpdwExtraPasses : DWORD) : HResult; stdcall;

// IDirect3DDevice7 interface methods

function IDirect3DDevice7_QueryInterface(idd : IDirect3DDevice7; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DDevice7_AddRef(idd : IDirect3DDevice7) : Longint; stdcall;
function IDirect3DDevice7_Release(idd : IDirect3DDevice7) : Longint; stdcall;
function IDirect3DDevice7_GetCaps(idd : IDirect3DDevice7; var lpD3DDevDesc : TD3DDeviceDesc7) : HResult; stdcall;
function IDirect3DDevice7_EnumTextureFormats(idd : IDirect3DDevice7; lpd3dEnumPixelProc : TD3DEnumPixelFormatsCallback; lpArg : Pointer) : HResult; stdcall;
function IDirect3DDevice7_BeginScene(idd : IDirect3DDevice7) : HResult; stdcall;
function IDirect3DDevice7_EndScene(idd : IDirect3DDevice7) : HResult; stdcall;
function IDirect3DDevice7_GetDirect3D(idd : IDirect3DDevice7; var lpD3D : IDirect3D7) : HResult; stdcall;
function IDirect3DDevice7_SetRenderTarget(idd : IDirect3DDevice7; lpNewRenderTarget : IDirectDrawSurface7; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice7_GetRenderTarget(idd : IDirect3DDevice7; var lplpRenderTarget : IDirectDrawSurface7) : HResult; stdcall;
function IDirect3DDevice7_Clear(idd : IDirect3DDevice7; dwCount : DWORD; lpRects : PD3DRect; dwFlags , dwColor : DWORD; dvZ : TD3DValue; dwStencil : DWORD) : HResult; stdcall;
function IDirect3DDevice7_SetTransform(idd : IDirect3DDevice7; dtstTransformStateType : TD3DTransformStateType; const lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
function IDirect3DDevice7_GetTransform(idd : IDirect3DDevice7; dtstTransformStateType : TD3DTransformStateType; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
function IDirect3DDevice7_SetViewport(idd : IDirect3DDevice7; const lpViewport : TD3DViewport7) : HResult; stdcall;
function IDirect3DDevice7_MultiplyTransform(idd : IDirect3DDevice7; dtstTransformStateType : TD3DTransformStateType; const lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
function IDirect3DDevice7_GetViewport(idd : IDirect3DDevice7; var lpViewport : TD3DViewport7) : HResult; stdcall;
function IDirect3DDevice7_SetMaterial(idd : IDirect3DDevice7; const lpMaterial : TD3DMaterial7) : HResult; stdcall;
function IDirect3DDevice7_GetMaterial(idd : IDirect3DDevice7; var lpMaterial : TD3DMaterial7) : HResult; stdcall;
function IDirect3DDevice7_SetLight(idd : IDirect3DDevice7; dwLightIndex : DWORD; const lpLight : TD3DLight7) : HResult; stdcall;
function IDirect3DDevice7_GetLight(idd : IDirect3DDevice7; dwLightIndex : DWORD; var lpLight : TD3DLight7) : HResult; stdcall;
function IDirect3DDevice7_SetRenderState(idd : IDirect3DDevice7; dwRenderStateType : TD3DRenderStateType; dwRenderState : DWORD) : HResult; stdcall;
function IDirect3DDevice7_GetRenderState(idd : IDirect3DDevice7; dwRenderStateType : TD3DRenderStateType; var dwRenderState : DWORD) : HResult; stdcall;
function IDirect3DDevice7_BeginStateBlock(idd : IDirect3DDevice7) : HResult; stdcall;
function IDirect3DDevice7_EndStateBlock(idd : IDirect3DDevice7; var lpdwBlockHandle : DWORD) : HResult; stdcall;
function IDirect3DDevice7_PreLoad(idd : IDirect3DDevice7; lpddsTexture : IDirectDrawSurface7) : HResult; stdcall;
function IDirect3DDevice7_DrawPrimitive(idd : IDirect3DDevice7; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; const lpvVertices; dwVertexCount , dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice7_DrawIndexedPrimitive(idd : IDirect3DDevice7; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; const lpvVertices; dwVertexCount : DWORD; const lpwIndices; dwIndexCount , dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice7_SetClipStatus(idd : IDirect3DDevice7; const lpD3DClipStatus : TD3DClipStatus) : HResult; stdcall;
function IDirect3DDevice7_GetClipStatus(idd : IDirect3DDevice7; var lpD3DClipStatus : TD3DClipStatus) : HResult; stdcall;
function IDirect3DDevice7_DrawPrimitiveStrided(idd : IDirect3DDevice7; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; const lpVertexArray : TD3DDrawPrimitiveStridedData; dwVertexCount , dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice7_DrawIndexedPrimitiveStrided(idd : IDirect3DDevice7; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; const lpVertexArray : TD3DDrawPrimitiveStridedData; dwVertexCount : DWORD; var lpwIndices : WORD; dwIndexCount , dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice7_DrawPrimitiveVB(idd : IDirect3DDevice7; dptPrimitiveType : TD3DPrimitiveType; lpd3dVertexBuffer : IDirect3DVertexBuffer7; dwStartVertex , dwNumVertices , dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice7_DrawIndexedPrimitiveVB(idd : IDirect3DDevice7; dptPrimitiveType : TD3DPrimitiveType; lpd3dVertexBuffer : IDirect3DVertexBuffer7; dwStartVertex , dwNumVertices : DWORD; var lpwIndices : WORD; dwIndexCount , dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice7_ComputeSphereVisibility(idd : IDirect3DDevice7; const lpCenters : TD3DVector; var lpRadii : TD3DValue; dwNumSpheres , dwFlags : DWORD; var lpdwReturnValues : DWORD) : HResult; stdcall;
function IDirect3DDevice7_GetTexture(idd : IDirect3DDevice7; dwStage : DWORD; var lplpTexture : IDirectDrawSurface7) : HResult; stdcall;
function IDirect3DDevice7_SetTexture(idd : IDirect3DDevice7; dwStage : DWORD; lpTexture : IDirectDrawSurface7) : HResult; stdcall;
function IDirect3DDevice7_GetTextureStageState(idd : IDirect3DDevice7; dwStage : DWORD; dwState : TD3DTextureStageStateType; var lpdwValue : DWORD) : HResult; stdcall;
function IDirect3DDevice7_SetTextureStageState(idd : IDirect3DDevice7; dwStage : DWORD; dwState : TD3DTextureStageStateType; lpdwValue : DWORD) : HResult; stdcall;
function IDirect3DDevice7_ValidateDevice(idd : IDirect3DDevice7; var lpdwExtraPasses : DWORD) : HResult; stdcall;
function IDirect3DDevice7_ApplyStateBlock(idd : IDirect3DDevice7; dwBlockHandle : DWORD) : HResult; stdcall;
function IDirect3DDevice7_CaptureStateBlock(idd : IDirect3DDevice7; dwBlockHandle : DWORD) : HResult; stdcall;
function IDirect3DDevice7_DeleteStateBlock(idd : IDirect3DDevice7; dwBlockHandle : DWORD) : HResult; stdcall;
function IDirect3DDevice7_CreateStateBlock(idd : IDirect3DDevice7; d3dsbType : TD3DStateBlockType; var lpdwBlockHandle : DWORD) : HResult; stdcall;
function IDirect3DDevice7_Load(idd : IDirect3DDevice7; lpDestTex : IDirectDrawSurface7; lpDestPoint : PPoint; lpSrcTex : IDirectDrawSurface7; lprcSrcRect : PRect; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DDevice7_LightEnable(idd : IDirect3DDevice7; dwLightIndex : DWORD; bEnable : BOOL) : HResult; stdcall;
function IDirect3DDevice7_GetLightEnable(idd : IDirect3DDevice7; dwLightIndex : DWORD; var bEnable : BOOL) : HResult; stdcall;
function IDirect3DDevice7_SetClipPlane(idd : IDirect3DDevice7; dwIndex : DWORD; var pPlaneEquation : TD3DValue) : HResult; stdcall;
function IDirect3DDevice7_GetClipPlane(idd : IDirect3DDevice7; dwIndex : DWORD; var pPlaneEquation : TD3DValue) : HResult; stdcall;
function IDirect3DDevice7_GetInfo(idd : IDirect3DDevice7; dwDevInfoID : DWORD; pDevInfoStruct : Pointer; dwSize : DWORD) : HResult; stdcall;

// IDirect3DExecuteBuffer interface methods

function IDirect3DExecuteBuffer_QueryInterface(idd : IDirect3DExecuteBuffer; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DExecuteBuffer_AddRef(idd : IDirect3DExecuteBuffer) : Longint; stdcall;
function IDirect3DExecuteBuffer_Release(idd : IDirect3DExecuteBuffer) : Longint; stdcall;
function IDirect3DExecuteBuffer_Initialize(idd : IDirect3DExecuteBuffer; lpDirect3DDevice : IDirect3DDevice; var lpDesc : TD3DExecuteBufferDesc) : HResult; stdcall;
function IDirect3DExecuteBuffer_Lock(idd : IDirect3DExecuteBuffer; var lpDesc : TD3DExecuteBufferDesc) : HResult; stdcall;
function IDirect3DExecuteBuffer_Unlock(idd : IDirect3DExecuteBuffer) : HResult; stdcall;
function IDirect3DExecuteBuffer_SetExecuteData(idd : IDirect3DExecuteBuffer; var lpData : TD3DExecuteData) : HResult; stdcall;
function IDirect3DExecuteBuffer_GetExecuteData(idd : IDirect3DExecuteBuffer; var lpData : TD3DExecuteData) : HResult; stdcall;
function IDirect3DExecuteBuffer_Validate(idd : IDirect3DExecuteBuffer; var lpdwOffset : DWORD; lpFunc : TD3DValidateCallback; lpUserArg : Pointer; dwReserved : DWORD) : HResult; stdcall;
function IDirect3DExecuteBuffer_Optimize(idd : IDirect3DExecuteBuffer; dwFlags : DWORD) : HResult; stdcall;

// IDirect3DLight interface methods

function IDirect3DLight_QueryInterface(idd : IDirect3DLight; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DLight_AddRef(idd : IDirect3DLight) : Longint; stdcall;
function IDirect3DLight_Release(idd : IDirect3DLight) : Longint; stdcall;
function IDirect3DLight_Initialize(idd : IDirect3DLight; lpDirect3D : IDirect3D) : HResult; stdcall;
function IDirect3DLight_SetLight(idd : IDirect3DLight; var lpLight : TD3DLight2) : HResult; stdcall;
function IDirect3DLight_GetLight(idd : IDirect3DLight; var lpLight : TD3DLight2) : HResult; stdcall;

// IDirect3DMaterial interface methods

function IDirect3DMaterial_QueryInterface(idd : IDirect3DMaterial; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DMaterial_AddRef(idd : IDirect3DMaterial) : Longint; stdcall;
function IDirect3DMaterial_Release(idd : IDirect3DMaterial) : Longint; stdcall;
function IDirect3DMaterial_Initialize(idd : IDirect3DMaterial; lpDirect3D : IDirect3D) : HResult; stdcall;
function IDirect3DMaterial_SetMaterial(idd : IDirect3DMaterial; var lpMat : TD3DMaterial) : HResult; stdcall;
function IDirect3DMaterial_GetMaterial(idd : IDirect3DMaterial; var lpMat : TD3DMaterial) : HResult; stdcall;
function IDirect3DMaterial_GetHandle(idd : IDirect3DMaterial; lpDirect3DDevice : IDirect3DDevice; var lpHandle : TD3DMaterialHandle) : HResult; stdcall;
function IDirect3DMaterial_Reserve(idd : IDirect3DMaterial) : HResult; stdcall;
function IDirect3DMaterial_Unreserve(idd : IDirect3DMaterial) : HResult; stdcall;

// IDirect3DMaterial2 interface methods

function IDirect3DMaterial2_QueryInterface(idd : IDirect3DMaterial2; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DMaterial2_AddRef(idd : IDirect3DMaterial2) : Longint; stdcall;
function IDirect3DMaterial2_Release(idd : IDirect3DMaterial2) : Longint; stdcall;
function IDirect3DMaterial2_SetMaterial(idd : IDirect3DMaterial2; var lpMat : TD3DMaterial) : HResult; stdcall;
function IDirect3DMaterial2_GetMaterial(idd : IDirect3DMaterial2; var lpMat : TD3DMaterial) : HResult; stdcall;
function IDirect3DMaterial2_GetHandle(idd : IDirect3DMaterial2; lpDirect3DDevice : IDirect3DDevice2; var lpHandle : TD3DMaterialHandle) : HResult; stdcall;

// IDirect3DMaterial3 interface methods

function IDirect3DMaterial3_QueryInterface(idd : IDirect3DMaterial3; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DMaterial3_AddRef(idd : IDirect3DMaterial3) : Longint; stdcall;
function IDirect3DMaterial3_Release(idd : IDirect3DMaterial3) : Longint; stdcall;
function IDirect3DMaterial3_SetMaterial(idd : IDirect3DMaterial3; var lpMat : TD3DMaterial) : HResult; stdcall;
function IDirect3DMaterial3_GetMaterial(idd : IDirect3DMaterial3; var lpMat : TD3DMaterial) : HResult; stdcall;
function IDirect3DMaterial3_GetHandle(idd : IDirect3DMaterial3; lpDirect3DDevice : IDirect3DDevice3; var lpHandle : TD3DMaterialHandle) : HResult; stdcall;

// IDirect3DTexture interface methods

function IDirect3DTexture_QueryInterface(idd : IDirect3DTexture; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DTexture_AddRef(idd : IDirect3DTexture) : Longint; stdcall;
function IDirect3DTexture_Release(idd : IDirect3DTexture) : Longint; stdcall;
function IDirect3DTexture_Initialize(idd : IDirect3DTexture; lpD3DDevice : IDirect3DDevice; lpDDSurface : IDirectDrawSurface) : HResult; stdcall;
function IDirect3DTexture_GetHandle(idd : IDirect3DTexture; lpDirect3DDevice : IDirect3DDevice; var lpHandle : TD3DTextureHandle) : HResult; stdcall;
function IDirect3DTexture_PaletteChanged(idd : IDirect3DTexture; dwStart : DWORD; dwCount : DWORD) : HResult; stdcall;
function IDirect3DTexture_Load(idd : IDirect3DTexture; lpD3DTexture : IDirect3DTexture) : HResult; stdcall;
function IDirect3DTexture_Unload(idd : IDirect3DTexture) : HResult; stdcall;

// IDirect3DTexture2 interface methods

function IDirect3DTexture2_QueryInterface(idd : IDirect3DTexture2; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DTexture2_AddRef(idd : IDirect3DTexture2) : Longint; stdcall;
function IDirect3DTexture2_Release(idd : IDirect3DTexture2) : Longint; stdcall;
function IDirect3DTexture2_GetHandle(idd : IDirect3DTexture2; lpDirect3DDevice : IDirect3DDevice2; var lpHandle : TD3DTextureHandle) : HResult; stdcall;
function IDirect3DTexture2_PaletteChanged(idd : IDirect3DTexture2; dwStart : DWORD; dwCount : DWORD) : HResult; stdcall;
function IDirect3DTexture2_Load(idd : IDirect3DTexture2; lpD3DTexture : IDirect3DTexture2) : HResult; stdcall;

// IDirect3DViewport interface methods

function IDirect3DViewport_QueryInterface(idd : IDirect3DViewport; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DViewport_AddRef(idd : IDirect3DViewport) : Longint; stdcall;
function IDirect3DViewport_Release(idd : IDirect3DViewport) : Longint; stdcall;
function IDirect3DViewport_Initialize(idd : IDirect3DViewport; lpDirect3D : IDirect3D) : HResult; stdcall;
function IDirect3DViewport_GetViewport(idd : IDirect3DViewport; var lpData : TD3DViewport) : HResult; stdcall;
function IDirect3DViewport_SetViewport(idd : IDirect3DViewport; const lpData : TD3DViewport) : HResult; stdcall;
function IDirect3DViewport_TransformVertices(idd : IDirect3DViewport; dwVertexCount : DWORD; const lpData : TD3DTransformData; dwFlags : DWORD; var lpOffscreen : DWORD) : HResult; stdcall;
function IDirect3DViewport_LightElements(idd : IDirect3DViewport; dwElementCount : DWORD; var lpData : TD3DLightData) : HResult; stdcall;
function IDirect3DViewport_SetBackground(idd : IDirect3DViewport; hMat : TD3DMaterialHandle) : HResult; stdcall;
function IDirect3DViewport_GetBackground(idd : IDirect3DViewport; var hMat : TD3DMaterialHandle) : HResult; stdcall;
function IDirect3DViewport_SetBackgroundDepth(idd : IDirect3DViewport; lpDDSurface : IDirectDrawSurface) : HResult; stdcall;
function IDirect3DViewport_GetBackgroundDepth(idd : IDirect3DViewport; var lplpDDSurface : IDirectDrawSurface; var lpValid : BOOL) : HResult; stdcall;
function IDirect3DViewport_Clear(idd : IDirect3DViewport; dwCount : DWORD; const lpRects : TD3DRect; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DViewport_AddLight(idd : IDirect3DViewport; lpDirect3DLight : IDirect3DLight) : HResult; stdcall;
function IDirect3DViewport_DeleteLight(idd : IDirect3DViewport; lpDirect3DLight : IDirect3DLight) : HResult; stdcall;
function IDirect3DViewport_NextLight(idd : IDirect3DViewport; lpDirect3DLight : IDirect3DLight; var lplpDirect3DLight : IDirect3DLight; dwFlags : DWORD) : HResult; stdcall;

// IDirect3DViewport2 interface methods

function IDirect3DViewport2_QueryInterface(idd : IDirect3DViewport2; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DViewport2_AddRef(idd : IDirect3DViewport2) : Longint; stdcall;
function IDirect3DViewport2_Release(idd : IDirect3DViewport2) : Longint; stdcall;
function IDirect3DViewport2_Initialize(idd : IDirect3DViewport2; lpDirect3D : IDirect3D) : HResult; stdcall;
function IDirect3DViewport2_GetViewport(idd : IDirect3DViewport2; var lpData : TD3DViewport) : HResult; stdcall;
function IDirect3DViewport2_SetViewport(idd : IDirect3DViewport2; const lpData : TD3DViewport) : HResult; stdcall;
function IDirect3DViewport2_TransformVertices(idd : IDirect3DViewport2; dwVertexCount : DWORD; const lpData : TD3DTransformData; dwFlags : DWORD; var lpOffscreen : DWORD) : HResult; stdcall;
function IDirect3DViewport2_LightElements(idd : IDirect3DViewport2; dwElementCount : DWORD; var lpData : TD3DLightData) : HResult; stdcall;
function IDirect3DViewport2_SetBackground(idd : IDirect3DViewport2; hMat : TD3DMaterialHandle) : HResult; stdcall;
function IDirect3DViewport2_GetBackground(idd : IDirect3DViewport2; var hMat : TD3DMaterialHandle) : HResult; stdcall;
function IDirect3DViewport2_SetBackgroundDepth(idd : IDirect3DViewport2; lpDDSurface : IDirectDrawSurface) : HResult; stdcall;
function IDirect3DViewport2_GetBackgroundDepth(idd : IDirect3DViewport2; var lplpDDSurface : IDirectDrawSurface; var lpValid : BOOL) : HResult; stdcall;
function IDirect3DViewport2_Clear(idd : IDirect3DViewport2; dwCount : DWORD; const lpRects : TD3DRect; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DViewport2_AddLight(idd : IDirect3DViewport2; lpDirect3DLight : IDirect3DLight) : HResult; stdcall;
function IDirect3DViewport2_DeleteLight(idd : IDirect3DViewport2; lpDirect3DLight : IDirect3DLight) : HResult; stdcall;
function IDirect3DViewport2_NextLight(idd : IDirect3DViewport2; lpDirect3DLight : IDirect3DLight; var lplpDirect3DLight : IDirect3DLight; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DViewport2_GetViewport2(idd : IDirect3DViewport2; var lpData : TD3DViewport2) : HResult; stdcall;
function IDirect3DViewport2_SetViewport2(idd : IDirect3DViewport2; const lpData : TD3DViewport2) : HResult; stdcall;

// IDirect3DViewport3 interface methods

function IDirect3DViewport3_QueryInterface(idd : IDirect3DViewport3; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DViewport3_AddRef(idd : IDirect3DViewport3) : Longint; stdcall;
function IDirect3DViewport3_Release(idd : IDirect3DViewport3) : Longint; stdcall;
function IDirect3DViewport3_Initialize(idd : IDirect3DViewport3; lpDirect3D : IDirect3D) : HResult; stdcall;
function IDirect3DViewport3_GetViewport(idd : IDirect3DViewport3; var lpData : TD3DViewport) : HResult; stdcall;
function IDirect3DViewport3_SetViewport(idd : IDirect3DViewport3; const lpData : TD3DViewport) : HResult; stdcall;
function IDirect3DViewport3_TransformVertices(idd : IDirect3DViewport3; dwVertexCount : DWORD; const lpData : TD3DTransformData; dwFlags : DWORD; var lpOffscreen : DWORD) : HResult; stdcall;
function IDirect3DViewport3_LightElements(idd : IDirect3DViewport3; dwElementCount : DWORD; var lpData : TD3DLightData) : HResult; stdcall;
function IDirect3DViewport3_SetBackground(idd : IDirect3DViewport3; hMat : TD3DMaterialHandle) : HResult; stdcall;
function IDirect3DViewport3_GetBackground(idd : IDirect3DViewport3; var hMat : TD3DMaterialHandle) : HResult; stdcall;
function IDirect3DViewport3_SetBackgroundDepth(idd : IDirect3DViewport3; lpDDSurface : IDirectDrawSurface) : HResult; stdcall;
function IDirect3DViewport3_GetBackgroundDepth(idd : IDirect3DViewport3; var lplpDDSurface : IDirectDrawSurface; var lpValid : BOOL) : HResult; stdcall;
function IDirect3DViewport3_Clear(idd : IDirect3DViewport3; dwCount : DWORD; const lpRects : TD3DRect; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DViewport3_AddLight(idd : IDirect3DViewport3; lpDirect3DLight : IDirect3DLight) : HResult; stdcall;
function IDirect3DViewport3_DeleteLight(idd : IDirect3DViewport3; lpDirect3DLight : IDirect3DLight) : HResult; stdcall;
function IDirect3DViewport3_NextLight(idd : IDirect3DViewport3; lpDirect3DLight : IDirect3DLight; var lplpDirect3DLight : IDirect3DLight; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DViewport3_GetViewport2(idd : IDirect3DViewport3; var lpData : TD3DViewport2) : HResult; stdcall;
function IDirect3DViewport3_SetViewport2(idd : IDirect3DViewport3; const lpData : TD3DViewport2) : HResult; stdcall;
function IDirect3DViewport3_SetBackgroundDepth2(idd : IDirect3DViewport3; lpDDSurface : IDirectDrawSurface4) : HResult; stdcall;
function IDirect3DViewport3_GetBackgroundDepth2(idd : IDirect3DViewport3; var lplpDDSurface : IDirectDrawSurface4; var lpValid : BOOL) : HResult; stdcall;
function IDirect3DViewport3_Clear2(idd : IDirect3DViewport3; dwCount : DWORD; const lpRects : TD3DRect; dwFlags : DWORD; dwColor : DWORD; dvZ : TD3DValue; dwStencil : DWORD) : HResult; stdcall;

// IDirect3DVertexBuffer interface methods

function IDirect3DVertexBuffer_QueryInterface(idd : IDirect3DVertexBuffer; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DVertexBuffer_AddRef(idd : IDirect3DVertexBuffer) : Longint; stdcall;
function IDirect3DVertexBuffer_Release(idd : IDirect3DVertexBuffer) : Longint; stdcall;
function IDirect3DVertexBuffer_Lock(idd : IDirect3DVertexBuffer; dwFlags : DWORD; var lplpData : pointer; var lpdwSize : DWORD) : HResult; stdcall;
function IDirect3DVertexBuffer_Unlock(idd : IDirect3DVertexBuffer) : HResult; stdcall;
function IDirect3DVertexBuffer_ProcessVertices(idd : IDirect3DVertexBuffer; dwVertexOp , dwDestIndex , dwCount : DWORD; lpSrcBuffer : IDirect3DVertexBuffer; dwSrcIndex : DWORD; lpD3DDevice : IDirect3DDevice3; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DVertexBuffer_GetVertexBufferDesc(idd : IDirect3DVertexBuffer; var lpVBDesc : TD3DVertexBufferDesc) : HResult; stdcall;
function IDirect3DVertexBuffer_Optimize(idd : IDirect3DVertexBuffer; lpD3DDevice : IDirect3DDevice3; dwFlags : DWORD) : HResult; stdcall;

// IDirect3DVertexBuffer7 interface methods

function IDirect3DVertexBuffer7_QueryInterface(idd : IDirect3DVertexBuffer7; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirect3DVertexBuffer7_AddRef(idd : IDirect3DVertexBuffer7) : Longint; stdcall;
function IDirect3DVertexBuffer7_Release(idd : IDirect3DVertexBuffer7) : Longint; stdcall;
function IDirect3DVertexBuffer7_Lock(idd : IDirect3DVertexBuffer7; dwFlags : DWORD; var lplpData : Pointer; var lpdwSize : DWORD) : HResult; stdcall;
function IDirect3DVertexBuffer7_Unlock(idd : IDirect3DVertexBuffer7) : HResult; stdcall;
function IDirect3DVertexBuffer7_ProcessVertices(idd : IDirect3DVertexBuffer7; dwVertexOp , dwDestIndex , dwCount : DWORD; lpSrcBuffer : IDirect3DVertexBuffer7; dwSrcIndex : DWORD; lpD3DDevice : IDirect3DDevice7; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DVertexBuffer7_GetVertexBufferDesc(idd : IDirect3DVertexBuffer7; var lpVBDesc : TD3DVertexBufferDesc) : HResult; stdcall;
function IDirect3DVertexBuffer7_Optimize(idd : IDirect3DVertexBuffer7; lpD3DDevice : IDirect3DDevice7; dwFlags : DWORD) : HResult; stdcall;
function IDirect3DVertexBuffer7_ProcessVerticesStrided(idd : IDirect3DVertexBuffer7; dwVertexOp , dwDestIndex , dwCount : DWORD; lpVertexArray : TD3DDrawPrimitiveStridedData; dwVertexTypeDesc : DWORD; lpD3DDevice : IDirect3DDevice7; dwFlags : DWORD) : HResult; stdcall;

// IDirectXFile interface methods

function IDirectXFile_QueryInterface(idd : IDirectXFile; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirectXFile_AddRef(idd : IDirectXFile) : Longint; stdcall;
function IDirectXFile_Release(idd : IDirectXFile) : Longint; stdcall;
function IDirectXFile_CreateEnumObject(idd : IDirectXFile; pvSource : Pointer; dwLoadOptions : TDXFileLoadOptions; var ppEnumObj : IDirectXFileEnumObject) : HResult; stdcall;
function IDirectXFile_CreateSaveObject(idd : IDirectXFile; szFileName : PChar; dwFileFormat : TDXFileFormat; var ppSaveObj : IDirectXFileSaveObject) : HResult; stdcall;
function IDirectXFile_RegisterTemplates(idd : IDirectXFile; pvData : Pointer; cbSize : DWORD) : HResult; stdcall;

// IDirectXFileEnumObject interface methods

function IDirectXFileEnumObject_QueryInterface(idd : IDirectXFileEnumObject; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirectXFileEnumObject_AddRef(idd : IDirectXFileEnumObject) : Longint; stdcall;
function IDirectXFileEnumObject_Release(idd : IDirectXFileEnumObject) : Longint; stdcall;
function IDirectXFileEnumObject_GetNextDataObject(idd : IDirectXFileEnumObject; var ppDataObj : IDirectXFileData) : HResult; stdcall;
function IDirectXFileEnumObject_GetDataObjectById(idd : IDirectXFileEnumObject; const rguid : TGUID; var ppDataObj : IDirectXFileData) : HResult; stdcall;
function IDirectXFileEnumObject_GetDataObjectByName(idd : IDirectXFileEnumObject; szName : PChar; var ppDataObj : IDirectXFileData) : HResult; stdcall;

// IDirectXFileSaveObject interface methods

function IDirectXFileSaveObject_QueryInterface(idd : IDirectXFileSaveObject; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirectXFileSaveObject_AddRef(idd : IDirectXFileSaveObject) : Longint; stdcall;
function IDirectXFileSaveObject_Release(idd : IDirectXFileSaveObject) : Longint; stdcall;
function IDirectXFileSaveObject_SaveTemplates(idd : IDirectXFileSaveObject; cTemplates : DWORD; var ppguidTemplates : PGUID) : HResult; stdcall;
function IDirectXFileSaveObject_CreateDataObject(idd : IDirectXFileSaveObject; const rguidTemplate : TGUID; szName : PChar; pguid : PGUID; cbSize : DWORD; pvData : Pointer; var ppDataObj : IDirectXFileData) : HResult; stdcall;
function IDirectXFileSaveObject_SaveData(idd : IDirectXFileSaveObject; pDataObj : IDirectXFileData) : HResult; stdcall;

// IDirectXFileObject interface methods

function IDirectXFileObject_QueryInterface(idd : IDirectXFileObject; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirectXFileObject_AddRef(idd : IDirectXFileObject) : Longint; stdcall;
function IDirectXFileObject_Release(idd : IDirectXFileObject) : Longint; stdcall;
function IDirectXFileObject_GetName(idd : IDirectXFileObject; pstrNameBuf : PChar; var dwBufLen : DWORD) : HResult; stdcall;
function IDirectXFileObject_GetId(idd : IDirectXFileObject; var pGuidBuf : TGUID) : HResult; stdcall;

// IDirectXFileData interface methods

function IDirectXFileData_QueryInterface(idd : IDirectXFileData; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirectXFileData_AddRef(idd : IDirectXFileData) : Longint; stdcall;
function IDirectXFileData_Release(idd : IDirectXFileData) : Longint; stdcall;
function IDirectXFileData_GetName(idd : IDirectXFileData; pstrNameBuf : PChar; var dwBufLen : DWORD) : HResult; stdcall;
function IDirectXFileData_GetId(idd : IDirectXFileData; var pGuidBuf : TGUID) : HResult; stdcall;
function IDirectXFileData_GetData(idd : IDirectXFileData; szMember : PChar; var pcbSize : DWORD; var ppvData : Pointer) : HResult; stdcall;
function IDirectXFileData_GetType(idd : IDirectXFileData; var ppguid : PGUID) : HResult; stdcall;
function IDirectXFileData_GetNextObject(idd : IDirectXFileData; var ppChildObj : IDirectXFileObject) : HResult; stdcall;
function IDirectXFileData_AddDataObject(idd : IDirectXFileData; pDataObj : IDirectXFileData) : HResult; stdcall;
function IDirectXFileData_AddDataReference(idd : IDirectXFileData; szRef : PChar; pguidRef : PGUID) : HResult; stdcall;
function IDirectXFileData_AddBinaryObject(idd : IDirectXFileData; szName : PChar; pguid : PGUID; szMimeType : PChar; pvData : Pointer; cbSize : DWORD) : HResult; stdcall;

// IDirectXFileDataReference interface methods

function IDirectXFileDataReference_QueryInterface(idd : IDirectXFileDataReference; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirectXFileDataReference_AddRef(idd : IDirectXFileDataReference) : Longint; stdcall;
function IDirectXFileDataReference_Release(idd : IDirectXFileDataReference) : Longint; stdcall;
function IDirectXFileDataReference_GetName(idd : IDirectXFileDataReference; pstrNameBuf : PChar; var dwBufLen : DWORD) : HResult; stdcall;
function IDirectXFileDataReference_GetId(idd : IDirectXFileDataReference; var pGuidBuf : TGUID) : HResult; stdcall;
function IDirectXFileDataReference_Resolve(idd : IDirectXFileDataReference; var ppDataObj : IDirectXFileData) : HResult; stdcall;

// IDirectXFileBinary interface methods

function IDirectXFileBinary_QueryInterface(idd : IDirectXFileBinary; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirectXFileBinary_AddRef(idd : IDirectXFileBinary) : Longint; stdcall;
function IDirectXFileBinary_Release(idd : IDirectXFileBinary) : Longint; stdcall;
function IDirectXFileBinary_GetName(idd : IDirectXFileBinary; pstrNameBuf : PChar; var dwBufLen : DWORD) : HResult; stdcall;
function IDirectXFileBinary_GetId(idd : IDirectXFileBinary; var pGuidBuf : TGUID) : HResult; stdcall;
function IDirectXFileBinary_GetSize(idd : IDirectXFileBinary; var pcbSize : DWORD) : HResult; stdcall;
function IDirectXFileBinary_GetMimeType(idd : IDirectXFileBinary; var pszMimeType : PChar) : HResult; stdcall;
function IDirectXFileBinary_Read(idd : IDirectXFileBinary; pvData : Pointer; cbSize : DWORD; pcbRead : PDWORD) : HResult; stdcall;

implementation


// IDirect3D interface methods

function IDirect3D_QueryInterface(idd : IDirect3D; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3D_AddRef(idd : IDirect3D) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3D_Release(idd : IDirect3D) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3D_Initialize(idd : IDirect3D; lpREFIID : {REFIID} PGUID) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpREFIID);
end;

function IDirect3D_EnumDevices(idd : IDirect3D; lpEnumDevicesCallback : TD3DEnumDevicesCallback; lpUserArg : Pointer) : HResult; stdcall;
begin
	result := idd^^.EnumDevices(idd, @lpEnumDevicesCallback, lpUserArg);
end;

function IDirect3D_CreateLight(idd : IDirect3D; var lplpDirect3Dlight : IDirect3DLight; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateLight(idd, lplpDirect3Dlight, pUnkOuter);
end;

function IDirect3D_CreateMaterial(idd : IDirect3D; var lplpDirect3DMaterial : IDirect3DMaterial; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateMaterial(idd, lplpDirect3DMaterial, pUnkOuter);
end;

function IDirect3D_CreateViewport(idd : IDirect3D; var lplpD3DViewport : IDirect3DViewport; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateViewport(idd, lplpD3DViewport, pUnkOuter);
end;

function IDirect3D_FindDevice(idd : IDirect3D; var lpD3DFDS : TD3DFindDeviceSearch; var lpD3DFDR : TD3DFindDeviceResult) : HResult; stdcall;
begin
	result := idd^^.FindDevice(idd, lpD3DFDS, lpD3DFDR);
end;


// IDirect3D2 interface methods

function IDirect3D2_QueryInterface(idd : IDirect3D2; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3D2_AddRef(idd : IDirect3D2) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3D2_Release(idd : IDirect3D2) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3D2_EnumDevices(idd : IDirect3D2; lpEnumDevicesCallback : TD3DEnumDevicesCallback; lpUserArg : pointer) : HResult; stdcall;
begin
	result := idd^^.EnumDevices(idd, @lpEnumDevicesCallback, lpUserArg);
end;

function IDirect3D2_CreateLight(idd : IDirect3D2; var lplpDirect3Dlight : IDirect3DLight; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateLight(idd, lplpDirect3Dlight, pUnkOuter);
end;

function IDirect3D2_CreateMaterial(idd : IDirect3D2; var lplpDirect3DMaterial2 : IDirect3DMaterial2; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateMaterial(idd, lplpDirect3DMaterial2, pUnkOuter);
end;

function IDirect3D2_CreateViewport(idd : IDirect3D2; var lplpD3DViewport2 : IDirect3DViewport2; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateViewport(idd, lplpD3DViewport2, pUnkOuter);
end;

function IDirect3D2_FindDevice(idd : IDirect3D2; var lpD3DFDS : TD3DFindDeviceSearch; var lpD3DFDR : TD3DFindDeviceResult) : HResult; stdcall;
begin
	result := idd^^.FindDevice(idd, lpD3DFDS, lpD3DFDR);
end;

function IDirect3D2_CreateDevice(idd : IDirect3D2; const rclsid : TRefClsID; lpDDS : IDirectDrawSurface; var lplpD3DDevice2 : IDirect3DDevice2) : HResult; stdcall;
begin
	result := idd^^.CreateDevice(idd, rclsid, lpDDS, lplpD3DDevice2);
end;


// IDirect3D3 interface methods

function IDirect3D3_QueryInterface(idd : IDirect3D3; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3D3_AddRef(idd : IDirect3D3) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3D3_Release(idd : IDirect3D3) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3D3_EnumDevices(idd : IDirect3D3; lpEnumDevicesCallback : TD3DEnumDevicesCallback; lpUserArg : pointer) : HResult; stdcall;
begin
	result := idd^^.EnumDevices(idd, @lpEnumDevicesCallback, lpUserArg);
end;

function IDirect3D3_CreateLight(idd : IDirect3D3; var lplpDirect3Dlight : IDirect3DLight; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateLight(idd, lplpDirect3Dlight, pUnkOuter);
end;

function IDirect3D3_CreateMaterial(idd : IDirect3D3; var lplpDirect3DMaterial3 : IDirect3DMaterial3; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateMaterial(idd, lplpDirect3DMaterial3, pUnkOuter);
end;

function IDirect3D3_CreateViewport(idd : IDirect3D3; var lplpD3DViewport3 : IDirect3DViewport3; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateViewport(idd, lplpD3DViewport3, pUnkOuter);
end;

function IDirect3D3_FindDevice(idd : IDirect3D3; var lpD3DFDS : TD3DFindDeviceSearch; var lpD3DFDR : TD3DFindDeviceResult) : HResult; stdcall;
begin
	result := idd^^.FindDevice(idd, lpD3DFDS, lpD3DFDR);
end;

function IDirect3D3_CreateDevice(idd : IDirect3D3; const rclsid : TRefClsID; lpDDS : IDirectDrawSurface4; var lplpD3DDevice : IDirect3DDevice3; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateDevice(idd, rclsid, lpDDS, lplpD3DDevice, pUnkOuter);
end;

function IDirect3D3_CreateVertexBuffer(idd : IDirect3D3; var lpVBDesc : TD3DVertexBufferDesc; var lpD3DVertexBuffer : IDirect3DVertexBuffer; dwFlags : DWORD; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateVertexBuffer(idd, lpVBDesc, lpD3DVertexBuffer, dwFlags, pUnkOuter);
end;

function IDirect3D3_EnumZBufferFormats(idd : IDirect3D3; const riidDevice : TRefClsID; lpEnumCallback : TD3DEnumPixelFormatsCallback; lpContext : pointer) : HResult; stdcall;
begin
	result := idd^^.EnumZBufferFormats(idd, riidDevice, @lpEnumCallback, lpContext);
end;

function IDirect3D3_EvictManagedTextures(idd : IDirect3D3) : HResult; stdcall;
begin
	result := idd^^.EvictManagedTextures(idd);
end;


// IDirect3D7 interface methods

function IDirect3D7_QueryInterface(idd : IDirect3D7; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3D7_AddRef(idd : IDirect3D7) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3D7_Release(idd : IDirect3D7) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3D7_EnumDevices(idd : IDirect3D7; lpEnumDevicesCallback : TD3DEnumDevicesCallback7; lpUserArg : pointer) : HResult; stdcall;
begin
	result := idd^^.EnumDevices(idd, @lpEnumDevicesCallback, lpUserArg);
end;

function IDirect3D7_CreateDevice(idd : IDirect3D7; const rclsid : TGUID; lpDDS : IDirectDrawSurface7; var lplpD3DDevice : IDirect3DDevice7) : HResult; stdcall;
begin
	result := idd^^.CreateDevice(idd, rclsid, lpDDS, lplpD3DDevice);
end;

function IDirect3D7_CreateVertexBuffer(idd : IDirect3D7; const lpVBDesc : TD3DVertexBufferDesc; var lplpD3DVertexBuffer : IDirect3DVertexBuffer7; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreateVertexBuffer(idd, lpVBDesc, lplpD3DVertexBuffer, dwFlags);
end;

function IDirect3D7_EnumZBufferFormats(idd : IDirect3D7; const riidDevice : TGUID; lpEnumCallback : TD3DEnumPixelFormatsCallback; lpContext : pointer) : HResult; stdcall;
begin
	result := idd^^.EnumZBufferFormats(idd, riidDevice, @lpEnumCallback, lpContext);
end;

function IDirect3D7_EvictManagedTextures(idd : IDirect3D7) : HResult; stdcall;
begin
	result := idd^^.EvictManagedTextures(idd);
end;


// IDirect3DDevice interface methods

function IDirect3DDevice_QueryInterface(idd : IDirect3DDevice; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DDevice_AddRef(idd : IDirect3DDevice) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DDevice_Release(idd : IDirect3DDevice) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DDevice_Initialize(idd : IDirect3DDevice; lpd3d : IDirect3D; lpGUID : PGUID; var lpd3ddvdesc : TD3DDeviceDesc) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpd3d, lpGUID, lpd3ddvdesc);
end;

function IDirect3DDevice_GetCaps(idd : IDirect3DDevice; var lpD3DHWDevDesc : TD3DDeviceDesc; var lpD3DHELDevDesc : TD3DDeviceDesc) : HResult; stdcall;
begin
	result := idd^^.GetCaps(idd, lpD3DHWDevDesc, lpD3DHELDevDesc);
end;

function IDirect3DDevice_SwapTextureHandles(idd : IDirect3DDevice; lpD3DTex1 : IDirect3DTexture; lpD3DTex2 : IDirect3DTexture) : HResult; stdcall;
begin
	result := idd^^.SwapTextureHandles(idd, lpD3DTex1, lpD3DTex2);
end;

function IDirect3DDevice_CreateExecuteBuffer(idd : IDirect3DDevice; var lpDesc : TD3DExecuteBufferDesc; var lplpDirect3DExecuteBuffer : IDirect3DExecuteBuffer; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateExecuteBuffer(idd, lpDesc, lplpDirect3DExecuteBuffer, pUnkOuter);
end;

function IDirect3DDevice_GetStats(idd : IDirect3DDevice; var lpD3DStats : TD3DStats) : HResult; stdcall;
begin
	result := idd^^.GetStats(idd, lpD3DStats);
end;

function IDirect3DDevice_Execute(idd : IDirect3DDevice; lpDirect3DExecuteBuffer : IDirect3DExecuteBuffer; lpDirect3DViewport : IDirect3DViewport; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Execute(idd, lpDirect3DExecuteBuffer, lpDirect3DViewport, dwFlags);
end;

function IDirect3DDevice_AddViewport(idd : IDirect3DDevice; lpDirect3DViewport : IDirect3DViewport) : HResult; stdcall;
begin
	result := idd^^.AddViewport(idd, lpDirect3DViewport);
end;

function IDirect3DDevice_DeleteViewport(idd : IDirect3DDevice; lpDirect3DViewport : IDirect3DViewport) : HResult; stdcall;
begin
	result := idd^^.DeleteViewport(idd, lpDirect3DViewport);
end;

function IDirect3DDevice_NextViewport(idd : IDirect3DDevice; lpDirect3DViewport : IDirect3DViewport; var lplpDirect3DViewport : IDirect3DViewport; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.NextViewport(idd, lpDirect3DViewport, lplpDirect3DViewport, dwFlags);
end;

function IDirect3DDevice_Pick(idd : IDirect3DDevice; lpDirect3DExecuteBuffer : IDirect3DExecuteBuffer; lpDirect3DViewport : IDirect3DViewport; dwFlags : DWORD; var lpRect : TD3DRect) : HResult; stdcall;
begin
	result := idd^^.Pick(idd, lpDirect3DExecuteBuffer, lpDirect3DViewport, dwFlags, lpRect);
end;

function IDirect3DDevice_GetPickRecords(idd : IDirect3DDevice; var lpCount : DWORD; var lpD3DPickRec : TD3DPickRecord) : HResult; stdcall;
begin
	result := idd^^.GetPickRecords(idd, lpCount, lpD3DPickRec);
end;

function IDirect3DDevice_EnumTextureFormats(idd : IDirect3DDevice; lpd3dEnumTextureProc : TD3DEnumTextureFormatsCallback; lpArg : Pointer) : HResult; stdcall;
begin
	result := idd^^.EnumTextureFormats(idd, @lpd3dEnumTextureProc, lpArg);
end;

function IDirect3DDevice_CreateMatrix(idd : IDirect3DDevice; var lpD3DMatHandle : TD3DMatrixHandle) : HResult; stdcall;
begin
	result := idd^^.CreateMatrix(idd, lpD3DMatHandle);
end;

function IDirect3DDevice_SetMatrix(idd : IDirect3DDevice; d3dMatHandle : TD3DMatrixHandle; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
begin
	result := idd^^.SetMatrix(idd, d3dMatHandle, lpD3DMatrix);
end;

function IDirect3DDevice_GetMatrix(idd : IDirect3DDevice; var lpD3DMatHandle : TD3DMatrixHandle; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
begin
	result := idd^^.GetMatrix(idd, lpD3DMatHandle, lpD3DMatrix);
end;

function IDirect3DDevice_DeleteMatrix(idd : IDirect3DDevice; d3dMatHandle : TD3DMatrixHandle) : HResult; stdcall;
begin
	result := idd^^.DeleteMatrix(idd, d3dMatHandle);
end;

function IDirect3DDevice_BeginScene(idd : IDirect3DDevice) : HResult; stdcall;
begin
	result := idd^^.BeginScene(idd);
end;

function IDirect3DDevice_EndScene(idd : IDirect3DDevice) : HResult; stdcall;
begin
	result := idd^^.EndScene(idd);
end;

function IDirect3DDevice_GetDirect3D(idd : IDirect3DDevice; var lpD3D : IDirect3D) : HResult; stdcall;
begin
	result := idd^^.GetDirect3D(idd, lpD3D);
end;


// IDirect3DDevice2 interface methods

function IDirect3DDevice2_QueryInterface(idd : IDirect3DDevice2; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DDevice2_AddRef(idd : IDirect3DDevice2) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DDevice2_Release(idd : IDirect3DDevice2) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DDevice2_GetCaps(idd : IDirect3DDevice2; var lpD3DHWDevDesc : TD3DDeviceDesc; var lpD3DHELDevDesc : TD3DDeviceDesc) : HResult; stdcall;
begin
	result := idd^^.GetCaps(idd, lpD3DHWDevDesc, lpD3DHELDevDesc);
end;

function IDirect3DDevice2_SwapTextureHandles(idd : IDirect3DDevice2; lpD3DTex1 : IDirect3DTexture2; lpD3DTex2 : IDirect3DTexture2) : HResult; stdcall;
begin
	result := idd^^.SwapTextureHandles(idd, lpD3DTex1, lpD3DTex2);
end;

function IDirect3DDevice2_GetStats(idd : IDirect3DDevice2; var lpD3DStats : TD3DStats) : HResult; stdcall;
begin
	result := idd^^.GetStats(idd, lpD3DStats);
end;

function IDirect3DDevice2_AddViewport(idd : IDirect3DDevice2; lpDirect3DViewport2 : IDirect3DViewport2) : HResult; stdcall;
begin
	result := idd^^.AddViewport(idd, lpDirect3DViewport2);
end;

function IDirect3DDevice2_DeleteViewport(idd : IDirect3DDevice2; lpDirect3DViewport : IDirect3DViewport2) : HResult; stdcall;
begin
	result := idd^^.DeleteViewport(idd, lpDirect3DViewport);
end;

function IDirect3DDevice2_NextViewport(idd : IDirect3DDevice2; lpDirect3DViewport : IDirect3DViewport2; var lplpDirect3DViewport : IDirect3DViewport2; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.NextViewport(idd, lpDirect3DViewport, lplpDirect3DViewport, dwFlags);
end;

function IDirect3DDevice2_EnumTextureFormats(idd : IDirect3DDevice2; lpd3dEnumTextureProc : TD3DEnumTextureFormatsCallback; lpArg : Pointer) : HResult; stdcall;
begin
	result := idd^^.EnumTextureFormats(idd, @lpd3dEnumTextureProc, lpArg);
end;

function IDirect3DDevice2_BeginScene(idd : IDirect3DDevice2) : HResult; stdcall;
begin
	result := idd^^.BeginScene(idd);
end;

function IDirect3DDevice2_EndScene(idd : IDirect3DDevice2) : HResult; stdcall;
begin
	result := idd^^.EndScene(idd);
end;

function IDirect3DDevice2_GetDirect3D(idd : IDirect3DDevice2; var lpD3D : IDirect3D2) : HResult; stdcall;
begin
	result := idd^^.GetDirect3D(idd, lpD3D);
end;

function IDirect3DDevice2_SetCurrentViewport(idd : IDirect3DDevice2; lpd3dViewport2 : IDirect3DViewport2) : HResult; stdcall;
begin
	result := idd^^.SetCurrentViewport(idd, lpd3dViewport2);
end;

function IDirect3DDevice2_GetCurrentViewport(idd : IDirect3DDevice2; var lplpd3dViewport2 : IDirect3DViewport2) : HResult; stdcall;
begin
	result := idd^^.GetCurrentViewport(idd, lplpd3dViewport2);
end;

function IDirect3DDevice2_SetRenderTarget(idd : IDirect3DDevice2; lpNewRenderTarget : IDirectDrawSurface) : HResult; stdcall;
begin
	result := idd^^.SetRenderTarget(idd, lpNewRenderTarget);
end;

function IDirect3DDevice2_GetRenderTarget(idd : IDirect3DDevice2; var lplpNewRenderTarget : IDirectDrawSurface) : HResult; stdcall;
begin
	result := idd^^.GetRenderTarget(idd, lplpNewRenderTarget);
end;

function IDirect3DDevice2_Begin_(idd : IDirect3DDevice2; d3dpt : TD3DPrimitiveType; d3dvt : TD3DVertexType; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Begin_(idd, d3dpt, d3dvt, dwFlags);
end;

function IDirect3DDevice2_BeginIndexed(idd : IDirect3DDevice2; dptPrimitiveType : TD3DPrimitiveType; dvtVertexType : TD3DVertexType; lpvVertices : pointer; dwNumVertices : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.BeginIndexed(idd, dptPrimitiveType, dvtVertexType, lpvVertices, dwNumVertices, dwFlags);
end;

function IDirect3DDevice2_Vertex(idd : IDirect3DDevice2; lpVertexType : pointer) : HResult; stdcall;
begin
	result := idd^^.Vertex(idd, lpVertexType);
end;

function IDirect3DDevice2_Index(idd : IDirect3DDevice2; wVertexIndex : WORD) : HResult; stdcall;
begin
	result := idd^^.Index(idd, wVertexIndex);
end;

function IDirect3DDevice2_End_(idd : IDirect3DDevice2; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.End_(idd, dwFlags);
end;

function IDirect3DDevice2_GetRenderState(idd : IDirect3DDevice2; dwRenderStateType : TD3DRenderStateType; var lpdwRenderState) : HResult; stdcall;
begin
	result := idd^^.GetRenderState(idd, dwRenderStateType, lpdwRenderState);
end;

function IDirect3DDevice2_SetRenderState(idd : IDirect3DDevice2; dwRenderStateType : TD3DRenderStateType; dwRenderState : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetRenderState(idd, dwRenderStateType, dwRenderState);
end;

function IDirect3DDevice2_GetLightState(idd : IDirect3DDevice2; dwLightStateType : TD3DLightStateType; var lpdwLightState) : HResult; stdcall;
begin
	result := idd^^.GetLightState(idd, dwLightStateType, lpdwLightState);
end;

function IDirect3DDevice2_SetLightState(idd : IDirect3DDevice2; dwLightStateType : TD3DLightStateType; dwLightState : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetLightState(idd, dwLightStateType, dwLightState);
end;

function IDirect3DDevice2_SetTransform(idd : IDirect3DDevice2; dtstTransformStateType : TD3DTransformStateType; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
begin
	result := idd^^.SetTransform(idd, dtstTransformStateType, lpD3DMatrix);
end;

function IDirect3DDevice2_GetTransform(idd : IDirect3DDevice2; dtstTransformStateType : TD3DTransformStateType; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
begin
	result := idd^^.GetTransform(idd, dtstTransformStateType, lpD3DMatrix);
end;

function IDirect3DDevice2_MultiplyTransform(idd : IDirect3DDevice2; dtstTransformStateType : TD3DTransformStateType; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
begin
	result := idd^^.MultiplyTransform(idd, dtstTransformStateType, lpD3DMatrix);
end;

function IDirect3DDevice2_DrawPrimitive(idd : IDirect3DDevice2; dptPrimitiveType : TD3DPrimitiveType; dvtVertexType : TD3DVertexType; var lpvVertices; dwVertexCount , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.DrawPrimitive(idd, dptPrimitiveType, dvtVertexType, lpvVertices, dwVertexCount, dwFlags);
end;

function IDirect3DDevice2_DrawIndexedPrimitive(idd : IDirect3DDevice2; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; lpvVertices : pointer; dwVertexCount : DWORD; var lpwIndices : WORD; dwIndexCount , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.DrawIndexedPrimitive(idd, dptPrimitiveType, dwVertexTypeDesc, lpvVertices, dwVertexCount, lpwIndices, dwIndexCount, dwFlags);
end;

function IDirect3DDevice2_SetClipStatus(idd : IDirect3DDevice2; var lpD3DClipStatus : TD3DClipStatus) : HResult; stdcall;
begin
	result := idd^^.SetClipStatus(idd, lpD3DClipStatus);
end;

function IDirect3DDevice2_GetClipStatus(idd : IDirect3DDevice2; var lpD3DClipStatus : TD3DClipStatus) : HResult; stdcall;
begin
	result := idd^^.GetClipStatus(idd, lpD3DClipStatus);
end;


// IDirect3DDevice3 interface methods

function IDirect3DDevice3_QueryInterface(idd : IDirect3DDevice3; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DDevice3_AddRef(idd : IDirect3DDevice3) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DDevice3_Release(idd : IDirect3DDevice3) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DDevice3_GetCaps(idd : IDirect3DDevice3; var lpD3DHWDevDesc : TD3DDeviceDesc; var lpD3DHELDevDesc : TD3DDeviceDesc) : HResult; stdcall;
begin
	result := idd^^.GetCaps(idd, lpD3DHWDevDesc, lpD3DHELDevDesc);
end;

function IDirect3DDevice3_GetStats(idd : IDirect3DDevice3; var lpD3DStats : TD3DStats) : HResult; stdcall;
begin
	result := idd^^.GetStats(idd, lpD3DStats);
end;

function IDirect3DDevice3_AddViewport(idd : IDirect3DDevice3; lpDirect3DViewport : IDirect3DViewport3) : HResult; stdcall;
begin
	result := idd^^.AddViewport(idd, lpDirect3DViewport);
end;

function IDirect3DDevice3_DeleteViewport(idd : IDirect3DDevice3; lpDirect3DViewport : IDirect3DViewport3) : HResult; stdcall;
begin
	result := idd^^.DeleteViewport(idd, lpDirect3DViewport);
end;

function IDirect3DDevice3_NextViewport(idd : IDirect3DDevice3; lpDirect3DViewport : IDirect3DViewport3; var lplpAnotherViewport : IDirect3DViewport3; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.NextViewport(idd, lpDirect3DViewport, lplpAnotherViewport, dwFlags);
end;

function IDirect3DDevice3_EnumTextureFormats(idd : IDirect3DDevice3; lpd3dEnumPixelProc : TD3DEnumPixelFormatsCallback; lpArg : Pointer) : HResult; stdcall;
begin
	result := idd^^.EnumTextureFormats(idd, @lpd3dEnumPixelProc, lpArg);
end;

function IDirect3DDevice3_BeginScene(idd : IDirect3DDevice3) : HResult; stdcall;
begin
	result := idd^^.BeginScene(idd);
end;

function IDirect3DDevice3_EndScene(idd : IDirect3DDevice3) : HResult; stdcall;
begin
	result := idd^^.EndScene(idd);
end;

function IDirect3DDevice3_GetDirect3D(idd : IDirect3DDevice3; var lpD3D : IDirect3D3) : HResult; stdcall;
begin
	result := idd^^.GetDirect3D(idd, lpD3D);
end;

function IDirect3DDevice3_SetCurrentViewport(idd : IDirect3DDevice3; lpd3dViewport : IDirect3DViewport3) : HResult; stdcall;
begin
	result := idd^^.SetCurrentViewport(idd, lpd3dViewport);
end;

function IDirect3DDevice3_GetCurrentViewport(idd : IDirect3DDevice3; var lplpd3dViewport : IDirect3DViewport3) : HResult; stdcall;
begin
	result := idd^^.GetCurrentViewport(idd, lplpd3dViewport);
end;

function IDirect3DDevice3_SetRenderTarget(idd : IDirect3DDevice3; lpNewRenderTarget : IDirectDrawSurface4) : HResult; stdcall;
begin
	result := idd^^.SetRenderTarget(idd, lpNewRenderTarget);
end;

function IDirect3DDevice3_GetRenderTarget(idd : IDirect3DDevice3; var lplpNewRenderTarget : IDirectDrawSurface4) : HResult; stdcall;
begin
	result := idd^^.GetRenderTarget(idd, lplpNewRenderTarget);
end;

function IDirect3DDevice3_Begin_(idd : IDirect3DDevice3; d3dpt : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Begin_(idd, d3dpt, dwVertexTypeDesc, dwFlags);
end;

function IDirect3DDevice3_BeginIndexed(idd : IDirect3DDevice3; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; lpvVertices : pointer; dwNumVertices : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.BeginIndexed(idd, dptPrimitiveType, dwVertexTypeDesc, lpvVertices, dwNumVertices, dwFlags);
end;

function IDirect3DDevice3_Vertex(idd : IDirect3DDevice3; lpVertex : pointer) : HResult; stdcall;
begin
	result := idd^^.Vertex(idd, lpVertex);
end;

function IDirect3DDevice3_Index(idd : IDirect3DDevice3; wVertexIndex : WORD) : HResult; stdcall;
begin
	result := idd^^.Index(idd, wVertexIndex);
end;

function IDirect3DDevice3_End_(idd : IDirect3DDevice3; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.End_(idd, dwFlags);
end;

function IDirect3DDevice3_GetRenderState(idd : IDirect3DDevice3; dwRenderStateType : TD3DRenderStateType; var lpdwRenderState) : HResult; stdcall;
begin
	result := idd^^.GetRenderState(idd, dwRenderStateType, lpdwRenderState);
end;

function IDirect3DDevice3_SetRenderState(idd : IDirect3DDevice3; dwRenderStateType : TD3DRenderStateType; dwRenderState : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetRenderState(idd, dwRenderStateType, dwRenderState);
end;

function IDirect3DDevice3_GetLightState(idd : IDirect3DDevice3; dwLightStateType : TD3DLightStateType; var lpdwLightState) : HResult; stdcall;
begin
	result := idd^^.GetLightState(idd, dwLightStateType, lpdwLightState);
end;

function IDirect3DDevice3_SetLightState(idd : IDirect3DDevice3; dwLightStateType : TD3DLightStateType; dwLightState : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetLightState(idd, dwLightStateType, dwLightState);
end;

function IDirect3DDevice3_SetTransform(idd : IDirect3DDevice3; dtstTransformStateType : TD3DTransformStateType; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
begin
	result := idd^^.SetTransform(idd, dtstTransformStateType, lpD3DMatrix);
end;

function IDirect3DDevice3_GetTransform(idd : IDirect3DDevice3; dtstTransformStateType : TD3DTransformStateType; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
begin
	result := idd^^.GetTransform(idd, dtstTransformStateType, lpD3DMatrix);
end;

function IDirect3DDevice3_MultiplyTransform(idd : IDirect3DDevice3; dtstTransformStateType : TD3DTransformStateType; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
begin
	result := idd^^.MultiplyTransform(idd, dtstTransformStateType, lpD3DMatrix);
end;

function IDirect3DDevice3_DrawPrimitive(idd : IDirect3DDevice3; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; const lpvVertices; dwVertexCount , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.DrawPrimitive(idd, dptPrimitiveType, dwVertexTypeDesc, lpvVertices, dwVertexCount, dwFlags);
end;

function IDirect3DDevice3_DrawIndexedPrimitive(idd : IDirect3DDevice3; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; const lpvVertices; dwVertexCount : DWORD; var lpwIndices : WORD; dwIndexCount , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.DrawIndexedPrimitive(idd, dptPrimitiveType, dwVertexTypeDesc, lpvVertices, dwVertexCount, lpwIndices, dwIndexCount, dwFlags);
end;

function IDirect3DDevice3_SetClipStatus(idd : IDirect3DDevice3; var lpD3DClipStatus : TD3DClipStatus) : HResult; stdcall;
begin
	result := idd^^.SetClipStatus(idd, lpD3DClipStatus);
end;

function IDirect3DDevice3_GetClipStatus(idd : IDirect3DDevice3; var lpD3DClipStatus : TD3DClipStatus) : HResult; stdcall;
begin
	result := idd^^.GetClipStatus(idd, lpD3DClipStatus);
end;

function IDirect3DDevice3_DrawPrimitiveStrided(idd : IDirect3DDevice3; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; var lpVertexArray : TD3DDrawPrimitiveStridedData; dwVertexCount , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.DrawPrimitiveStrided(idd, dptPrimitiveType, dwVertexTypeDesc, lpVertexArray, dwVertexCount, dwFlags);
end;

function IDirect3DDevice3_DrawIndexedPrimitiveStrided(idd : IDirect3DDevice3; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; var lpVertexArray : TD3DDrawPrimitiveStridedData; dwVertexCount : DWORD; var lpwIndices : WORD; dwIndexCount , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.DrawIndexedPrimitiveStrided(idd, dptPrimitiveType, dwVertexTypeDesc, lpVertexArray, dwVertexCount, lpwIndices, dwIndexCount, dwFlags);
end;

function IDirect3DDevice3_DrawPrimitiveVB(idd : IDirect3DDevice3; dptPrimitiveType : TD3DPrimitiveType; lpd3dVertexBuffer : IDirect3DVertexBuffer; dwStartVertex , dwNumVertices , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.DrawPrimitiveVB(idd, dptPrimitiveType, lpd3dVertexBuffer, dwStartVertex, dwNumVertices, dwFlags);
end;

function IDirect3DDevice3_DrawIndexedPrimitiveVB(idd : IDirect3DDevice3; dptPrimitiveType : TD3DPrimitiveType; lpd3dVertexBuffer : IDirect3DVertexBuffer; var lpwIndices : WORD; dwIndexCount , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.DrawIndexedPrimitiveVB(idd, dptPrimitiveType, lpd3dVertexBuffer, lpwIndices, dwIndexCount, dwFlags);
end;

function IDirect3DDevice3_ComputeSphereVisibility(idd : IDirect3DDevice3; var lpCenters : TD3DVector; var lpRadii : TD3DValue; dwNumSpheres , dwFlags : DWORD; var lpdwReturnValues : DWORD) : HResult; stdcall;
begin
	result := idd^^.ComputeSphereVisibility(idd, lpCenters, lpRadii, dwNumSpheres, dwFlags, lpdwReturnValues);
end;

function IDirect3DDevice3_GetTexture(idd : IDirect3DDevice3; dwStage : DWORD; var lplpTexture : IDirect3DTexture2) : HResult; stdcall;
begin
	result := idd^^.GetTexture(idd, dwStage, lplpTexture);
end;

function IDirect3DDevice3_SetTexture(idd : IDirect3DDevice3; dwStage : DWORD; lplpTexture : IDirect3DTexture2) : HResult; stdcall;
begin
	result := idd^^.SetTexture(idd, dwStage, lplpTexture);
end;

function IDirect3DDevice3_GetTextureStageState(idd : IDirect3DDevice3; dwStage : DWORD; dwState : TD3DTextureStageStateType; var lpdwValue : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetTextureStageState(idd, dwStage, dwState, lpdwValue);
end;

function IDirect3DDevice3_SetTextureStageState(idd : IDirect3DDevice3; dwStage : DWORD; dwState : TD3DTextureStageStateType; lpdwValue : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetTextureStageState(idd, dwStage, dwState, lpdwValue);
end;

function IDirect3DDevice3_ValidateDevice(idd : IDirect3DDevice3; var lpdwExtraPasses : DWORD) : HResult; stdcall;
begin
	result := idd^^.ValidateDevice(idd, lpdwExtraPasses);
end;


// IDirect3DDevice7 interface methods

function IDirect3DDevice7_QueryInterface(idd : IDirect3DDevice7; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DDevice7_AddRef(idd : IDirect3DDevice7) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DDevice7_Release(idd : IDirect3DDevice7) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DDevice7_GetCaps(idd : IDirect3DDevice7; var lpD3DDevDesc : TD3DDeviceDesc7) : HResult; stdcall;
begin
	result := idd^^.GetCaps(idd, lpD3DDevDesc);
end;

function IDirect3DDevice7_EnumTextureFormats(idd : IDirect3DDevice7; lpd3dEnumPixelProc : TD3DEnumPixelFormatsCallback; lpArg : Pointer) : HResult; stdcall;
begin
	result := idd^^.EnumTextureFormats(idd, @lpd3dEnumPixelProc, lpArg);
end;

function IDirect3DDevice7_BeginScene(idd : IDirect3DDevice7) : HResult; stdcall;
begin
	result := idd^^.BeginScene(idd);
end;

function IDirect3DDevice7_EndScene(idd : IDirect3DDevice7) : HResult; stdcall;
begin
	result := idd^^.EndScene(idd);
end;

function IDirect3DDevice7_GetDirect3D(idd : IDirect3DDevice7; var lpD3D : IDirect3D7) : HResult; stdcall;
begin
	result := idd^^.GetDirect3D(idd, lpD3D);
end;

function IDirect3DDevice7_SetRenderTarget(idd : IDirect3DDevice7; lpNewRenderTarget : IDirectDrawSurface7; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetRenderTarget(idd, lpNewRenderTarget, dwFlags);
end;

function IDirect3DDevice7_GetRenderTarget(idd : IDirect3DDevice7; var lplpRenderTarget : IDirectDrawSurface7) : HResult; stdcall;
begin
	result := idd^^.GetRenderTarget(idd, lplpRenderTarget);
end;

function IDirect3DDevice7_Clear(idd : IDirect3DDevice7; dwCount : DWORD; lpRects : PD3DRect; dwFlags , dwColor : DWORD; dvZ : TD3DValue; dwStencil : DWORD) : HResult; stdcall;
begin
	result := idd^^.Clear(idd, dwCount, lpRects, dwFlags, dwColor, dvZ, dwStencil);
end;

function IDirect3DDevice7_SetTransform(idd : IDirect3DDevice7; dtstTransformStateType : TD3DTransformStateType; const lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
begin
	result := idd^^.SetTransform(idd, dtstTransformStateType, lpD3DMatrix);
end;

function IDirect3DDevice7_GetTransform(idd : IDirect3DDevice7; dtstTransformStateType : TD3DTransformStateType; var lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
begin
	result := idd^^.GetTransform(idd, dtstTransformStateType, lpD3DMatrix);
end;

function IDirect3DDevice7_SetViewport(idd : IDirect3DDevice7; const lpViewport : TD3DViewport7) : HResult; stdcall;
begin
	result := idd^^.SetViewport(idd, lpViewport);
end;

function IDirect3DDevice7_MultiplyTransform(idd : IDirect3DDevice7; dtstTransformStateType : TD3DTransformStateType; const lpD3DMatrix : TD3DMatrix) : HResult; stdcall;
begin
	result := idd^^.MultiplyTransform(idd, dtstTransformStateType, lpD3DMatrix);
end;

function IDirect3DDevice7_GetViewport(idd : IDirect3DDevice7; var lpViewport : TD3DViewport7) : HResult; stdcall;
begin
	result := idd^^.GetViewport(idd, lpViewport);
end;

function IDirect3DDevice7_SetMaterial(idd : IDirect3DDevice7; const lpMaterial : TD3DMaterial7) : HResult; stdcall;
begin
	result := idd^^.SetMaterial(idd, lpMaterial);
end;

function IDirect3DDevice7_GetMaterial(idd : IDirect3DDevice7; var lpMaterial : TD3DMaterial7) : HResult; stdcall;
begin
	result := idd^^.GetMaterial(idd, lpMaterial);
end;

function IDirect3DDevice7_SetLight(idd : IDirect3DDevice7; dwLightIndex : DWORD; const lpLight : TD3DLight7) : HResult; stdcall;
begin
	result := idd^^.SetLight(idd, dwLightIndex, lpLight);
end;

function IDirect3DDevice7_GetLight(idd : IDirect3DDevice7; dwLightIndex : DWORD; var lpLight : TD3DLight7) : HResult; stdcall;
begin
	result := idd^^.GetLight(idd, dwLightIndex, lpLight);
end;

function IDirect3DDevice7_SetRenderState(idd : IDirect3DDevice7; dwRenderStateType : TD3DRenderStateType; dwRenderState : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetRenderState(idd, dwRenderStateType, dwRenderState);
end;

function IDirect3DDevice7_GetRenderState(idd : IDirect3DDevice7; dwRenderStateType : TD3DRenderStateType; var dwRenderState : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetRenderState(idd, dwRenderStateType, dwRenderState);
end;

function IDirect3DDevice7_BeginStateBlock(idd : IDirect3DDevice7) : HResult; stdcall;
begin
	result := idd^^.BeginStateBlock(idd);
end;

function IDirect3DDevice7_EndStateBlock(idd : IDirect3DDevice7; var lpdwBlockHandle : DWORD) : HResult; stdcall;
begin
	result := idd^^.EndStateBlock(idd, lpdwBlockHandle);
end;

function IDirect3DDevice7_PreLoad(idd : IDirect3DDevice7; lpddsTexture : IDirectDrawSurface7) : HResult; stdcall;
begin
	result := idd^^.PreLoad(idd, lpddsTexture);
end;

function IDirect3DDevice7_DrawPrimitive(idd : IDirect3DDevice7; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; const lpvVertices; dwVertexCount , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.DrawPrimitive(idd, dptPrimitiveType, dwVertexTypeDesc, lpvVertices, dwVertexCount, dwFlags);
end;

function IDirect3DDevice7_DrawIndexedPrimitive(idd : IDirect3DDevice7; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; const lpvVertices; dwVertexCount : DWORD; const lpwIndices; dwIndexCount , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.DrawIndexedPrimitive(idd, dptPrimitiveType, dwVertexTypeDesc, lpvVertices, dwVertexCount, lpwIndices, dwIndexCount, dwFlags);
end;

function IDirect3DDevice7_SetClipStatus(idd : IDirect3DDevice7; const lpD3DClipStatus : TD3DClipStatus) : HResult; stdcall;
begin
	result := idd^^.SetClipStatus(idd, lpD3DClipStatus);
end;

function IDirect3DDevice7_GetClipStatus(idd : IDirect3DDevice7; var lpD3DClipStatus : TD3DClipStatus) : HResult; stdcall;
begin
	result := idd^^.GetClipStatus(idd, lpD3DClipStatus);
end;

function IDirect3DDevice7_DrawPrimitiveStrided(idd : IDirect3DDevice7; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; const lpVertexArray : TD3DDrawPrimitiveStridedData; dwVertexCount , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.DrawPrimitiveStrided(idd, dptPrimitiveType, dwVertexTypeDesc, lpVertexArray, dwVertexCount, dwFlags);
end;

function IDirect3DDevice7_DrawIndexedPrimitiveStrided(idd : IDirect3DDevice7; dptPrimitiveType : TD3DPrimitiveType; dwVertexTypeDesc : DWORD; const lpVertexArray : TD3DDrawPrimitiveStridedData; dwVertexCount : DWORD; var lpwIndices : WORD; dwIndexCount , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.DrawIndexedPrimitiveStrided(idd, dptPrimitiveType, dwVertexTypeDesc, lpVertexArray, dwVertexCount, lpwIndices, dwIndexCount, dwFlags);
end;

function IDirect3DDevice7_DrawPrimitiveVB(idd : IDirect3DDevice7; dptPrimitiveType : TD3DPrimitiveType; lpd3dVertexBuffer : IDirect3DVertexBuffer7; dwStartVertex , dwNumVertices , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.DrawPrimitiveVB(idd, dptPrimitiveType, lpd3dVertexBuffer, dwStartVertex, dwNumVertices, dwFlags);
end;

function IDirect3DDevice7_DrawIndexedPrimitiveVB(idd : IDirect3DDevice7; dptPrimitiveType : TD3DPrimitiveType; lpd3dVertexBuffer : IDirect3DVertexBuffer7; dwStartVertex , dwNumVertices : DWORD; var lpwIndices : WORD; dwIndexCount , dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.DrawIndexedPrimitiveVB(idd, dptPrimitiveType, lpd3dVertexBuffer, dwStartVertex, dwNumVertices, lpwIndices, dwIndexCount, dwFlags);
end;

function IDirect3DDevice7_ComputeSphereVisibility(idd : IDirect3DDevice7; const lpCenters : TD3DVector; var lpRadii : TD3DValue; dwNumSpheres , dwFlags : DWORD; var lpdwReturnValues : DWORD) : HResult; stdcall;
begin
	result := idd^^.ComputeSphereVisibility(idd, lpCenters, lpRadii, dwNumSpheres, dwFlags, lpdwReturnValues);
end;

function IDirect3DDevice7_GetTexture(idd : IDirect3DDevice7; dwStage : DWORD; var lplpTexture : IDirectDrawSurface7) : HResult; stdcall;
begin
	result := idd^^.GetTexture(idd, dwStage, lplpTexture);
end;

function IDirect3DDevice7_SetTexture(idd : IDirect3DDevice7; dwStage : DWORD; lpTexture : IDirectDrawSurface7) : HResult; stdcall;
begin
	result := idd^^.SetTexture(idd, dwStage, lpTexture);
end;

function IDirect3DDevice7_GetTextureStageState(idd : IDirect3DDevice7; dwStage : DWORD; dwState : TD3DTextureStageStateType; var lpdwValue : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetTextureStageState(idd, dwStage, dwState, lpdwValue);
end;

function IDirect3DDevice7_SetTextureStageState(idd : IDirect3DDevice7; dwStage : DWORD; dwState : TD3DTextureStageStateType; lpdwValue : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetTextureStageState(idd, dwStage, dwState, lpdwValue);
end;

function IDirect3DDevice7_ValidateDevice(idd : IDirect3DDevice7; var lpdwExtraPasses : DWORD) : HResult; stdcall;
begin
	result := idd^^.ValidateDevice(idd, lpdwExtraPasses);
end;

function IDirect3DDevice7_ApplyStateBlock(idd : IDirect3DDevice7; dwBlockHandle : DWORD) : HResult; stdcall;
begin
	result := idd^^.ApplyStateBlock(idd, dwBlockHandle);
end;

function IDirect3DDevice7_CaptureStateBlock(idd : IDirect3DDevice7; dwBlockHandle : DWORD) : HResult; stdcall;
begin
	result := idd^^.CaptureStateBlock(idd, dwBlockHandle);
end;

function IDirect3DDevice7_DeleteStateBlock(idd : IDirect3DDevice7; dwBlockHandle : DWORD) : HResult; stdcall;
begin
	result := idd^^.DeleteStateBlock(idd, dwBlockHandle);
end;

function IDirect3DDevice7_CreateStateBlock(idd : IDirect3DDevice7; d3dsbType : TD3DStateBlockType; var lpdwBlockHandle : DWORD) : HResult; stdcall;
begin
	result := idd^^.CreateStateBlock(idd, d3dsbType, lpdwBlockHandle);
end;

function IDirect3DDevice7_Load(idd : IDirect3DDevice7; lpDestTex : IDirectDrawSurface7; lpDestPoint : PPoint; lpSrcTex : IDirectDrawSurface7; lprcSrcRect : PRect; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Load(idd, lpDestTex, lpDestPoint, lpSrcTex, lprcSrcRect, dwFlags);
end;

function IDirect3DDevice7_LightEnable(idd : IDirect3DDevice7; dwLightIndex : DWORD; bEnable : BOOL) : HResult; stdcall;
begin
	result := idd^^.LightEnable(idd, dwLightIndex, bEnable);
end;

function IDirect3DDevice7_GetLightEnable(idd : IDirect3DDevice7; dwLightIndex : DWORD; var bEnable : BOOL) : HResult; stdcall;
begin
	result := idd^^.GetLightEnable(idd, dwLightIndex, bEnable);
end;

function IDirect3DDevice7_SetClipPlane(idd : IDirect3DDevice7; dwIndex : DWORD; var pPlaneEquation : TD3DValue) : HResult; stdcall;
begin
	result := idd^^.SetClipPlane(idd, dwIndex, pPlaneEquation);
end;

function IDirect3DDevice7_GetClipPlane(idd : IDirect3DDevice7; dwIndex : DWORD; var pPlaneEquation : TD3DValue) : HResult; stdcall;
begin
	result := idd^^.GetClipPlane(idd, dwIndex, pPlaneEquation);
end;

function IDirect3DDevice7_GetInfo(idd : IDirect3DDevice7; dwDevInfoID : DWORD; pDevInfoStruct : Pointer; dwSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetInfo(idd, dwDevInfoID, pDevInfoStruct, dwSize);
end;


// IDirect3DExecuteBuffer interface methods

function IDirect3DExecuteBuffer_QueryInterface(idd : IDirect3DExecuteBuffer; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DExecuteBuffer_AddRef(idd : IDirect3DExecuteBuffer) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DExecuteBuffer_Release(idd : IDirect3DExecuteBuffer) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DExecuteBuffer_Initialize(idd : IDirect3DExecuteBuffer; lpDirect3DDevice : IDirect3DDevice; var lpDesc : TD3DExecuteBufferDesc) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpDirect3DDevice, lpDesc);
end;

function IDirect3DExecuteBuffer_Lock(idd : IDirect3DExecuteBuffer; var lpDesc : TD3DExecuteBufferDesc) : HResult; stdcall;
begin
	result := idd^^.Lock(idd, lpDesc);
end;

function IDirect3DExecuteBuffer_Unlock(idd : IDirect3DExecuteBuffer) : HResult; stdcall;
begin
	result := idd^^.Unlock(idd);
end;

function IDirect3DExecuteBuffer_SetExecuteData(idd : IDirect3DExecuteBuffer; var lpData : TD3DExecuteData) : HResult; stdcall;
begin
	result := idd^^.SetExecuteData(idd, lpData);
end;

function IDirect3DExecuteBuffer_GetExecuteData(idd : IDirect3DExecuteBuffer; var lpData : TD3DExecuteData) : HResult; stdcall;
begin
	result := idd^^.GetExecuteData(idd, lpData);
end;

function IDirect3DExecuteBuffer_Validate(idd : IDirect3DExecuteBuffer; var lpdwOffset : DWORD; lpFunc : TD3DValidateCallback; lpUserArg : Pointer; dwReserved : DWORD) : HResult; stdcall;
begin
	result := idd^^.Validate(idd, lpdwOffset, @lpFunc, lpUserArg, dwReserved);
end;

function IDirect3DExecuteBuffer_Optimize(idd : IDirect3DExecuteBuffer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Optimize(idd, dwFlags);
end;


// IDirect3DLight interface methods

function IDirect3DLight_QueryInterface(idd : IDirect3DLight; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DLight_AddRef(idd : IDirect3DLight) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DLight_Release(idd : IDirect3DLight) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DLight_Initialize(idd : IDirect3DLight; lpDirect3D : IDirect3D) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpDirect3D);
end;

function IDirect3DLight_SetLight(idd : IDirect3DLight; var lpLight : TD3DLight2) : HResult; stdcall;
begin
	result := idd^^.SetLight(idd, lpLight);
end;

function IDirect3DLight_GetLight(idd : IDirect3DLight; var lpLight : TD3DLight2) : HResult; stdcall;
begin
	result := idd^^.GetLight(idd, lpLight);
end;


// IDirect3DMaterial interface methods

function IDirect3DMaterial_QueryInterface(idd : IDirect3DMaterial; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DMaterial_AddRef(idd : IDirect3DMaterial) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DMaterial_Release(idd : IDirect3DMaterial) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DMaterial_Initialize(idd : IDirect3DMaterial; lpDirect3D : IDirect3D) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpDirect3D);
end;

function IDirect3DMaterial_SetMaterial(idd : IDirect3DMaterial; var lpMat : TD3DMaterial) : HResult; stdcall;
begin
	result := idd^^.SetMaterial(idd, lpMat);
end;

function IDirect3DMaterial_GetMaterial(idd : IDirect3DMaterial; var lpMat : TD3DMaterial) : HResult; stdcall;
begin
	result := idd^^.GetMaterial(idd, lpMat);
end;

function IDirect3DMaterial_GetHandle(idd : IDirect3DMaterial; lpDirect3DDevice : IDirect3DDevice; var lpHandle : TD3DMaterialHandle) : HResult; stdcall;
begin
	result := idd^^.GetHandle(idd, lpDirect3DDevice, lpHandle);
end;

function IDirect3DMaterial_Reserve(idd : IDirect3DMaterial) : HResult; stdcall;
begin
	result := idd^^.Reserve(idd);
end;

function IDirect3DMaterial_Unreserve(idd : IDirect3DMaterial) : HResult; stdcall;
begin
	result := idd^^.Unreserve(idd);
end;


// IDirect3DMaterial2 interface methods

function IDirect3DMaterial2_QueryInterface(idd : IDirect3DMaterial2; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DMaterial2_AddRef(idd : IDirect3DMaterial2) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DMaterial2_Release(idd : IDirect3DMaterial2) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DMaterial2_SetMaterial(idd : IDirect3DMaterial2; var lpMat : TD3DMaterial) : HResult; stdcall;
begin
	result := idd^^.SetMaterial(idd, lpMat);
end;

function IDirect3DMaterial2_GetMaterial(idd : IDirect3DMaterial2; var lpMat : TD3DMaterial) : HResult; stdcall;
begin
	result := idd^^.GetMaterial(idd, lpMat);
end;

function IDirect3DMaterial2_GetHandle(idd : IDirect3DMaterial2; lpDirect3DDevice : IDirect3DDevice2; var lpHandle : TD3DMaterialHandle) : HResult; stdcall;
begin
	result := idd^^.GetHandle(idd, lpDirect3DDevice, lpHandle);
end;


// IDirect3DMaterial3 interface methods

function IDirect3DMaterial3_QueryInterface(idd : IDirect3DMaterial3; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DMaterial3_AddRef(idd : IDirect3DMaterial3) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DMaterial3_Release(idd : IDirect3DMaterial3) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DMaterial3_SetMaterial(idd : IDirect3DMaterial3; var lpMat : TD3DMaterial) : HResult; stdcall;
begin
	result := idd^^.SetMaterial(idd, lpMat);
end;

function IDirect3DMaterial3_GetMaterial(idd : IDirect3DMaterial3; var lpMat : TD3DMaterial) : HResult; stdcall;
begin
	result := idd^^.GetMaterial(idd, lpMat);
end;

function IDirect3DMaterial3_GetHandle(idd : IDirect3DMaterial3; lpDirect3DDevice : IDirect3DDevice3; var lpHandle : TD3DMaterialHandle) : HResult; stdcall;
begin
	result := idd^^.GetHandle(idd, lpDirect3DDevice, lpHandle);
end;


// IDirect3DTexture interface methods

function IDirect3DTexture_QueryInterface(idd : IDirect3DTexture; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DTexture_AddRef(idd : IDirect3DTexture) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DTexture_Release(idd : IDirect3DTexture) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DTexture_Initialize(idd : IDirect3DTexture; lpD3DDevice : IDirect3DDevice; lpDDSurface : IDirectDrawSurface) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpD3DDevice, lpDDSurface);
end;

function IDirect3DTexture_GetHandle(idd : IDirect3DTexture; lpDirect3DDevice : IDirect3DDevice; var lpHandle : TD3DTextureHandle) : HResult; stdcall;
begin
	result := idd^^.GetHandle(idd, lpDirect3DDevice, lpHandle);
end;

function IDirect3DTexture_PaletteChanged(idd : IDirect3DTexture; dwStart : DWORD; dwCount : DWORD) : HResult; stdcall;
begin
	result := idd^^.PaletteChanged(idd, dwStart, dwCount);
end;

function IDirect3DTexture_Load(idd : IDirect3DTexture; lpD3DTexture : IDirect3DTexture) : HResult; stdcall;
begin
	result := idd^^.Load(idd, lpD3DTexture);
end;

function IDirect3DTexture_Unload(idd : IDirect3DTexture) : HResult; stdcall;
begin
	result := idd^^.Unload(idd);
end;


// IDirect3DTexture2 interface methods

function IDirect3DTexture2_QueryInterface(idd : IDirect3DTexture2; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DTexture2_AddRef(idd : IDirect3DTexture2) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DTexture2_Release(idd : IDirect3DTexture2) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DTexture2_GetHandle(idd : IDirect3DTexture2; lpDirect3DDevice : IDirect3DDevice2; var lpHandle : TD3DTextureHandle) : HResult; stdcall;
begin
	result := idd^^.GetHandle(idd, lpDirect3DDevice, lpHandle);
end;

function IDirect3DTexture2_PaletteChanged(idd : IDirect3DTexture2; dwStart : DWORD; dwCount : DWORD) : HResult; stdcall;
begin
	result := idd^^.PaletteChanged(idd, dwStart, dwCount);
end;

function IDirect3DTexture2_Load(idd : IDirect3DTexture2; lpD3DTexture : IDirect3DTexture2) : HResult; stdcall;
begin
	result := idd^^.Load(idd, lpD3DTexture);
end;


// IDirect3DViewport interface methods

function IDirect3DViewport_QueryInterface(idd : IDirect3DViewport; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DViewport_AddRef(idd : IDirect3DViewport) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DViewport_Release(idd : IDirect3DViewport) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DViewport_Initialize(idd : IDirect3DViewport; lpDirect3D : IDirect3D) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpDirect3D);
end;

function IDirect3DViewport_GetViewport(idd : IDirect3DViewport; var lpData : TD3DViewport) : HResult; stdcall;
begin
	result := idd^^.GetViewport(idd, lpData);
end;

function IDirect3DViewport_SetViewport(idd : IDirect3DViewport; const lpData : TD3DViewport) : HResult; stdcall;
begin
	result := idd^^.SetViewport(idd, lpData);
end;

function IDirect3DViewport_TransformVertices(idd : IDirect3DViewport; dwVertexCount : DWORD; const lpData : TD3DTransformData; dwFlags : DWORD; var lpOffscreen : DWORD) : HResult; stdcall;
begin
	result := idd^^.TransformVertices(idd, dwVertexCount, lpData, dwFlags, lpOffscreen);
end;

function IDirect3DViewport_LightElements(idd : IDirect3DViewport; dwElementCount : DWORD; var lpData : TD3DLightData) : HResult; stdcall;
begin
	result := idd^^.LightElements(idd, dwElementCount, lpData);
end;

function IDirect3DViewport_SetBackground(idd : IDirect3DViewport; hMat : TD3DMaterialHandle) : HResult; stdcall;
begin
	result := idd^^.SetBackground(idd, hMat);
end;

function IDirect3DViewport_GetBackground(idd : IDirect3DViewport; var hMat : TD3DMaterialHandle) : HResult; stdcall;
begin
	result := idd^^.GetBackground(idd, hMat);
end;

function IDirect3DViewport_SetBackgroundDepth(idd : IDirect3DViewport; lpDDSurface : IDirectDrawSurface) : HResult; stdcall;
begin
	result := idd^^.SetBackgroundDepth(idd, lpDDSurface);
end;

function IDirect3DViewport_GetBackgroundDepth(idd : IDirect3DViewport; var lplpDDSurface : IDirectDrawSurface; var lpValid : BOOL) : HResult; stdcall;
begin
	result := idd^^.GetBackgroundDepth(idd, lplpDDSurface, lpValid);
end;

function IDirect3DViewport_Clear(idd : IDirect3DViewport; dwCount : DWORD; const lpRects : TD3DRect; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Clear(idd, dwCount, lpRects, dwFlags);
end;

function IDirect3DViewport_AddLight(idd : IDirect3DViewport; lpDirect3DLight : IDirect3DLight) : HResult; stdcall;
begin
	result := idd^^.AddLight(idd, lpDirect3DLight);
end;

function IDirect3DViewport_DeleteLight(idd : IDirect3DViewport; lpDirect3DLight : IDirect3DLight) : HResult; stdcall;
begin
	result := idd^^.DeleteLight(idd, lpDirect3DLight);
end;

function IDirect3DViewport_NextLight(idd : IDirect3DViewport; lpDirect3DLight : IDirect3DLight; var lplpDirect3DLight : IDirect3DLight; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.NextLight(idd, lpDirect3DLight, lplpDirect3DLight, dwFlags);
end;


// IDirect3DViewport2 interface methods

function IDirect3DViewport2_QueryInterface(idd : IDirect3DViewport2; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DViewport2_AddRef(idd : IDirect3DViewport2) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DViewport2_Release(idd : IDirect3DViewport2) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DViewport2_Initialize(idd : IDirect3DViewport2; lpDirect3D : IDirect3D) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpDirect3D);
end;

function IDirect3DViewport2_GetViewport(idd : IDirect3DViewport2; var lpData : TD3DViewport) : HResult; stdcall;
begin
	result := idd^^.GetViewport(idd, lpData);
end;

function IDirect3DViewport2_SetViewport(idd : IDirect3DViewport2; const lpData : TD3DViewport) : HResult; stdcall;
begin
	result := idd^^.SetViewport(idd, lpData);
end;

function IDirect3DViewport2_TransformVertices(idd : IDirect3DViewport2; dwVertexCount : DWORD; const lpData : TD3DTransformData; dwFlags : DWORD; var lpOffscreen : DWORD) : HResult; stdcall;
begin
	result := idd^^.TransformVertices(idd, dwVertexCount, lpData, dwFlags, lpOffscreen);
end;

function IDirect3DViewport2_LightElements(idd : IDirect3DViewport2; dwElementCount : DWORD; var lpData : TD3DLightData) : HResult; stdcall;
begin
	result := idd^^.LightElements(idd, dwElementCount, lpData);
end;

function IDirect3DViewport2_SetBackground(idd : IDirect3DViewport2; hMat : TD3DMaterialHandle) : HResult; stdcall;
begin
	result := idd^^.SetBackground(idd, hMat);
end;

function IDirect3DViewport2_GetBackground(idd : IDirect3DViewport2; var hMat : TD3DMaterialHandle) : HResult; stdcall;
begin
	result := idd^^.GetBackground(idd, hMat);
end;

function IDirect3DViewport2_SetBackgroundDepth(idd : IDirect3DViewport2; lpDDSurface : IDirectDrawSurface) : HResult; stdcall;
begin
	result := idd^^.SetBackgroundDepth(idd, lpDDSurface);
end;

function IDirect3DViewport2_GetBackgroundDepth(idd : IDirect3DViewport2; var lplpDDSurface : IDirectDrawSurface; var lpValid : BOOL) : HResult; stdcall;
begin
	result := idd^^.GetBackgroundDepth(idd, lplpDDSurface, lpValid);
end;

function IDirect3DViewport2_Clear(idd : IDirect3DViewport2; dwCount : DWORD; const lpRects : TD3DRect; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Clear(idd, dwCount, lpRects, dwFlags);
end;

function IDirect3DViewport2_AddLight(idd : IDirect3DViewport2; lpDirect3DLight : IDirect3DLight) : HResult; stdcall;
begin
	result := idd^^.AddLight(idd, lpDirect3DLight);
end;

function IDirect3DViewport2_DeleteLight(idd : IDirect3DViewport2; lpDirect3DLight : IDirect3DLight) : HResult; stdcall;
begin
	result := idd^^.DeleteLight(idd, lpDirect3DLight);
end;

function IDirect3DViewport2_NextLight(idd : IDirect3DViewport2; lpDirect3DLight : IDirect3DLight; var lplpDirect3DLight : IDirect3DLight; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.NextLight(idd, lpDirect3DLight, lplpDirect3DLight, dwFlags);
end;

function IDirect3DViewport2_GetViewport2(idd : IDirect3DViewport2; var lpData : TD3DViewport2) : HResult; stdcall;
begin
	result := idd^^.GetViewport2(idd, lpData);
end;

function IDirect3DViewport2_SetViewport2(idd : IDirect3DViewport2; const lpData : TD3DViewport2) : HResult; stdcall;
begin
	result := idd^^.SetViewport2(idd, lpData);
end;


// IDirect3DViewport3 interface methods

function IDirect3DViewport3_QueryInterface(idd : IDirect3DViewport3; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DViewport3_AddRef(idd : IDirect3DViewport3) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DViewport3_Release(idd : IDirect3DViewport3) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DViewport3_Initialize(idd : IDirect3DViewport3; lpDirect3D : IDirect3D) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, lpDirect3D);
end;

function IDirect3DViewport3_GetViewport(idd : IDirect3DViewport3; var lpData : TD3DViewport) : HResult; stdcall;
begin
	result := idd^^.GetViewport(idd, lpData);
end;

function IDirect3DViewport3_SetViewport(idd : IDirect3DViewport3; const lpData : TD3DViewport) : HResult; stdcall;
begin
	result := idd^^.SetViewport(idd, lpData);
end;

function IDirect3DViewport3_TransformVertices(idd : IDirect3DViewport3; dwVertexCount : DWORD; const lpData : TD3DTransformData; dwFlags : DWORD; var lpOffscreen : DWORD) : HResult; stdcall;
begin
	result := idd^^.TransformVertices(idd, dwVertexCount, lpData, dwFlags, lpOffscreen);
end;

function IDirect3DViewport3_LightElements(idd : IDirect3DViewport3; dwElementCount : DWORD; var lpData : TD3DLightData) : HResult; stdcall;
begin
	result := idd^^.LightElements(idd, dwElementCount, lpData);
end;

function IDirect3DViewport3_SetBackground(idd : IDirect3DViewport3; hMat : TD3DMaterialHandle) : HResult; stdcall;
begin
	result := idd^^.SetBackground(idd, hMat);
end;

function IDirect3DViewport3_GetBackground(idd : IDirect3DViewport3; var hMat : TD3DMaterialHandle) : HResult; stdcall;
begin
	result := idd^^.GetBackground(idd, hMat);
end;

function IDirect3DViewport3_SetBackgroundDepth(idd : IDirect3DViewport3; lpDDSurface : IDirectDrawSurface) : HResult; stdcall;
begin
	result := idd^^.SetBackgroundDepth(idd, lpDDSurface);
end;

function IDirect3DViewport3_GetBackgroundDepth(idd : IDirect3DViewport3; var lplpDDSurface : IDirectDrawSurface; var lpValid : BOOL) : HResult; stdcall;
begin
	result := idd^^.GetBackgroundDepth(idd, lplpDDSurface, lpValid);
end;

function IDirect3DViewport3_Clear(idd : IDirect3DViewport3; dwCount : DWORD; const lpRects : TD3DRect; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Clear(idd, dwCount, lpRects, dwFlags);
end;

function IDirect3DViewport3_AddLight(idd : IDirect3DViewport3; lpDirect3DLight : IDirect3DLight) : HResult; stdcall;
begin
	result := idd^^.AddLight(idd, lpDirect3DLight);
end;

function IDirect3DViewport3_DeleteLight(idd : IDirect3DViewport3; lpDirect3DLight : IDirect3DLight) : HResult; stdcall;
begin
	result := idd^^.DeleteLight(idd, lpDirect3DLight);
end;

function IDirect3DViewport3_NextLight(idd : IDirect3DViewport3; lpDirect3DLight : IDirect3DLight; var lplpDirect3DLight : IDirect3DLight; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.NextLight(idd, lpDirect3DLight, lplpDirect3DLight, dwFlags);
end;

function IDirect3DViewport3_GetViewport2(idd : IDirect3DViewport3; var lpData : TD3DViewport2) : HResult; stdcall;
begin
	result := idd^^.GetViewport2(idd, lpData);
end;

function IDirect3DViewport3_SetViewport2(idd : IDirect3DViewport3; const lpData : TD3DViewport2) : HResult; stdcall;
begin
	result := idd^^.SetViewport2(idd, lpData);
end;

function IDirect3DViewport3_SetBackgroundDepth2(idd : IDirect3DViewport3; lpDDSurface : IDirectDrawSurface4) : HResult; stdcall;
begin
	result := idd^^.SetBackgroundDepth2(idd, lpDDSurface);
end;

function IDirect3DViewport3_GetBackgroundDepth2(idd : IDirect3DViewport3; var lplpDDSurface : IDirectDrawSurface4; var lpValid : BOOL) : HResult; stdcall;
begin
	result := idd^^.GetBackgroundDepth2(idd, lplpDDSurface, lpValid);
end;

function IDirect3DViewport3_Clear2(idd : IDirect3DViewport3; dwCount : DWORD; const lpRects : TD3DRect; dwFlags : DWORD; dwColor : DWORD; dvZ : TD3DValue; dwStencil : DWORD) : HResult; stdcall;
begin
	result := idd^^.Clear2(idd, dwCount, lpRects, dwFlags, dwColor, dvZ, dwStencil);
end;


// IDirect3DVertexBuffer interface methods

function IDirect3DVertexBuffer_QueryInterface(idd : IDirect3DVertexBuffer; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DVertexBuffer_AddRef(idd : IDirect3DVertexBuffer) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DVertexBuffer_Release(idd : IDirect3DVertexBuffer) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DVertexBuffer_Lock(idd : IDirect3DVertexBuffer; dwFlags : DWORD; var lplpData : pointer; var lpdwSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.Lock(idd, dwFlags, lplpData, lpdwSize);
end;

function IDirect3DVertexBuffer_Unlock(idd : IDirect3DVertexBuffer) : HResult; stdcall;
begin
	result := idd^^.Unlock(idd);
end;

function IDirect3DVertexBuffer_ProcessVertices(idd : IDirect3DVertexBuffer; dwVertexOp , dwDestIndex , dwCount : DWORD; lpSrcBuffer : IDirect3DVertexBuffer; dwSrcIndex : DWORD; lpD3DDevice : IDirect3DDevice3; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.ProcessVertices(idd, dwVertexOp, dwDestIndex, dwCount, lpSrcBuffer, dwSrcIndex, lpD3DDevice, dwFlags);
end;

function IDirect3DVertexBuffer_GetVertexBufferDesc(idd : IDirect3DVertexBuffer; var lpVBDesc : TD3DVertexBufferDesc) : HResult; stdcall;
begin
	result := idd^^.GetVertexBufferDesc(idd, lpVBDesc);
end;

function IDirect3DVertexBuffer_Optimize(idd : IDirect3DVertexBuffer; lpD3DDevice : IDirect3DDevice3; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Optimize(idd, lpD3DDevice, dwFlags);
end;


// IDirect3DVertexBuffer7 interface methods

function IDirect3DVertexBuffer7_QueryInterface(idd : IDirect3DVertexBuffer7; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirect3DVertexBuffer7_AddRef(idd : IDirect3DVertexBuffer7) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirect3DVertexBuffer7_Release(idd : IDirect3DVertexBuffer7) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirect3DVertexBuffer7_Lock(idd : IDirect3DVertexBuffer7; dwFlags : DWORD; var lplpData : Pointer; var lpdwSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.Lock(idd, dwFlags, lplpData, lpdwSize);
end;

function IDirect3DVertexBuffer7_Unlock(idd : IDirect3DVertexBuffer7) : HResult; stdcall;
begin
	result := idd^^.Unlock(idd);
end;

function IDirect3DVertexBuffer7_ProcessVertices(idd : IDirect3DVertexBuffer7; dwVertexOp , dwDestIndex , dwCount : DWORD; lpSrcBuffer : IDirect3DVertexBuffer7; dwSrcIndex : DWORD; lpD3DDevice : IDirect3DDevice7; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.ProcessVertices(idd, dwVertexOp, dwDestIndex, dwCount, lpSrcBuffer, dwSrcIndex, lpD3DDevice, dwFlags);
end;

function IDirect3DVertexBuffer7_GetVertexBufferDesc(idd : IDirect3DVertexBuffer7; var lpVBDesc : TD3DVertexBufferDesc) : HResult; stdcall;
begin
	result := idd^^.GetVertexBufferDesc(idd, lpVBDesc);
end;

function IDirect3DVertexBuffer7_Optimize(idd : IDirect3DVertexBuffer7; lpD3DDevice : IDirect3DDevice7; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Optimize(idd, lpD3DDevice, dwFlags);
end;

function IDirect3DVertexBuffer7_ProcessVerticesStrided(idd : IDirect3DVertexBuffer7; dwVertexOp , dwDestIndex , dwCount : DWORD; lpVertexArray : TD3DDrawPrimitiveStridedData; dwVertexTypeDesc : DWORD; lpD3DDevice : IDirect3DDevice7; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.ProcessVerticesStrided(idd, dwVertexOp, dwDestIndex, dwCount, lpVertexArray, dwVertexTypeDesc, lpD3DDevice, dwFlags);
end;


// IDirectXFile interface methods

function IDirectXFile_QueryInterface(idd : IDirectXFile; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirectXFile_AddRef(idd : IDirectXFile) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectXFile_Release(idd : IDirectXFile) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectXFile_CreateEnumObject(idd : IDirectXFile; pvSource : Pointer; dwLoadOptions : TDXFileLoadOptions; var ppEnumObj : IDirectXFileEnumObject) : HResult; stdcall;
begin
	result := idd^^.CreateEnumObject(idd, pvSource, dwLoadOptions, ppEnumObj);
end;

function IDirectXFile_CreateSaveObject(idd : IDirectXFile; szFileName : PChar; dwFileFormat : TDXFileFormat; var ppSaveObj : IDirectXFileSaveObject) : HResult; stdcall;
begin
	result := idd^^.CreateSaveObject(idd, szFileName, dwFileFormat, ppSaveObj);
end;

function IDirectXFile_RegisterTemplates(idd : IDirectXFile; pvData : Pointer; cbSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.RegisterTemplates(idd, pvData, cbSize);
end;


// IDirectXFileEnumObject interface methods

function IDirectXFileEnumObject_QueryInterface(idd : IDirectXFileEnumObject; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirectXFileEnumObject_AddRef(idd : IDirectXFileEnumObject) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectXFileEnumObject_Release(idd : IDirectXFileEnumObject) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectXFileEnumObject_GetNextDataObject(idd : IDirectXFileEnumObject; var ppDataObj : IDirectXFileData) : HResult; stdcall;
begin
	result := idd^^.GetNextDataObject(idd, ppDataObj);
end;

function IDirectXFileEnumObject_GetDataObjectById(idd : IDirectXFileEnumObject; const rguid : TGUID; var ppDataObj : IDirectXFileData) : HResult; stdcall;
begin
	result := idd^^.GetDataObjectById(idd, rguid, ppDataObj);
end;

function IDirectXFileEnumObject_GetDataObjectByName(idd : IDirectXFileEnumObject; szName : PChar; var ppDataObj : IDirectXFileData) : HResult; stdcall;
begin
	result := idd^^.GetDataObjectByName(idd, szName, ppDataObj);
end;


// IDirectXFileSaveObject interface methods

function IDirectXFileSaveObject_QueryInterface(idd : IDirectXFileSaveObject; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirectXFileSaveObject_AddRef(idd : IDirectXFileSaveObject) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectXFileSaveObject_Release(idd : IDirectXFileSaveObject) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectXFileSaveObject_SaveTemplates(idd : IDirectXFileSaveObject; cTemplates : DWORD; var ppguidTemplates : PGUID) : HResult; stdcall;
begin
	result := idd^^.SaveTemplates(idd, cTemplates, ppguidTemplates);
end;

function IDirectXFileSaveObject_CreateDataObject(idd : IDirectXFileSaveObject; const rguidTemplate : TGUID; szName : PChar; pguid : PGUID; cbSize : DWORD; pvData : Pointer; var ppDataObj : IDirectXFileData) : HResult; stdcall;
begin
	result := idd^^.CreateDataObject(idd, rguidTemplate, szName, pguid, cbSize, pvData, ppDataObj);
end;

function IDirectXFileSaveObject_SaveData(idd : IDirectXFileSaveObject; pDataObj : IDirectXFileData) : HResult; stdcall;
begin
	result := idd^^.SaveData(idd, pDataObj);
end;


// IDirectXFileObject interface methods

function IDirectXFileObject_QueryInterface(idd : IDirectXFileObject; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirectXFileObject_AddRef(idd : IDirectXFileObject) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectXFileObject_Release(idd : IDirectXFileObject) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectXFileObject_GetName(idd : IDirectXFileObject; pstrNameBuf : PChar; var dwBufLen : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetName(idd, pstrNameBuf, dwBufLen);
end;

function IDirectXFileObject_GetId(idd : IDirectXFileObject; var pGuidBuf : TGUID) : HResult; stdcall;
begin
	result := idd^^.GetId(idd, pGuidBuf);
end;


// IDirectXFileData interface methods

function IDirectXFileData_QueryInterface(idd : IDirectXFileData; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirectXFileData_AddRef(idd : IDirectXFileData) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectXFileData_Release(idd : IDirectXFileData) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectXFileData_GetName(idd : IDirectXFileData; pstrNameBuf : PChar; var dwBufLen : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetName(idd, pstrNameBuf, dwBufLen);
end;

function IDirectXFileData_GetId(idd : IDirectXFileData; var pGuidBuf : TGUID) : HResult; stdcall;
begin
	result := idd^^.GetId(idd, pGuidBuf);
end;

function IDirectXFileData_GetData(idd : IDirectXFileData; szMember : PChar; var pcbSize : DWORD; var ppvData : Pointer) : HResult; stdcall;
begin
	result := idd^^.GetData(idd, szMember, pcbSize, ppvData);
end;

function IDirectXFileData_GetType(idd : IDirectXFileData; var ppguid : PGUID) : HResult; stdcall;
begin
	result := idd^^.GetType(idd, ppguid);
end;

function IDirectXFileData_GetNextObject(idd : IDirectXFileData; var ppChildObj : IDirectXFileObject) : HResult; stdcall;
begin
	result := idd^^.GetNextObject(idd, ppChildObj);
end;

function IDirectXFileData_AddDataObject(idd : IDirectXFileData; pDataObj : IDirectXFileData) : HResult; stdcall;
begin
	result := idd^^.AddDataObject(idd, pDataObj);
end;

function IDirectXFileData_AddDataReference(idd : IDirectXFileData; szRef : PChar; pguidRef : PGUID) : HResult; stdcall;
begin
	result := idd^^.AddDataReference(idd, szRef, pguidRef);
end;

function IDirectXFileData_AddBinaryObject(idd : IDirectXFileData; szName : PChar; pguid : PGUID; szMimeType : PChar; pvData : Pointer; cbSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.AddBinaryObject(idd, szName, pguid, szMimeType, pvData, cbSize);
end;


// IDirectXFileDataReference interface methods

function IDirectXFileDataReference_QueryInterface(idd : IDirectXFileDataReference; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirectXFileDataReference_AddRef(idd : IDirectXFileDataReference) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectXFileDataReference_Release(idd : IDirectXFileDataReference) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectXFileDataReference_GetName(idd : IDirectXFileDataReference; pstrNameBuf : PChar; var dwBufLen : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetName(idd, pstrNameBuf, dwBufLen);
end;

function IDirectXFileDataReference_GetId(idd : IDirectXFileDataReference; var pGuidBuf : TGUID) : HResult; stdcall;
begin
	result := idd^^.GetId(idd, pGuidBuf);
end;

function IDirectXFileDataReference_Resolve(idd : IDirectXFileDataReference; var ppDataObj : IDirectXFileData) : HResult; stdcall;
begin
	result := idd^^.Resolve(idd, ppDataObj);
end;


// IDirectXFileBinary interface methods

function IDirectXFileBinary_QueryInterface(idd : IDirectXFileBinary; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirectXFileBinary_AddRef(idd : IDirectXFileBinary) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectXFileBinary_Release(idd : IDirectXFileBinary) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectXFileBinary_GetName(idd : IDirectXFileBinary; pstrNameBuf : PChar; var dwBufLen : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetName(idd, pstrNameBuf, dwBufLen);
end;

function IDirectXFileBinary_GetId(idd : IDirectXFileBinary; var pGuidBuf : TGUID) : HResult; stdcall;
begin
	result := idd^^.GetId(idd, pGuidBuf);
end;

function IDirectXFileBinary_GetSize(idd : IDirectXFileBinary; var pcbSize : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetSize(idd, pcbSize);
end;

function IDirectXFileBinary_GetMimeType(idd : IDirectXFileBinary; var pszMimeType : PChar) : HResult; stdcall;
begin
	result := idd^^.GetMimeType(idd, pszMimeType);
end;

function IDirectXFileBinary_Read(idd : IDirectXFileBinary; pvData : Pointer; cbSize : DWORD; pcbRead : PDWORD) : HResult; stdcall;
begin
	result := idd^^.Read(idd, pvData, cbSize, pcbRead);
end;


begin
end.
