unit DirectInputFPC;

{$I SWITCHES.INC}

interface

uses
	windows, DirectDraw, DirectInput, ole2;


// IDirectInputEffect interface methods

function IDirectInputEffect_QueryInterface(idd : IDirectInputEffect; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirectInputEffect_AddRef(idd : IDirectInputEffect) : Longint; stdcall;
function IDirectInputEffect_Release(idd : IDirectInputEffect) : Longint; stdcall;
function IDirectInputEffect_Initialize(idd : IDirectInputEffect; hinst : THandle; dwVersion : DWORD; const rguid : TGUID) : HResult; stdcall;
function IDirectInputEffect_GetEffectGuid(idd : IDirectInputEffect; var pguid : TGUID) : HResult; stdcall;
function IDirectInputEffect_GetParameters(idd : IDirectInputEffect; var peff : TDIEffect; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputEffect_SetParameters(idd : IDirectInputEffect; var peff : TDIEffect; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputEffect_Start(idd : IDirectInputEffect; dwIterations : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputEffect_Stop(idd : IDirectInputEffect) : HResult; stdcall;
function IDirectInputEffect_GetEffectStatus(idd : IDirectInputEffect; var pdwFlags : DWORD) : HResult; stdcall;
function IDirectInputEffect_Download(idd : IDirectInputEffect) : HResult; stdcall;
function IDirectInputEffect_Unload(idd : IDirectInputEffect) : HResult; stdcall;
function IDirectInputEffect_Escape(idd : IDirectInputEffect; var pesc : TDIEffEscape) : HResult; stdcall;

// IDirectInputDeviceAW interface methods

function IDirectInputDevice_AddRef(idd : IDirectInputDeviceAW) : Longint; stdcall;
function IDirectInputDevice_Release(idd : IDirectInputDeviceAW) : Longint; stdcall;
function IDirectInputDevice_GetCapabilities(idd : IDirectInputDeviceAW; var lpDIDevCaps : TDIDevCaps) : HResult; stdcall;
function IDirectInputDevice_EnumObjects(idd : IDirectInputDeviceAW; lpCallback : TDIEnumDeviceObjectsCallbackA; pvRef : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputDevice_GetProperty(idd : IDirectInputDeviceAW; rguidProp : PGUID; var pdiph : TDIPropHeader) : HResult; stdcall;
function IDirectInputDevice_SetProperty(idd : IDirectInputDeviceAW; rguidProp : PGUID; const pdiph : TDIPropHeader) : HResult; stdcall;
function IDirectInputDevice_Acquire(idd : IDirectInputDeviceAW) : HResult; stdcall;
function IDirectInputDevice_Unacquire(idd : IDirectInputDeviceAW) : HResult; stdcall;
function IDirectInputDevice_GetDeviceState(idd : IDirectInputDeviceAW; cbData : DWORD; lpvData : Pointer) : HResult; stdcall;
function IDirectInputDevice_GetDeviceData(idd : IDirectInputDeviceAW; cbObjectData : DWORD; rgdod : PDIDeviceObjectData; var pdwInOut : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputDevice_SetDataFormat(idd : IDirectInputDeviceAW; var lpdf : TDIDataFormat) : HResult; stdcall;
function IDirectInputDevice_SetEventNotification(idd : IDirectInputDeviceAW; hEvent : THandle) : HResult; stdcall;
function IDirectInputDevice_SetCooperativeLevel(idd : IDirectInputDeviceAW; hwnd : HWND; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputDevice_GetObjectInfo(idd : IDirectInputDeviceAW; var pdidoi : TDIDeviceObjectInstanceA; dwObj : DWORD; dwHow : DWORD) : HResult; stdcall;
function IDirectInputDevice_GetDeviceInfo(idd : IDirectInputDeviceAW; var pdidi : TDIDeviceInstanceA) : HResult; stdcall;
function IDirectInputDevice_RunControlPanel(idd : IDirectInputDeviceAW; hwndOwner : HWND; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputDevice_Initialize(idd : IDirectInputDeviceAW; hinst : THandle; dwVersion : DWORD; const rguid : TGUID) : HResult; stdcall;

// IDirectInputDeviceA interface methods


// IDirectInputDeviceW interface methods


// IDirectInputDevice2AW interface methods

function IDirectInputDevice2_AddRef(idd : IDirectInputDevice2AW) : Longint; stdcall;
function IDirectInputDevice2_Release(idd : IDirectInputDevice2AW) : Longint; stdcall;
function IDirectInputDevice2_GetCapabilities(idd : IDirectInputDevice2AW; var lpDIDevCaps : TDIDevCaps) : HResult; stdcall;
function IDirectInputDevice2_EnumObjects(idd : IDirectInputDevice2AW; lpCallback : TDIEnumDeviceObjectsCallbackA; pvRef : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputDevice2_GetProperty(idd : IDirectInputDevice2AW; rguidProp : PGUID; var pdiph : TDIPropHeader) : HResult; stdcall;
function IDirectInputDevice2_SetProperty(idd : IDirectInputDevice2AW; rguidProp : PGUID; const pdiph : TDIPropHeader) : HResult; stdcall;
function IDirectInputDevice2_Acquire(idd : IDirectInputDevice2AW) : HResult; stdcall;
function IDirectInputDevice2_Unacquire(idd : IDirectInputDevice2AW) : HResult; stdcall;
function IDirectInputDevice2_GetDeviceState(idd : IDirectInputDevice2AW; cbData : DWORD; lpvData : Pointer) : HResult; stdcall;
function IDirectInputDevice2_GetDeviceData(idd : IDirectInputDevice2AW; cbObjectData : DWORD; rgdod : PDIDeviceObjectData; var pdwInOut : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputDevice2_SetDataFormat(idd : IDirectInputDevice2AW; var lpdf : TDIDataFormat) : HResult; stdcall;
function IDirectInputDevice2_SetEventNotification(idd : IDirectInputDevice2AW; hEvent : THandle) : HResult; stdcall;
function IDirectInputDevice2_SetCooperativeLevel(idd : IDirectInputDevice2AW; hwnd : HWND; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputDevice2_GetObjectInfo(idd : IDirectInputDevice2AW; var pdidoi : TDIDeviceObjectInstanceA; dwObj : DWORD; dwHow : DWORD) : HResult; stdcall;
function IDirectInputDevice2_GetDeviceInfo(idd : IDirectInputDevice2AW; var pdidi : TDIDeviceInstanceA) : HResult; stdcall;
function IDirectInputDevice2_RunControlPanel(idd : IDirectInputDevice2AW; hwndOwner : HWND; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputDevice2_Initialize(idd : IDirectInputDevice2AW; hinst : THandle; dwVersion : DWORD; const rguid : TGUID) : HResult; stdcall;
function IDirectInputDevice2_CreateEffect(idd : IDirectInputDevice2AW; const rguid : TGUID; lpeff : PDIEffect; var ppdeff : IDirectInputEffect; punkOuter : IUnknown) : HResult; stdcall;
function IDirectInputDevice2_EnumEffects(idd : IDirectInputDevice2AW; lpCallback : TDIEnumEffectsCallbackA; pvRef : pointer; dwEffType : DWORD) : HResult; stdcall;
function IDirectInputDevice2_GetEffectInfo(idd : IDirectInputDevice2AW; pdei : TDIEffectInfoA; const rguid : TGUID) : HResult; stdcall;
function IDirectInputDevice2_GetForceFeedbackState(idd : IDirectInputDevice2AW; var pdwOut : DWORD) : HResult; stdcall;
function IDirectInputDevice2_SendForceFeedbackCommand(idd : IDirectInputDevice2AW; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputDevice2_EnumCreatedEffectObjects(idd : IDirectInputDevice2AW; lpCallback : TDIEnumCreatedEffectObjectsCallback; pvRef : pointer; fl : DWORD) : HResult; stdcall;
function IDirectInputDevice2_Escape(idd : IDirectInputDevice2AW; var pesc : TDIEffEscape) : HResult; stdcall;
function IDirectInputDevice2_Poll(idd : IDirectInputDevice2AW) : HResult; stdcall;
function IDirectInputDevice2_SendDeviceData(idd : IDirectInputDevice2AW; cbObjectData : DWORD; var rgdod : TDIDeviceObjectData; var pdwInOut : DWORD; fl : DWORD) : HResult; stdcall;

// IDirectInputDevice2A interface methods


// IDirectInputDevice2W interface methods


// IDirectInputDevice7AW interface methods

function IDirectInputDevice7_AddRef(idd : IDirectInputDevice7AW) : Longint; stdcall;
function IDirectInputDevice7_Release(idd : IDirectInputDevice7AW) : Longint; stdcall;
function IDirectInputDevice7_GetCapabilities(idd : IDirectInputDevice7AW; var lpDIDevCaps : TDIDevCaps) : HResult; stdcall;
function IDirectInputDevice7_EnumObjects(idd : IDirectInputDevice7AW; lpCallback : TDIEnumDeviceObjectsCallbackW; pvRef : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputDevice7_GetProperty(idd : IDirectInputDevice7AW; rguidProp : PGUID; var pdiph : TDIPropHeader) : HResult; stdcall;
function IDirectInputDevice7_SetProperty(idd : IDirectInputDevice7AW; rguidProp : PGUID; var pdiph : TDIPropHeader) : HResult; stdcall;
function IDirectInputDevice7_Acquire(idd : IDirectInputDevice7AW) : HResult; stdcall;
function IDirectInputDevice7_Unacquire(idd : IDirectInputDevice7AW) : HResult; stdcall;
function IDirectInputDevice7_GetDeviceState(idd : IDirectInputDevice7AW; cbData : DWORD; lpvData : Pointer) : HResult; stdcall;
function IDirectInputDevice7_GetDeviceData(idd : IDirectInputDevice7AW; cbObjectData : DWORD; rgdod : PDIDeviceObjectData; var pdwInOut : DWORD; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputDevice7_SetDataFormat(idd : IDirectInputDevice7AW; var lpdf : TDIDataFormat) : HResult; stdcall;
function IDirectInputDevice7_SetEventNotification(idd : IDirectInputDevice7AW; hEvent : THandle) : HResult; stdcall;
function IDirectInputDevice7_SetCooperativeLevel(idd : IDirectInputDevice7AW; hwnd : HWND; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputDevice7_GetObjectInfo(idd : IDirectInputDevice7AW; var pdidoi : TDIDeviceObjectInstanceW; dwObj : DWORD; dwHow : DWORD) : HResult; stdcall;
function IDirectInputDevice7_GetDeviceInfo(idd : IDirectInputDevice7AW; var pdidi : TDIDeviceInstanceW) : HResult; stdcall;
function IDirectInputDevice7_RunControlPanel(idd : IDirectInputDevice7AW; hwndOwner : HWND; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputDevice7_Initialize(idd : IDirectInputDevice7AW; hinst : THandle; dwVersion : DWORD; const rguid : TGUID) : HResult; stdcall;
function IDirectInputDevice7_CreateEffect(idd : IDirectInputDevice7AW; const rguid : TGUID; lpeff : PDIEffect; var ppdeff : IDirectInputEffect; punkOuter : IUnknown) : HResult; stdcall;
function IDirectInputDevice7_EnumEffects(idd : IDirectInputDevice7AW; lpCallback : TDIEnumEffectsCallbackW; pvRef : pointer; dwEffType : DWORD) : HResult; stdcall;
function IDirectInputDevice7_GetEffectInfo(idd : IDirectInputDevice7AW; pdei : TDIEffectInfoW; const rguid : TGUID) : HResult; stdcall;
function IDirectInputDevice7_GetForceFeedbackState(idd : IDirectInputDevice7AW; var pdwOut : DWORD) : HResult; stdcall;
function IDirectInputDevice7_SendForceFeedbackCommand(idd : IDirectInputDevice7AW; dwFlags : DWORD) : HResult; stdcall;
function IDirectInputDevice7_EnumCreatedEffectObjects(idd : IDirectInputDevice7AW; lpCallback : TDIEnumCreatedEffectObjectsCallback; pvRef : pointer; fl : DWORD) : HResult; stdcall;
function IDirectInputDevice7_Escape(idd : IDirectInputDevice7AW; var pesc : TDIEffEscape) : HResult; stdcall;
function IDirectInputDevice7_Poll(idd : IDirectInputDevice7AW) : HResult; stdcall;
function IDirectInputDevice7_SendDeviceData(idd : IDirectInputDevice7AW; cbObjectData : DWORD; var rgdod : TDIDeviceObjectData; var pdwInOut : DWORD; fl : DWORD) : HResult; stdcall;
function IDirectInputDevice7_EnumEffectsInFile(idd : IDirectInputDevice7AW; const lpszFileName : PChar; pec : TEnumEffectsInFileCallback; pvRef : Pointer; dwFlags : DWord) : HResult; stdcall;
function IDirectInputDevice7_WriteEffectToFile(idd : IDirectInputDevice7AW; const lpszFileName : PChar; dwEntries : DWord; const rgDIFileEft : PDIFileEffect; dwFlags : DWord) : HResult; stdcall;

// IDirectInputDevice7W interface methods


// IDirectInputDevice7A interface methods


// IDirectInputAW interface methods

function IDirectInput_AddRef(idd : IDirectInputAW) : Longint; stdcall;
function IDirectInput_Release(idd : IDirectInputAW) : Longint; stdcall;
function IDirectInput_CreateDevice(idd : IDirectInputAW; const rguid : TGUID; var lplpDirectInputDevice : IDirectInputDeviceW; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirectInput_EnumDevices(idd : IDirectInputAW; dwDevType : DWORD; lpCallback : TDIEnumDevicesCallbackW; pvRef : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectInput_GetDeviceStatus(idd : IDirectInputAW; const rguidInstance : TGUID) : HResult; stdcall;
function IDirectInput_RunControlPanel(idd : IDirectInputAW; hwndOwner : HWND; dwFlags : DWORD) : HResult; stdcall;
function IDirectInput_Initialize(idd : IDirectInputAW; hinst : THandle; dwVersion : DWORD) : HResult; stdcall;

// IDirectInputW interface methods


// IDirectInputA interface methods


// IDirectInput2AW interface methods

function IDirectInput2_AddRef(idd : IDirectInput2AW) : Longint; stdcall;
function IDirectInput2_Release(idd : IDirectInput2AW) : Longint; stdcall;
function IDirectInput2_CreateDevice(idd : IDirectInput2AW; const rguid : TGUID; var lplpDirectInputDevice : IDirectInputDeviceW; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirectInput2_EnumDevices(idd : IDirectInput2AW; dwDevType : DWORD; lpCallback : TDIEnumDevicesCallbackW; pvRef : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectInput2_GetDeviceStatus(idd : IDirectInput2AW; const rguidInstance : TGUID) : HResult; stdcall;
function IDirectInput2_RunControlPanel(idd : IDirectInput2AW; hwndOwner : HWND; dwFlags : DWORD) : HResult; stdcall;
function IDirectInput2_Initialize(idd : IDirectInput2AW; hinst : THandle; dwVersion : DWORD) : HResult; stdcall;
function IDirectInput2_FindDevice(idd : IDirectInput2AW; const rguidClass : TGUID; ptszName : PWideChar; var pguidInstance : TGUID) : HResult; stdcall;

// IDirectInput2W interface methods


// IDirectInput2A interface methods


// IDirectInput7AW interface methods

function IDirectInput7_QueryInterface(idd : IDirectInput7AW; const IID : TGUID; var obj) : HRESULT; stdcall;
function IDirectInput7_AddRef(idd : IDirectInput7AW) : Longint; stdcall;
function IDirectInput7_Release(idd : IDirectInput7AW) : Longint; stdcall;
function IDirectInput7_CreateDevice(idd : IDirectInput7AW; const rguid : TGUID; var lplpDirectInputDevice : IDirectInputDeviceW; pUnkOuter : IUnknown) : HResult; stdcall;
function IDirectInput7_EnumDevices(idd : IDirectInput7AW; dwDevType : DWORD; lpCallback : TDIEnumDevicesCallbackW; pvRef : Pointer; dwFlags : DWORD) : HResult; stdcall;
function IDirectInput7_GetDeviceStatus(idd : IDirectInput7AW; const rguidInstance : TGUID) : HResult; stdcall;
function IDirectInput7_RunControlPanel(idd : IDirectInput7AW; hwndOwner : HWND; dwFlags : DWORD) : HResult; stdcall;
function IDirectInput7_Initialize(idd : IDirectInput7AW; hinst : THandle; dwVersion : DWORD) : HResult; stdcall;
function IDirectInput7_FindDevice(idd : IDirectInput7AW; const rguidClass : TGUID; ptszName : PWideChar; var pguidInstance : TGUID) : HResult; stdcall;
function IDirectInput7_CreateDeviceEx(idd : IDirectInput7AW; const rguid , riid : TGUID; var lplpDirectInputDevice; pUnkOuter : IUnknown) : HResult; stdcall;

// IDirectInput7W interface methods


// IDirectInput7A interface methods


implementation


// IDirectInputEffect interface methods

function IDirectInputEffect_QueryInterface(idd : IDirectInputEffect; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirectInputEffect_AddRef(idd : IDirectInputEffect) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectInputEffect_Release(idd : IDirectInputEffect) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectInputEffect_Initialize(idd : IDirectInputEffect; hinst : THandle; dwVersion : DWORD; const rguid : TGUID) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, hinst, dwVersion, rguid);
end;

function IDirectInputEffect_GetEffectGuid(idd : IDirectInputEffect; var pguid : TGUID) : HResult; stdcall;
begin
	result := idd^^.GetEffectGuid(idd, pguid);
end;

function IDirectInputEffect_GetParameters(idd : IDirectInputEffect; var peff : TDIEffect; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetParameters(idd, peff, dwFlags);
end;

function IDirectInputEffect_SetParameters(idd : IDirectInputEffect; var peff : TDIEffect; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetParameters(idd, peff, dwFlags);
end;

function IDirectInputEffect_Start(idd : IDirectInputEffect; dwIterations : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.Start(idd, dwIterations, dwFlags);
end;

function IDirectInputEffect_Stop(idd : IDirectInputEffect) : HResult; stdcall;
begin
	result := idd^^.Stop(idd);
end;

function IDirectInputEffect_GetEffectStatus(idd : IDirectInputEffect; var pdwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetEffectStatus(idd, pdwFlags);
end;

function IDirectInputEffect_Download(idd : IDirectInputEffect) : HResult; stdcall;
begin
	result := idd^^.Download(idd);
end;

function IDirectInputEffect_Unload(idd : IDirectInputEffect) : HResult; stdcall;
begin
	result := idd^^.Unload(idd);
end;

function IDirectInputEffect_Escape(idd : IDirectInputEffect; var pesc : TDIEffEscape) : HResult; stdcall;
begin
	result := idd^^.Escape(idd, pesc);
end;


// IDirectInputDeviceAW interface methods

function IDirectInputDevice_AddRef(idd : IDirectInputDeviceAW) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectInputDevice_Release(idd : IDirectInputDeviceAW) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectInputDevice_GetCapabilities(idd : IDirectInputDeviceAW; var lpDIDevCaps : TDIDevCaps) : HResult; stdcall;
begin
	result := idd^^.GetCapabilities(idd, lpDIDevCaps);
end;

function IDirectInputDevice_EnumObjects(idd : IDirectInputDeviceAW; lpCallback : TDIEnumDeviceObjectsCallbackA; pvRef : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumObjects(idd, @lpCallback, pvRef, dwFlags);
end;

function IDirectInputDevice_GetProperty(idd : IDirectInputDeviceAW; rguidProp : PGUID; var pdiph : TDIPropHeader) : HResult; stdcall;
begin
	result := idd^^.GetProperty(idd, rguidProp, pdiph);
end;

function IDirectInputDevice_SetProperty(idd : IDirectInputDeviceAW; rguidProp : PGUID; const pdiph : TDIPropHeader) : HResult; stdcall;
begin
	result := idd^^.SetProperty(idd, rguidProp, pdiph);
end;

function IDirectInputDevice_Acquire(idd : IDirectInputDeviceAW) : HResult; stdcall;
begin
	result := idd^^.Acquire(idd);
end;

function IDirectInputDevice_Unacquire(idd : IDirectInputDeviceAW) : HResult; stdcall;
begin
	result := idd^^.Unacquire(idd);
end;

function IDirectInputDevice_GetDeviceState(idd : IDirectInputDeviceAW; cbData : DWORD; lpvData : Pointer) : HResult; stdcall;
begin
	result := idd^^.GetDeviceState(idd, cbData, lpvData);
end;

function IDirectInputDevice_GetDeviceData(idd : IDirectInputDeviceAW; cbObjectData : DWORD; rgdod : PDIDeviceObjectData; var pdwInOut : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetDeviceData(idd, cbObjectData, rgdod, pdwInOut, dwFlags);
end;

function IDirectInputDevice_SetDataFormat(idd : IDirectInputDeviceAW; var lpdf : TDIDataFormat) : HResult; stdcall;
begin
	result := idd^^.SetDataFormat(idd, lpdf);
end;

function IDirectInputDevice_SetEventNotification(idd : IDirectInputDeviceAW; hEvent : THandle) : HResult; stdcall;
begin
	result := idd^^.SetEventNotification(idd, hEvent);
end;

function IDirectInputDevice_SetCooperativeLevel(idd : IDirectInputDeviceAW; hwnd : HWND; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetCooperativeLevel(idd, hwnd, dwFlags);
end;

function IDirectInputDevice_GetObjectInfo(idd : IDirectInputDeviceAW; var pdidoi : TDIDeviceObjectInstanceA; dwObj : DWORD; dwHow : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetObjectInfo(idd, pdidoi, dwObj, dwHow);
end;

function IDirectInputDevice_GetDeviceInfo(idd : IDirectInputDeviceAW; var pdidi : TDIDeviceInstanceA) : HResult; stdcall;
begin
	result := idd^^.GetDeviceInfo(idd, pdidi);
end;

function IDirectInputDevice_RunControlPanel(idd : IDirectInputDeviceAW; hwndOwner : HWND; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.RunControlPanel(idd, hwndOwner, dwFlags);
end;

function IDirectInputDevice_Initialize(idd : IDirectInputDeviceAW; hinst : THandle; dwVersion : DWORD; const rguid : TGUID) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, hinst, dwVersion, rguid);
end;


// IDirectInputDeviceA interface methods


// IDirectInputDeviceW interface methods


// IDirectInputDevice2AW interface methods

function IDirectInputDevice2_AddRef(idd : IDirectInputDevice2AW) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectInputDevice2_Release(idd : IDirectInputDevice2AW) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectInputDevice2_GetCapabilities(idd : IDirectInputDevice2AW; var lpDIDevCaps : TDIDevCaps) : HResult; stdcall;
begin
	result := idd^^.GetCapabilities(idd, lpDIDevCaps);
end;

function IDirectInputDevice2_EnumObjects(idd : IDirectInputDevice2AW; lpCallback : TDIEnumDeviceObjectsCallbackA; pvRef : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumObjects(idd, @lpCallback, pvRef, dwFlags);
end;

function IDirectInputDevice2_GetProperty(idd : IDirectInputDevice2AW; rguidProp : PGUID; var pdiph : TDIPropHeader) : HResult; stdcall;
begin
	result := idd^^.GetProperty(idd, rguidProp, pdiph);
end;

function IDirectInputDevice2_SetProperty(idd : IDirectInputDevice2AW; rguidProp : PGUID; const pdiph : TDIPropHeader) : HResult; stdcall;
begin
	result := idd^^.SetProperty(idd, rguidProp, pdiph);
end;

function IDirectInputDevice2_Acquire(idd : IDirectInputDevice2AW) : HResult; stdcall;
begin
	result := idd^^.Acquire(idd);
end;

function IDirectInputDevice2_Unacquire(idd : IDirectInputDevice2AW) : HResult; stdcall;
begin
	result := idd^^.Unacquire(idd);
end;

function IDirectInputDevice2_GetDeviceState(idd : IDirectInputDevice2AW; cbData : DWORD; lpvData : Pointer) : HResult; stdcall;
begin
	result := idd^^.GetDeviceState(idd, cbData, lpvData);
end;

function IDirectInputDevice2_GetDeviceData(idd : IDirectInputDevice2AW; cbObjectData : DWORD; rgdod : PDIDeviceObjectData; var pdwInOut : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetDeviceData(idd, cbObjectData, rgdod, pdwInOut, dwFlags);
end;

function IDirectInputDevice2_SetDataFormat(idd : IDirectInputDevice2AW; var lpdf : TDIDataFormat) : HResult; stdcall;
begin
	result := idd^^.SetDataFormat(idd, lpdf);
end;

function IDirectInputDevice2_SetEventNotification(idd : IDirectInputDevice2AW; hEvent : THandle) : HResult; stdcall;
begin
	result := idd^^.SetEventNotification(idd, hEvent);
end;

function IDirectInputDevice2_SetCooperativeLevel(idd : IDirectInputDevice2AW; hwnd : HWND; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetCooperativeLevel(idd, hwnd, dwFlags);
end;

function IDirectInputDevice2_GetObjectInfo(idd : IDirectInputDevice2AW; var pdidoi : TDIDeviceObjectInstanceA; dwObj : DWORD; dwHow : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetObjectInfo(idd, pdidoi, dwObj, dwHow);
end;

function IDirectInputDevice2_GetDeviceInfo(idd : IDirectInputDevice2AW; var pdidi : TDIDeviceInstanceA) : HResult; stdcall;
begin
	result := idd^^.GetDeviceInfo(idd, pdidi);
end;

function IDirectInputDevice2_RunControlPanel(idd : IDirectInputDevice2AW; hwndOwner : HWND; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.RunControlPanel(idd, hwndOwner, dwFlags);
end;

function IDirectInputDevice2_Initialize(idd : IDirectInputDevice2AW; hinst : THandle; dwVersion : DWORD; const rguid : TGUID) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, hinst, dwVersion, rguid);
end;

function IDirectInputDevice2_CreateEffect(idd : IDirectInputDevice2AW; const rguid : TGUID; lpeff : PDIEffect; var ppdeff : IDirectInputEffect; punkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateEffect(idd, rguid, lpeff, ppdeff, punkOuter);
end;

function IDirectInputDevice2_EnumEffects(idd : IDirectInputDevice2AW; lpCallback : TDIEnumEffectsCallbackA; pvRef : pointer; dwEffType : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumEffects(idd, @lpCallback, pvRef, dwEffType);
end;

function IDirectInputDevice2_GetEffectInfo(idd : IDirectInputDevice2AW; pdei : TDIEffectInfoA; const rguid : TGUID) : HResult; stdcall;
begin
	result := idd^^.GetEffectInfo(idd, pdei, rguid);
end;

function IDirectInputDevice2_GetForceFeedbackState(idd : IDirectInputDevice2AW; var pdwOut : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetForceFeedbackState(idd, pdwOut);
end;

function IDirectInputDevice2_SendForceFeedbackCommand(idd : IDirectInputDevice2AW; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SendForceFeedbackCommand(idd, dwFlags);
end;

function IDirectInputDevice2_EnumCreatedEffectObjects(idd : IDirectInputDevice2AW; lpCallback : TDIEnumCreatedEffectObjectsCallback; pvRef : pointer; fl : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumCreatedEffectObjects(idd, @lpCallback, pvRef, fl);
end;

function IDirectInputDevice2_Escape(idd : IDirectInputDevice2AW; var pesc : TDIEffEscape) : HResult; stdcall;
begin
	result := idd^^.Escape(idd, pesc);
end;

function IDirectInputDevice2_Poll(idd : IDirectInputDevice2AW) : HResult; stdcall;
begin
	result := idd^^.Poll(idd);
end;

function IDirectInputDevice2_SendDeviceData(idd : IDirectInputDevice2AW; cbObjectData : DWORD; var rgdod : TDIDeviceObjectData; var pdwInOut : DWORD; fl : DWORD) : HResult; stdcall;
begin
	result := idd^^.SendDeviceData(idd, cbObjectData, rgdod, pdwInOut, fl);
end;


// IDirectInputDevice2A interface methods


// IDirectInputDevice2W interface methods


// IDirectInputDevice7AW interface methods

function IDirectInputDevice7_AddRef(idd : IDirectInputDevice7AW) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectInputDevice7_Release(idd : IDirectInputDevice7AW) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectInputDevice7_GetCapabilities(idd : IDirectInputDevice7AW; var lpDIDevCaps : TDIDevCaps) : HResult; stdcall;
begin
	result := idd^^.GetCapabilities(idd, lpDIDevCaps);
end;

function IDirectInputDevice7_EnumObjects(idd : IDirectInputDevice7AW; lpCallback : TDIEnumDeviceObjectsCallbackW; pvRef : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumObjects(idd, @lpCallback, pvRef, dwFlags);
end;

function IDirectInputDevice7_GetProperty(idd : IDirectInputDevice7AW; rguidProp : PGUID; var pdiph : TDIPropHeader) : HResult; stdcall;
begin
	result := idd^^.GetProperty(idd, rguidProp, pdiph);
end;

function IDirectInputDevice7_SetProperty(idd : IDirectInputDevice7AW; rguidProp : PGUID; var pdiph : TDIPropHeader) : HResult; stdcall;
begin
	result := idd^^.SetProperty(idd, rguidProp, pdiph);
end;

function IDirectInputDevice7_Acquire(idd : IDirectInputDevice7AW) : HResult; stdcall;
begin
	result := idd^^.Acquire(idd);
end;

function IDirectInputDevice7_Unacquire(idd : IDirectInputDevice7AW) : HResult; stdcall;
begin
	result := idd^^.Unacquire(idd);
end;

function IDirectInputDevice7_GetDeviceState(idd : IDirectInputDevice7AW; cbData : DWORD; lpvData : Pointer) : HResult; stdcall;
begin
	result := idd^^.GetDeviceState(idd, cbData, lpvData);
end;

function IDirectInputDevice7_GetDeviceData(idd : IDirectInputDevice7AW; cbObjectData : DWORD; rgdod : PDIDeviceObjectData; var pdwInOut : DWORD; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetDeviceData(idd, cbObjectData, rgdod, pdwInOut, dwFlags);
end;

function IDirectInputDevice7_SetDataFormat(idd : IDirectInputDevice7AW; var lpdf : TDIDataFormat) : HResult; stdcall;
begin
	result := idd^^.SetDataFormat(idd, lpdf);
end;

function IDirectInputDevice7_SetEventNotification(idd : IDirectInputDevice7AW; hEvent : THandle) : HResult; stdcall;
begin
	result := idd^^.SetEventNotification(idd, hEvent);
end;

function IDirectInputDevice7_SetCooperativeLevel(idd : IDirectInputDevice7AW; hwnd : HWND; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SetCooperativeLevel(idd, hwnd, dwFlags);
end;

function IDirectInputDevice7_GetObjectInfo(idd : IDirectInputDevice7AW; var pdidoi : TDIDeviceObjectInstanceW; dwObj : DWORD; dwHow : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetObjectInfo(idd, pdidoi, dwObj, dwHow);
end;

function IDirectInputDevice7_GetDeviceInfo(idd : IDirectInputDevice7AW; var pdidi : TDIDeviceInstanceW) : HResult; stdcall;
begin
	result := idd^^.GetDeviceInfo(idd, pdidi);
end;

function IDirectInputDevice7_RunControlPanel(idd : IDirectInputDevice7AW; hwndOwner : HWND; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.RunControlPanel(idd, hwndOwner, dwFlags);
end;

function IDirectInputDevice7_Initialize(idd : IDirectInputDevice7AW; hinst : THandle; dwVersion : DWORD; const rguid : TGUID) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, hinst, dwVersion, rguid);
end;

function IDirectInputDevice7_CreateEffect(idd : IDirectInputDevice7AW; const rguid : TGUID; lpeff : PDIEffect; var ppdeff : IDirectInputEffect; punkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateEffect(idd, rguid, lpeff, ppdeff, punkOuter);
end;

function IDirectInputDevice7_EnumEffects(idd : IDirectInputDevice7AW; lpCallback : TDIEnumEffectsCallbackW; pvRef : pointer; dwEffType : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumEffects(idd, @lpCallback, pvRef, dwEffType);
end;

function IDirectInputDevice7_GetEffectInfo(idd : IDirectInputDevice7AW; pdei : TDIEffectInfoW; const rguid : TGUID) : HResult; stdcall;
begin
	result := idd^^.GetEffectInfo(idd, pdei, rguid);
end;

function IDirectInputDevice7_GetForceFeedbackState(idd : IDirectInputDevice7AW; var pdwOut : DWORD) : HResult; stdcall;
begin
	result := idd^^.GetForceFeedbackState(idd, pdwOut);
end;

function IDirectInputDevice7_SendForceFeedbackCommand(idd : IDirectInputDevice7AW; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.SendForceFeedbackCommand(idd, dwFlags);
end;

function IDirectInputDevice7_EnumCreatedEffectObjects(idd : IDirectInputDevice7AW; lpCallback : TDIEnumCreatedEffectObjectsCallback; pvRef : pointer; fl : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumCreatedEffectObjects(idd, @lpCallback, pvRef, fl);
end;

function IDirectInputDevice7_Escape(idd : IDirectInputDevice7AW; var pesc : TDIEffEscape) : HResult; stdcall;
begin
	result := idd^^.Escape(idd, pesc);
end;

function IDirectInputDevice7_Poll(idd : IDirectInputDevice7AW) : HResult; stdcall;
begin
	result := idd^^.Poll(idd);
end;

function IDirectInputDevice7_SendDeviceData(idd : IDirectInputDevice7AW; cbObjectData : DWORD; var rgdod : TDIDeviceObjectData; var pdwInOut : DWORD; fl : DWORD) : HResult; stdcall;
begin
	result := idd^^.SendDeviceData(idd, cbObjectData, rgdod, pdwInOut, fl);
end;

function IDirectInputDevice7_EnumEffectsInFile(idd : IDirectInputDevice7AW; const lpszFileName : PChar; pec : TEnumEffectsInFileCallback; pvRef : Pointer; dwFlags : DWord) : HResult; stdcall;
begin
	result := idd^^.EnumEffectsInFile(idd, lpszFileName, @pec, pvRef, dwFlags);
end;

function IDirectInputDevice7_WriteEffectToFile(idd : IDirectInputDevice7AW; const lpszFileName : PChar; dwEntries : DWord; const rgDIFileEft : PDIFileEffect; dwFlags : DWord) : HResult; stdcall;
begin
	result := idd^^.WriteEffectToFile(idd, lpszFileName, dwEntries, rgDIFileEft, dwFlags);
end;


// IDirectInputDevice7W interface methods


// IDirectInputDevice7A interface methods


// IDirectInputAW interface methods

function IDirectInput_AddRef(idd : IDirectInputAW) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectInput_Release(idd : IDirectInputAW) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectInput_CreateDevice(idd : IDirectInputAW; const rguid : TGUID; var lplpDirectInputDevice : IDirectInputDeviceW; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateDevice(idd, rguid, lplpDirectInputDevice, pUnkOuter);
end;

function IDirectInput_EnumDevices(idd : IDirectInputAW; dwDevType : DWORD; lpCallback : TDIEnumDevicesCallbackW; pvRef : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumDevices(idd, dwDevType, @lpCallback, pvRef, dwFlags);
end;

function IDirectInput_GetDeviceStatus(idd : IDirectInputAW; const rguidInstance : TGUID) : HResult; stdcall;
begin
	result := idd^^.GetDeviceStatus(idd, rguidInstance);
end;

function IDirectInput_RunControlPanel(idd : IDirectInputAW; hwndOwner : HWND; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.RunControlPanel(idd, hwndOwner, dwFlags);
end;

function IDirectInput_Initialize(idd : IDirectInputAW; hinst : THandle; dwVersion : DWORD) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, hinst, dwVersion);
end;


// IDirectInputW interface methods


// IDirectInputA interface methods


// IDirectInput2AW interface methods

function IDirectInput2_AddRef(idd : IDirectInput2AW) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectInput2_Release(idd : IDirectInput2AW) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectInput2_CreateDevice(idd : IDirectInput2AW; const rguid : TGUID; var lplpDirectInputDevice : IDirectInputDeviceW; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateDevice(idd, rguid, lplpDirectInputDevice, pUnkOuter);
end;

function IDirectInput2_EnumDevices(idd : IDirectInput2AW; dwDevType : DWORD; lpCallback : TDIEnumDevicesCallbackW; pvRef : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumDevices(idd, dwDevType, @lpCallback, pvRef, dwFlags);
end;

function IDirectInput2_GetDeviceStatus(idd : IDirectInput2AW; const rguidInstance : TGUID) : HResult; stdcall;
begin
	result := idd^^.GetDeviceStatus(idd, rguidInstance);
end;

function IDirectInput2_RunControlPanel(idd : IDirectInput2AW; hwndOwner : HWND; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.RunControlPanel(idd, hwndOwner, dwFlags);
end;

function IDirectInput2_Initialize(idd : IDirectInput2AW; hinst : THandle; dwVersion : DWORD) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, hinst, dwVersion);
end;

function IDirectInput2_FindDevice(idd : IDirectInput2AW; const rguidClass : TGUID; ptszName : PWideChar; var pguidInstance : TGUID) : HResult; stdcall;
begin
	result := idd^^.FindDevice(idd, rguidClass, ptszName, pguidInstance);
end;


// IDirectInput2W interface methods


// IDirectInput2A interface methods


// IDirectInput7AW interface methods

function IDirectInput7_QueryInterface(idd : IDirectInput7AW; const IID : TGUID; var obj) : HRESULT; stdcall;
begin
	result := idd^^.QueryInterface(idd, IID, obj);
end;

function IDirectInput7_AddRef(idd : IDirectInput7AW) : Longint; stdcall;
begin
	result := idd^^.AddRef(idd);
end;

function IDirectInput7_Release(idd : IDirectInput7AW) : Longint; stdcall;
begin
	result := idd^^.Release(idd);
end;

function IDirectInput7_CreateDevice(idd : IDirectInput7AW; const rguid : TGUID; var lplpDirectInputDevice : IDirectInputDeviceW; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateDevice(idd, rguid, lplpDirectInputDevice, pUnkOuter);
end;

function IDirectInput7_EnumDevices(idd : IDirectInput7AW; dwDevType : DWORD; lpCallback : TDIEnumDevicesCallbackW; pvRef : Pointer; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.EnumDevices(idd, dwDevType, @lpCallback, pvRef, dwFlags);
end;

function IDirectInput7_GetDeviceStatus(idd : IDirectInput7AW; const rguidInstance : TGUID) : HResult; stdcall;
begin
	result := idd^^.GetDeviceStatus(idd, rguidInstance);
end;

function IDirectInput7_RunControlPanel(idd : IDirectInput7AW; hwndOwner : HWND; dwFlags : DWORD) : HResult; stdcall;
begin
	result := idd^^.RunControlPanel(idd, hwndOwner, dwFlags);
end;

function IDirectInput7_Initialize(idd : IDirectInput7AW; hinst : THandle; dwVersion : DWORD) : HResult; stdcall;
begin
	result := idd^^.Initialize(idd, hinst, dwVersion);
end;

function IDirectInput7_FindDevice(idd : IDirectInput7AW; const rguidClass : TGUID; ptszName : PWideChar; var pguidInstance : TGUID) : HResult; stdcall;
begin
	result := idd^^.FindDevice(idd, rguidClass, ptszName, pguidInstance);
end;

function IDirectInput7_CreateDeviceEx(idd : IDirectInput7AW; const rguid , riid : TGUID; var lplpDirectInputDevice; pUnkOuter : IUnknown) : HResult; stdcall;
begin
	result := idd^^.CreateDeviceEx(idd, rguid, riid, lplpDirectInputDevice, pUnkOuter);
end;


// IDirectInput7W interface methods


// IDirectInput7A interface methods


begin
end.
