DECLARE SUB StatusMsg (Msg$)
DECLARE SUB PutRgn (Rgn%())
DECLARE SUB GetRgn (x%, y%, w%, h%, Rgn%())
DECLARE SUB AddItem (Text$, Id%, Submenu%, Hint$)
DECLARE SUB InitMenuItems (Id%)
DECLARE FUNCTION DrawMenuBar% (Id%)
DECLARE FUNCTION DrawMenu% (x%, y%, Id%)
DEFINT A-Z

'  㭪権 DrawMenuXXX
CONST mrCancel = -1     '  "ESC"
CONST mrLeft = -2       '  "<-"
CONST mrRight = -3      '  "->"

', ࠭ ᢮⢠ 㭪 
TYPE TItemProp
  Id AS INTEGER         '䨪 /
  Submenu AS INTEGER    '= 1 ᫨ 㭪 ᮤন 
END TYPE

' ६, ࠭騥  ⥪饣 
CONST MaxItems = 100
DIM SHARED Items(MaxItems - 1) AS STRING        ' 㭪⮢
DIM SHARED Props(MaxItems - 1) AS TItemProp     '⢠ 㭪⮢
DIM SHARED Hints(MaxItems - 1) AS STRING        '᪠
DIM SHARED NumItems                             '- 㭪⮢ 

' ࠭
CONST ScrWidth = 80
CONST ScrHeight = 25

'䨪 /
CONST idMainMenu = 1
CONST idFileMenu = 2
CONST idEditMenu = 3
CONST idTestMenu = 4
CONST idHelpMenu = 5

CONST idHelp = 5
CONST idExit = 6
CONST idItem1 = 7
CONST idItem2 = 8
CONST idItem3 = 9
CONST idItem4 = 10
CONST idAbout = 12

SCREEN 0
WIDTH ScrWidth, ScrHeight
VIEW PRINT 1 TO ScrHeight
CLS
DO
  xc = POS(0)
  yc = CSRLIN
  StatusMsg "Press ESC to enter the menu"
  DO
    k$ = INKEY$
  LOOP WHILE k$ = ""
  IF k$ = CHR$(27) THEN
    r = DrawMenuBar(idMainMenu)
    LOCATE yc, xc
    COLOR 2, 0
    SELECT CASE r
      CASE idExit
        EXIT DO
      CASE idItem1
        PRINT "Item 1 has been selected"
      CASE idItem2
        PRINT "Item 2 has been selected"
      CASE idItem3
        PRINT "Item 3 has been selected"
      CASE idAbout
        SHELL "logo32.exe"
      CASE ELSE
    END SELECT
  END IF
LOOP

MenuData:

'  㭪  ⥪饥 
SUB AddItem (Text$, Id, Submenu, Hint$)
  Items(NumItems) = Text$
  Props(NumItems).Id = Id
  Props(NumItems).Submenu = Submenu
  Hints(NumItems) = Hint$
  NumItems = NumItems + 1
END SUB

'뢮 ⨪쭮 
FUNCTION DrawMenu (x, y, Id)
  InitMenuItems Id
  w = 0
  FOR i = 0 TO NumItems - 1
    IF LEN(Items(i)) > w THEN w = LEN(Items(i)) + Props(i).Submenu * 2
  NEXT
  IF x + w > ScrWidth - 4 THEN x = ScrWidth - 4 - w
  IF y + NumItems > ScrHeight - 2 THEN y = ScrHeight - 2 - NumItems
  w1 = w + 5
  h1 = NumItems + 2
  DIM Rgn(w1 * h1 + 4)
  GetRgn x, y, w1, h1, Rgn()
  Foc = 0
  DO
    COLOR 7, 0
    LOCATE y, x
    PRINT ""; STRING$(w + 3, ""); "";
    FOR i = 0 TO NumItems - 1
      s$ = Items(i)
      yi = y + i + 1
      LOCATE yi, x
      PRINT "";
      IF s$ = "-" THEN
        PRINT STRING$(w + 3, "");
      ELSE
        IF i = Foc THEN COLOR 0, 7
        PRINT " "; s$; STRING$(w - LEN(s$), " ");
        IF Props(i).Submenu THEN PRINT CHR$(16); " ";  ELSE PRINT "  ";
      END IF
      COLOR 7, 0
      PRINT "";
    NEXT
    LOCATE y + NumItems + 1, x
    PRINT ""; STRING$(w + 3, ""); "";
    DO
      k$ = INKEY$
    LOOP WHILE k$ = ""
    r = 0
    SELECT CASE k$
      CASE CHR$(0) + CHR$(72)
        DO
          Foc = Foc - 1
          IF Foc < 0 THEN Foc = NumItems - 1
        LOOP WHILE Items(Foc) = "-"
      CASE CHR$(0) + CHR$(80)
        DO
          Foc = Foc + 1
          IF Foc >= NumItems THEN Foc = 0
        LOOP WHILE Items(Foc) = "-"
      CASE CHR$(0) + CHR$(75)
        r = mrLeft
      CASE CHR$(0) + CHR$(77)
        r = mrRight
      CASE CHR$(27)
        r = mrCancel
      CASE CHR$(13)
        IF Props(Foc).Submenu THEN
          r = DrawMenu(x + w + 2, y + Foc, Props(Foc).Id)
          IF r = mrCancel OR r = mrLeft OR r = mrRight THEN r = 0
          InitMenuItems Id
        ELSE
          r = Props(Foc).Id
        END IF
      CASE ELSE
    END SELECT
  LOOP UNTIL r
  PutRgn Rgn()
  DrawMenu = r
END FUNCTION

'뢮 ப  
FUNCTION DrawMenuBar (Id)
  DIM Rgn(ScrWidth + 4)
  GetRgn 1, 1, ScrWidth, 1, Rgn()
  InitMenuItems Id
  Foc = 0
  AutoExp = 0
  DO
    COLOR 0, 7
    LOCATE 1, 1
    PRINT " ";
    w = 1
    FOR i = 0 TO NumItems - 1
      s$ = Items(i)
      IF s$ = "-" THEN
        PRINT "  ";
      ELSE
        IF i = Foc THEN
          x = w
          COLOR 7, 0
        END IF
        PRINT " "; s$; " ";
      END IF
      COLOR 0, 7
      w = w + LEN(s$) + 2
    NEXT
    PRINT SPC(ScrWidth - w);
    StatusMsg Hints(Foc)
    IF AutoExp AND Props(Foc).Submenu THEN
      k$ = CHR$(13)
    ELSE
      DO
        k$ = INKEY$
      LOOP WHILE k$ = ""
    END IF
    SELECT CASE k$
      CASE CHR$(0) + CHR$(75)
        r = mrLeft
      CASE CHR$(0) + CHR$(77)
        r = mrRight
      CASE CHR$(27)
        r = mrCancel
      CASE CHR$(13), CHR$(0) + CHR$(72), CHR$(0) + CHR$(80)
        AutoExp = 1
        IF Props(Foc).Submenu THEN
          r = DrawMenu(x, 2, Props(Foc).Id)
        ELSE
          r = Props(Foc).Id
        END IF
      CASE ELSE
    END SELECT
    SELECT CASE r
      CASE mrCancel
        InitMenuItems Id
        EXIT DO
      CASE mrLeft
        InitMenuItems Id
        DO
          Foc = Foc - 1
          IF Foc < 0 THEN Foc = NumItems - 1
        LOOP WHILE Items(Foc) = "-"
      CASE mrRight
        InitMenuItems Id
        DO
          Foc = Foc + 1
          IF Foc >= NumItems THEN Foc = 0
        LOOP WHILE Items(Foc) = "-"
    CASE ELSE
      EXIT DO
    END SELECT
  LOOP
  PutRgn Rgn()
  DrawMenuBar = r
END FUNCTION

'࠭ אַ㣮쭮  ࠭  ᨢ
'ᨢ   , 楫᫥  - -⮢ >= w * h + 4
SUB GetRgn (x, y, w, h, Rgn())
  Rgn(0) = x
  Rgn(1) = y
  Rgn(2) = w
  Rgn(3) = h
  p = 4
  FOR i = y TO y + h - 1
    FOR j = x TO x + w - 1
      Rgn(p) = SCREEN(i, j) + SCREEN(i, j, 1) * 256
      p = p + 1
    NEXT
  NEXT
END SUB

'樠 ⥪饥    䨪
SUB InitMenuItems (Id)
  NumItems = 0
  SELECT CASE Id
    CASE idMainMenu
      AddItem "File", idFileMenu, 1, "File related commands"
      AddItem "Edit", idEditMenu, 1, "Clipboard commands"
      AddItem "Submenu", idTestMenu, 1, "Example of nested submenus"
      AddItem "Item", 0, 0, "Simple item"
      AddItem "Help", idHelpMenu, 1, "Help information"
    CASE idFileMenu
      AddItem "New", 0, 0, ""
      AddItem "Open...", 0, 0, ""
      AddItem "Save", 0, 0, ""
      AddItem "Save as...", 0, 0, ""
      AddItem "-", 0, 0, ""
      AddItem "Exit", idExit, 0, ""
    CASE idEditMenu
      AddItem "Undo", 0, 0, ""
      AddItem "Redo...", 0, 0, ""
      AddItem "-", 0, 0, ""
      AddItem "Cut", 0, 0, ""
      AddItem "Copy", 0, 0, ""
      AddItem "Paste", 0, 0, ""
      AddItem "Clear", 0, 0, ""
   CASE idTestMenu
      AddItem "Item 1", idItem1, 0, ""
      AddItem "Submenu again", idTestMenu, 1, ""
      AddItem "Item 2", idItem2, 0, ""
      AddItem "Item 3", idItem3, 0, ""
   CASE idHelpMenu
      AddItem "About...", idAbout, 0, ""
  END SELECT
END SUB

'⠭ ࠭  ࠭
SUB PutRgn (Rgn())
  x = Rgn(0)
  y = Rgn(1)
  w = Rgn(2)
  h = Rgn(3)
  p = 4
  FOR i = y TO y + h - 1
    FOR j = x TO x + w - 1
      LOCATE i, j
      COLOR Rgn(p) \ 256 AND 15, Rgn(p) \ 4096
      PRINT CHR$(Rgn(p) AND 255);
      p = p + 1
    NEXT
  NEXT
END SUB

'饭  ப ﭨ
SUB StatusMsg (Msg$)
  LOCATE 25, 1
  COLOR 0, 7
  PRINT " "; Msg$; SPC(ScrWidth - LEN(Msg$) - 1);
END SUB

