.include "tn26def.inc"

.equ V_REF		= (2860 * 2)	;V_REF = Vref() * 2
.equ T_DISP		= 500			;   ()

; 
.equ LCD_DDR	= DDRB
.equ LCD_PORT	= PORTB

.equ LCD_A0		= 4
.equ LCD_WR		= 5

; 
.equ CTL_DDR	= DDRA
.equ CTL_PORT	= PORTA

.equ CTL_POWER	= 4

.def _0			= r0	;  _0

.def tmp		= r16	; 
.def i			= r17	; 

.def flags		= r18	;
.equ F_DP		= 0		;   

.def nibble		= r19	; / 
.def digit		= r20	;

;   
.def c_disp_l	= r2
.def c_disp_h	= r3

; /
.def res0		= r8
.def res1		= r9
.def res2		= r10
.def res3		= r11

.cseg

.org 0
	rjmp reset

;-----      0 -----
.org OVF0addr
	;   0 (  T = 1 )
	ldi tmp,-124		
	out TCNT0,tmp

;c_disp = c_disp - 1
	ldi tmp,1
	sub c_disp_l,tmp
	sbc c_disp_h,_0
;ec c_disp <> 0,  
	brne exit_tov0
	
; 		
	sbi ADCSR,ADSC

;,    
wait_adc:
	sbic ADCSR,ADSC
	rjmp wait_adc

;    ADC
;res[0..1] = ADC
	in res0,ADCL
	in res1,ADCH

;   
;res = res[0..1] * V_REF = ADC * V_REF
	clr	res3
	clr	res2
	ldi	i,16
	lsr	res1
	ror	res0
mul1:
	brcc mul2
	ldi tmp,low(V_REF)
	add	res2,tmp
	ldi tmp,high(V_REF)
	adc	res3,tmp
mul2:
	ror	res3
	ror	res2
	ror	res1
	ror	res0
	dec i
	brne mul1
;res[3..1] = res / 1024 = ADC * VREF / 1024
	lsr res3
	ror res2
	ror res1
	lsr res3
	ror res2
	ror res1

;   10- ,    
	rcall div10
	push digit
	rcall div10
	push digit
	rcall div10
	push digit
	rcall div10
	push digit

;   
	clr nibble
	rcall lcd_out_addr

;  ( -     10)
	pop digit
	rcall lcd_digit
	pop digit
	rcall lcd_digit
	pop digit
	sbr flags,1<<F_DP	;   
	rcall lcd_digit
	cbr flags,1<<F_DP
	pop digit
	rcall lcd_digit

;c_disp = T_DISP
	ldi tmp,low(T_DISP)
	mov c_disp_l,tmp
	ldi tmp,high(T_DISP)
	mov c_disp_h,tmp

exit_tov0:
	reti

;gidit = res[2..1] mod 10
;res[2..1] = res[2..1] / 10
div10:
	sub digit,digit
	cpc res1,_0
	cpc res2,_0
	breq div10_exit
	clc
	ldi i,17
div10_1:
	rol res1
	rol res2
	dec i
	breq div10_exit
div10_2:
	rol digit
	subi digit,10
	brcc div10_3
	subi digit,-10
	clc
	rjmp div10_1
div10_3:
	sec
	rjmp div10_1
div10_exit:
	ret

;-----   -----

;     
lcd_out_data:
	sbr nibble,1<<LCD_A0
;   
lcd_out_addr:
lcd_out:
	andi nibble,0xF|1<<LCD_A0
	out LCD_PORT,nibble
	sbi LCD_PORT,LCD_WR
	ret

;      
lcd_digit:
	ldi zl,low(digits<<1)
	ldi zh,high(digits<<1)
	add zl,digit
	adc zh,_0
	lpm tmp,z
	rcall lcd_digit1
	swap tmp
	sbrc flags,F_DP
	ori tmp,1
lcd_digit1:
	mov nibble,tmp
	rcall lcd_out_data
	ret

;-----     -----
reset:
	clr _0
	clr flags

;c_disp = T_DISP
	ldi tmp,low(T_DISP)
	mov c_disp_l,tmp
	ldi tmp,high(T_DISP)
	mov c_disp_h,tmp

;  
	ldi tmp,RAMEND
	out SP,tmp

;   SLEEP ( )
	ldi tmp,1<<SE
	out MCUCR,tmp

;  0
	ldi tmp,1<<CS01		;f = f_clk / 8
	out TCCR0,tmp
	ldi tmp,1<<TOIE0	;   
	out TIMSK,tmp

; 
	ldi tmp,1<<ADEN|1<<ADPS2|1<<ADPS1|1<<ADPS0
	out ADCSR,tmp
	ldi tmp,1<<REFS0|1<<REFS1	;   Vref
	out ADMUX,tmp				;c    

;  
	sbi CTL_DDR,CTL_POWER
	sbi CTL_PORT,CTL_POWER

;  
	ldi tmp,1<<LCD_WR|1<<LCD_A0|0xF
	out LCD_DDR,tmp

;  
	ldi nibble,0xF
	rcall lcd_out_addr
	rcall lcd_out_data

; 
	clr nibble
	rcall lcd_out_addr
	ldi i,20
clr_lcd:
	rcall lcd_out_data
	dec i
	brne clr_lcd

;  
	sei
idle:
	sleep
	rjmp idle

; 
digits:
.db 0b11101110,0b01100000	;"0", "1"
.db 0b00101111,0b01101101	;"2", "3"
.db 0b11100001,0b11001101	;"4", "5"
.db 0b11001111,0b01101000	;"6", "7"
.db 0b11101111,0b11101101	;"8", "9"
.db 0b00000001,0b00000000	;"-", " "
;----[fcbhadeg]-[fcbhadeg]----
;
;        a
;       ---
;     f| g |b
;       ---
;     e|   |c
;       ---  *
;        d   h
;

.equ DG_HYPEN = 10
.equ DG_SPACE = 11
