unit SBMixer;
    interface
        type
            ThreeBit=0..7;
            Nibble=0..15;
        type
            InputSource=0..3;
        const
            inpMicDefault = 0;
            inpCDAudio    = 1;
            inpMicrophone = 2;
            inpLineIn     = 3;

        type
            FilterSelect=0..7;
        const
            LowFilter  = 0;
            HighFilter = 1;
            NoFilter   = 4;

        type
            VoiceMode=0..1;
        const
            Mono   = 0;
            Stereo = 1;

        procedure ResetMixer;
        procedure SetMicVolume(Volume: ThreeBit);
        procedure SetInputSettings(Source: InputSource; Filter: FilterSelect);
        procedure SetOutputSettings(DNFI: boolean; Mode: VoiceMode);
        procedure SetMasterVolume(Left, Right: Nibble);
        procedure SetVoiceVolume(Left, Right: Nibble);
        procedure SetFMVolume(Left, Right: Nibble);
        procedure SetCDVolume(Left, Right: Nibble);
        procedure SetLineinVolume(Left, Right: Nibble);
    implementation
        uses
            CRT;
        const
            MixerAddrPort = $224;
            MixerDataPort = $225;
        procedure WriteMixer(Register: byte; Value: byte);
            begin
                Port[MixerAddrPort] := Register;
                Delay(1);
                Port[MixerDataPort] := Value;
                Delay(1);
            end;
        function ReadMixer(Register: byte): byte;
            begin
                Port[MixerAddrPort] := Register;
                Delay(1);
                ReadMixer := Port[MixerDataPort];
                Delay(1);
            end;

        procedure ResetMixer;
            begin
                WriteMixer($00, $FF);
                Delay(10);
            end;

        procedure SetMicVolume(Volume: ThreeBit);
            begin
                WriteMixer($0A, Volume);
            end;
        procedure SetInputSettings(Source: InputSource; Filter: FilterSelect);
            begin
                WriteMixer($0C, (Source shl 1) + (Filter shl 3));
            end;
        procedure SetOutputSettings(DNFI: boolean; Mode: VoiceMode);
            var
                Out: byte;
            begin
                Out := 0;
                if DNFI then Out := Out + 32;
                Out := Out + (Mode shl 1);
                WriteMixer($0E, Out);
            end;
        procedure SetMasterVolume(Left, Right: Nibble);
            begin
                WriteMixer($22, (Left shl 4) + Right);
            end;
        procedure SetVoiceVolume(Left, Right: Nibble);
            begin
                WriteMixer($04, (Left shl 4) + Right);
            end;
        procedure SetFMVolume(Left, Right: Nibble);
            begin
                WriteMixer($26, (Left shl 4) + Right);
            end;
        procedure SetCDVolume(Left, Right: Nibble);
            begin
                WriteMixer($28, (Left shl 4) + Right);
            end;
        procedure SetLineinVolume(Left, Right: Nibble);
            begin
                WriteMixer($2E, (Left shl 4) + Right);
            end;
    end.