#ifndef FRACTAL_PRINTER_H_INCLUDED
#define FRACTAL_PRINTER_H_INCLUDED

#include "coord.h"
#include<vector>

namespace fract
{

    template<class div_policy, class draw_policy>

    class fractal_printer
    {
    public :

        fractal_printer () ;
        void print_fractal (const coord_math::coord& u_fcoord, const coord_math::coord& u_scoord, int max_l ) ;
        ~fractal_printer () ;

    private :

        div_policy* m_div ;
        draw_policy* m_draw ;



    };

    template<class div_policy, class draw_policy>
    fractal_printer<div_policy, draw_policy>::fractal_printer() :
            m_div(new div_policy), m_draw(new draw_policy)  {}

    template<class div_policy, class draw_policy>
    void fractal_printer<div_policy, draw_policy>::print_fractal (const coord_math::coord& u_fcoord, const coord_math::coord& u_scoord, int max_l )
    {

        coord_math::v_paircoord vc;
        typedef coord_math::v_paircoord::iterator cit ;
        static int n = 0;
        ++n ;
        m_draw->draw(u_fcoord, u_scoord, n, max_l);


        if (n <= max_l)
        {
            vc = m_div->div_l(u_fcoord, u_scoord, n, max_l);
            for (cit it = vc.begin(), end = vc.end(); it != end; ++it)
            {
                print_fractal((*it).first, (*it).second, max_l);
            }

        }

        --n ;
    }

    template<class div_policy, class draw_policy>
    fractal_printer<div_policy, draw_policy>::~fractal_printer ()
    {
        delete m_draw ;
        delete m_div ;
    }




}//namespace

#endif // FRACTAL_PRINTER_H_INCLUDED
