#ifndef COORD_H_INCLUDED
#define COORD_H_INCLUDED

#include<utility>
#include<vector>
#include<math.h>
namespace coord_math
{
    typedef std::pair<double, double> coord ;
    typedef std::vector<coord>        v_coord ;
    typedef std::pair<coord, coord>   pair_coord ;
    typedef std::vector<pair_coord>   v_paircoord ;

    double get_angle (const coord& a, const coord& b) ;
    double get_len   (const coord& a, const coord& b) ;

    double get_len   (const coord& a, const coord& b)
    {
        return sqrt(pow((a.first-b.first), 2) + pow((a.second-b.second), 2)) ;
    }

    double get_angle (const coord& a, const coord& b)
    {
        float x = a.first ;
        float x1 = b.first;
        float y = a .second;
        float y1 = b.second ;
        float  l = abs(x - x1);
        float  h = abs(y - y1);
        float  s = sqrt(l * l + h * h) ;

        const float pi = 3.141592653589793238462643383 ;
        if (s == 0) s += 0000000000.1;
        if ((x1 >= x) && (y1 <= y)) return  (acos(l/s)) ;
        if ((x1 >= x) && (y1 >= y)) return  (2*pi - acos(l/s));
        if ((x1 <= x) && (y1 <= y)) return  (pi -  acos(l/s)) ;
        if ((x1 <= x) && (y1 >= y)) return  ( pi + acos(l/s));


    }
}

#endif // COORD_H_INCLUDED
