﻿library myhook;

{ Тут было длинное предупреждение... }

uses
  SysUtils, Windows, Messages;

{$R *.res}

type
  PHookRec = ^THookRec;
  THookRec =
  record
    AppWindow: HWND;
    HookID: HHOOK;
  end;

const
  MY_MESSAGE = WM_USER + 1;
var
  RHookRec: PHookRec = nil;


function GetClName(myWnd: HWND): String;
var
  Cl: array[0 .. pred(MAX_PATH)] of char;
begin
  GetClassName(myWnd, Cl, MAX_PATH);
  result := cl;
end;

function CBTProc(Code: integer; myWParam: WPARAM;
                 myLParam: LPARAM): LRESULT; stdcall;
begin
  if Code < 0 then
  begin
    Result := CallNextHookEx(rHookRec^.HookID, code, myWParam, myLParam);
    exit;
  end;

  case Code of
    HCBT_CREATEWND:
    begin
      if pos('NOTEPAD', UpperCase(GetClName(myWParam))) > 0 then
      begin
        PostMessage(RHookRec^.AppWindow, MY_MESSAGE, myWParam, 0);
        result := 1; Exit;
      end;
    end;
  end;
  result := 0;
end;

procedure SetTheHook(Handle: HWND); stdcall;
begin
  RHookRec^.AppWindow := Handle;
  RHookRec^.HookID := SetWindowsHookEx(WH_CBT, @CBTProc, HInstance, 0);
end;
procedure DelTheHook; stdcall;
begin
  UnhookWindowsHookEx(rHookRec^.HookID);
end;

{$J+}
procedure EntryPointProc(Reason: Integer);
const
  hMapObject: THandle = 0;
begin
  case reason of
    DLL_PROCESS_ATTACH:
      begin
        hMapObject :=
          CreateFileMapping(INVALID_HANDLE_VALUE, nil, PAGE_READWRITE, 0, SizeOf(THookRec), 'volvo_CBT');
        rHookRec := MapViewOfFile(hMapObject, FILE_MAP_ALL_ACCESS, 0, 0, SizeOf(THookRec));
      end;

    DLL_PROCESS_DETACH:
      begin
        UnMapViewOfFile(rHookRec);
        CloseHandle(hMapObject);
      end;

    DLL_THREAD_ATTACH,
    DLL_THREAD_DETACH: ;
  end;
end;

exports
  SetTheHook, DelTheHook;

begin
  DllProc := @EntryPointProc;
  EntryPointProc(DLL_PROCESS_ATTACH);
end.

