﻿unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, ComCtrls, DBGrids, ExtCtrls,
  DB, DBClient, Grids;

type
  TForm1 = class(TForm)
    ClientDataSet1: TClientDataSet;
    Button1: TButton;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    Button2: TButton;
    procedure FormCreate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation
uses ShellAPI, ComObj;
{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var i : integer;
begin
  for i := 1 to 20 do
  begin
    ClientDataSet1.Append();
    ClientDataSet1.FieldByName('ID_SOURCE').Value := 'ID' + IntToStr(i);
    ClientDataSet1.FieldByName('Pr_MEST').Value := 'Pr' + IntToStr(i mod 5);
    ClientDataSet1.FieldByName('NO_ONE_FAM').Value := 'Fam' + IntToStr(i);
    ClientDataSet1.Post();
  end;
end;


const
  TemplateSheet = 'F:\Programs\Delphi\XLL\Sheet1.XLT';
  // В этом шаблоне только один лист, с шапкой которая тебе нужна

var
  XLApp : Variant;

procedure TForm1.Button2Click(Sender: TObject);

var
  workBooks, activeBook, curr, Range : Variant;
  CellStart, CellFinish : Variant;
  sPlace : String;
  Ls : TStringList;
  i, iRec : Integer;
  Data : Variant;
begin
  XLApp := CreateOleObject('Excel.Application');
  XLApp.Visible := True;
  XLApp.SheetsInNewWorkbook := 1; // Добавим не 3 (по умолчанию), а 1 лист

  workBooks := XLApp.WorkBooks;
  ActiveBook := workBooks.Add;
  Curr := ActiveBook.Sheets[1]; // Запомним добавленный лист, ниже поймешь зачем

  try
    Ls := TStringList.Create;

    // Ну, дальше все ПОЧТИ без изменений
    ClientDataSet1.First;
    while not ClientDataSet1.Eof do
    begin
      sPlace := ClientDataSet1.FieldByName('Pr_MEST').AsString;
      if Ls.IndexOf(sPlace) = -1 then
      begin
        Ls.Add(sPlace);
      end;
      ClientDataSet1.Next;
    end;

    for i := 0 to Pred(Ls.Count) do
    begin
      ClientDataSet1.Filtered := False;
      ClientDataSet1.Filter := 'Pr_MEST = ' + QuotedStr(Ls.Strings[i]);
      ClientDataSet1.Filtered := True;

      Data := VarArrayCreate([1, ClientDataSet1.RecordCount, 1, 3], varVariant);

      ClientDataSet1.First;
      iRec := 0;
      while not ClientDataSet1.Eof do
      begin

        Data[iRec + 1, 1] := ClientDataSet1.FieldByName('ID_SOURCE').AsString;
        Data[iRec + 1, 2] := ClientDataSet1.FieldByName('Pr_MEST').AsString;
        Data[iRec + 1, 3] := ClientDataSet1.FieldByName('NO_ONE_FAM').AsString;
        Inc(iRec);

        ClientDataSet1.Next;
      end;

      // А вот и изменения: добавляем новый личт из шаблона ПОСЛЕ того, что был текущим
      Curr := ActiveBook.Sheets.Add (Type := TemplateSheet, After := Curr);
      Curr.Name := Ls.Strings[i];
      CellStart := Curr.Cells[2, 1];
      CellFinish := Curr.Cells[iRec + 1, 3]; // Ну, и корректируем позицию вставки
      Range := Curr.Range[CellStart, CellFinish];
      Range.Value := Data;

      VarClear(Data);
    end;

  finally
    Ls.Free;
  end;
  ActiveBook.Sheets[1].Delete; // Помнишь первый добавленный лист? Он не нужен...
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
   ClientDataSet1.FieldDefs.Add ('ID_SOURCE', ftString, 20);
   ClientDataSet1.FieldDefs.Add ('Pr_MEST', ftString, 20);
   ClientDataSet1.FieldDefs.Add ('NO_ONE_FAM', ftString, 20);
   ClientDataSet1.CreateDataSet();

   ClientDataSet1.Active := True;
end;

end.
