; 
X_SIZE				equ 640
SCREEN_BYTES			equ (X_SIZE / 8)
GRAPHICS_SEGMENT		equ 0a000h	;     10h

SC_INDEX			equ 03c4h		; Sequence Controller Index register
	SC_CPWE		equ 2		; Color Plane Write Enable -    
	
GC_INDEX		equ 03ceh		; Graphics Controller Index reg
	GC_SRR		equ 0		; Set/Reset Register -  /
	GC_SRER		equ 1		; Set/Reset Enable Register -   /
	GC_BMR		equ 8		; Bit Mask Register -   

data segment

	color db 1			;    
	current_color db ?	; ,      
	
	Len dw 160		; ""   = X_SIZE / 4
	One dw 1			; .    FPU
	
	LenY	dw 88		; Round (Len * 350 / X_SIZE);
	InvY dd 1.828571	; (X_SIZE / 350)

	iX dw 0
	iY dw 349			;  ()   
	fY dd 349.0		;    
	fDY dd 0.546875	; (350 / X_SIZE)
	
	pp dw ?			;     
	pp1 dw ?
	ii dw ?
	curr_y dw ?
	
data ends

code segment
	assume cs: code, ds: data
	
start proc
        mov ax, data
	mov ds, ax
	
	mov ax, 10h
	int 10h		;   (640*350*16)
	
	;  
	mov cx, 4
outer_loop:
	inc color
	push cx
		
		mov al, color
		mov current_color, al
		
		;      .
		;  Line (0, iy, ix, 350), .  -   
		mov ax, 0
		mov bx, iy
		mov curr_y, bx
		push bx		;  iy ...
		mov cx, ix
		push cx		; ...  ix  
		mov dx, 350
		mov si, 0
		call Line
		
		mov al, color
		add al, 4
		mov current_color, al
		
		pop ax		;  ix -> AX ...
		add ax, 160
		mov ix, ax
		
		pop dx		; ...  iy -> DX  
		sub dx, LenY
		mov iy, dx
			
		;      
		;  Line (ix, 0, 640, iy),  . .     
		mov bx, 0
		mov cx, 640
		mov si, 1
		call Line
		
		;      .
		;      ...
		mov cx, LenY
		inc cx
		
		mov ii, 0		;      
	inner_loop:
		push cx
			inc ii
			
			fld InvY
			fild ii
			fmul
			frndint
			fist pp		; pp <- Round(ii * InvY);
			fisubr Len
			fiadd One
			fistp pp1
				
			mov al, color
			mov bx, 1
			mov cx, curr_y
			mov dx,  pp1
			call _ScanLine ; _ScanLine (1, pp1, curr_y)
			
			mov al, color
			add al, 4
				
			mov bx, pp
			mov dx, bx		;    1  
			neg bx
			add bx, 639
			mov cx, curr_y
			inc dx
			call _ScanLine ; _ScanLine (640 - pp, 640, curr_y)
			
			dec curr_y
		pop cx				
		loop inner_loop
			
	pop cx
	dec cx		;  -   SHORT jump
	jcxz quit_loop
	jmp outer_loop
quit_loop:

	mov ah, 1
	int 21h		;    
	mov ax,3h
	int 10h		;    
	mov ah, 4ch 
	int 21h		;   
	
	
GetSign macro V1, V2,  Res
	local negative, quit
	mov ax, V1
	sub ax, V2
	
	shl ax, 1
	jc negative
	mov  ax, 1
	jmp quit
negative:
	mov ax, -1
quit:
	mov Res, ax
	endm
	
GetAbs macro Value, Res
	local aboveeq
	cmp Value, 0
	jnl aboveeq
	neg Value
aboveeq:
	mov Res, Value
	endm
	
Incr macro Val
	mov ax, s&Val
	add Val, ax
	endm
	
Calc macro Var, Op, Delta
	mov ax, _d&Delta
	sal ax, 1
	Op Var, ax
	endm
	
IfThen macro Expr, Mac, TrueParam, FalseParam
	local expr_false, quit
	cmp Expr, 1
	jne expr_false
	Mac TrueParam
	jmp quit
expr_false:
	Mac FalseParam
quit:
	endm
	
;      ( )
; :
;	AX <- Xstart
;	BX <- Ystart
;	CX <- Xfinish
;	DX <- Yfinish
;	SI = 0  .    , = 1  

proc line
	jmp beg
	
	; "" 
	x1 dw ?
	x2 dw ?
	y1 dw ?
	y2 dw ?
	_dx dw ?
	_dy dw ?
	sx dw ?
	sy dw ?
	check dw ?
	e dw ?
	x dw ?
	y dw ?
	
beg:
	mov x1, ax
	mov x, ax
	mov y1, bx
	mov y, bx
	mov x2, cx
	mov y2, dx
	
	; _dx := Abs (x1 - x2);
	sub ax, cx		; AX <- x1 - x2
	GetAbs ax, _dx		; _dx <- Abs (AX)
	
	; _dy := Abs (y1 - y2)
	mov ax, bx		; AX <- y1
	sub ax,  dx		; AX <- y1 - y2
	GetAbs ax, _dy		; _dy <- Abs (AX)

	; sx := Sign (x2 - x1);
	GetSign x2, x1, sx
	
	; sy := Sign (y2 - y1);
	GetSign y2, y1, sy
	
	mov check, 0
	
	; if _dy > _dx then begin
		mov ax, _dy
		cmp ax, _dx
		jle next
	
		; Swap (_dx, _dy);
		mov ax, _dy
		xchg _dx, ax
		mov _dy,  ax
	
		mov check, 1 		; check <- 1;
	; end
	
next:

	; e := 2 * _dy - _dx;
	push _dy
	pop e			; e <- _dy
	sal e, 1			; e <- 2 * e
	mov ax, _dx		; AX <- _dx
	sub e, ax			; e <- e - AX
	
	; for i := 1 to _dx do begin
	mov cx, _dx
for_loop:
	mov al, current_color;
	
	push bx
	push cx
	
	mov bx, x
	cmp si, 0			; ,      . 
	jz without_decr
	sub bx, 161
without_decr:
	mov cx, y
	mov dx, 161
	call _ScanLine
	
	pop cx
	pop bx
	
	; if e >= 0 then begin
		cmp e, 0
		jl next1
	
		; if check = 1 then x := x + sx else y := y + sy
		IfThen check, Incr, x, y
	
		; e := e - 2 * _dx
		Calc e, sub, x
	; end
	
next1:
	; if check = 1 then y := y + sy else x := x + sx
	IfThen check, Incr, y, x
	; e := e + 2 * _dy
	Calc e, add, y
	
	loop for_loop
	
	; finished
	ret
endp line


;
;        
; :
;	AL =  
;	BX =  X
;	CX =  Y
;	DX =  

_ScanLine proc near

	jmp begin_scan
	
	FStart dw ?
	FStop dw ?
	FRaster dw ?
	FColor   db ?

begin_scan:

	mov FColor, al
	mov FStart, bx
	add bx, dx
	mov FStop, bx
	mov FRaster, cx
	
	;   
	push di
	push si
	push ds
	push es
	
	mov dx, GC_INDEX	;    -
	mov al, GC_SRR
	out dx, al
	inc dx
	mov al, FColor
	out dx, al
	dec dx			;   
	mov al, GC_SRER
	out dx, al
	inc dx
	mov al, 0Fh
	out dx, al
	mov dx, SC_INDEX	;     4  
	mov al, SC_CPWE
	out dx, al
	inc dx
	mov al, 0Fh
	out dx, al
	
	;       
SL_Address:

        ;       
	mov ax, FRaster	; 80*y+x/8
	mov bx, SCREEN_BYTES
	mul bx
	mov di, FStart		; + x/8
	mov cl, 3
	shr di, cl
	add di, ax

        mov dx, GRAPHICS_SEGMENT
	mov ds, dx
	mov es, dx

        mov cx, FStop
        sub cx, FStart
	
	;        

	;        
	; ( FStart   8,      ,
	;   ,       )
	mov ax, FStart
	and ax, 07H			
	
	jz SL_Complete			; ... ,   
	mov bx, 0FFH			;     ,  FF ,
	push cx				;     , 
	mov cx, ax			;    
	shr bx, cl
	pop cx
	add cx, ax			;   
	sub cx, 8
	jge SL_SetMask
	neg cx
	shr bx, cl
	shl bx, cl
	xor cx, cx
SL_SetMask:
	mov dx, GC_INDEX		;  
	mov al, GC_BMR
	out dx, al
	inc dx
	mov al, bl
	out dx, al

	;     
	mov al, [di]
	stosb
	
	;    ,  

SL_Complete:				;    ?
	mov bx, cx			; ,      8
	cmp cx, 8
	jl SL_Trailing			; ...  ,   

	shr cx, 1				; CX <-   
	shr cx, 1
	shr cx, 1
	mov dx, GC_INDEX		;   8     GC_BMR
	mov al, GC_BMR
	out dx, al
	inc dx
	mov al, 0FFH
	out dx, al

	rep stosb				;    
	
	;      
	
SL_Trailing:
	and bx, 07H			; ,   -   
	jz SL_Done			; ... . , 
	mov ax, 0FFFFH		; ... .     , 
	mov cx, bx			;  FFFF    
	shr ax, cl
	xor ah, 0FFH
	mov dx, GC_INDEX		;    GC_BMR
	mov al, GC_BMR
	out dx, al
	inc dx
	mov al, ah
	out dx, al

	;      
	mov ax, [di]
	stosb

        ;   GC_SRER  GC_BMR
SL_Done:
	mov dx, GC_INDEX		;    8-   
	mov al, GC_BMR
	out dx, al
	inc dx
	mov al, 0FFh
	out dx, al

	dec dx				;   Set/Reset
	mov al, GC_SRER
	out dx, al
	inc dx
	xor ax, ax
	out dx, al

	pop es				;   
	pop ds
	pop si
	pop di
        ret
_ScanLine endp

start endp
code ends
	end start
